/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.BenzoHeterocycle;
import chemaxon.marvin.io.formats.name.nameexport.Canonicalizer;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.Compound;
import chemaxon.marvin.io.formats.name.nameexport.GeneralFusedRingSystem;
import chemaxon.marvin.io.formats.name.nameexport.GroupSearch;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.NameTranslator;
import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.RetainedFullName;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.Substituent;
import chemaxon.marvin.io.formats.name.nameexport.TopologyAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.TraditionalDictionary;
import chemaxon.marvin.io.formats.name.nameexport.TraditionalDictionaryFromStructure;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.util.LoggingUtil;
import chemaxon.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NamingCentral {
    static final Object lock = new Object();
    static int relativeStereoSwapRS;
    static TopologyAnalyser topologyAnalyser;
    static boolean foreignCall;
    private static final Logger logger;

    static boolean isAllRelativeStereo() {
        int i = SubmoleculeBuilder.globalMolecule.getAtomCount();
        while (--i >= 0) {
            MolAtom a = SubmoleculeBuilder.globalMolecule.getAtom(i);
            if (Chem.getChirality(a) == 0 || a.getStereoGroupType() == 2) continue;
            return false;
        }
        return true;
    }

    String getName(Molecule m) throws IUPACNamer.Error {
        String name = this.getNameCore(m);
        name = NameTranslator.translate(name);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getNameCore(Molecule m) throws IUPACNamer.Error {
        if (Options.common) {
            return TraditionalDictionaryFromStructure.getTraditionalName(m);
        }
        if (m.getAtomCount() == 0) {
            return "";
        }
        try {
            m = Canonicalizer.prepareForS2N(m);
            this.checkSupport(m);
            Object object = lock;
            synchronized (object) {
                relativeStereoSwapRS = 0;
                GroupSearch.resetStats();
                Compound compound = new Compound(NamingCentral.analyse(m));
                String res = compound.getName();
                if (relativeStereoSwapRS != 0 && NamingCentral.isAllRelativeStereo()) {
                    res = "rel-" + res;
                }
                return res;
            }
        }
        catch (RuntimeException e) {
            String name;
            if (!Options.noDict && (name = NamingCentral.nameFromSmiles(m)) != null) {
                return name;
            }
            throw new IUPACNamer.Error("Name generation failed", e);
        }
        catch (Error e) {
            try {
                throw (Error)e.getClass().getConstructor(String.class, Throwable.class).newInstance("java.lang.Error thrown while generating name for " + Util.getDictionarySmiles(m), e);
            }
            catch (InstantiationException e1) {
                throw e;
            }
            catch (IllegalAccessException e1) {
                throw e;
            }
            catch (InvocationTargetException e1) {
                throw e;
            }
            catch (NoSuchMethodException e1) {
                throw e;
            }
        }
    }

    static String nameFromSmiles(Molecule m) {
        String smiles = Util.getDictionarySmiles(m);
        String name = TraditionalDictionary.getTraditionalName(smiles);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(smiles + " -> " + name);
        }
        return name;
    }

    void checkSupport(Molecule m) {
        if (this.multipleRadicals(m)) {
            throw new IUPACNamer.UnsupportedError("Multiple radicals are not supported");
        }
    }

    private boolean multipleRadicals(Molecule m) {
        boolean found = false;
        int i = m.getAtomCount();
        while (--i >= 0) {
            MolAtom a = m.getAtom(i);
            if (a.getRadicalCount() <= 0) continue;
            if (found) {
                return true;
            }
            found = true;
        }
        return false;
    }

    static Part[] analyse(Molecule m) {
        SubmoleculeBuilder.globalMolecule = m;
        topologyAnalyser = new TopologyAnalyser(m);
        return topologyAnalyser.analyse();
    }

    static String rewrite(String name) {
        String traditionalName;
        name = StringUtil.replaceAll(name, "methanoic acid", "formic acid");
        name = StringUtil.replaceAll(name, "ethanoic acid", "acetic acid");
        name = StringUtil.replaceAll(name, "methanoate", "formate");
        name = StringUtil.replaceAll(name, "ethanoate", "acetate");
        name = StringUtil.replaceAll(name, "methanamid", "formamid");
        name = StringUtil.replaceAll(name, "ethanamid", "acetamid");
        name = StringUtil.replaceAll(name, "methanenitrile", "formonitrile");
        name = StringUtil.replaceAll(name, "ethanenitrile", "acetonitrile");
        name = StringUtil.replaceAll(name, "methanehydrazid", "formohydrazid");
        name = StringUtil.replaceAll(name, "ethanehydrazid", "acetohydrazid");
        name = StringUtil.replaceAll(name, "methanal", "formaldehyde");
        name = StringUtil.replaceAll(name, "ethanal", "acetaldehyde");
        name = StringUtil.replaceAll(name, "phenylcarbonyl", "benzoyl");
        name = StringUtil.replaceAll(name, "benzenecarbonyl", "benzoyl");
        name = StringUtil.replaceAll(name, "benzene-1-carbonyl", "benzoyl");
        name = StringUtil.replaceAll(name, "-1,4-oxazine", "-oxazine");
        if (Options.traditionalGroups) {
            name = NamingCentral.rewriteTraditional(name);
        }
        if ((traditionalName = RetainedFullName.get(name)) != null) {
            return traditionalName;
        }
        return name;
    }

    static String rewriteTraditional(String name) {
        name = StringUtil.replaceAll(name, "benzene-1,2-dicarboxylate", "phthalate");
        return name;
    }

    public static int[] getNumbering(Molecule m) {
        return NamingCentral.getNumbering(m, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] getNumbering(Molecule m, boolean onlyFused) {
        Object object = lock;
        synchronized (object) {
            boolean oldNumberingOnly = Options.numberingOnly;
            Options.numberingOnly = true;
            boolean oldForeignCall = foreignCall;
            foreignCall = true;
            try {
                Part[] parts = NamingCentral.analyse(m);
                if (onlyFused) {
                    for (Part p : parts) {
                        if (p instanceof GeneralFusedRingSystem || p instanceof BenzoHeterocycle) continue;
                        int[] nArray = null;
                        return nArray;
                    }
                }
                int[] res = new int[m.getAtomCount()];
                int p = parts.length;
                while (--p >= 0) {
                    if (NamingCentral.setAtomNumbering(parts[p], res)) continue;
                    int[] nArray = null;
                    return nArray;
                }
                int[] nArray = res;
                return nArray;
            }
            finally {
                foreignCall = oldForeignCall;
                Options.numberingOnly = oldNumberingOnly;
            }
        }
    }

    private static boolean setAtomNumbering(Part p, int[] globalNumbering) {
        if (!(p instanceof SimplePart)) {
            return false;
        }
        SimplePart part = (SimplePart)p;
        int[][][] numberings = part.bestNumberings(true);
        if (numberings == null || numberings.length == 0) {
            return false;
        }
        int[] numbering = numberings[0][1];
        int i = part.getAtomCount();
        while (--i >= 0) {
            MolAtom a = part.getAtom(i);
            globalNumbering[SubmoleculeBuilder.indexOf((MolAtom)a)] = numbering[i];
        }
        if (part.modifiers.substituents != null) {
            for (Substituent substituent : part.modifiers.substituents) {
                NamingCentral.setAtomNumbering(substituent.part, globalNumbering);
            }
        }
        return true;
    }

    public static boolean numberMolecule(Molecule m, boolean asAlias) {
        int[] numbering = NamingCentral.getNumbering(m);
        if (numbering == null) {
            return false;
        }
        int i = numbering.length;
        while (--i >= 0) {
            String locant = Util.locant(numbering[i]);
            MolAtom a = m.getAtom(i);
            if (asAlias) {
                a.setAliasstr(locant);
                continue;
            }
            a.setExtraLabel(locant);
        }
        return true;
    }

    static {
        foreignCall = false;
        logger = LoggingUtil.getLogger(NamingCentral.class);
    }
}

