/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Modifiers;
import chemaxon.marvin.io.formats.name.nameexport.NamingCentral;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.HashMap;

abstract class Part {
    private Part parent;
    protected Molecule originalMolecule;
    int[] primes;
    MolAtom root;
    MolAtom radical;
    String cachedPrefixName;
    String ending = null;
    HashMap owners;

    Part(Molecule m) {
        this.originalMolecule = m;
        this.primes = new int[m.getAtomCount()];
    }

    Part(MolAtom root) {
        this.root = root;
    }

    void setParent(Part parent) {
        this.parent = parent;
    }

    Part getParent() {
        return this.parent;
    }

    int getRadicalIndex() {
        return this.originalMolecule.indexOf(this.radical);
    }

    int getAtomCount() {
        return this.originalMolecule == null ? -1 : this.originalMolecule.getAtomCount();
    }

    MolAtom getAtom(int i) {
        return this.originalMolecule.getAtom(i);
    }

    int indexOf(MolAtom a) {
        return this.originalMolecule.indexOf(a);
    }

    int getCharge() {
        return Integer.MAX_VALUE;
    }

    boolean hasCharge() {
        int charge = this.getCharge();
        return charge != 0 && charge != Integer.MAX_VALUE;
    }

    boolean isSalt() {
        return false;
    }

    abstract String getName();

    String getRewrittenName() {
        return NamingCentral.rewrite(this.getName());
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (RuntimeException e) {
            e.printStackTrace(System.out);
            return "?";
        }
    }

    void resetPrefixName() {
        this.cachedPrefixName = null;
        if (this.parent != null) {
            this.parent.resetPrefixName();
        }
    }

    final String getPrefixName() {
        if (this.cachedPrefixName == null) {
            this.cachedPrefixName = this.computePrefixName();
        }
        return this.cachedPrefixName;
    }

    void setEnding(String ending) {
        this.ending = ending;
    }

    String computePrefixName() {
        return this.getName();
    }

    int suffixJuniority() {
        return -1;
    }

    int parentSeniority() {
        return 0x30000000;
    }

    boolean canBeParent() {
        return this.parentSeniority() != Integer.MAX_VALUE;
    }

    int compareSeniority(Part other) {
        return 0;
    }

    boolean complex() {
        return false;
    }

    boolean cyclic() {
        return false;
    }

    boolean isBenzene() {
        return false;
    }

    boolean isMethane() {
        return false;
    }

    boolean isAmine() {
        return false;
    }

    boolean isAminoAcid() {
        return false;
    }

    boolean isHydroxy() {
        return false;
    }

    boolean isHydrogen() {
        if (this.originalMolecule == null) {
            return false;
        }
        return this.originalMolecule.getAtomCount() == 1 && this.originalMolecule.getAtom(0).getAtno() == 1;
    }

    int getSeniorityClass() {
        if (this.hasRadical()) {
            return 100;
        }
        int anionCount = this.getAnionCount();
        if (anionCount > 0) {
            return 400 + (100 - anionCount);
        }
        int cationCount = this.getCationCount();
        if (cationCount > 0) {
            return 600 + (100 - cationCount);
        }
        return Integer.MAX_VALUE;
    }

    private int getAnionCount() {
        int res = this.suffixCount("ide");
        return res;
    }

    private int getCationCount() {
        int res = this.suffixCount("ium");
        return res;
    }

    Modifiers getModifiers() {
        return null;
    }

    boolean noBrackets() {
        Modifiers mods = this.getModifiers();
        if (mods == null) {
            return false;
        }
        return mods.noBrackets;
    }

    private int suffixCount(String suffix) {
        Modifiers modifiers = this.getModifiers();
        if (modifiers == null) {
            return 0;
        }
        if (modifiers.suffixes.isEmpty()) {
            return 0;
        }
        int res = 0;
        for (Modifiers.Suffix s : modifiers.suffixes) {
            if (!s.suffix.endsWith(suffix)) continue;
            ++res;
        }
        return res;
    }

    boolean hasRadical() {
        if (this.radical == null) {
            return false;
        }
        return Chem.isRadical(SubmoleculeBuilder.originalAtom(this.radical));
    }

    void addSubstituent(Part substituent) {
        substituent.setParent(this);
        int root = Integer.MAX_VALUE;
        String label = substituent.root.getExtraLabel();
        if (label != null && label.length() != 0) {
            root = Util.groupLocant(label);
        } else if (this.originalMolecule != null) {
            MolAtom a = SubmoleculeBuilder.localAtom(substituent.root, this.originalMolecule);
            if (a != null) {
                root = this.originalMolecule.indexOf(a);
            }
            if (root == Integer.MAX_VALUE) {
                root = Part.heteroLocant(substituent.root);
            }
        }
        this.addSubstituent(substituent, root);
        this.resetPrefixName();
    }

    static int heteroLocant(MolAtom a) {
        String sym = a.getSymbol();
        if (sym.length() != 1) {
            throw new IUPACNamer.Failure(sym);
        }
        int res = 1000000000 + SubmoleculeBuilder.indexOf(a) * 100000 + sym.charAt(0);
        return -res;
    }

    static char heteroSymbol(int locant) {
        if (locant == -1) {
            return 'N';
        }
        if ((locant = -locant) < 1000000000) {
            throw new IUPACNamer.Failure("" + locant);
        }
        return (char)((locant -= 1000000000) % 100000);
    }

    void addSubstituent(Part substituent, int root) {
        throw new IUPACNamer.Failure("Not supported");
    }

    void makeOwner(MolAtom a) {
        this.owners.put(SubmoleculeBuilder.originalAtom(a), this);
    }

    Part getRealParent(Part substituent) {
        MolAtom root = SubmoleculeBuilder.originalAtom(substituent.root);
        return this.getRealParent(root);
    }

    Part getRealParent(MolAtom atom) {
        if (this.owners == null) {
            return null;
        }
        return (Part)this.owners.get(atom);
    }

    void removeSubstituents(ArrayList substituents) {
    }

    int getParentRootBondStereo() {
        return 0;
    }

    boolean noHydro() {
        return false;
    }

    boolean needsLocants() {
        return true;
    }

    boolean needsLocants(int[] locants, boolean substituents) {
        int i = locants.length;
        while (--i >= 0) {
            if (!Util.isSpecialLocant(locants[i])) continue;
            return true;
        }
        if (!this.needsLocants()) {
            return false;
        }
        if (!substituents) {
            return true;
        }
        return this.hasSubstituablePosition();
    }

    boolean hasSubstituablePosition() {
        return true;
    }

    boolean ignoreBonds() {
        return false;
    }

    boolean canHaveSuffix() {
        return true;
    }

    public boolean isShortRing() {
        return false;
    }

    public void glueToSuffix() {
    }
}

