/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.RingSystem;
import chemaxon.marvin.io.formats.name.nameexport.SpecialFusedRingSystem;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.Molecule;

public class Polyacene
extends SpecialFusedRingSystem {
    int[] ringOrder;
    boolean polyaphene;

    static SpecialFusedRingSystem create(Molecule m, int[] atomIndexMap, RingSystem rs) {
        int[][] rings = rs.getRings();
        int nrings = rings.length;
        if (nrings < 4) {
            return null;
        }
        int i = nrings;
        while (--i >= 0) {
            if (rings[i].length == 6) continue;
            return null;
        }
        int[] ringOrder = rs.getLinearFusedRings();
        if (ringOrder == null) {
            return null;
        }
        boolean polyaphene = false;
        int i2 = nrings;
        while (--i2 >= 2) {
            if (rs.straight(ringOrder[i2 - 2], ringOrder[i2 - 1], ringOrder[i2])) continue;
            if (!(polyaphene || i2 != 1 + nrings / 2 && i2 != 1 + (nrings - 1) / 2)) {
                polyaphene = true;
                continue;
            }
            return null;
        }
        return new Polyacene(m, atomIndexMap, rs, ringOrder, polyaphene);
    }

    private Polyacene(Molecule m, int[] atomIndexMap, RingSystem rs, int[] ringOrder, boolean polyaphene) {
        super(m, atomIndexMap, rs);
        this.ringOrder = ringOrder;
        this.polyaphene = polyaphene;
    }

    @Override
    boolean maximizeFusions() {
        return this.polyaphene;
    }

    @Override
    String nameDescriptor(int[] descriptor, int[] numbering, boolean saturatedBase, boolean omitSuffix) {
        StringBuffer res = new StringBuffer();
        res.append(Chem.greek(this.originalMolecule.getSSSR().length));
        Util.appendRemovingVowel(this.polyaphene ? "aphene" : "acene", res);
        return res.toString();
    }

    @Override
    int[][][] recognize() {
        int[][] numberings = this.rs.linearFusedNumberings(this.ringOrder, this.originalMolecule.getAtomCount());
        int[][][] res = new int[4][][];
        int i = numberings.length;
        while (--i >= 0) {
            res[i] = new int[][]{null, numberings[i]};
        }
        return res;
    }
}

