/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.RingSystem;
import chemaxon.marvin.io.formats.name.nameexport.SpecialFusedRingSystem;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

class Polyhelicene
extends SpecialFusedRingSystem {
    int[] ringOrder;
    int numberingStart1;
    int numberingStart2;
    int numberingDir1;
    int numberingDir2;

    static SpecialFusedRingSystem create(Molecule m, int[] atomIndexMap, RingSystem rs) {
        int[] fusion;
        int[] ringOrder = rs.getLinearFusedRings();
        if (ringOrder == null) {
            return null;
        }
        int nrings = ringOrder.length;
        if (nrings < 6) {
            return null;
        }
        int r = ringOrder.length;
        while (--r >= 0) {
            if (rs.getRing(r).length == 6) continue;
            return null;
        }
        int[] fusion0 = rs.getFusion(ringOrder[0], ringOrder[1]);
        int firstAtom = fusion0[0];
        int atom = Polyhelicene.hasBond(m, firstAtom, fusion = rs.getFusion(ringOrder[1], ringOrder[2]));
        if (atom == -1) {
            firstAtom = fusion0[1];
            atom = Polyhelicene.hasBond(m, firstAtom, fusion);
        }
        if (atom == -1) {
            return null;
        }
        for (int i = 2; i < ringOrder.length - 1; ++i) {
            fusion = rs.getFusion(ringOrder[i], ringOrder[i + 1]);
            if ((atom = Polyhelicene.hasBond(m, atom, fusion)) != -1) continue;
            return null;
        }
        int firstDir = Polyhelicene.getStartDir(rs.getRing(ringOrder[0]), firstAtom, fusion0);
        int lastDir = Polyhelicene.getStartDir(rs.getRing(ringOrder[nrings - 1]), atom, fusion);
        int lastAtom = Util.indexOf(atom, rs.getRing(nrings - 1));
        firstAtom = Util.indexOf(firstAtom, rs.getRing(0));
        firstAtom = (firstAtom + firstDir + 6) % 6;
        lastAtom = (lastAtom + lastDir + 6) % 6;
        return new Polyhelicene(m, atomIndexMap, rs, ringOrder, firstAtom, firstDir, lastAtom, lastDir);
    }

    static int hasBond(Molecule m, int atom1, int[] atoms2) {
        MolAtom a1 = m.getAtom(atom1);
        int i = atoms2.length;
        while (--i >= 0) {
            int atom2 = atoms2[i];
            if (a1.getBondTo(m.getAtom(atom2)) == null) continue;
            return atom2;
        }
        return -1;
    }

    static int getStartDir(int[] ring, int atom, int[] fusion) {
        int other = atom == fusion[0] ? fusion[1] : fusion[0];
        atom = Util.indexOf(atom, ring);
        other = Util.indexOf(other, ring);
        return atom - other;
    }

    private Polyhelicene(Molecule m, int[] atomIndexMap, RingSystem rs, int[] ringOrder, int numberingStart1, int numberingDir1, int numberingStart2, int numberingDir2) {
        super(m, atomIndexMap, rs);
        this.ringOrder = ringOrder;
        this.numberingStart1 = numberingStart1;
        this.numberingDir1 = numberingDir1;
        this.numberingStart2 = numberingStart2;
        this.numberingDir2 = numberingDir2;
    }

    @Override
    String nameDescriptor(int[] descriptor, int[] numbering, boolean saturatedBase, boolean omitSuffix) {
        return Chem.greek(this.ringOrder.length) + "helicene";
    }

    @Override
    int[][][] recognize() {
        int[][][] res = new int[2][2][this.originalMolecule.getAtomCount()];
        this.rs.fusedNumbering(this.ringOrder[0], this.numberingStart1, this.numberingDir1, res[0][1]);
        this.rs.fusedNumbering(this.ringOrder[this.ringOrder.length - 1], this.numberingStart2, this.numberingDir2, res[1][1]);
        return res;
    }
}

