/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.RingSystem;
import chemaxon.marvin.io.formats.name.nameexport.SpecialFusedRingSystem;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.Molecule;

public class Polyphenylene
extends SpecialFusedRingSystem {
    int size;
    int center;

    static SpecialFusedRingSystem create(Molecule m, int[] atomIndexMap, RingSystem rs) {
        int[][] rings = rs.getRings();
        if (rings.length < 3) {
            return null;
        }
        int center = 0;
        int[] centerRing = rings[center];
        int[][] fusions = rs.getFusions(center);
        if (fusions.length == 1) {
            center = fusions[0][0];
            centerRing = rings[center];
            fusions = rs.getFusions(center);
        }
        if (fusions.length != rings.length - 1) {
            return null;
        }
        if (fusions.length * 2 != centerRing.length) {
            return null;
        }
        int r = rings.length;
        while (--r >= 0) {
            if (r == center) continue;
            if (rings[r].length != 6) {
                return null;
            }
            if (rs.getFusions(r).length == 1) continue;
            return null;
        }
        return new Polyphenylene(m, atomIndexMap, rs, fusions.length, center);
    }

    private Polyphenylene(Molecule m, int[] atomIndexMap, RingSystem rs, int size, int center) {
        super(m, atomIndexMap, rs);
        this.size = size;
        this.center = center;
    }

    @Override
    String nameDescriptor(int[] descriptor, int[] numbering, boolean saturatedBase, boolean omitSuffix) {
        StringBuffer res = new StringBuffer();
        res.append(Chem.multiplier(this.size));
        Util.appendRemovingVowel("phenylene", res);
        return res.toString();
    }

    @Override
    int[][][] recognize() {
        int[][][] res = new int[this.size * 2][2][this.originalMolecule.getAtomCount()];
        int n = 0;
        int i = this.size + 1;
        while (--i >= 0) {
            if (i == this.center) continue;
            this.rs.fusedNumberingFromNextFusionNeighbourAtom(i, 0, 1, res[n++][1]);
            this.rs.fusedNumberingFromNextFusionNeighbourAtom(i, -1, -1, res[n++][1]);
        }
        return res;
    }
}

