/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.BenzoHeterocycle;
import chemaxon.marvin.io.formats.name.nameexport.CarbonBridgedRingSystem;
import chemaxon.marvin.io.formats.name.nameexport.GeneralFusedRingSystem;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Monocycle;
import chemaxon.marvin.io.formats.name.nameexport.NamingCentral;
import chemaxon.marvin.io.formats.name.nameexport.Search;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.SpecialFusedRingSystem;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class RingSystem
implements Cloneable {
    public static int fusedRingSystems = 0;
    public static int fusedNamedAsBridged = 0;
    Molecule molecule;
    ArrayList rings = new ArrayList();
    IntVector connections = new IntVector();
    IntVector spiroAtoms = new IntVector();
    ArrayList fusions = new ArrayList();
    boolean notFused = false;
    RingSystem localRS;
    private static final boolean dbg = false;

    SimplePart create(Molecule molecule, int[] atomIndexMap) {
        SimplePart res = Search.cyclic(molecule, atomIndexMap);
        if (res != null) {
            return res;
        }
        if (molecule.getSSSR().length == 1) {
            return new Monocycle(molecule, atomIndexMap);
        }
        if (this.isFused()) {
            if (!NamingCentral.foreignCall) {
                ++fusedRingSystems;
            }
            if ((res = BenzoHeterocycle.create(molecule, atomIndexMap)) != null) {
                return res;
            }
            res = SpecialFusedRingSystem.create(molecule, atomIndexMap, this);
            if (res != null) {
                return res;
            }
            res = GeneralFusedRingSystem.create(molecule, atomIndexMap, this);
            if (res != null) {
                return res;
            }
            if (!NamingCentral.foreignCall) {
                ++fusedNamedAsBridged;
            }
        }
        return new CarbonBridgedRingSystem(molecule, atomIndexMap);
    }

    public Object clone() {
        RingSystem res;
        try {
            res = (RingSystem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        res.rings = (ArrayList)this.rings.clone();
        int i = this.rings.size();
        while (--i >= 0) {
            res.rings.set(i, ((int[])this.rings.get(i)).clone());
        }
        res.connections = (IntVector)this.connections.clone();
        res.spiroAtoms = (IntVector)this.spiroAtoms.clone();
        res.fusions = (ArrayList)this.fusions.clone();
        i = this.fusions.size();
        while (--i >= 0) {
            ArrayList orig = (ArrayList)this.fusions.get(i);
            if (orig == null) continue;
            ArrayList cloned = (ArrayList)orig.clone();
            res.fusions.set(i, cloned);
            int j = cloned.size();
            while (--j >= 0) {
                cloned.set(j, ((int[])cloned.get(j)).clone());
            }
        }
        return res;
    }

    boolean isFused() {
        if (this.notFused) {
            return false;
        }
        int fiveOrMoreMembersRings = 0;
        for (int[] ring : this.rings) {
            if (ring.length < 5 || ++fiveOrMoreMembersRings < 2) continue;
            return true;
        }
        return false;
    }

    void add(int[] ring) {
        this.rings.add(ring);
        this.fusions.add(null);
    }

    int[] getRing(int r) {
        return (int[])this.rings.get(r);
    }

    int[][] getRings() {
        return Util.intArrayArray(this.rings);
    }

    void addFusion(int[] ring1, int[] ring2, int fusion1, int fusion2) {
        int r1 = this.rings.indexOf(ring1);
        int r2 = this.rings.indexOf(ring2);
        ArrayList<int[]> l = (ArrayList<int[]>)this.fusions.get(r1);
        if (l == null) {
            l = new ArrayList<int[]>();
            this.fusions.set(r1, l);
        }
        l.add(new int[]{r2, fusion1, fusion2});
    }

    int[][] getFusions(int r) {
        return Util.intArrayArray((ArrayList)this.fusions.get(r));
    }

    int[] getFusion(int r1, int r2) {
        int[][] fusions = this.getFusions(r1);
        int i = fusions.length;
        while (--i >= 0) {
            int[] fusion = fusions[i];
            if (fusion[0] != r2) continue;
            return new int[]{fusion[1], fusion[2]};
        }
        return null;
    }

    int[] fusionByAtom(int r, int a) {
        int[][] fusions = this.getFusions(r);
        int i = fusions.length;
        while (--i >= 0) {
            int[] fusion = fusions[i];
            if (fusion[1] == a) {
                return new int[]{fusion[0], fusion[2]};
            }
            if (fusion[2] != a) continue;
            return new int[]{fusion[0], fusion[1]};
        }
        return null;
    }

    int[] getLinearFusedRings() {
        boolean[] visited = new boolean[this.rings.size()];
        IntVector res = new IntVector();
        if ((res = this.addLinear(visited, 0, -1, res, true, false)) == null) {
            return null;
        }
        return res.toArray();
    }

    private IntVector addLinear(boolean[] visited, int r, int from, IntVector res, boolean first, boolean inFront) {
        int[][] fusions;
        if (visited[r]) {
            return null;
        }
        visited[r] = true;
        if (!first) {
            if (inFront) {
                res.add(0, r);
            } else {
                res.add(r);
            }
        }
        if ((fusions = this.getFusions(r)) == null || fusions.length == 0 || fusions.length > 2) {
            return null;
        }
        int i = fusions.length;
        while (--i >= 0) {
            int r2 = fusions[i][0];
            if (r2 == from) continue;
            if ((res = this.addLinear(visited, r2, r, res, false, inFront)) == null) {
                return null;
            }
            if (!first || res.size() <= 0) continue;
            res.add(0, r);
            inFront = true;
            first = false;
        }
        return res;
    }

    boolean straight(int r1, int r2, int r3) {
        int next;
        int[] ring2 = this.getRing(r2);
        int len2 = ring2.length;
        int[] fusion1 = this.getFusion(r1, r2);
        int[] fusion3 = this.getFusion(r2, r3);
        int start = Util.indexOf(fusion1[0], ring2);
        int dir = ring2[(start + 1) % len2] == fusion1[1] ? len2 - 1 : 1;
        int distance = 0;
        while ((next = ring2[(start + dir * ++distance) % len2]) != fusion3[0] && next != fusion3[1]) {
        }
        if (len2 % 2 == 0) {
            return distance + 1 == len2 / 2;
        }
        return distance == len2 / 2 || distance + 1 == len2 / 2;
    }

    int computeAngle(int r1, int r2, int r3) {
        int next;
        if (this.localRS != null) {
            return this.localRS.computeAngle(r1, r2, r3);
        }
        int[] ring2 = this.getRing(r2);
        int len2 = ring2.length;
        int[] fusion1 = this.getFusion(r1, r2);
        int[] fusion3 = this.getFusion(r2, r3);
        int start = Util.indexOf(fusion1[0], ring2);
        int dir = ring2[(start + 1) % len2] == fusion1[1] ? len2 - 1 : 1;
        int distance = 0;
        while ((next = ring2[(start + dir * distance) % len2]) != fusion3[0] && next != fusion3[1]) {
            ++distance;
        }
        if (len2 % 2 == 0 ? distance + 1 == len2 / 2 : distance == len2 / 2 || distance + 1 == len2 / 2) {
            return -1;
        }
        int fusionAtom = ring2[(start + dir * distance) % len2];
        int otherFusionAtomOnRing3 = fusion3[0] == fusionAtom ? fusion3[1] : fusion3[0];
        int[] ring3 = this.getRing(r3);
        if (distance + 1 < len2 / 2) {
            return RingSystem.getRingAtom(ring3, fusionAtom, otherFusionAtomOnRing3);
        }
        return RingSystem.getRingAtom(ring3, otherFusionAtomOnRing3, fusionAtom);
    }

    private static int getRingAtom(int[] ring, int neighbour, int exclude) {
        int i = ring.length;
        while (--i >= 0) {
            int a = RingSystem.getRingAtom(ring, i);
            if (a == exclude || RingSystem.getRingAtom(ring, i + 1) != neighbour && RingSystem.getRingAtom(ring, i - 1) != neighbour) continue;
            return a;
        }
        throw new IUPACNamer.Failure("Either the parameters are incorrect, or we have a bug in the method");
    }

    private static int getRingAtom(int[] ring, int index) {
        int len = ring.length;
        return ring[(index + len) % len];
    }

    int[][] linearFusedNumberings(int[] ringOrder, int N) {
        if (this.localRS != null) {
            return this.localRS.linearFusedNumberings(ringOrder, N);
        }
        int[][] res = new int[4][N];
        int lastRing = ringOrder.length - 1;
        this.fusedNumberingFromNextFusionNeighbourAtom(ringOrder[0], 0, 1, res[0]);
        this.fusedNumberingFromNextFusionNeighbourAtom(ringOrder[0], -1, -1, res[1]);
        this.fusedNumberingFromNextFusionNeighbourAtom(ringOrder[lastRing], 0, 1, res[2]);
        this.fusedNumberingFromNextFusionNeighbourAtom(ringOrder[lastRing], 1, -1, res[3]);
        return res;
    }

    void fusedNumberingFromNextFusionNeighbourAtom(int r, int atom, int atomDir, int[] numbering) {
        int[] ring = this.getRing(r);
        int len = ring.length;
        atom = (atom + len) % len;
        while (this.fusionByAtom(r, ring[atom]) != null) {
            atom = (atom + len + atomDir) % len;
        }
        while (this.fusionByAtom(r, ring[(atom + len - atomDir) % len]) == null) {
            atom = (atom + len - atomDir) % len;
        }
        this.fusedNumbering(r, atom, atomDir, numbering);
    }

    void fusedNumbering(int r, int atom, int atomDir, int[] numbering) {
        int[] ring = this.getRing(r);
        int len = ring.length;
        int fromAtom = (atom + len - atomDir) % len;
        this.linearFusedNumbering(r, atom, fromAtom, numbering, 0, 0);
    }

    private void linearFusedNumbering(int r, int atom, int from, int[] numbering, int loc, int letter) {
        int[] fusion;
        int[] ring = this.getRing(r);
        int len = ring.length;
        int dir = (atom - from + len) % len;
        while ((fusion = this.fusionByAtom(r, ring[atom])) == null) {
            if (numbering[ring[atom]] != 0) {
                return;
            }
            letter = 0;
            numbering[ring[atom]] = ++loc;
            atom = (atom + dir) % len;
        }
        while (fusion == null) {
        }
        if (this.molecule.getAtom(ring[atom]).getAtno() == 6) {
            ++letter;
        } else {
            ++loc;
        }
        numbering[ring[atom]] = Util.locant(loc, 0, letter, 0);
        int otherRingIndex = fusion[0];
        int[] otherRing = this.getRing(otherRingIndex);
        int otherAtom = Util.indexOf(ring[atom], otherRing);
        int otherFrom = Util.indexOf(fusion[1], otherRing);
        dir = (otherAtom - otherFrom + otherRing.length) % otherRing.length;
        otherFrom = otherAtom;
        otherAtom = (otherAtom + dir) % otherRing.length;
        this.linearFusedNumbering(otherRingIndex, otherAtom, otherFrom, numbering, loc, letter);
    }

    public int[] getRing() {
        if (this.rings.size() != 1) {
            throw new IUPACNamer.Failure("Unexpected case");
        }
        return (int[])this.rings.get(0);
    }

    public int getRingSize() {
        return this.getRing().length;
    }

    SubmoleculeBuilder computeMolecule(Molecule originalMolecule) {
        SubmoleculeBuilder builder = new SubmoleculeBuilder(originalMolecule);
        for (int[] ring : this.rings) {
            builder.addRing(ring);
        }
        this.localRS = (RingSystem)this.clone();
        this.localRS.updateIndexes(builder);
        return builder;
    }

    void computeMolecule(SubmoleculeBuilder builder) {
        for (int[] ring : this.rings) {
            for (int i = 1; i < ring.length; ++i) {
                builder.addBond(ring[i - 1], ring[i]);
            }
            builder.addBond(ring[ring.length - 1], ring[0]);
        }
    }

    void updateIndexes(SubmoleculeBuilder builder) {
        this.molecule = builder.getMolecule();
        for (int[] ring : this.rings) {
            int i = ring.length;
            while (--i >= 0) {
                ring[i] = builder.getNewIndex(ring[i]);
            }
        }
        int i = this.spiroAtoms.size();
        while (--i >= 0) {
            this.spiroAtoms.set(i, builder.getNewIndex(this.spiroAtoms.get(i)));
        }
        for (ArrayList f : this.fusions) {
            if (f == null) continue;
            for (int[] fusion : f) {
                fusion[1] = builder.getNewIndex(fusion[1]);
                fusion[2] = builder.getNewIndex(fusion[2]);
            }
        }
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("Rings: " + this.rings.size() + "\n");
        for (int[] ring : this.rings) {
            res.append(Util.print(ring) + "\n");
        }
        res.append(Util.print(this.connections.toArray())).append("\n");
        res.append(Util.print(this.spiroAtoms.toArray())).append("\n");
        return res.toString();
    }

    int printAtom(int atom) {
        return SubmoleculeBuilder.indexOf(this.molecule.getAtom(atom));
    }
}

