/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.Modifiers;
import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

abstract class SaturationAnalyser {
    static final int saturated = 1;
    static final int unsaturated = 2;
    static final int triple = 3;

    SaturationAnalyser() {
    }

    static void analyse(SimplePart carbon, int[] atomIndexMap, IntVector exclude, Modifiers modifiers) {
        Molecule m = carbon.originalMolecule;
        if (carbon.hasRetainedName()) {
            SaturationAnalyser.addSaturatedAtoms(carbon.originalMolecule, carbon.hasSaturatedBase(), exclude, atomIndexMap, modifiers);
        } else {
            SaturationAnalyser.findBonds(m, atomIndexMap, modifiers);
        }
    }

    static void analyse(SimplePart carbon, Modifiers modifiers) {
        Molecule m = carbon.originalMolecule;
        if (carbon.hasRetainedName()) {
            SaturationAnalyser.addSaturatedAtoms(m, carbon.hasSaturatedBase(), null, null, modifiers);
        } else {
            SaturationAnalyser.findBonds(m, null, modifiers);
        }
    }

    static int saturation(Molecule m) {
        int res = 1;
        int i = m.getBondCount();
        while (--i >= 0) {
            MolBond b = m.getBond(i);
            int type = b.getType();
            if (type == 3) {
                return 3;
            }
            if (type == 1) continue;
            res = 2;
        }
        return res;
    }

    static boolean isMancude(Molecule m) {
        int last = -1;
        int type = -1;
        int i = m.getBondCount();
        while (--i >= 0) {
            MolBond b = m.getBond(i);
            type = b.getType();
            if (type != 1 && type != 2) {
                return false;
            }
            if (last != -1 && b.getAtom1().getValence() != 2 && b.getAtom1().getBondCount() <= 2 && b.getAtom2().getValence() != 2 && b.getAtom2().getBondCount() <= 2 && type == last) {
                return false;
            }
            last = type;
        }
        return true;
    }

    static boolean isSaturated(Molecule m) {
        int i = m.getBondCount();
        while (--i >= 0) {
            MolBond b = m.getBond(i);
            if (b.getType() == 1) continue;
            return false;
        }
        return true;
    }

    private static int[] analyseSaturation(Molecule m, boolean saturatedBase) {
        if (saturatedBase && SaturationAnalyser.isSaturated(m)) {
            return Util.int0;
        }
        IntVector saturated = new IntVector();
        int i = m.getAtomCount();
        block0: while (--i >= 0) {
            MolAtom a = m.getAtom(i);
            int e = a.getBondCount();
            while (--e >= 0) {
                MolBond b = a.getBond(e);
                if (b.getType() == 1) continue;
                continue block0;
            }
            int ionicType = Chem.getIonicType(a);
            if (!Options.indicateSubstitutedHydrogens) {
                a = SubmoleculeBuilder.originalAtom(a);
            }
            if (a.getImplicitHcount() == 0 && !Chem.isRadical(a) && (ionicType == 0 || ionicType == 2)) continue;
            saturated.add(i);
        }
        return saturated.toArray();
    }

    private static void addSaturatedAtoms(Molecule m, boolean saturatedBase, IntVector exclude, int[] atomIndexMap, Modifiers modifiers) {
        int[] saturatedAtoms = SaturationAnalyser.analyseSaturation(m, saturatedBase);
        if (exclude != null) {
            saturatedAtoms = Util.remove(exclude, saturatedAtoms);
        }
        if (saturatedAtoms.length > 0) {
            int[] sat = saturatedAtoms;
            if (atomIndexMap != null) {
                sat = Util.apply(atomIndexMap, sat);
            }
            modifiers.addSaturatedAtoms(sat);
        }
    }

    private static void findBonds(Molecule m, int[] map, Modifiers modifiers) {
        int i = m.getBondCount();
        while (--i >= 0) {
            MolBond bond = m.getBond(i);
            int type = bond.getType();
            if (type == 1) continue;
            int atom1 = m.indexOf(bond.getAtom1());
            int atom2 = m.indexOf(bond.getAtom2());
            if (map != null) {
                atom1 = map[atom1];
                atom2 = map[atom2];
            }
            modifiers.addBond(type, atom1, atom2);
        }
    }
}

