/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Dictionary;
import chemaxon.marvin.io.formats.name.nameexport.Monocycle;
import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.marvin.io.formats.name.nameexport.SaturationAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.marvin.modules.SubstructureSearch;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

abstract class Search {
    private static Dictionary dict = new Dictionary();
    private static final boolean dbg = false;

    Search() {
    }

    public static SimplePart[] getCyclicComponents(Molecule molecule, int[] atomIndexMap) {
        int i;
        ArrayList<SimplePart> res = new ArrayList<SimplePart>();
        Molecule cloned = molecule.cloneMolecule();
        cloned.aromatize();
        SubstructureSearch sss = new SubstructureSearch();
        sss.setTarget(cloned);
        int[][] rings = cloned.getSSSR();
        boolean[] foundRings = new boolean[rings.length];
        for (i = 0; i < Search.dict.structures.length && !Util.allTrue(foundRings); ++i) {
            Dictionary.Structure s = Search.dict.structures[i];
            SimplePart p = Search.match(s, sss, molecule, cloned, rings, foundRings);
            if (p == null) continue;
            res.add(p);
        }
        i = foundRings.length;
        while (--i >= 0) {
            if (foundRings[i]) continue;
            SubmoleculeBuilder builder = new SubmoleculeBuilder(molecule);
            builder.addRing(rings[i]);
            Monocycle monocycle = new Monocycle(builder.getMolecule(), builder.atomIndexMap.toArray()){

                @Override
                void analyseSaturation() {
                }

                @Override
                void analyseAtoms() {
                }
            };
            res.add(monocycle);
        }
        return res.toArray(new SimplePart[res.size()]);
    }

    private static SimplePart match(Dictionary.Structure s, SubstructureSearch sss, Molecule molecule, Molecule aromatized, int[][] rings, boolean[] foundRings) {
        Molecule query = s.query;
        sss.setQuery(s.getStaticQuery());
        sss.setIgnoreBondType(s.ignoreBondType);
        if (!sss.findFirst()) {
            return null;
        }
        String name = s.getName(aromatized, sss.getResult());
        if (name == null) {
            return null;
        }
        ArrayList<int[]> mappings = new ArrayList<int[]>();
        int[] mainMappedRings = null;
        Molecule mappedMolecule = null;
        block0: do {
            int[] mapping = sss.getResult();
            int[] mappedRings = Search.getRings(rings, query, mapping);
            if (mainMappedRings == null) {
                int r = mappedRings.length;
                while (--r >= 0) {
                    int mappedRing = mappedRings[r];
                    if (mappedRing >= 0 && !foundRings[mappedRing]) continue;
                    continue block0;
                }
                mainMappedRings = mappedRings;
                SubmoleculeBuilder builder = new SubmoleculeBuilder(molecule);
                int r2 = mappedRings.length;
                while (--r2 >= 0) {
                    int mappedRing = mappedRings[r2];
                    foundRings[mappedRing] = true;
                    builder.addRing(rings[mappedRing]);
                }
                mappedMolecule = builder.getMolecule();
            } else if (!Util.sameElements(mappedRings, mainMappedRings)) continue;
            mappings.add(mapping);
        } while (sss.findNext());
        if (mappings.isEmpty()) {
            return null;
        }
        int[] mainMapping = (int[])mappings.get(0);
        int[][][] numberings = new int[mappings.size()][2][];
        int j = mappings.size();
        while (--j >= 0) {
            int[] mapping = (int[])mappings.get(j);
            int[] numbering = new int[query.getAtomCount()];
            int k = query.getAtomCount();
            while (--k >= 0) {
                numbering[Util.indexOf((int)mapping[k], (int[])mainMapping)] = Util.locant(query.getAtom(k).getAliasstr());
            }
            numberings[j][1] = numbering;
        }
        return Search.createPart(mappedMolecule, mainMapping, name, query, numberings);
    }

    private static int[] getRings(int[][] rings, Molecule query, int[] mapping) {
        int[][] queryRings = query.getSSSR();
        int[] res = new int[queryRings.length];
        int r = queryRings.length;
        block0: while (--r >= 0) {
            int[] queryRing = Util.apply(mapping, queryRings[r]);
            int i = rings.length - 1;
            while (true) {
                if (i < 0 || Util.sameElements(queryRing, rings[i])) {
                    res[r] = i;
                    continue block0;
                }
                --i;
            }
        }
        return res;
    }

    static SimplePart cyclic(Molecule m, int[] atomIndexMap) {
        if (Options.numberingOnly) {
            return null;
        }
        Molecule cloned = m.cloneMolecule();
        cloned.aromatize();
        SubstructureSearch sss = new SubstructureSearch();
        sss.setTarget(cloned);
        for (int i = 0; i < Search.dict.structures.length; ++i) {
            String name;
            Dictionary.Structure s = Search.dict.structures[i];
            Molecule query = s.query;
            if (query.getAtomCount() != m.getAtomCount() || query.getBondCount() != m.getBondCount()) continue;
            sss.setQuery(s.getStaticQuery());
            sss.setIgnoreBondType(s.ignoreBondType);
            if (!sss.findFirst() || s.notSaturated && SaturationAnalyser.saturation(m) == 1 || (name = s.getName(m, sss.getResult())) == null) continue;
            ArrayList<int[]> mappings = new ArrayList<int[]>();
            do {
                int[] mapping = sss.getResult();
                mappings.add(mapping);
            } while (sss.findNext());
            int[][][] numberings = new int[mappings.size()][2][];
            int j = mappings.size();
            while (--j >= 0) {
                int[] mapping = (int[])mappings.get(j);
                int[] numbering = new int[m.getAtomCount()];
                int k = query.getAtomCount();
                while (--k >= 0) {
                    numbering[mapping[k]] = Util.locant(query.getAtom(k).getAliasstr());
                }
                numberings[j][1] = numbering;
            }
            return Search.createPart(m, atomIndexMap, name, query, numberings);
        }
        return null;
    }

    private static SimplePart createPart(Molecule molecule, int[] mainMapping, String name, Molecule query, int[][][] numberings) {
        if (name.equals("benzene")) {
            return new Benzene(molecule, mainMapping, name, query, numberings);
        }
        return new Part(molecule, mainMapping, name, query, numberings);
    }

    private static class Benzene
    extends Monocycle {
        private final String name;

        private Benzene(Molecule m, int[] map, String name, Molecule query, int[][][] numberings) {
            super(m, map);
            this.name = name;
        }

        @Override
        void analyseSaturation() {
        }

        @Override
        int[][][] recognize() {
            return new int[][][]{new int[][]{null, null}};
        }

        @Override
        String nameDescriptor(int[] descriptor, int[] numbering, boolean saturatedBase, boolean omitSuffix) {
            return this.name;
        }

        @Override
        boolean hasRetainedName() {
            return true;
        }

        @Override
        boolean isBenzene() {
            return true;
        }

        @Override
        boolean ignoreHeteroAtoms() {
            return true;
        }

        @Override
        boolean needsLocants() {
            return this.modifiers.getNumberOfLocants() > 1;
        }
    }

    private static final class Part
    extends SimplePart {
        private final String name;
        private final Molecule query;
        private final int[][][] numberings;

        private Part(Molecule m, int[] map, String name, Molecule query, int[][][] numberings) {
            super(m, map);
            this.name = name;
            this.query = query;
            this.numberings = numberings;
            this.analyseSaturation();
        }

        @Override
        void analyseSaturation() {
            if (this.query != null) {
                super.analyseSaturation();
            }
        }

        @Override
        int[][][] recognize() {
            return this.numberings;
        }

        @Override
        int[][][] bestNumberings(boolean useModifiers) {
            return this.recognize();
        }

        @Override
        String nameDescriptor(int[] descriptor, int[] numbering, boolean saturatedBase, boolean omitSuffix) {
            return this.name;
        }

        @Override
        boolean hasRetainedName() {
            return true;
        }

        @Override
        boolean hasSaturatedBase() {
            return this.query.getBond(0).getType() == 1;
        }

        @Override
        boolean ignoreHeteroAtoms() {
            return true;
        }

        @Override
        boolean cyclic() {
            return true;
        }
    }
}

