/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.AminoAcid;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.GeneralFusedRingSystem;
import chemaxon.marvin.io.formats.name.nameexport.HeteroAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.Modifiers;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.SaturationAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.Substituent;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

abstract class SimplePart
extends Part {
    Modifiers modifiers = new Modifiers(this);
    int[] atomIndexMap;
    boolean notComplex = false;

    SimplePart(Molecule m, int[] atomIndexMap) {
        super(m);
        this.atomIndexMap = atomIndexMap;
        this.analyseSaturation();
        this.analyseAtoms();
    }

    SimplePart(Molecule m) {
        this(m, null);
    }

    SimplePart(MolAtom root) {
        super(root);
    }

    @Override
    Modifiers getModifiers() {
        return this.modifiers;
    }

    void setRadical(MolAtom radical, int connections) {
        int count = Chem.radicalCount(radical, true) + connections;
        if (count == 0) {
            return;
        }
        this.radical = radical;
        String ending = Chem.ylSuffix(count);
        int loc = this.originalMolecule.indexOf(radical);
        this.modifiers.setEnding(loc, ending);
    }

    abstract int[][][] recognize();

    int[][][] addMissingNumbering(int[][][] results, IntVector spiroAtoms, boolean prioritizeSpiro) {
        return results;
    }

    int[][][] addMissingNumbering(int[][][] results, Modifiers modifiers) {
        return results;
    }

    String nameDescriptor(int[] descriptor, int[] numbering, boolean saturatedBase, boolean omitSuffix, boolean asFusedComponent) {
        return this.nameDescriptor(descriptor, numbering, saturatedBase, omitSuffix);
    }

    abstract String nameDescriptor(int[] var1, int[] var2, boolean var3, boolean var4);

    void namePrefix(int[] descriptor, int[] numbering, boolean bracket, boolean global, boolean printHeteros, StringBuffer to) {
    }

    boolean hasRetainedName() {
        return false;
    }

    boolean hasSaturatedBase() {
        return true;
    }

    @Override
    boolean hasSubstituablePosition() {
        int i = this.getAtomCount();
        while (--i >= 0) {
            MolAtom a = this.getAtom(i);
            if (this.modifiers.suffixGroups != null && i == this.modifiers.suffixLocants[0] && this.modifiers.suffixGroups.get((int)0).group != null && this.modifiers.suffixGroups.get((int)0).group.eatCarbon) {
                a = this.modifiers.suffixGroups.get((int)0).group.query.getAtom(0);
            }
            if (Chem.getNonIsotopeHCount(a = SubmoleculeBuilder.originalAtom(a)) <= 0) continue;
            return true;
        }
        return false;
    }

    boolean ignoreHeteroAtoms() {
        return false;
    }

    boolean printHeteroLocations(HeteroAnalyser.HeteroAtom[] heteroAtoms) {
        return false;
    }

    boolean maximizeFusions() {
        return false;
    }

    int[][][] bestNumberings(int[][][] candidates, boolean useModifiers) {
        candidates = this.addMissingNumbering(candidates, null, false);
        candidates = HeteroAnalyser.bestHeteroResults(this.originalMolecule, this.hasRadical() ? this.radical : null, candidates);
        candidates = GeneralFusedRingSystem.bestFusionNumberings(candidates, this.maximizeFusions());
        candidates = this.addMissingNumbering(candidates, this.modifiers);
        if (useModifiers) {
            candidates = this.modifiers.bestNumberings(candidates);
        }
        return candidates;
    }

    int[][][] bestNumberings(boolean useModifiers) {
        return this.bestNumberings(this.recognize(), useModifiers);
    }

    @Override
    String getName() {
        int[][][] result = this.bestNumberings(this.recognize(), true);
        int[] descriptor = null;
        int[] numbering = null;
        if (result.length != 0) {
            int[][] bestResult = result[Util.randomInt(result.length)];
            descriptor = bestResult[0];
            numbering = bestResult[1];
        }
        boolean isHetero = HeteroAnalyser.hasHeteroAtoms(this.originalMolecule);
        HeteroAnalyser ha = new HeteroAnalyser(this);
        String name = ha.print(descriptor, numbering);
        if (!ha.completeName) {
            name = name + this.nameDescriptor(descriptor, numbering, this.hasSaturatedBase(), false);
        }
        if (this.modifiers.isEmpty() && !this.isAminoAcid()) {
            return name;
        }
        StringBuffer res = new StringBuffer(name.length() + 20);
        if (this.modifiers.printPrefix(numbering, null, res)) {
            return res.toString();
        }
        if (!this.modifiers.hasNoBonds() && name.endsWith("ane")) {
            name = name.substring(0, name.length() - 3);
        }
        if (this.isAminoAcid()) {
            String ending = this.modifiers.getEnding();
            if (ending == "ol") {
                this.modifiers.setEnding(null);
            } else if (ending == "amine") {
                if (name.equals("aspartic acid")) {
                    name = "isoasparagine";
                    this.modifiers.setEnding(null);
                } else if (name.equals("glutamic acid")) {
                    name = "isoglutamine";
                    this.modifiers.setEnding(null);
                } else {
                    this.modifiers.setEnding("amide");
                }
            } else if (ending == "yl" || ending == null) {
                name = AminoAcid.acylName(this.originalMolecule.getAtom(0), this.root);
                this.modifiers.setEnding(null);
            }
        }
        if (!(res.length() <= 0 || name.charAt(0) == '-' || Character.isLetter(name.charAt(0)) && name.charAt(1) != '-')) {
            Util.appendDash(res);
        }
        res.append(name);
        this.modifiers.printSuffix(numbering, null, false, isHetero, res);
        String fullName = res.toString();
        fullName = this.modifiers.getFullName(fullName);
        return fullName;
    }

    @Override
    boolean complex() {
        if (this.notComplex) {
            return false;
        }
        if (this.isAminoAcid() && this.modifiers.getNumberOfSubstituents() <= 1) {
            return false;
        }
        return this.modifiers.substituents != null;
    }

    @Override
    void addSubstituent(Part substituent, int root) {
        this.modifiers.addSubstituent(root, substituent);
    }

    @Override
    void removeSubstituents(ArrayList substituents) {
        if (this.modifiers == null || this.modifiers.substituents == null) {
            return;
        }
        for (Substituent s : this.modifiers.substituents) {
            s.part.removeSubstituents(substituents);
        }
    }

    @Override
    Part getRealParent(MolAtom atom) {
        if (this.modifiers.substituents != null) {
            for (Substituent s : this.modifiers.substituents) {
                Part res = s.part.getRealParent(atom);
                if (res == null) continue;
                return res;
            }
        }
        return super.getRealParent(atom);
    }

    void analyseSaturation() {
        SaturationAnalyser.analyse(this, this.modifiers);
    }

    void analyseAtoms() {
        SimplePart.analyseAtoms(this.originalMolecule, this.modifiers);
    }

    static void analyseAtoms(Molecule m, Modifiers modifiers) {
        int i = m.getAtomCount();
        while (--i >= 0) {
            int isotope;
            MolAtom a = SubmoleculeBuilder.originalAtom(m.getAtom(i));
            int chirality = Chem.getChirality(a);
            if (chirality != 0) {
                modifiers.addChiralAtom(i, chirality);
            }
            int charge = a.getCharge();
            String suffix = Chem.suffix(a, m.getAtom(i), false, false);
            if (suffix == "ium+ylium" && charge == 2) {
                modifiers.addCumulativeSuffix(i, "ium");
                modifiers.addCumulativeSuffix(i, "ylium");
            } else if (suffix != null) {
                int n = Math.abs(charge);
                while (--n >= 0) {
                    modifiers.addCumulativeSuffix(i, suffix);
                }
            }
            if ((isotope = a.getMassno()) == 0) continue;
            modifiers.addIsotope(i, isotope);
        }
    }

    @Override
    int getParentRootBondStereo() {
        if (this.modifiers.rootBondDescribedInParent) {
            return this.modifiers.rootBondStereo;
        }
        return 0;
    }

    @Override
    public void glueToSuffix() {
        this.modifiers.noPrintedEnding();
        this.modifiers.noBrackets = true;
    }
}

