/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.SgroupAtom;
import java.util.WeakHashMap;

public class SubmoleculeBuilder {
    Molecule source;
    private Molecule to = new Molecule();
    IntVector atomIndexMap = new IntVector();
    MolAtom[] atoms;
    MolAtom[] attachPoints;
    int attachPointIndex;
    private static WeakHashMap originalAtoms = new WeakHashMap();
    public static Molecule globalMolecule;

    SubmoleculeBuilder(Molecule source) {
        this.source = source;
        this.atoms = new MolAtom[source.getAtomCount()];
        this.attachPoints = new MolAtom[source.getAtomCount() * 2];
    }

    Molecule getMolecule() {
        return this.to;
    }

    void addAttachPoint(MolAtom root, MolAtom start) {
        this.attachPoints[this.attachPointIndex++] = root;
        this.attachPoints[this.attachPointIndex++] = start;
    }

    void addBond(int i1, int i2) {
        this.addBond(this.source.getAtom(i1), this.source.getAtom(i2));
    }

    void addBond(MolAtom a1, MolAtom a2) {
        MolBond bond = a1.getBondTo(a2);
        if ((a1 = this.add(a1)).getBondTo(a2 = this.add(a2)) == null) {
            this.to.add(new MolBond(a1, a2, bond.getFlags()));
        }
    }

    void addRing(int[] ring) {
        for (int i = 1; i < ring.length; ++i) {
            this.addBond(ring[i - 1], ring[i]);
        }
        this.addBond(ring[ring.length - 1], ring[0]);
    }

    MolAtom add(MolAtom atom) {
        int originalIndex = this.source.indexOf(atom);
        if (this.atoms[originalIndex] == null) {
            this.atoms[originalIndex] = (MolAtom)atom.clone();
            MolAtom newAtom = this.atoms[originalIndex];
            if (newAtom instanceof SgroupAtom) {
                SgroupAtom sga = (SgroupAtom)newAtom;
                sga.getSgroup().getAtom(0).setAttach(3);
                sga.getSgroup().getAtom(1).setAttach(3);
            }
            this.to.add(newAtom);
            this.atomIndexMap.add(originalIndex);
            MolAtom original = SubmoleculeBuilder.originalAtom(atom);
            originalAtoms.put(newAtom, original);
        }
        return this.atoms[originalIndex];
    }

    int getNewIndex(int oldIndex) {
        return this.to.indexOf(this.add(this.source.getAtom(oldIndex)));
    }

    public static MolAtom originalAtom(MolAtom atom) {
        Object res = originalAtoms.get(atom);
        if (res == null) {
            return atom;
        }
        return (MolAtom)res;
    }

    public static MolAtom localAtom(MolAtom globalAtom, Molecule m) {
        globalAtom = SubmoleculeBuilder.originalAtom(globalAtom);
        int i = m.getAtomCount();
        while (--i >= 0) {
            MolAtom atom = m.getAtom(i);
            if (SubmoleculeBuilder.originalAtom(atom) != globalAtom) continue;
            return atom;
        }
        return null;
    }

    public static void setParentAtom(MolAtom localAtom, MolAtom olderAtom) {
        localAtom.setQProp("parentAtom", olderAtom);
    }

    static MolAtom getParentAtom(MolAtom atom) {
        MolAtom res = (MolAtom)atom.getQProp("parentAtom");
        if (res != null) {
            return res;
        }
        return atom;
    }

    public static void setOriginalAtom(MolAtom localAtom, MolAtom olderAtom) {
        MolAtom global = SubmoleculeBuilder.originalAtom(olderAtom);
        originalAtoms.put(localAtom, global);
    }

    public static int indexOf(MolAtom a) {
        if (globalMolecule == null) {
            return -2;
        }
        MolAtom global = SubmoleculeBuilder.originalAtom(a);
        if (global == null) {
            return -3;
        }
        return globalMolecule.indexOf(global);
    }

    static String debugPrint(Molecule m, int[] atoms) {
        IntVector indexes = new IntVector();
        for (int i = 0; i < atoms.length; ++i) {
            indexes.add(SubmoleculeBuilder.indexOf(m.getAtom(atoms[i])));
        }
        return Util.print(indexes.toArray());
    }

    static String debugPrint(MolBond b) {
        return SubmoleculeBuilder.indexOf(b.getAtom1()) + "-" + SubmoleculeBuilder.indexOf(b.getAtom2());
    }
}

