/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.List;

abstract class SubstituablePart
extends Part {
    Part[] substituents;

    SubstituablePart(Molecule m) {
        super(m);
    }

    SubstituablePart(MolAtom root) {
        super(root);
    }

    void addSubstituents(List substituents) {
        if (substituents == null) {
            return;
        }
        this.addSubstituents(substituents.toArray(new Part[substituents.size()]));
    }

    void addSubstituents(Part[] newSubstituents) {
        int i = newSubstituents.length;
        while (--i >= 0) {
            newSubstituents[i].setParent(this);
        }
        if (this.substituents == null) {
            this.substituents = newSubstituents;
        } else {
            Part[] oldSubstituents = this.substituents;
            this.substituents = new Part[oldSubstituents.length + newSubstituents.length];
            System.arraycopy(oldSubstituents, 0, this.substituents, 0, oldSubstituents.length);
            System.arraycopy(newSubstituents, 0, this.substituents, oldSubstituents.length, newSubstituents.length);
        }
        this.resetPrefixName();
    }

    @Override
    void addSubstituent(Part substituent, int root) {
        this.addSubstituents(new Part[]{substituent});
    }
}

