/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

public class TimeLimitedTask<Result>
extends Thread {
    int timeout;
    Function<Result> function;
    public Result result;
    long startTime;

    public TimeLimitedTask(int timeout, Function<Result> function) {
        this.timeout = timeout;
        this.function = function;
    }

    @Override
    public void start() {
        super.start();
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void run() {
        this.result = this.function.run();
    }

    public Result getResult() throws InterruptedException {
        long toWait;
        if (!this.isAlive()) {
            this.start();
        }
        if ((toWait = (long)this.timeout + System.currentTimeMillis() - this.startTime) > 0L) {
            this.join(toWait);
        }
        if (this.isAlive()) {
            this.stop();
            throw new InterruptedException("Timeout after " + this.timeout + "ms");
        }
        return this.result;
    }

    public static interface Function<Result> {
        public Result run();
    }
}

