/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.Acyclic;
import chemaxon.marvin.io.formats.name.nameexport.Chain;
import chemaxon.marvin.io.formats.name.nameexport.CharacteristicGroup;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.EtherParent;
import chemaxon.marvin.io.formats.name.nameexport.EtherSubstituent;
import chemaxon.marvin.io.formats.name.nameexport.ParentFinder;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.RingSystemRecognizer;
import chemaxon.marvin.io.formats.name.nameexport.SimpleGroup;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.SpecialPart;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.SubstituablePart;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class TopologyAnalyser {
    Molecule m;
    boolean[] visited;
    Part[] owner;
    Part[] parts;
    Part parent;
    Neighbour[][] neighbours;
    private final boolean dbg = false;

    TopologyAnalyser(Molecule m) {
        this.m = m;
        this.visited = new boolean[m.getAtomCount()];
        this.owner = new Part[m.getAtomCount()];
    }

    Part[] analyse() {
        SpecialPart.find(this.m);
        Part[] rings = RingSystemRecognizer.separateRingsSystems(this.m);
        if (rings.length == 0 && this.m.getFragCount() == 1) {
            Part p = Acyclic.create(this.m);
            if (p instanceof SimplePart) {
                this.findRadical((SimplePart)p);
            }
            return new Part[]{p};
        }
        if (rings.length > 0 && this.m.getAtomCount() == rings[0].originalMolecule.getAtomCount()) {
            if (rings[0] instanceof SimplePart) {
                this.findRadical((SimplePart)rings[0]);
            }
            return new Part[]{rings[0]};
        }
        int r = rings.length;
        while (--r >= 0) {
            Part ring = rings[r];
            this.markOwner(ring);
        }
        this.findAllParts(rings);
        ArrayList<Part> res = new ArrayList<Part>();
        do {
            this.parent = this.getNextFragment();
            if (this.parent == null) continue;
            res.add(this.parent);
        } while (this.parent != null);
        return res.toArray(new Part[res.size()]);
    }

    Part getNextFragment() {
        this.parent = ParentFinder.parent(this.parts, this.neighbours);
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof SimplePart) {
            this.findRadical((SimplePart)this.parent);
        }
        this.findSubstituents(Util.indexOf(this.parent, this.parts));
        return this.parent;
    }

    private void findAllParts(Part[] rings) {
        ArrayList<Part> parts = new ArrayList<Part>();
        ArrayList neighbours = new ArrayList();
        int i = rings.length;
        while (--i >= 0) {
            parts.add(rings[i]);
            neighbours.add(null);
        }
        i = rings.length;
        while (--i >= 0) {
            this.findAcyclicParts(rings[i], parts, neighbours);
        }
        i = this.m.getAtomCount();
        while (--i >= 0) {
            if (this.visited[i]) continue;
            parts.add(this.findTree(this.m.getAtom(i), null, parts, true));
            neighbours.add(null);
        }
        this.parts = parts.toArray(new Part[parts.size()]);
        this.neighbours = new Neighbour[neighbours.size()][];
        i = neighbours.size();
        while (--i >= 0) {
            ArrayList n = (ArrayList)neighbours.get(i);
            if (n == null) continue;
            this.neighbours[i] = n.toArray(new Neighbour[n.size()]);
        }
    }

    private void markOwner(Part part) {
        int i = part.getAtomCount();
        while (--i >= 0) {
            int index = this.m.indexOf(SubmoleculeBuilder.originalAtom(part.getAtom(i)));
            this.owner[index] = part;
        }
    }

    private void findRadical(SimplePart part) {
        int i = part.getAtomCount();
        while (--i >= 0) {
            MolAtom a = part.getAtom(i);
            if (!Chem.isRadical(SubmoleculeBuilder.originalAtom(a))) continue;
            part.setRadical(a, 0);
            break;
        }
    }

    private void findAcyclicParts(Part part, ArrayList parts, ArrayList neighbours) {
        int i = part.getAtomCount();
        while (--i >= 0) {
            MolAtom sourceAtom = SubmoleculeBuilder.originalAtom(part.getAtom(i));
            this.visited[this.m.indexOf((MolAtom)sourceAtom)] = true;
            int n = sourceAtom.getBondCount();
            while (--n >= 0) {
                int neighbourIndex;
                MolAtom neighbour = sourceAtom.getLigand(n);
                int index = this.m.indexOf(neighbour);
                this.visited[index] = true;
                Part owner = this.owner[index];
                if (owner == part) continue;
                if (owner == null) {
                    owner = this.findTree(neighbour, sourceAtom.getBondTo(neighbour), parts, false);
                    if (parts.size() > neighbours.size()) {
                        int numGroupSubstituents = parts.size() - neighbours.size();
                        Part[] groupSubstituents = new Part[numGroupSubstituents];
                        int[] roots = new int[numGroupSubstituents];
                        int r = numGroupSubstituents;
                        while (--r >= 0) {
                            groupSubstituents[r] = (Part)parts.get(neighbours.size());
                            roots[r] = -1;
                            neighbours.add(null);
                        }
                        ((SimplePart)part).modifiers.addSubstituents(roots, groupSubstituents);
                    }
                    neighbourIndex = parts.size();
                    parts.add(owner);
                    neighbours.add(null);
                } else {
                    neighbourIndex = parts.indexOf(owner);
                }
                this.addNeighbour(part, neighbourIndex, parts, neighbours, index, sourceAtom, neighbour);
                this.addNeighbour(owner, parts.indexOf(part), parts, neighbours, this.m.indexOf(sourceAtom), neighbour, sourceAtom);
            }
        }
    }

    private void addNeighbour(Part p1, int neighbourIndex, ArrayList parts, ArrayList neighbours, int startIndex, MolAtom root, MolAtom start) {
        int i1 = parts.indexOf(p1);
        ArrayList<Neighbour> partNeighbours = (ArrayList<Neighbour>)neighbours.get(i1);
        if (partNeighbours == null) {
            partNeighbours = new ArrayList<Neighbour>();
            neighbours.set(i1, partNeighbours);
        }
        partNeighbours.add(new Neighbour(neighbourIndex, startIndex, root, start));
    }

    private void findSubstituents(int partIndex) {
        Part part = this.parts[partIndex];
        this.parts[partIndex] = null;
        Neighbour[] neighbours = this.neighbours[partIndex];
        if (neighbours == null) {
            return;
        }
        ArrayList<Part> subs = new ArrayList<Part>();
        IntVector roots = new IntVector();
        SimplePart sp = null;
        if (part instanceof SimplePart) {
            sp = (SimplePart)part;
        }
        int i = neighbours.length;
        while (--i >= 0) {
            Neighbour n = neighbours[i];
            Part owner = this.parts[n.neighbourIndex];
            if (owner == null) continue;
            if (owner instanceof Chain) {
                Chain chain = (Chain)owner;
                chain.completeMolecule.clearExtraLabels();
                this.parts[n.neighbourIndex] = owner = this.createAcyclicSubstituent(chain.completeMolecule, n.root, n.start, chain.completeAtomIndexMap, subs);
                while (subs.size() > roots.size()) {
                    roots.add(-1);
                }
            } else if (owner instanceof CharacteristicGroup) {
                MolBond rootBond = n.root.getBondTo(n.start);
                if (owner.originalMolecule != null && n.isSuffixOf != this.parent) {
                    owner.originalMolecule.clearExtraLabels();
                    this.parts[n.neighbourIndex] = owner = new Acyclic(owner.originalMolecule, SubmoleculeBuilder.localAtom(n.start, owner.originalMolecule), rootBond, null, subs, this).branch();
                } else {
                    ((CharacteristicGroup)owner).setRootBond(rootBond);
                }
            }
            owner.root = n.root;
            Part realParent = part.getRealParent(owner);
            if (realParent != null) {
                realParent.addSubstituent(owner);
            } else {
                if (sp != null) {
                    int rootIndex = sp.atomIndexMap != null ? Util.indexOf(this.m.indexOf(n.root), sp.atomIndexMap) : sp.originalMolecule.indexOf(SubmoleculeBuilder.localAtom(n.root, sp.originalMolecule));
                    roots.add(rootIndex);
                }
                subs.add(owner);
            }
            if (owner instanceof EtherParent) {
                EtherParent ether = (EtherParent)owner;
                ether.setParent(part);
                this.parts[n.neighbourIndex] = null;
                this.findSubstituents(Util.indexOf(ether.getSubstituent(), this.parts));
                continue;
            }
            if (owner.originalMolecule != null && !(owner instanceof Chain) && !(owner instanceof EtherSubstituent)) {
                owner.radical = SubmoleculeBuilder.localAtom(n.start, owner.originalMolecule);
                int radicalIndex = owner.originalMolecule.indexOf(owner.radical);
                MolBond rootBond = n.start.getBondTo(n.root);
                if (owner instanceof SimplePart) {
                    SimplePart child = (SimplePart)owner;
                    if (child.modifiers.getEnding() == null) {
                        child.modifiers.setEnding(radicalIndex, Chem.substituentEnding[rootBond.getType()]);
                        child.modifiers.setRootBond(rootBond, false);
                    } else {
                        child.modifiers.setEndingLocant(radicalIndex);
                    }
                } else {
                    owner.setEnding(Chem.substituentEnding[rootBond.getType()]);
                }
            }
            this.findSubstituents(n.neighbourIndex);
        }
        if (subs.size() == 0) {
            return;
        }
        if (sp == null) {
            if (part instanceof SubstituablePart) {
                ((SubstituablePart)part).addSubstituents(subs.toArray(new Part[subs.size()]));
            }
            return;
        }
        sp.modifiers.findSuffixGroup(part.originalMolecule, roots, subs);
        sp.modifiers.addSubstituents(roots.toArray(), subs.toArray(new Part[subs.size()]));
    }

    private Part findTree(MolAtom radical, MolBond rootBond, ArrayList parts, boolean alone) {
        IntVector substituted;
        SubmoleculeBuilder builder = new SubmoleculeBuilder(this.m);
        builder.add(radical).valenceCheck();
        this.findTree(radical, builder);
        Molecule m = builder.getMolecule();
        int[] atomIndexMap = builder.atomIndexMap.toArray();
        if (builder.attachPointIndex == 0) {
            substituted = null;
        } else {
            substituted = new IntVector();
            for (int i = 0; i < builder.attachPointIndex / 2; ++i) {
                MolAtom root = builder.attachPoints[2 * i];
                MolAtom start = builder.attachPoints[2 * i + 1];
                int substitutedIndex = this.m.indexOf(start);
                substituted.add(Util.indexOf(substitutedIndex, atomIndexMap));
            }
        }
        Part res = alone ? Acyclic.create(m) : new Acyclic(m, null, rootBond, atomIndexMap, parts, substituted, this).create(false, true);
        int i = m.getAtomCount();
        while (--i >= 0) {
            this.owner[atomIndexMap[i]] = res;
        }
        return res;
    }

    private Part createAcyclicSubstituent(Molecule m, MolAtom root, MolAtom start, int[] atomIndexMap, ArrayList parts) {
        Part res;
        if (m.getAtomCount() == 1 && (res = SimpleGroup.lookup(root, start)) != null) {
            return res;
        }
        MolBond bond = root.getBondTo(start);
        MolAtom localStart = SubmoleculeBuilder.localAtom(start, m);
        return new Acyclic(m, localStart, bond, atomIndexMap, parts, this).branch();
    }

    private void findTree(MolAtom atom, SubmoleculeBuilder builder) {
        int i = atom.getBondCount();
        while (--i >= 0) {
            MolAtom n = atom.getLigand(i);
            int index = this.m.indexOf(n);
            if (this.owner[index] != null) {
                builder.addAttachPoint(n, atom);
                continue;
            }
            if (this.visited[index]) continue;
            this.visited[index] = true;
            builder.addBond(atom, n);
            this.findTree(n, builder);
        }
    }

    Part getOwner(MolAtom a) {
        return this.owner[this.m.indexOf(a)];
    }

    static class Neighbour {
        int neighbourIndex;
        int startIndex;
        MolAtom root;
        MolAtom start;
        Part isSuffixOf;

        Neighbour(int neighbourIndex, int startIndex, MolAtom root, MolAtom start) {
            this.neighbourIndex = neighbourIndex;
            this.startIndex = startIndex;
            this.root = root;
            this.start = start;
        }
    }
}

