/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.util.NamingDataLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TraditionalDictionary {
    private static HashMap<String, String> _dict = null;

    static String getTraditionalName(String systematicName) {
        return TraditionalDictionary.getDict().get(systematicName);
    }

    private static HashMap<String, String> getDict() {
        if (_dict == null) {
            _dict = TraditionalDictionary.loadDict();
        }
        return _dict;
    }

    static Set<Map.Entry<String, String>> getEntries() {
        return TraditionalDictionary.getDict().entrySet();
    }

    private static synchronized HashMap<String, String> loadDict() {
        HashMap<String, String> res = new HashMap<String, String>();
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(TraditionalDictionary.class.getResourceAsStream("/chemaxon/naming/n2s/table2.dat"), "UTF-8"));
            while ((line = r.readLine()) != null) {
                int tab = (line = NamingDataLoader.read(line)).indexOf(9);
                if (tab == -1) {
                    throw new IUPACNamer.Failure("Invalid traditional name export dictionary entry: " + line);
                }
                String systematic = line.substring(0, tab);
                String traditional = line.substring(tab + 1);
                res.put(systematic, traditional);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        res.put("methylbenzene", "toluene");
        res.put("1,3,7-trimethylpurine-2,6-dione", "caffeine");
        return res;
    }
}

