/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.marvin.io.formats.name.nameexport.TraditionalDictionary;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.naming.n2s.Dictionary;
import chemaxon.struc.Molecule;
import chemaxon.util.MultiMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TraditionalDictionaryFromStructure {
    private static MultiMap<String, String> _dict;
    private static HashMap<String, Boolean> preferredNames;

    static String getTraditionalName(Molecule m) throws IUPACNamer.Error {
        String smiles = Util.getDictionarySmiles(m);
        List<String> names = TraditionalDictionaryFromStructure.getDict().get(smiles);
        if (names == null) {
            throw new IUPACNamer.NoCommonName();
        }
        if (Options.all) {
            return Util.join(names, '\n');
        }
        if (names.size() == 1) {
            return names.get(0);
        }
        for (String name : names) {
            TraditionalDictionaryFromStructure.loadPreferredNames();
            if (!preferredNames.containsKey(name)) continue;
            return name;
        }
        System.err.println("Unexpected structure which has no preferred traditional name for export: " + smiles);
        return names.get(0);
    }

    static MultiMap<String, String> getDict() {
        if (_dict == null) {
            _dict = new MultiMap();
            Dictionary n2s = Dictionary.getTraditionalDict();
            for (Map.Entry<String, String> e : n2s.getEntries()) {
                String name = e.getKey();
                String smiles = e.getValue();
                _dict.put(smiles, name);
            }
        }
        return _dict;
    }

    private static void loadPreferredNames() {
        if (preferredNames != null) {
            return;
        }
        preferredNames = new HashMap();
        for (Map.Entry<String, String> entry : TraditionalDictionary.getEntries()) {
            String preferred = entry.getValue();
            preferredNames.put(preferred, Boolean.TRUE);
        }
    }
}

