/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.formats.cml.MrvExport;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.GeneralSpiroNamer;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Util {
    private static JFrame mspaceFrame;
    private static boolean mspaceShowing;
    static final String[] _primes;
    private static final int SPECIAL_LOCANT_BASE = -1000;
    static final int LOCANT_SPACE = -900;
    static final int LOCANT_EMPTY = -899;
    static final int[] int0;
    private static Random rnd;
    public static boolean random;
    private static final char[] brackets;
    private static MrvExport mrvExporter;
    private static final String eol;

    static String print(Object[] array) {
        if (array == null) {
            return "null";
        }
        return Arrays.asList(array).toString();
    }

    public static String print(int[] list) {
        String res = Util.printList(list);
        return "[" + res + "]";
    }

    public static String printList(int[] list) {
        if (list == null) {
            return "NULL";
        }
        if (list.length == 0) {
            return "";
        }
        StringBuffer res = new StringBuffer("");
        for (int i = 0; i < list.length - 1; ++i) {
            res.append(list[i]).append(',');
        }
        res.append(list[list.length - 1]);
        return res.toString();
    }

    public static String print(int[][] list) {
        if (list == null) {
            return "NULL";
        }
        if (list.length == 0) {
            return "[]";
        }
        StringBuffer res = new StringBuffer("[");
        for (int i = 0; i < list.length - 1; ++i) {
            res.append(Util.print(list[i])).append(',');
        }
        res.append(Util.print(list[list.length - 1])).append(']');
        return res.toString();
    }

    public static String print(int[][][] list) {
        if (list == null) {
            return "NULL";
        }
        if (list.length == 0) {
            return "[]";
        }
        StringBuffer res = new StringBuffer("[");
        for (int i = 0; i < list.length - 1; ++i) {
            res.append(Util.print(list[i])).append(",\n");
        }
        res.append(Util.print(list[list.length - 1])).append(']');
        return res.toString();
    }

    static void removeBond(MoleculeGraph g, int node1, int node2) {
        MolAtom n2;
        MolAtom n1 = g.getAtom(node1);
        MolBond e = n1.getBondTo(n2 = g.getAtom(node2));
        if (e == null) {
            throw new IUPACNamer.Failure("Not found: " + node1 + "-" + node2);
        }
        g.removeBond(e);
    }

    static int getBondIndex(MoleculeGraph g, int node1, int node2) {
        MolAtom n2;
        MolAtom n1 = g.getAtom(node1);
        MolBond e = n1.getBondTo(n2 = g.getAtom(node2));
        if (e == null) {
            return -1;
        }
        return g.indexOf(e);
    }

    static void removePath(MoleculeGraph g, int[] path) {
        for (int i = 0; i < path.length - 1; ++i) {
            Util.removeBond(g, path[i], path[i + 1]);
        }
    }

    static int[][] intArrayArray(List<int[]> l) {
        int[][] res = new int[l.size()][];
        int n = 0;
        for (int[] array : l) {
            res[n++] = array;
        }
        return res;
    }

    static int[][][] intArrayArrayArray(List[] l) {
        int[][][] res = new int[l.length][][];
        for (int i = 0; i < l.length; ++i) {
            res[i] = Util.intArrayArray(l[i]);
        }
        return res;
    }

    static int[][][] intArrayArrayArray(List l) {
        int[][][] res = new int[l.size()][][];
        int n = 0;
        Iterator it = l.iterator();
        while (it.hasNext()) {
            res[n++] = (int[][])it.next();
        }
        return res;
    }

    static boolean sameElements(int[] array1, int[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        int i = array1.length;
        while (--i >= 0) {
            if (Util.contains(array2, array1[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(int[] array, int value) {
        int i = array.length;
        while (--i >= 0) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    static boolean intersects(int[] array1, int[] array2) {
        int i = array1.length;
        while (--i >= 0) {
            if (!Util.contains(array2, array1[i])) continue;
            return true;
        }
        return false;
    }

    static boolean intersects(List l, int[] value) {
        for (int[] array : l) {
            if (!Util.intersects(array, value)) continue;
            return true;
        }
        return false;
    }

    static int[] intersection(int[] array1, int[] array2, int max) {
        int[] res = new int[max + 1];
        int n = 0;
        int i = array1.length;
        while (--i >= 0) {
            if (!Util.contains(array2, array1[i])) continue;
            if (++n > max) break;
            res[n] = array1[i];
        }
        res[0] = n;
        return res;
    }

    static int[] intersectionIndexes(int[] array1, int[] array2, int max) {
        int[] res = new int[max * 2 + 1];
        int n = 0;
        int i = array1.length;
        while (--i >= 0) {
            int j = Util.indexOf(array1[i], array2);
            if (j == -1) continue;
            if (++n > max) break;
            res[n * 2 - 1] = i;
            res[n * 2] = j;
        }
        res[0] = n;
        return res;
    }

    static int indexOf(int value, int[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    static int indexOf(Object value, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(Object[] array, Object value) {
        return Util.indexOfEquality(value, array) != -1;
    }

    static int indexOfEquality(Object value, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!value.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    static int indexOf(char[] chars, String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            int j = chars.length;
            while (--j >= 0) {
                if (c != chars[j]) continue;
                return i;
            }
        }
        return -1;
    }

    static int[] reverse(int[] array) {
        int len = array.length;
        int[] res = new int[len];
        for (int i = 0; i < len; ++i) {
            res[i] = array[len - i - 1];
        }
        return res;
    }

    static void reverse(Object[] array) {
        if (array == null) {
            return;
        }
        int last = array.length - 1;
        int i = (last + 1) / 2;
        while (--i >= 0) {
            Object tmp = array[i];
            array[i] = array[last - i];
            array[last - i] = tmp;
        }
    }

    public static int pointToPointComparison(int[] array1, int[] array2) {
        if (array1 == array2) {
            return 0;
        }
        if (array1 == null) {
            return -1;
        }
        if (array2 == null) {
            return 1;
        }
        int len = Math.min(array1.length, array2.length);
        for (int i = 0; i < len; ++i) {
            int diff = array1[i] - array2[i];
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public static int pointToPointComparison(int[] array1, int[] array2, IntVector indexes) {
        int len = indexes.size();
        for (int i = 0; i < len; ++i) {
            int v2;
            int index = indexes.get(i);
            int v1 = array1[index];
            if (v1 < (v2 = array2[index])) {
                return -1;
            }
            if (v2 >= v1) continue;
            return 1;
        }
        return 0;
    }

    public static int pointToPointComparison(int[] array1, int[] array2, IntVector indexes1, IntVector indexes2) {
        int len = indexes1.size();
        if (indexes2.size() != len) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < len; ++i) {
            int index2;
            int v2;
            int index1 = indexes1.get(i);
            int v1 = array1[index1];
            if (v1 < (v2 = array2[index2 = indexes2.get(i)])) {
                return -1;
            }
            if (v2 >= v1) continue;
            return 1;
        }
        return 0;
    }

    public static int orderedComparison(int[] array1, int[] array2) {
        int[] copy1 = new int[array1.length];
        int[] copy2 = new int[array2.length];
        System.arraycopy(array1, 0, copy1, 0, array1.length);
        System.arraycopy(array2, 0, copy2, 0, array2.length);
        Arrays.sort(copy1);
        Arrays.sort(copy2);
        return Util.pointToPointComparison(copy1, copy2);
    }

    public static int setComparison(int[] array1, int[] array2) {
        int[] copy1 = new int[array1.length];
        int[] copy2 = new int[array2.length];
        System.arraycopy(array1, 0, copy1, 0, array1.length);
        System.arraycopy(array2, 0, copy2, 0, array2.length);
        Arrays.sort(copy1);
        Arrays.sort(copy2);
        int i1 = 0;
        for (int i2 = 0; i1 < copy1.length && i2 < copy2.length; ++i1, ++i2) {
            if (copy1[i1] < copy2[i2]) {
                return -1;
            }
            if (copy2[i2] < copy1[i1]) {
                return 1;
            }
            while (i1 + 1 < copy1.length && copy1[i1] == copy1[i1 + 1]) {
                ++i1;
            }
            while (i2 + 1 < copy2.length && copy2[i2] == copy2[i2 + 1]) {
                ++i2;
            }
        }
        return 0;
    }

    public static int setComparison(long[] array1, long[] array2) {
        long[] copy1 = new long[array1.length];
        long[] copy2 = new long[array2.length];
        System.arraycopy(array1, 0, copy1, 0, array1.length);
        System.arraycopy(array2, 0, copy2, 0, array2.length);
        Arrays.sort(copy1);
        Arrays.sort(copy2);
        int i1 = 0;
        for (int i2 = 0; i1 < copy1.length && i2 < copy2.length; ++i1, ++i2) {
            if (copy1[i1] < copy2[i2]) {
                return -1;
            }
            if (copy2[i2] < copy1[i1]) {
                return 1;
            }
            while (i1 + 1 < copy1.length && copy1[i1] == copy1[i1 + 1]) {
                ++i1;
            }
            while (i2 + 1 < copy2.length && copy2[i2] == copy2[i2 + 1]) {
                ++i2;
            }
        }
        return 0;
    }

    public static int setComparison(int[] array1, int[] array2, IntVector indexes) {
        if (indexes.size() == 0) {
            return 0;
        }
        int[] copy1 = new int[indexes.size()];
        int[] copy2 = new int[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            copy1[i] = array1[indexes.get(i)];
            copy2[i] = array2[indexes.get(i)];
        }
        Arrays.sort(copy1);
        Arrays.sort(copy2);
        return Util.pointToPointComparison(copy1, copy2);
    }

    public static int pointToPointComparison(Object[] array1, Object[] array2, Comparator comp) {
        int len = Math.min(array1.length, array2.length);
        for (int i = 0; i < len; ++i) {
            int res = comp.compare(array1[i], array2[i]);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static int alphabeticalPointToPointComparison(List l1, List l2) {
        Iterator i1 = l1.iterator();
        Iterator i2 = l2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            String alpha2;
            String s1 = (String)i1.next();
            String s2 = (String)i2.next();
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            if (s2 == null) {
                return 1;
            }
            String alpha1 = Util.alphabeticalParts(s1);
            int diff = alpha1.compareTo(alpha2 = Util.alphabeticalParts(s2));
            if (diff != 0) {
                return diff;
            }
            diff = s1.compareTo(s2);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public static int comparePair(int p1, int p2, int q1, int q2) {
        if (p1 < q1) {
            return -1;
        }
        if (q1 < p1) {
            return 1;
        }
        if (p2 < q2) {
            return -1;
        }
        if (q2 < p2) {
            return 1;
        }
        return 0;
    }

    static int distance(int n1, int n2, int[] ring) {
        int i = 0;
        int res = 0;
        while (ring[i] != n1) {
            ++i;
        }
        while (ring[i] != n2) {
            ++res;
            if (++i != ring.length) continue;
            i = 0;
        }
        return res - 1;
    }

    static int[] leftRingNumbering(int start, int len) {
        int[] numberingLeft = new int[len];
        for (int i = 0; i < len; ++i) {
            numberingLeft[(start + len - i) % len] = i + 1;
        }
        return numberingLeft;
    }

    static int[] rightRingNumbering(int start, int len) {
        int[] numberingRight = new int[len];
        for (int i = 0; i < len; ++i) {
            numberingRight[(start + i) % len] = i + 1;
        }
        return numberingRight;
    }

    public static int[][] smallestMembers(int[][] arrays, Comparator comp) {
        if (arrays.length == 0) {
            return null;
        }
        ArrayList<int[]> results = new ArrayList<int[]>();
        int[] best = arrays[0];
        for (int i = 1; i < arrays.length; ++i) {
            int diff = comp.compare(best, arrays[i]);
            if (diff < 0) continue;
            if (diff > 0) {
                best = arrays[i];
                results.clear();
                results.add(best);
                continue;
            }
            results.add(arrays[i]);
        }
        return Util.intArrayArray(results);
    }

    public static void addAll(int[] elements, BitSet set) {
        for (int i = 0; i < elements.length; ++i) {
            set.set(elements[i]);
        }
    }

    public static void displayMolecule(MoleculeGraph mol) {
        Util.displayMolecule(mol, null, null);
    }

    public static void displayMoleculeIndexes(MoleculeGraph mol) {
        Object[] labels = new String[mol.getAtomCount()];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = Integer.toString(i);
        }
        Util.displayMolecule(mol, labels, null);
    }

    public static void displayNumbering(MoleculeGraph mol, int[] numbering) {
        Object[] labels = new String[numbering.length];
        for (int i = 0; i < numbering.length; ++i) {
            labels[i] = Util.locant(numbering[i]);
        }
        Util.displayMolecule(mol, labels, null);
    }

    public static void displayMolecule(MoleculeGraph mol, Object[] labelsArray, int[] selected) {
        if (mspaceFrame != null && mspaceFrame.isVisible()) {
            return;
        }
        mol = (MoleculeGraph)mol.clone();
        ArrayList<Object> labels = labelsArray == null ? null : new ArrayList<Object>(Arrays.asList(labelsArray));
        try {
            Class.forName("chemaxon.marvin.space.gui.MSpace");
        }
        catch (ClassNotFoundException cne) {
            System.err.println(cne.toString());
            return;
        }
        try {
            JPanel spacePanel = new JPanel();
            spacePanel.setSize(400, 400);
            Class<?> MSpaceEasyClass = Class.forName("chemaxon.marvin.space.MSpaceEasy");
            CallbackIface mspace = (CallbackIface)MSpaceEasyClass.getConstructor(Boolean.TYPE).newInstance(Boolean.TRUE);
            mspace.callback("addCanvas", spacePanel);
            mspace.callback("addPopupMenu", null);
            mspace.callback("setLicenseKey", null);
            mspace.callback("setSize", new Object[]{new Integer(800), new Integer(600)});
            mspace.callback("setProperty", new Object[]{"SynchronMode", "true"});
            mspace.callback("setProperty", new Object[]{"Ligand.DrawType", "BallAndWire"});
            Object gc = mspace.callback("addMoleculeTo", new Object[]{mol, new Integer(0)});
            if (labels != null) {
                mspace.callback("createAtomLabels", new Object[]{gc, labels});
            }
            if (selected != null) {
                Method selectAtom = gc.getClass().getMethod("selectAtom", Integer.TYPE);
                for (int i = 0; i < selected.length; ++i) {
                    selectAtom.invoke(gc, new Integer(selected[i]));
                }
            }
            mspaceFrame = new JFrame();
            mspaceFrame.setDefaultCloseOperation(2);
            mspaceFrame.getContentPane().add(spacePanel);
            mspaceFrame.pack();
            mspaceFrame.show();
            mspaceShowing = true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return;
        }
    }

    static void waitForDisplay() {
        if (mspaceFrame == null || !mspaceShowing) {
            return;
        }
        while (mspaceShowing && !mspaceFrame.isVisible()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        mspaceShowing = false;
        while (mspaceFrame.isVisible()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static String labelledSmiles(Molecule mol, int[] numbering) {
        Molecule m = (Molecule)mol.clone();
        StringBuffer res = new StringBuffer(mol.toFormat("smiles"));
        res.append(" |$");
        for (int i = 0; i < numbering.length; ++i) {
            if (i > 0) {
                res.append(';');
            }
            res.append(numbering[i]);
            m.getAtom(i).setAliasstr(Integer.toString(numbering[i]));
        }
        res.append("$|");
        return m.toFormat("cxsmiles");
    }

    public static Molecule moleculeFromSmiles(String smiles) {
        try {
            return MolImporter.importMol(smiles, "cxsmiles");
        }
        catch (MolFormatException e) {
            throw new IUPACNamer.Failure(e);
        }
    }

    public static String toSmilesOrSmarts(Molecule m) {
        String result = null;
        try {
            result = m.toFormat("cxsmiles:u");
        }
        catch (RuntimeException e1) {
            try {
                result = m.toFormat("cxsmarts:u");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return result;
    }

    static int insertSorted(int element, IntVector vect) {
        int index = Util.indexInsertSorted(element, vect);
        vect.add(index, element);
        return index;
    }

    static int indexInsertSorted(int element, IntVector vect) {
        for (int i = 0; i < vect.size(); ++i) {
            if (vect.get(i) < element) continue;
            return i;
        }
        return vect.size();
    }

    static String alphabeticalParts(String s) {
        StringBuffer res = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isLetter(c)) continue;
            res.append(c);
        }
        return res.toString();
    }

    static String alphabeticalRoot(String s) {
        char c;
        int start;
        for (start = 0; start < s.length() && !Character.isLowerCase(c = s.charAt(start)); ++start) {
        }
        s = s.substring(start);
        if (Options.italicsSpecialForOrdering && s.startsWith("tert-")) {
            s = s.substring(5);
        }
        return s;
    }

    static boolean isIsotope(String name) {
        return name.startsWith("(") && name.endsWith(")") && Util.isUnicodeSuperscriptNumber(name.charAt(1));
    }

    static int alphabeticalOrder(String s1, String s2) {
        if (Util.isIsotope(s1)) {
            return 1;
        }
        if (Util.isIsotope(s2)) {
            return -1;
        }
        int diff = Util.alphabeticalRoot(s1).compareTo(Util.alphabeticalRoot(s2));
        if (diff != 0) {
            return diff;
        }
        return Util.numericCompare(s1, s2);
    }

    static int insertSortedAlphabetically(String s, List l) {
        String root = Util.alphabeticalRoot(s);
        ListIterator<String> it = l.listIterator();
        while (it.hasNext()) {
            String cur = (String)it.next();
            int diff = root.compareTo(Util.alphabeticalRoot(cur));
            if (diff == 0) {
                diff = Util.numericCompare(s, cur);
            }
            if (diff >= 0) continue;
            int index = it.previousIndex();
            it.previous();
            it.add(s);
            return index;
        }
        l.add(s);
        return l.size() - 1;
    }

    static int numericCompare(String s1, String s2) {
        return s1.compareTo(s2);
    }

    static boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'y';
    }

    static boolean isConsonant(char c) {
        return c >= 'b' && c <= 'z' && !Util.isVowel(c);
    }

    public static boolean startsWithVowel(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        if (Util.isVowel(text.charAt(0))) {
            return true;
        }
        int closeParen = text.indexOf(41);
        if (closeParen != -1 && Util.isIsotope(text.substring(0, closeParen + 1))) {
            return Util.startsWithVowel(text.substring(closeParen + 1));
        }
        return false;
    }

    static void removeTrailingVowel(StringBuffer to) {
        if (to.length() == 0) {
            return;
        }
        int last = to.length() - 1;
        char c = to.charAt(last);
        if (c == ']') {
            c = to.charAt(--last);
        }
        if (Util.isVowel(c) && c != 'y') {
            to.deleteCharAt(last);
        }
    }

    static void appendRemovingDoubleVowel(String s, StringBuffer to) {
        if (s == "") {
            return;
        }
        if (to.length() > 0 && s.charAt(0) == to.charAt(to.length() - 1)) {
            to.deleteCharAt(to.length() - 1);
        }
        to.append(s);
    }

    static void appendRemovingVowel(String s, StringBuffer to) {
        if (s == "") {
            return;
        }
        if (Util.startsWithVowel(s)) {
            Util.removeTrailingVowel(to);
        }
        if (s.charAt(0) == '-' && to.charAt(to.length() - 1) == '-') {
            s = s.substring(1);
        }
        to.append(s);
    }

    static boolean startsWithVowel(StringBuffer s, int from) {
        for (int i = from; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Util.isVowel(c)) {
                return true;
            }
            if (!Util.isConsonant(c)) continue;
            return false;
        }
        return false;
    }

    public static boolean startsWithNumber(String name) {
        if (name == "") {
            return false;
        }
        char c = name.charAt(0);
        return c >= '0' && c <= '9';
    }

    static void appendDash(StringBuffer sb) {
        int len = sb.length();
        if (len == 0) {
            return;
        }
        char previous = sb.charAt(len - 1);
        if (previous == '-' || previous == ' ') {
            return;
        }
        sb.append('-');
    }

    static String primes(int num) {
        if (num < _primes.length) {
            return _primes[num];
        }
        if (num > 1000) {
            throw new IUPACNamer.Failure("Too big number of primes");
        }
        StringBuffer res = new StringBuffer(num);
        for (int i = 0; i < num; ++i) {
            res.append('\'');
        }
        return res.toString();
    }

    static int locant(int number, int prime, char letter, int superscript) {
        return Util.locant(number, prime, letter == '\u0000' ? 0 : letter - 96, superscript);
    }

    static int locant(int number, int prime, int letter, int superscript) {
        return number * 1000000 + superscript * 10000 + letter * 100 + prime;
    }

    static int locant(int number, int prime) {
        if (number < 1000000) {
            return Util.locant(number, prime, 0, 0);
        }
        return number | prime;
    }

    static int locant(int atom, int[] numbering, int[] primes) {
        int prime = primes == null ? 0 : GeneralSpiroNamer.decode2(primes[atom]);
        return Util.locant(numbering[atom], prime);
    }

    static int getNumber(int encoded) {
        if (encoded < 1000000) {
            return encoded;
        }
        return encoded / 1000000;
    }

    static int getSuperscript(int encoded) {
        return encoded / 10000 % 100;
    }

    static int getPrime(int encoded) {
        return encoded % 100;
    }

    static char getLetter(int encoded) {
        int res = encoded / 100 % 100;
        if (res != 0) {
            res += 96;
        }
        return (char)res;
    }

    public static String locant(int encoded) {
        if (encoded == 0) {
            return "";
        }
        if (encoded < 0) {
            return Util.groupLocantString(encoded);
        }
        if (encoded < 1000000) {
            return Integer.toString(encoded);
        }
        int number = Util.getNumber(encoded);
        int primes = Util.getPrime(encoded);
        char letter = Util.getLetter(encoded);
        int superscript = Util.getSuperscript(encoded);
        if (primes == 0 && letter == '\u0000') {
            return Integer.toString(number);
        }
        StringBuffer res = new StringBuffer();
        res.append(number);
        res.append(Util.primes(primes));
        if (letter != '\u0000') {
            res.append(letter);
        }
        if (superscript > 0) {
            res.append("^{").append(superscript).append('}');
        }
        return res.toString();
    }

    static void printLocants(int[] locants, StringBuffer res) {
        for (int i = 0; i < locants.length; ++i) {
            if (i > 0) {
                res.append(',');
            }
            res.append(Util.locant(locants[i]));
        }
    }

    static boolean isSpecialLocant(int locant) {
        return locant < 0;
    }

    static Integer groupLocant(String label) {
        if (label == null) {
            return null;
        }
        if (label.equals("N")) {
            return -1000;
        }
        if (label.equals("N'")) {
            return -999;
        }
        if (label.equals("O")) {
            return -998;
        }
        if (label.equals("P")) {
            return -997;
        }
        if (label.equals("S")) {
            return -996;
        }
        if (label.equals("C")) {
            return -995;
        }
        if (label.equals("1")) {
            return -989;
        }
        if (label.equals("2")) {
            return -988;
        }
        if (label.equals("3")) {
            return -987;
        }
        if (label.equals(" ")) {
            return -900;
        }
        return null;
    }

    static String groupLocantString(int value) {
        switch (value) {
            case -1000: {
                return "N";
            }
            case -999: {
                return "N'";
            }
            case -998: {
                return "O";
            }
            case -997: {
                return "P";
            }
            case -996: {
                return "S";
            }
            case -995: {
                return "C";
            }
            case -989: {
                return "1";
            }
            case -988: {
                return "2";
            }
            case -987: {
                return "3";
            }
            case -900: {
                return " ";
            }
            case -899: {
                return "";
            }
        }
        return null;
    }

    static boolean letterLocant(int loc) {
        if (loc >= 0) {
            return false;
        }
        return loc != -899;
    }

    static int locant(String label) {
        if (label == null) {
            return 0;
        }
        int letter = 0;
        int superscript = 0;
        try {
            return Integer.parseInt(label);
        }
        catch (NumberFormatException e) {
            int end = label.length() - 1;
            char c = label.charAt(end - 1);
            if (c == '^') {
                superscript = Integer.parseInt(label.substring(end));
                c = label.charAt(end -= 2);
            } else {
                c = label.charAt(end);
            }
            int number = Integer.parseInt(label.substring(0, end));
            letter = c - 96;
            return Util.locant(number, 0, letter, superscript);
        }
    }

    static int[] locants(int[] numbering, int[] primes, int[] atoms) {
        int[] res = new int[atoms.length];
        int i = res.length;
        while (--i >= 0) {
            int atom = atoms[i];
            if (atom < 0) {
                res[i] = atom;
                continue;
            }
            res[i] = Util.locant(atom, numbering, primes);
        }
        return res;
    }

    static int[] apply(int[] map, int[] base) {
        int[] res = new int[base.length];
        int i = res.length;
        while (--i >= 0) {
            res[i] = base[i] < 0 ? -1 : map[base[i]];
        }
        return res;
    }

    static int[] remove(IntVector exclude, int[] base) {
        IntVector res = new IntVector();
        for (int i = 0; i < base.length; ++i) {
            if (exclude.indexOf(base[i]) != -1) continue;
            res.add(base[i]);
        }
        return res.toArray();
    }

    static int[] flatten(ArrayList arrays) {
        IntVector res = new IntVector();
        for (int[] array : arrays) {
            int i = array.length;
            while (--i >= 0) {
                res.add(array[i]);
            }
        }
        return res.toArray();
    }

    public static int countNonZeroElements(int[] array) {
        int res = 0;
        int i = array.length;
        while (--i >= 0) {
            if (array[i] == 0) continue;
            ++res;
        }
        return res;
    }

    public static boolean allTrue(boolean[] array) {
        int i = array.length;
        while (--i >= 0) {
            if (array[i]) continue;
            return false;
        }
        return true;
    }

    static boolean randomBoolean() {
        if (random) {
            return rnd.nextBoolean();
        }
        return false;
    }

    static int randomInt(int n) {
        if (random) {
            return rnd.nextInt(n);
        }
        return 0;
    }

    static String parenthesize(String name) {
        if (name == "tert-butyl") {
            return name;
        }
        int index = Util.indexOf(brackets, name);
        if (index == -1) {
            return '(' + name + ')';
        }
        char c = name.charAt(index);
        if (c == '[') {
            return '{' + name + '}';
        }
        if (c == '(') {
            return '[' + name + ']';
        }
        return '(' + name + ')';
    }

    static void serialize(Molecule m, String filename) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filename));
            out.writeObject(m);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void removeConsecutiveArrayDuplicates(List list) {
        Object[] prev = null;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object[] current = (Object[])it.next();
            if (Arrays.equals(prev, current)) {
                it.remove();
                continue;
            }
            prev = current;
        }
    }

    public static String multipliedNames(ArrayList names) {
        StringBuffer res = new StringBuffer();
        ListIterator it = names.listIterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            int repeat = 1;
            while (it.hasNext()) {
                if (name.equals(it.next())) {
                    ++repeat;
                    continue;
                }
                it.previous();
                break;
            }
            if (res.length() != 0) {
                res.append(' ');
            }
            res.append(Chem.diMultiplier(repeat)).append(name);
        }
        return res.toString();
    }

    public static String unicodeSuperscriptNumber(int n) {
        StringBuffer res = new StringBuffer();
        int start = 0;
        if (n < 0) {
            res.append('\u207b');
            n = -n;
            start = 1;
        }
        do {
            char c;
            int d = n % 10;
            switch (d) {
                case 1: {
                    c = '\u00b9';
                    break;
                }
                case 2: {
                    c = '\u00b2';
                    break;
                }
                case 3: {
                    c = '\u00b3';
                    break;
                }
                default: {
                    c = (char)(8304 + d);
                }
            }
            res.insert(start, c);
        } while ((n /= 10) != 0);
        return res.toString();
    }

    public static int unicodeSuperscriptNumberValue(char c) {
        switch (c) {
            case '\u00b9': {
                return 1;
            }
            case '\u00b2': {
                return 2;
            }
            case '\u00b3': {
                return 3;
            }
            case '\u2070': {
                return 0;
            }
            case '\u2074': {
                return 4;
            }
            case '\u2075': {
                return 5;
            }
            case '\u2076': {
                return 6;
            }
            case '\u2077': {
                return 7;
            }
            case '\u2078': {
                return 8;
            }
            case '\u2079': {
                return 9;
            }
        }
        return -1;
    }

    public static boolean isUnicodeSuperscriptNumber(char c) {
        return Util.unicodeSuperscriptNumberValue(c) >= 0;
    }

    public static String unicodeSubscriptNumber(int n) {
        StringBuffer res = new StringBuffer();
        int start = 0;
        if (n < 0) {
            res.append('\u207b');
            n = -n;
            start = 1;
        }
        do {
            int d = n % 10;
            char c = (char)(8320 + d);
            res.insert(start, c);
        } while ((n /= 10) != 0);
        return res.toString();
    }

    static int min(int a, int b, int c) {
        int res = a;
        if (b < res) {
            res = b;
        }
        if (c < res) {
            res = c;
        }
        return res;
    }

    public static int levenshteinDistance(String s, String t) {
        int i;
        int n = s.length();
        int m = t.length();
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (int j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (int j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = Util.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    static void addNulls(List<?> l, int untilIndex) {
        while (l.size() <= untilIndex) {
            l.add(null);
        }
    }

    private static void removeExtraFeatures(Molecule m) {
        int i = m.getAtomCount();
        while (--i >= 0) {
            MolAtom a = m.getAtom(i);
            a.setAtomMap(0);
        }
    }

    public static String getSmilesOrMrv(Molecule m) {
        try {
            try {
                return m.exportToFormat("cxsmiles");
            }
            catch (RuntimeException e) {
                throw new MolExportException(e);
            }
        }
        catch (MolExportException e) {
            try {
                try {
                    return Util.compactMrv(m);
                }
                catch (RuntimeException e1) {
                    throw new MolExportException(e1);
                }
            }
            catch (MolExportException e1) {
                return "<failed>";
            }
        }
    }

    public static String getDictionarySmiles(Molecule m) {
        return Util.getDictionarySmiles(m, false);
    }

    public static String getDictionarySmiles(Molecule m, boolean setAbsStereo) {
        Util.removeExtraFeatures(m);
        if (setAbsStereo) {
            m.setAbsStereo(true);
        }
        try {
            try {
                Molecule unique = MolImporter.importMol(m.exportToFormat("cxsmiles:u"), "cxsmiles");
                if (unique != null) {
                    m = unique;
                }
            }
            catch (MolExportException e) {
            }
            catch (MolFormatException e) {
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            try {
                return m.exportToFormat("cxsmiles:u-aH");
            }
            catch (RuntimeException e) {
                throw new MolExportException(e);
            }
        }
        catch (MolExportException e) {
            try {
                m = m.cloneMolecule();
                m.clearProperties();
                m.setDim(0);
                m.setName(null);
                return Util.compactMrv(m);
            }
            catch (MolExportException e2) {
                System.out.println("Error while exporting " + m.getName() + ": " + e2);
                return null;
            }
        }
    }

    private static MrvExport getMrvExporter() {
        if (mrvExporter != null) {
            return mrvExporter;
        }
        try {
            mrvExporter = new MrvExport();
        }
        catch (MolExportException e) {
            throw new RuntimeException(e);
        }
        mrvExporter.setEncoding("", "UTF-8");
        return mrvExporter;
    }

    public static String compactMrv(Molecule m) throws MolExportException {
        String mrv = m.exportToFormat("mrv:P");
        int start = mrv.indexOf("<molecule");
        int end = mrv.lastIndexOf("</MChemicalStruct>");
        mrv = mrv.substring(start, end);
        mrv = mrv.replace(eol, "").replaceAll(" +", " ").replace("> ", ">").replace(" />", "/>").replace(" ?>", "?>").replace(" molID=\"m1\"", "");
        return mrv;
    }

    public static String join(List<String> elements, char delim) {
        StringBuilder res = null;
        for (String s : elements) {
            if (res == null) {
                res = new StringBuilder(s);
                continue;
            }
            res.append(delim).append(s);
        }
        if (res == null) {
            return "";
        }
        return res.toString();
    }

    static {
        _primes = new String[]{"", "'", "''", "'''", "''''", "'''''"};
        int0 = new int[0];
        rnd = new Random(0L);
        random = false;
        brackets = new char[]{'(', '[', '{'};
        eol = System.getProperty("line.separator");
    }
}

