/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.util.NamingDataLoader;
import chemaxon.marvin.io.formats.name.util.TextUtils;
import chemaxon.naming.NameConverter;
import chemaxon.naming.NamePrefixException;
import chemaxon.naming.n2s.Standardize;
import chemaxon.struc.Molecule;
import chemaxon.util.DotfileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Dictionary
implements NameConverter {
    static final String TRADITIONAL_PATH = "/chemaxon/marvin/io/formats/name/nameimport/table1.dat";
    static final String USER_PATH;
    private HashMap<String, String> _dict = null;
    private HashMap<String, String> prefixDict = null;
    private boolean prefixMode = false;
    private static Dictionary userDict;
    private static Dictionary traditionalDict;
    private Type type;
    private final String path;
    private int namePropertyIndex = 1;

    public String toString() {
        return "Dictionary(" + this.path + ")";
    }

    Dictionary(String path, Type type) {
        this.path = path;
        this.type = type;
    }

    public static Dictionary getTraditionalDict() {
        if (traditionalDict == null) {
            traditionalDict = new Dictionary(TRADITIONAL_PATH, Type.TRADITIONAL);
        }
        return traditionalDict;
    }

    public static Dictionary getUserDict() {
        return Dictionary.getUserDict(USER_PATH);
    }

    static Dictionary getUserDict(String path) {
        if (userDict == null || path != Dictionary.userDict.path) {
            userDict = new Dictionary(path, Type.USER);
        }
        return userDict;
    }

    public void reloadDict() {
        this._dict = null;
    }

    HashMap<String, String> getDict() {
        if (this._dict == null) {
            this.loadDictionary(false);
        }
        return this._dict;
    }

    @Override
    public boolean setPrefixMode(boolean prefixMode) {
        this.prefixMode = prefixMode;
        return true;
    }

    @Override
    public Molecule convert(String name) throws NamePrefixException {
        String prefix;
        Molecule res = this.find(name);
        if (res != null) {
            return res;
        }
        if (this.prefixMode && (prefix = this.findPrefix(name)) != null) {
            throw new NamePrefixException(prefix);
        }
        return null;
    }

    public static Molecule parseSmilesOrMrv(String structure) throws MolFormatException {
        if (structure.charAt(0) == '<') {
            return MolImporter.importMol(structure);
        }
        return MolImporter.importMol(structure, "cxsmiles");
    }

    public Molecule find(String name) {
        String smiles = this.getDict().get(name);
        if (smiles == null) {
            return null;
        }
        try {
            return Dictionary.parseSmilesOrMrv(smiles);
        }
        catch (MolFormatException e) {
            throw new NameImportException.Failure(e);
        }
    }

    public static boolean isTraditionalName(String name) {
        return Dictionary.getTraditionalDict().find(Standardize.get(name)) != null;
    }

    private String findPrefix(String name) {
        String namePrefix = Dictionary.getPrefix(name);
        if (namePrefix == null) {
            namePrefix = name;
        }
        if (this.prefixDict == null) {
            this.loadDictionary(true);
        }
        if (this.prefixDict.get(namePrefix) != null) {
            return namePrefix;
        }
        return null;
    }

    private void loadDictionary(boolean prefix) {
        HashMap<String, String> newDict = new HashMap<String, String>(40000);
        try {
            this.loadDictionary(newDict, prefix);
            if (prefix) {
                this.prefixDict = newDict;
            } else {
                this._dict = newDict;
            }
        }
        catch (IOException e) {
            System.err.println("Error while loading import dictionary:");
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadDictionary(HashMap<String, String> targetDict, boolean prefix) throws IOException {
        BufferedReader reader = this.createReader();
        if (reader == null) {
            return;
        }
        boolean decrypt = this.path.endsWith(".dat");
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (decrypt) {
                    line = NamingDataLoader.read(line);
                }
                this.loadDictionaryEntry(targetDict, line, prefix);
            }
        }
        finally {
            reader.close();
        }
    }

    private BufferedReader createReader() {
        BufferedReader reader = null;
        switch (this.type) {
            case TRADITIONAL: {
                InputStream dictData = Dictionary.class.getResourceAsStream(this.path);
                if (dictData == null) {
                    System.err.println("Warning: import dictionary file not found");
                    break;
                }
                try {
                    reader = new BufferedReader(new InputStreamReader(dictData, "UTF-8"));
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
            }
            case USER: {
                FileInputStream dictData;
                try {
                    dictData = new FileInputStream(this.path);
                }
                catch (FileNotFoundException e1) {
                    return null;
                }
                catch (SecurityException e2) {
                    return null;
                }
                if (dictData == null) break;
                reader = new BufferedReader(new InputStreamReader(dictData));
            }
        }
        return reader;
    }

    static String getPrefix(String name) {
        int space = name.lastIndexOf(32);
        if (space == -1) {
            return null;
        }
        return name.substring(0, space);
    }

    void loadDictionaryEntry(HashMap<String, String> targetDict, String line, boolean prefix) throws IOException {
        String[] fields;
        if (line.startsWith("#SMILES")) {
            this.namePropertyIndex = Dictionary.getNamePropertyIndex(line);
        }
        if ((fields = TextUtils.split(line, '\t')).length <= this.namePropertyIndex) {
            return;
        }
        String smiles = fields[0];
        String[] names = TextUtils.split(fields[this.namePropertyIndex], ';');
        int i = names.length;
        while (--i >= 0) {
            this.loadEntry(names[i], smiles, prefix, targetDict);
        }
    }

    void loadEntry(String name, String smiles, boolean prefix, HashMap<String, String> targetDict) {
        if (this.type == Type.USER) {
            name = Standardize.get(name);
        }
        if (prefix && (name = Dictionary.getPrefix(name)) == null) {
            return;
        }
        String old = targetDict.put(name, smiles);
        if (old != null && old.length() > smiles.length()) {
            targetDict.put(name, old);
        }
    }

    private static int getNamePropertyIndex(String line) {
        if (!line.startsWith("#SMILES")) {
            return 1;
        }
        String[] fields = TextUtils.split(line, '\t');
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].equals("NAME")) continue;
            return i;
        }
        return 1;
    }

    public Set<Map.Entry<String, String>> getEntries() {
        return this.getDict().entrySet();
    }

    static {
        userDict = null;
        traditionalDict = null;
        File df = null;
        try {
            df = DotfileUtil.getDotFile("/custom_names.smi");
        }
        catch (SecurityException sex) {
            System.err.println("Cannot access user dir");
        }
        USER_PATH = df != null ? df.getAbsolutePath() : null;
    }

    static enum Type {
        TRADITIONAL,
        USER;

    }
}

