/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport;

import chemaxon.marvin.io.formats.name.nameimport.parse.data.BenzoFusedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.VonBaeyerSystem;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class Hydrogenizator {
    public static void addHydrogens(ArrayList<MolAtom> atomList, Structure struc) {
        if (Hydrogenizator.hasSpecialCases(atomList, struc)) {
            return;
        }
        if (atomList.size() == 1) {
            MolAtom atom = atomList.get(0);
            ArrayList<MolBond> bondlist = Hydrogenizator.getAromaticBonds(atom);
            if (!bondlist.isEmpty()) {
                Hydrogenizator.setAromBondsToSingle(bondlist);
            } else {
                int hcount = atom.getImplicitHcount();
                if (hcount > 0) {
                    atom.setImplicitHcount(hcount - 1);
                } else {
                    Hydrogenizator.decreaseDoubleOrTripleBonds(atom, struc);
                }
            }
            return;
        }
        ArrayList<MolBond> l = new ArrayList<MolBond>();
        for (int i = 0; i < atomList.size(); ++i) {
            MolAtom atom = atomList.get(i);
            ArrayList<MolBond> list = Hydrogenizator.getAromaticBonds(atom);
            if (list.isEmpty()) {
                Hydrogenizator.decreaseDoubleOrTripleBonds(atom, struc);
                continue;
            }
            l.addAll(list);
        }
        Hydrogenizator.setAromBondsToSingle(l);
    }

    private static void setAromBondsToSingle(ArrayList<MolBond> bondlist) {
        for (int i = 0; i < bondlist.size(); ++i) {
            bondlist.get(i).setType(1);
        }
    }

    public static void remHydrogens(ArrayList<MolAtom> atomList) {
        ArrayList<MolAtom> list = new ArrayList<MolAtom>();
        list.addAll(atomList);
        while (!list.isEmpty()) {
            MolAtom atom = (MolAtom)list.get(0);
            list.remove(0);
            int index = Hydrogenizator.findNeighbouringAtom(atom, list);
            if (index <= -1) continue;
            MolBond bond = atom.getBondTo(list.get(index));
            Hydrogenizator.increaseBondType(bond);
            list.remove(index);
        }
    }

    private static boolean hasSpecialCases(ArrayList<MolAtom> atomList, Structure struc) {
        MolAtom atom = null;
        if (struc instanceof BenzoFusedSystem || struc instanceof VonBaeyerSystem) {
            return false;
        }
        if (atomList.size() == 1 && (atom = atomList.get(0)).getSymbol().matches("^.*(N|P|As|Bi|Sb).*$") && !Hydrogenizator.getAromaticBonds(atom).isEmpty()) {
            atom.setImplicitHcount(atom.getImplicitHcount() + 1);
            return true;
        }
        return false;
    }

    private static void decreaseDoubleOrTripleBonds(MolAtom atom, Structure struc) {
        MolAtom atom2;
        MolBond bond = Hydrogenizator.getMaxNonAromaticBond(atom);
        ArrayList<MolBond> list = Hydrogenizator.getAromaticBonds(atom);
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).setType(1);
            }
            return;
        }
        if (bond != null && list.size() == 0 && bond.getType() > 1 && struc.isBasicAtom(atom2 = bond.getOtherAtom(atom))) {
            bond.setType(bond.getType() - 1);
        }
    }

    private static MolBond getMaxNonAromaticBond(MolAtom atom) {
        MolBond bond = null;
        int type = -1;
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolBond b = atom.getBond(i);
            if (b.getType() <= type || b.getType() >= 4) continue;
            type = b.getType();
            bond = b;
        }
        return bond;
    }

    private static ArrayList<MolBond> getAromaticBonds(MolAtom atom) {
        ArrayList<MolBond> list = new ArrayList<MolBond>();
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolBond b = atom.getBond(i);
            if (b.getType() != 4) continue;
            list.add(b);
        }
        return list;
    }

    private static int findNeighbouringAtom(MolAtom atom, ArrayList<MolAtom> list) {
        for (int i = 0; i < list.size(); ++i) {
            MolAtom atom2 = list.get(i);
            if (!atom.isBoundTo(atom2)) continue;
            return i;
        }
        return -1;
    }

    private static void increaseBondType(MolBond bond) {
        switch (bond.getType()) {
            case 1: 
            case 2: {
                bond.setType(bond.getType() + 1);
                break;
            }
            case 4: {
                int i;
                MolAtom atom = bond.getAtom1();
                ArrayList<MolBond> list = Hydrogenizator.getAromaticBonds(atom);
                for (i = 0; i < list.size(); ++i) {
                    list.get(i).setType(2);
                }
                atom = bond.getAtom2();
                list = Hydrogenizator.getAromaticBonds(atom);
                for (i = 0; i < list.size(); ++i) {
                    list.get(i).setType(2);
                }
                break;
            }
        }
    }

    public static boolean addHydrogens(Molecule mol, int mul, ArrayList<MolAtom> list, Structure struc) {
        if (mul == 0) {
            return true;
        }
        list.addAll(Hydrogenizator.getAtomsToHydrogenize(mol, mul));
        Hydrogenizator.addHydrogens(list, struc);
        return true;
    }

    public static boolean remHydrogens(Molecule mol, int mul) {
        if (mul == 0) {
            return true;
        }
        ArrayList<MolAtom> list = Hydrogenizator.getAtomsTodeHydrogenize(mol);
        if (list.size() != mul) {
            return false;
        }
        Hydrogenizator.remHydrogens(list);
        return true;
    }

    private static int getMaxBondType(MolAtom atom) {
        int type = 0;
        for (int i = 0; i < atom.getBondCount(); ++i) {
            int t = atom.getBond(i).getType();
            if (t <= type) continue;
            type = t;
        }
        return type;
    }

    private static ArrayList<MolAtom> getAtomsToHydrogenize(Molecule mol, int mul) {
        ArrayList<MolAtom> atomList = new ArrayList<MolAtom>();
        ArrayList<MolAtom> optionalList = new ArrayList<MolAtom>();
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom atom = mol.getAtom(i);
            if (atom.getSymbol().equals("O") || atom.getSymbol().equals("N") && atom.getBondCount() == 3) {
                optionalList.add(atom);
                continue;
            }
            if (atom.hasAromaticBond()) {
                atomList.add(atom);
                continue;
            }
            if (Hydrogenizator.getMaxBondType(atom) <= 1) continue;
            optionalList.add(atom);
        }
        if (atomList.size() + optionalList.size() == mul) {
            atomList.addAll(optionalList);
        }
        return atomList;
    }

    private static ArrayList<MolAtom> getAtomsTodeHydrogenize(Molecule mol) {
        ArrayList<MolAtom> atomList = new ArrayList<MolAtom>();
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom atom = mol.getAtom(i);
            if (atom.getImplicitHcount() <= 0) continue;
            atomList.add(atom);
        }
        return atomList;
    }
}

