/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport;

import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.formats.name.nameimport.lex.NameLexer;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.BracketToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.IUPACParserCore;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.naming.NameFormatException;
import chemaxon.naming.n2s.Standardize;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class NameImportDebugger {
    private static String[] getTokenInfo(Token token) {
        String[] info = new String[4];
        info[0] = token.getName();
        info[1] = token.getClass().toString();
        int index = info[1].lastIndexOf(46);
        info[1] = info[1].substring(index + 1);
        info[2] = token.getValue();
        info[3] = token.getTypeInString();
        return info;
    }

    public static void main(String[] args) throws MolFormatException {
        boolean dataMining = true;
        String name = args.length == 1 ? args[0] : "3-Phenyl-5-ureido-1,2,4-oxadiazole";
        System.out.println("Name: " + name);
        System.out.println();
        IUPACParserCore.revolution = false;
        ArrayList<Token> list = null;
        try {
            name = Standardize.get(name);
            list = NameLexer.parse(name, dataMining);
            NameImportDebugger.printTokens(list);
        }
        catch (NameFormatException e) {
            e.printStackTrace(System.out);
        }
        if (list != null) {
            Structure s;
            String oldSmiles = null;
            try {
                IUPACParserCore.debug = true;
                IUPACParserCore.revolution = false;
                s = IUPACParserCore.parseTokens(list);
                oldSmiles = NameImportDebugger.displayMolecule(s.getMolecule());
                System.out.println(oldSmiles);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                IUPACParserCore.revolution = true;
                list = NameLexer.parse(name, dataMining);
                System.out.println("\nREVOLUTION");
                s = IUPACParserCore.parseTokens(list);
                System.out.println();
                Molecule res = s.getMolecule();
                String newSmiles = NameImportDebugger.displayMolecule(res);
                System.out.println(newSmiles);
                if (!newSmiles.equals(oldSmiles)) {
                    System.out.println(oldSmiles + " !=");
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    private static String displayMolecule(Molecule molecule) {
        String res = molecule.toFormat("cxsmiles");
        if (molecule.hasValenceError()) {
            res = res + " [valence error]";
        }
        return res;
    }

    private static void printTokens(ArrayList<Token> list) {
        NameImportDebugger.printTokens(list, 0);
        System.out.println();
    }

    private static void printTokens(ArrayList<Token> list, int depth) {
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < depth; ++j) {
                System.out.print('\t');
            }
            Token token = list.get(i);
            String[] info = NameImportDebugger.getTokenInfo(token);
            for (int j = 0; j < info.length; ++j) {
                System.out.print(info[j] + "\t");
                if (info[j].length() >= 8) continue;
                System.out.print("\t");
            }
            System.out.println();
            if (!(token instanceof BracketToken)) continue;
            NameImportDebugger.printTokens(((BracketToken)token).getInside(), depth + 1);
        }
    }
}

