/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.BracketToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.EndingToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Separator;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.AcetateGroup;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.AminoAcid;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.FusedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroAtom;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class Util {
    public static final int N = Util.stringToLocant("N");
    public static final int N_PRIME = Util.stringToLocant("N'");
    public static final int PRIME = 1000000;
    public static final int LETTER = 100;
    public static final int ALPHA = Integer.MAX_VALUE;
    public static final int BETA = 0x7FFFFFFE;
    public static final int OMEGA = 0x7FFFFFFD;
    private static String[] implicitPolyAcidNames = new String[]{"adipate", "adipic acid"};

    public static int findPairOfSeparator(String str, int i) {
        String open = "([{";
        String close = ")]}";
        char mysep = str.charAt(i);
        int br = 1;
        if (close.indexOf(mysep) > -1) {
            char pair = open.charAt(close.indexOf(mysep));
            while (br > 0 && i > 0) {
                if (str.charAt(--i) == pair) {
                    --br;
                    continue;
                }
                if (str.charAt(i) != mysep) continue;
                ++br;
            }
            return br > 0 ? -1 : i;
        }
        if (open.indexOf(mysep) > -1) {
            char pair = close.charAt(open.indexOf(mysep));
            while (br > 0 && i < str.length() - 1) {
                if (str.charAt(++i) == pair) {
                    --br;
                    continue;
                }
                if (str.charAt(i) != mysep) continue;
                ++br;
            }
            return br > 0 ? -1 : i;
        }
        return -1;
    }

    public static String getAtom(String smiles, int index) {
        int start = Util.getFirstIndexOfElement(smiles, index);
        int end = Util.getLastIndexOfElement(smiles, index);
        return smiles.substring(start, end + 1);
    }

    public static int getLastIndexOfElement(String smiles, int position) {
        int tmppos = smiles.indexOf(":" + Integer.toString(position) + "]");
        int bracketCounter = 0;
        if (tmppos > -1) {
            int j;
            String tmp = smiles.substring(tmppos + Integer.toString(position).length() + 2);
            for (j = 0; j < tmp.length() && (bracketCounter != 0 || tmp.charAt(j) != '[' && tmp.charAt(j) != ')'); ++j) {
                if (tmp.charAt(j) == '(') {
                    ++bracketCounter;
                }
                if (tmp.charAt(j) != ')') continue;
                --bracketCounter;
            }
            return tmppos + smiles.substring(tmppos).indexOf(93) + j;
        }
        char[] charsmiles = smiles.toCharArray();
        if (position <= 0) {
            position = 1;
        }
        if (position > charsmiles.length) {
            return charsmiles.length;
        }
        int counter = 0;
        int i = -1;
        while (counter <= position && i < charsmiles.length - 1) {
            ++i;
            if (bracketCounter == 0) {
                if (Character.isLetter(charsmiles[i]) && (Character.isUpperCase(charsmiles[i]) || charsmiles[i] == 'c' || i > 0 && !Character.isUpperCase(charsmiles[i - 1]) || i == 0)) {
                    ++counter;
                } else if (counter == position && charsmiles[i] == '[') break;
            }
            if (charsmiles[i] == '[') {
                if (bracketCounter == 0) {
                    ++counter;
                }
                ++bracketCounter;
            }
            if (charsmiles[i] != ']') continue;
            --bracketCounter;
        }
        if (i > 0 && (charsmiles[i - 1] == '#' || charsmiles[i - 1] == '=')) {
            --i;
        }
        if (i == 0 || i == charsmiles.length - 1 && counter <= position) {
            return i;
        }
        return i - 1;
    }

    public static int getFirstIndexOfElement(String smiles, int position) {
        String seps = "()";
        int tmppos = smiles.indexOf(":" + Integer.toString(position) + "]");
        if (tmppos > -1) {
            String tmp = smiles.substring(0, tmppos);
            return tmp.lastIndexOf("[");
        }
        if (position <= 1) {
            return 0;
        }
        int pos = Util.getLastIndexOfElement(smiles, position - 1) + 1;
        while (seps.indexOf(smiles.charAt(pos)) > -1) {
            ++pos;
        }
        return pos;
    }

    public static int endOfAtom(String smiles, int position) {
        int start = Util.getFirstIndexOfElement(smiles, position);
        char tmp = smiles.charAt(start);
        if (tmp == '[') {
            return start + smiles.substring(start).indexOf(93);
        }
        if (Character.isUpperCase(tmp)) {
            while (start < smiles.length() - 2 && (Character.isLowerCase(smiles.charAt(start + 1)) || smiles.charAt(start + 1) == 'c')) {
                ++start;
            }
            return start;
        }
        if (Character.isLowerCase(tmp)) {
            return start;
        }
        return -1;
    }

    public static int atomCount(String smiles) {
        if (smiles.equals("[HWE]")) {
            return 0;
        }
        if (smiles.indexOf("{") > 0) {
            smiles = smiles.substring(0, smiles.indexOf("{"));
        }
        int counter = 0;
        char[] charsmiles = smiles.toCharArray();
        for (int i = 0; i < charsmiles.length; ++i) {
            if (!Character.isLetter(charsmiles[i]) || charsmiles[i] == 'H' && (i >= charsmiles.length - 1 || !Character.isLowerCase(charsmiles[i + 1])) || charsmiles[i] == 'h' || !Character.isUpperCase(charsmiles[i]) && charsmiles[i] != 'c' && (i <= 0 || Character.isUpperCase(charsmiles[i - 1])) && i != 0) continue;
            ++counter;
        }
        return counter;
    }

    public static boolean heteroAtom(String smiles) {
        return !smiles.equals("C") && Util.atomCount(smiles) == 1 && !smiles.endsWith(".") && !smiles.startsWith("=") && !smiles.startsWith("#") && smiles.indexOf("+") < 0 && smiles.indexOf("-") < 0 && smiles.indexOf("Radical:") < 0;
    }

    public static String unMap(String smiles) {
        return smiles.substring(0, smiles.indexOf(" "));
    }

    public static boolean isCharbonChain(String smiles) {
        if (smiles.equals("")) {
            return false;
        }
        smiles = smiles.replaceAll("=|#", "");
        return smiles.matches("^C+$");
    }

    public static boolean isChainEnding(String suffix) {
        return suffix.equals(".") || suffix.equals("=.") || suffix.equals("#.") || suffix.equals("|.") || suffix.equals("|=.") || suffix.equals("|#.");
    }

    public static void addSuffix(Structure struc, String name, String value, int locant) {
        ArrayList<Token> l = new ArrayList<Token>();
        LocantList n = new LocantList();
        n.tryAddLocant(new SimpleLocant(locant, 0));
        EndingToken e = new EndingToken(name, value);
        l.add(n);
        l.add(new Separator('-'));
        l.add(e);
        struc.addSuffix(SuffixFactory.createSuffix(l, 2, -1));
    }

    public static int matchCount(String str, String pattern) {
        int count = -1;
        int index = 0;
        while (index > -1 && index != (index = str.indexOf(pattern, index + 1))) {
            ++count;
        }
        return count;
    }

    public static void addBond(Molecule mol, MolAtom atom1, MolAtom atom2, int type) {
        if (atom1.equals(atom2) || atom1.isBoundTo(atom2)) {
            throw new NameImportException("Error during building the molecule.");
        }
        boolean isRelative = (type & 0x200) != 0;
        MolBond b = new MolBond(atom1, atom2, type &= 0xFFFFFDFF);
        mol.add(b);
        if ((type & 0x30) != 0) {
            if (isRelative) {
                atom1.setStereoGroupType(2);
                atom1.setStereoGroupNumber(1);
            }
            if (mol.getDim() == 0) {
                mol.clean(2, null);
                b.setFlags(type);
            }
        }
    }

    public static int sumBonds(MolAtom atom) {
        float sum = 0.0f;
        for (int i = 0; i < atom.getBondCount(); ++i) {
            int type = atom.getBond(i).getType();
            if (type < 3) {
                sum += (float)type;
                continue;
            }
            sum = (float)((double)sum + 1.5);
        }
        return (int)Math.floor(sum);
    }

    public static boolean isGreekLetter(int numbering) {
        return numbering == Integer.MAX_VALUE || numbering == 0x7FFFFFFE || numbering == 0x7FFFFFFD;
    }

    public static int greekLetterToNumbering(int greekLetter) {
        switch (greekLetter) {
            case 0x7FFFFFFF: {
                return 1;
            }
            case 0x7FFFFFFE: {
                return 2;
            }
        }
        return -1;
    }

    public static int stringToLocant(String locant) {
        try {
            return Integer.parseInt(locant);
        }
        catch (NumberFormatException e) {
            if (locant.equals("alpha")) {
                return Integer.MAX_VALUE;
            }
            if (locant.equals("beta")) {
                return 0x7FFFFFFE;
            }
            int value = 0;
            char[] chloc = locant.toCharArray();
            for (int i = 0; i < chloc.length; ++i) {
                char asc;
                if (Character.isDigit(chloc[i])) {
                    value *= 10;
                    value += Character.getNumericValue(chloc[i]);
                    continue;
                }
                if (Character.isLowerCase(chloc[i])) {
                    value *= 100;
                    asc = chloc[i];
                    value += asc - 96;
                    continue;
                }
                if (Character.isUpperCase(chloc[i])) {
                    value *= 100;
                    asc = chloc[i];
                    value += 30 + asc - 65;
                    continue;
                }
                if (chloc[i] == '\'') {
                    value += 1000000;
                    continue;
                }
                if (chloc[i] != '\"') continue;
                value += 2000000;
            }
            return Math.max(value, 1);
        }
    }

    public static int locantToInt(Locant locant) {
        return locant.getParent() * 1000000 + locant.getValue();
    }

    public static boolean isAcid(Structure struc) {
        if (struc == null) {
            return false;
        }
        if (struc instanceof AminoAcid) {
            return true;
        }
        if (struc instanceof SimpleStructure && ((SimpleStructure)struc).getName().indexOf("acid") > -1) {
            return true;
        }
        for (int i = 0; i < struc.suffixCount(); ++i) {
            if (struc.getSuffix(i).getType() != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isRingAtom(MolAtom a) {
        try {
            int i = a.getBondCount();
            while (--i >= 0) {
                if (!a.getParent().isRingBond(a.getParent().indexOf(a.getBond(i)))) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean isHetero(Structure struc) {
        if (struc instanceof HeteroAtom) {
            return true;
        }
        if (!(struc instanceof SimpleStructure)) {
            return false;
        }
        SimpleStructure ss = (SimpleStructure)struc;
        return ss.getType() == 4;
    }

    public static boolean isAcetate(Structure s) {
        if (s instanceof AcetateGroup) {
            return true;
        }
        if (!(s instanceof SimpleStructure)) {
            return false;
        }
        SimpleStructure ss = (SimpleStructure)s;
        return ss.getName().endsWith("ate");
    }

    public static boolean isNumbering(Token token) {
        if (token instanceof LocantList) {
            return true;
        }
        if (!(token instanceof BracketToken)) {
            return false;
        }
        BracketToken bracket = (BracketToken)token;
        if (bracket.getInsideLength() != 1) {
            return false;
        }
        return bracket.getInside().get(0) instanceof LocantList;
    }

    public static LocantList getNumbering(Token token) {
        if (token instanceof LocantList) {
            return (LocantList)token;
        }
        if (token instanceof BracketToken) {
            return ((BracketToken)token).toNumbering();
        }
        return null;
    }

    public static boolean isIonNumbering(Token token) {
        if (!Util.isNumbering(token)) {
            return false;
        }
        return ((BracketToken)token).getInside().get(0).getType() == 4;
    }

    public static boolean isEnding(Token token) {
        if (token instanceof EndingToken) {
            return true;
        }
        if (!(token instanceof BracketToken)) {
            return false;
        }
        BracketToken bracket = (BracketToken)token;
        return bracket.getInsideLength() == 1 && bracket.getInside().get(0) instanceof EndingToken;
    }

    public static boolean hasClone(Structure struc) {
        if (struc.getParent() == null) {
            return false;
        }
        Structure parentStruc = struc.getParent();
        int strucIndex = parentStruc.indexOf(struc);
        if (strucIndex == parentStruc.substituentCount() - 1) {
            return false;
        }
        Structure nextLigand = parentStruc.getSubstituent(strucIndex + 1);
        return nextLigand.isCloneOf(struc);
    }

    public static int getIndexOfDoubleBoundedAtom(Molecule mol, ArrayList<Structure.StereoInfo> exceptThem) {
        if (mol == null) {
            return -1;
        }
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom atom = mol.getAtom(i);
            if (exceptThem.contains(atom)) continue;
            for (int j = 0; j < atom.getBondCount(); ++j) {
                if (atom.getBond(j).getType() != 2) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean hasRealParent(Structure struc) {
        if (struc.getParent() == null) {
            return false;
        }
        if (!(struc.getParent() instanceof FusedSystem)) {
            return true;
        }
        FusedSystem fusedParent = (FusedSystem)struc.getParent();
        return !fusedParent.hasSubSystem(struc);
    }

    public static void dissect(Molecule mol) {
        StringBuffer description = new StringBuffer();
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom a = mol.getAtom(i);
            description.append(a.getSymbol());
            if (a.getValenceProp() != -1) {
                description.append(" valence=").append(a.getValenceProp());
            }
            description.append('\n');
        }
        System.out.println(description.toString());
    }

    public static boolean isAtom(MolAtom atom, int atno) {
        if (atom == null) {
            return false;
        }
        return atom.getAtno() == atno;
    }

    public static boolean isOxygen(MolAtom atom) {
        return Util.isAtom(atom, 8);
    }

    public static boolean isOH(MolAtom atom) {
        return Util.isOxygen(atom) && Util.isOHOrAnalog(atom);
    }

    public static boolean isOHOrAnalog(MolAtom atom) {
        if (!Util.isOxygenOrAnalog(atom)) {
            return false;
        }
        if (atom.getBondCount() != 1) {
            return false;
        }
        return atom.getBond(0).getType() == 1;
    }

    public static boolean isOxygenOrAnalog(MolAtom atom) {
        return Util.isAtom(atom, 8) || Util.isAtom(atom, 16) || Util.isAtom(atom, 34) || Util.isAtom(atom, 52);
    }

    public static boolean isNitrogen(MolAtom atom) {
        return Util.isAtom(atom, 7);
    }

    public static boolean isRGroup(MolAtom atom) {
        return Util.isAtom(atom, 134);
    }

    public static boolean isImplicitPolyAcid(Structure struc) {
        return Util.isImplicitPolyAcid(struc.getName());
    }

    public static boolean isImplicitPolyAcid(String name) {
        for (String acidname : implicitPolyAcidNames) {
            if (!acidname.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean canBeBasic(Structure struc, Structure next) {
        if (struc == null) {
            return false;
        }
        if (next != null && next.isCloneOf(struc)) {
            return false;
        }
        if (struc.isRoot() || struc.isSpaceSeparated() || struc.hasLocant() || struc.getDashConnected()) {
            return false;
        }
        boolean hasRadical = struc.getFirstRadicalSuffixIndex() > -1;
        boolean isRadical = struc.getName() != null && struc.getName().endsWith("yl");
        return !hasRadical && !isRadical;
    }

    public static MolBond getDoubleBond(Molecule m) {
        int i = m.getBondCount();
        while (--i >= 0) {
            MolBond b = m.getBond(i);
            if (b.getType() != 2) continue;
            return b;
        }
        return null;
    }

    public static String basicSmiles(String cxsmiles) {
        String res = cxsmiles;
        if (res == null) {
            return "";
        }
        int start = res.indexOf(" |");
        if (start != -1) {
            res = res.substring(0, start);
        }
        if ((start = res.indexOf("{")) != -1) {
            res = res.substring(0, start);
        }
        return res;
    }

    public static boolean isChain(String cxsmiles) {
        if (cxsmiles.endsWith("Chain}")) {
            return true;
        }
        String smiles = Util.basicSmiles(cxsmiles);
        return smiles.replaceAll("[C=#]", "").length() == 0;
    }

    public static boolean isName(String name, String key) {
        if (key.equals(name)) {
            return true;
        }
        return key.endsWith("e") && key.substring(0, key.length() - 1).equals(name);
    }

    public static String readURL(String url) throws IOException {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(url).openStream()));
            StringBuilder res = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                res.append(line).append('\n');
            }
            return res.toString();
        }
        catch (MalformedURLException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }
}

