/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.lex;

import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.marvin.io.formats.name.nameimport.NameImportException;

public class Lexer {
    final String name;
    final int len;
    private final char[] chars;
    protected int index = 0;

    Lexer(String name) {
        this.name = name;
        this.len = name.length();
        this.chars = name.toCharArray();
    }

    protected boolean hasMore() {
        return this.index < this.len;
    }

    protected char read() {
        if (this.index >= this.len) {
            return '\u0000';
        }
        return this.chars[this.index++];
    }

    protected char peek() {
        return this.peek(0);
    }

    protected char next() {
        return this.peek(1);
    }

    protected char peek(int offset) {
        if (this.index + offset >= this.len) {
            return '\u0000';
        }
        return this.chars[this.index + offset];
    }

    protected boolean eol(int offset) {
        return this.peek(offset) == '\u0000';
    }

    protected char prev() {
        if (this.index == 0) {
            return '\u0000';
        }
        return this.chars[this.index - 1];
    }

    public void move(int offset) {
        this.index += offset;
    }

    protected int readOptionalInt() {
        char c;
        int res = -1;
        while ((c = this.read()) != '\u0000') {
            int value;
            if (Character.isDigit(c)) {
                value = Character.getNumericValue(c);
            } else {
                value = Util.unicodeSuperscriptNumberValue(c);
                if (value < 0) {
                    --this.index;
                    break;
                }
            }
            if (res == -1) {
                res = 0;
            }
            res = res * 10 + value;
        }
        return res;
    }

    protected int readInt() {
        int res = this.readOptionalInt();
        if (res == -1) {
            throw new NameImportException("Number expected at " + this.remainder());
        }
        return res;
    }

    void skipSpaces() {
        while (this.peek() == ' ') {
            this.read();
        }
    }

    protected boolean read(String prefix) {
        if (!this.name.substring(this.index).startsWith(prefix)) {
            return false;
        }
        this.index += prefix.length();
        return true;
    }

    protected boolean readToEnd(String text) {
        if (!this.name.substring(this.index).equals(text)) {
            return false;
        }
        this.index += text.length();
        return true;
    }

    protected boolean read(char c) {
        if (this.peek() != c) {
            return false;
        }
        ++this.index;
        return true;
    }

    protected void mustRead(char c) {
        if (this.read(c)) {
            return;
        }
        throw new NameImportException("Expected: " + c);
    }

    public String alreadyLexed() {
        return this.name.substring(0, this.index);
    }

    public String remainder() {
        return this.name.substring(this.index);
    }

    public String toString() {
        return "Lexer { remaining: " + this.remainder() + " }";
    }
}

