/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.lex;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.UnknownTokenException;
import chemaxon.marvin.io.formats.name.nameimport.lex.Lexer;
import chemaxon.marvin.io.formats.name.nameimport.lex.PostLexer;
import chemaxon.marvin.io.formats.name.nameimport.lex.PreLexer;
import chemaxon.marvin.io.formats.name.nameimport.lex.StructureLexer;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AzaLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.BondNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.BracketToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.ComplexLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.EndingToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.FusedLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Hydro;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.IonNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.NonStdValenceLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.RatioToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.RingNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Separator;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StereoNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.IUPACParserCore;
import chemaxon.naming.NameFormatException;
import chemaxon.naming.NamePrefixException;
import chemaxon.naming.n2s.N2S;
import java.util.ArrayList;

public class NameLexer
extends Lexer {
    private final boolean dataMining;
    int num;
    int primes;
    Locant locant;
    boolean dropBracket;
    boolean ringNumbering;

    public static ArrayList<Token> parse(String name, boolean dataMining) throws NameFormatException {
        return new NameLexer(name, dataMining).parseName();
    }

    NameLexer(String name) {
        super(name);
        this.dataMining = false;
    }

    private NameLexer(String name, boolean dataMining) {
        super(NameLexer.preParse(name, dataMining));
        this.dataMining = dataMining;
    }

    private static String preParse(String name, boolean dataMining) {
        name = PreLexer.preParseName(name, dataMining);
        return name;
    }

    private ArrayList<Token> parseName() throws NameFormatException {
        ArrayList<Token> tokens = this.parseName('\u0000');
        if (!PostLexer.canBeValidName(tokens = PostLexer.fix(tokens), this.dataMining)) {
            throw new NameImportException("Invalid name: " + this.name);
        }
        return tokens;
    }

    private ArrayList<Token> parseName(char close) throws NameFormatException {
        ArrayList<Token> res = new ArrayList<Token>();
        while (this.hasMore()) {
            LocantList l;
            int valence;
            if (this.read(close)) {
                return res;
            }
            if (this.dataMining && close != '\u0000' && (this.read(')') || this.read('}') || this.read(']'))) {
                return res;
            }
            if (this.peek() == '[' && this.parseFusedLocants(res) || this.parseLocants(res, close) || this.parseRatio(res)) continue;
            if (this.read('{')) {
                this.parseBracket(res, '{', '}');
                continue;
            }
            if (this.read('(')) {
                this.parseBracket(res, '(', ')');
                continue;
            }
            if (this.read('[')) {
                this.parseBracket(res, '[', ']');
                continue;
            }
            if (this.read('-') || this.read(' ')) {
                this.read(this.prev());
                res.add(new Separator(this.prev()));
                continue;
            }
            if (this.read("rel-")) {
                N2S.getState().rel = true;
                continue;
            }
            if (this.read("$l")) {
                valence = this.parseLambda();
                l = new LocantList();
                l.tryAddLocant(new NonStdValenceLocant(1, 0, valence));
                res.add(l);
                continue;
            }
            if (this.read("\u03bb") || this.read("lambda")) {
                valence = this.readInt();
                l = new LocantList();
                l.tryAddLocant(new NonStdValenceLocant(1, 0, valence));
                res.add(l);
                continue;
            }
            if (Character.isLetter(this.peek())) {
                this.parseText(res);
                continue;
            }
            if (this.read('\u200b')) {
                if (!IUPACParserCore.revolution) continue;
                res.add(new Separator('\u200b'));
                continue;
            }
            if (this.read('/')) {
                res.add(new Separator('/'));
                continue;
            }
            throw new NameImportException("Unrecognized name format: " + this.remainder());
        }
        return res;
    }

    private void parseBracket(ArrayList<Token> res, char open, char close) throws NameFormatException {
        ArrayList<Token> inside = this.parseName(close);
        if (this.avoidBrackets(inside, res, open)) {
            res.addAll(inside);
        } else {
            res.add(new BracketToken(open, close, inside));
        }
    }

    private boolean avoidBrackets(ArrayList<Token> inside, ArrayList<Token> res, char open) {
        if (inside.size() != 1) {
            return false;
        }
        Token t = inside.get(0);
        if (t.getType() == 5) {
            return true;
        }
        if (t.getType() == 2 && open != '[') {
            return true;
        }
        if (t instanceof Hydro) {
            return true;
        }
        return (res.size() == 0 || !(res.get(res.size() - 1) instanceof EndingToken) && !(res.get(res.size() - 1) instanceof Separator)) && t.getType() == 0;
    }

    private boolean parseLocants(ArrayList<Token> res, char close) {
        Locant singleLocant = this.parseSingleLocant();
        if (singleLocant == null) {
            return this.parseLocantList(res, close);
        }
        LocantList l = new LocantList();
        l.tryAddLocant(singleLocant);
        res.add(l);
        if (this.prev() == '-') {
            this.move(-1);
        }
        return true;
    }

    boolean parseLocantList(ArrayList<Token> res, char close) {
        boolean foundSomething = false;
        this.ringNumbering = false;
        this.dropBracket = false;
        boolean complexLocant = false;
        LocantList l = new LocantList();
        this.locant = null;
        while (this.hasMore()) {
            if (this.parseOneLocant(res, close)) {
                foundSomething = true;
                continue;
            }
            if (this.num == -1 && this.locant == null) {
                if (this.read(',') || this.ringNumbering && this.read(".")) continue;
                int size = l.getLocantsList().size();
                if (size <= 0 || size % 2 != 0 || !this.read(":")) break;
                complexLocant = true;
                continue;
            }
            this.makeLocantObject();
            if (this.remainder().matches("\\(\\d+'*\\).*")) {
                SimpleLocant bondNumberStart = (SimpleLocant)this.locant;
                this.locant = null;
                this.read();
                this.parseOneLocant(res, close);
                this.makeLocantObject();
                this.locant = new BondNumber(bondNumberStart, (SimpleLocant)this.locant);
                this.read();
            } else if (this.peek() == '-' && l.getLocantsList().size() == 1 && Character.isLowerCase(this.next()) && this.peek(2) == close) {
                this.read();
                char letter = this.read();
                int locant1 = l.getLocant(0).getValue();
                int locant2 = this.locant.getValue();
                l = new LocantList();
                this.locant = new FusedLocant(locant1, locant2, letter);
            }
            this.addLocant(l, this.locant);
            if (this.peek() != '(' || !this.remainder().matches("\\(\\d+H(\\)|,).*") && (!this.remainder().matches("\\([RS](\\)|,).*") || l.size() != 0)) continue;
            this.dropBracket = true;
            this.move(1);
        }
        if (complexLocant) {
            l = NameLexer.makeComplexLocant(l);
        }
        if (l.hasLocant()) {
            res.add(l);
            return true;
        }
        return foundSomething;
    }

    private void addLocant(LocantList list, Locant locant) {
        if (list.size() > 0 && locant instanceof StereoNumber && list.getType() == 6) {
            LocantList stereoList = new LocantList();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                StereoNumber sn = ((AtomLocant)list.removeLocant(0)).toStereoNumber();
                if (sn == null) {
                    throw new NameImportException("Numbering cannot be parsed.");
                }
                stereoList.addLocant(sn);
            }
            list.tryAddLocant(stereoList);
        }
        list.addLocant(locant);
    }

    private void makeLocantObject() {
        if (this.locant != null) {
            this.locant.setParent(this.primes);
        } else {
            this.locant = this.ringNumbering ? new RingNumber(this.num) : new SimpleLocant(this.num, this.primes);
        }
    }

    Locant parseLocant() {
        this.parseOneLocant(null, '\u0000');
        this.makeLocantObject();
        return this.locant;
    }

    private boolean parseOneLocant(ArrayList<Token> res, char close) {
        this.locant = null;
        if (this.read("\u03b1") || this.peek(1) == '-' && !this.eol(2) && (this.read("a") || this.read("A"))) {
            this.locant = new SimpleLocant(Integer.MAX_VALUE);
            return false;
        }
        if (this.read("\u03b2") || this.peek(1) == '-' && !this.eol(2) && (this.read("b") || this.read("B"))) {
            this.locant = new SimpleLocant(0x7FFFFFFE);
            return false;
        }
        if (this.read("\u03c9")) {
            this.locant = new SimpleLocant(0x7FFFFFFD);
            return false;
        }
        if (this.prev() == '(' && this.read("+")) {
            int charge = this.readInt();
            this.locant = new IonNumber(charge);
            return false;
        }
        if (this.prev() == '(' && this.read("-")) {
            int charge = this.readInt();
            this.locant = new IonNumber(-charge);
            return false;
        }
        this.num = this.readOptionalInt();
        if (this.num >= 100) {
            throw new NameImportException("Too big locant: " + this.num);
        }
        if (this.num != -1) {
            this.skipSpaces();
        }
        if (this.num == -1 && this.isAtomLocant(this.peek(), 1)) {
            if (this.read('N') || this.read('n')) {
                this.num = this.readOptionalInt();
                this.locant = this.num == -1 ? new AzaLocant("N") : new AzaLocant(this.num + "-N");
            } else {
                this.locant = new AtomLocant(this.read() + "");
            }
        }
        this.primes = this.parsePrimes();
        if (this.num != -1 && NameLexer.isLatinLowerCase(this.peek()) && !NameLexer.isLatinLowerCase(this.peek(1))) {
            this.num *= 100;
            this.num += this.read() - 97 + 1;
        }
        if (this.primes == 0) {
            this.primes = this.parsePrimes();
        }
        if (this.read('H') || this.read("(H)")) {
            Hydro h = new Hydro(this.num, this.primes);
            res.add(h);
            if (this.dropBracket && this.read(')')) {
                this.dropBracket = false;
                if (IUPACParserCore.revolution) {
                    res.add(new Separator('-'));
                }
            }
            return true;
        }
        if (this.read('^')) {
            this.ringNumbering = true;
            if (this.num == -1) {
                throw new NameImportException("Unexpected superscript");
            }
            this.locant = this.parseRingNumbering(this.num);
        } else if (this.stereoLetter()) {
            char stereo = this.read();
            boolean relative = false;
            if ("RSrs".indexOf(stereo) != -1 && this.read('*')) {
                relative = true;
            }
            if (this.locant != null) {
                this.locant = new StereoNumber(this.locant, stereo, relative);
            } else {
                boolean empty;
                boolean bl = empty = this.num == -1;
                if (this.num == -1) {
                    this.num = 1;
                }
                this.locant = new StereoNumber(this.num, stereo, relative, empty);
            }
            if (this.dropBracket && this.read(')')) {
                this.dropBracket = false;
            }
        }
        if (this.locant == null && this.num != -1) {
            int valence;
            if (this.peek(1) == ')' && this.read('+')) {
                this.locant = new IonNumber(this.num);
            } else if (this.peek(1) == ')' && this.read('-')) {
                this.locant = new IonNumber(-this.num);
            } else if (this.read("-N")) {
                this.locant = new AzaLocant(this.num + "-N");
            } else if (this.isAtomLocant(this.peek(1), 2) && this.read("-")) {
                char atom = this.read();
                this.locant = new SimpleLocant(this.num, this.primes);
            } else if (this.read("$l")) {
                valence = this.parseLambda();
                this.locant = new NonStdValenceLocant(this.num, 0, valence);
            } else if (this.read("\u03bb") || this.read("lambda") || this.read("-lambda")) {
                valence = this.readInt();
                this.locant = new NonStdValenceLocant(this.num, 0, valence);
            } else if (this.read("\u03b1") || this.read("-\u03b1")) {
                this.locant = new SimpleLocant(this.num, 'a');
            } else if (this.read("\u03b2") || this.read("-\u03b2")) {
                this.locant = new SimpleLocant(this.num, 'b');
            } else if (this.read("-cis")) {
                this.locant = new StereoNumber(this.num, "cis");
            } else if (this.read("-trans")) {
                this.locant = new StereoNumber(this.num, "trans");
            } else if (this.read("-exo")) {
                this.locant = new StereoNumber(this.num, "exo");
            } else if (this.read("-endo")) {
                this.locant = new StereoNumber(this.num, "endo");
            } else if (this.peek() == '.' && close != '\u0000' && this.locant == null) {
                this.locant = new RingNumber(this.num);
                this.ringNumbering = true;
            }
        }
        return false;
    }

    private boolean stereoLetter() {
        if ("EZRS".indexOf(this.peek()) != -1) {
            return true;
        }
        return "rs".indexOf(this.peek()) != -1 && !Character.isLetter(this.peek(1));
    }

    private int parsePrimes() {
        int primes = 0;
        if (this.num != -1 || this.locant != null) {
            while (this.read('\"')) {
                primes += 2;
            }
            while (this.read('\'')) {
                ++primes;
            }
        }
        return primes;
    }

    private static boolean isLatinLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }

    private Locant parseSingleLocant() {
        if (this.read("cis-")) {
            return StereoNumber.cis;
        }
        if (this.read("trans-")) {
            return StereoNumber.trans;
        }
        if (!this.read("(+)") && !this.read("(-)") && !this.read("(+-)") && !this.read("(.+-.)") || this.read(' ') || this.read('-')) {
            // empty if block
        }
        if (this.read("d-") || this.read("l-")) {
            // empty if block
        }
        if (this.read("endo-") || this.read("(endo)")) {
            return StereoNumber.endo;
        }
        if (this.read("exo-") || this.read("(exo)")) {
            return StereoNumber.exo;
        }
        if (this.read("D-") || this.read("(D)")) {
            return new StereoNumber(4);
        }
        if (this.read("L-") || this.read("(L)")) {
            return new StereoNumber(3);
        }
        if (this.read("DL-") || this.read("(DL)")) {
            return new StereoNumber(5);
        }
        if (this.read("ortho-") || this.read("o-") || this.readToEnd("o")) {
            return new SimpleLocant(2, true);
        }
        if (this.read("meta-") || this.read("m-") || this.readToEnd("m")) {
            return new SimpleLocant(3, true);
        }
        if (this.read("para-") || this.read("p-") || this.readToEnd("p")) {
            return new SimpleLocant(4, true);
        }
        return null;
    }

    private Locant parseRingNumbering(int num) {
        char open = this.read();
        int first = this.readInt();
        char c = this.read();
        if (c == this.closingBracket(open)) {
            return new RingNumber(num, first);
        }
        if (c != ',') {
            throw new NameImportException("Comma or bracket expected in ring number");
        }
        int second = this.readInt();
        char closeBracket = this.read();
        if (closeBracket != this.closingBracket(open)) {
            throw new NameImportException(this.closingBracket(open) + " expected, " + closeBracket + " found");
        }
        return new RingNumber(num, first, second);
    }

    private static LocantList makeComplexLocant(LocantList l) {
        ArrayList<Locant> locants = l.getLocantsList();
        if (locants.size() % 2 != 0) {
            throw new NameImportException("Invalid locant format");
        }
        l = new LocantList();
        int i = 0;
        while (i < locants.size()) {
            SimpleLocant l1 = (SimpleLocant)locants.get(i++);
            SimpleLocant l2 = (SimpleLocant)locants.get(i++);
            ComplexLocant c = new ComplexLocant(l1, l2);
            l.tryAddLocant(c);
        }
        return l;
    }

    private static boolean isAtomLocantStart(char c) {
        return "CNOPSn".indexOf(c) != -1;
    }

    private boolean isAtomLocant(char c, int offset) {
        if (!NameLexer.isAtomLocantStart(c)) {
            return false;
        }
        char next = this.peek(offset);
        if (next == '\u0000') {
            return true;
        }
        return "'\"-,EZ123456789".indexOf(next) != -1;
    }

    private boolean parseFusedLocants(ArrayList<Token> res) {
        int len = 0;
        if (Character.isLowerCase(this.peek(1)) && this.peek(2) == ']') {
            len = 1;
        } else if (Character.isLowerCase(this.peek(1)) && Character.isLowerCase(this.peek(2)) && this.peek(3) == ']') {
            len = 2;
        } else {
            return false;
        }
        this.read();
        LocantList l = new LocantList();
        int i = 1;
        while (i <= len) {
            char c = this.read();
            FusedLocant f = new FusedLocant(i++, i, c);
            l.tryAddLocant(f);
        }
        res.add(l);
        this.read();
        return true;
    }

    private int parseLambda() {
        this.mustRead('^');
        char open = this.read();
        char close = this.closingBracket(open);
        if (close == '\u0000') {
            throw new NameImportException("Bracket expected");
        }
        int closeIndex = this.name.indexOf(close, this.index);
        if (closeIndex == -1) {
            throw new NameImportException("Missing closing bracket");
        }
        String value = this.name.substring(this.index, closeIndex);
        this.index = closeIndex + 1;
        int l = Integer.parseInt(value);
        return l;
    }

    private boolean parseRatio(ArrayList<Token> res) {
        if (this.peek(0) != '(' || this.peek(2) != ':' || this.peek(4) != ')') {
            return false;
        }
        char c1 = this.peek(1);
        char c2 = this.peek(3);
        try {
            int mix1 = Integer.parseInt(c1 + "");
            int mix2 = c2 == '?' ? -1 : Integer.parseInt(c2 + "");
            String text = this.remainder().substring(0, 5);
            this.move(5);
            RatioToken t = new RatioToken(mix1, mix2);
            t.setName(text);
            res.add(t);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void parseText(ArrayList<Token> res) throws NameFormatException {
        char c;
        StringBuffer buff = new StringBuffer();
        while (Character.isLetter(c = this.peek()) || c == ' ' || c == '.' && (buff.toString().equals("compd") || buff.toString().equals("mixt"))) {
            buff.append(this.read());
        }
        String text = buff.toString();
        if (text.contains("cyclo") && text.endsWith("a") && this.peek() == '[') {
            text = text.substring(0, text.length() - 1);
        }
        try {
            this.index -= text.length();
            String parsed = this.parseText(text, res);
            this.index += parsed.length();
        }
        catch (UnknownTokenException e) {
            String prefix = this.alreadyLexed();
            throw new UnknownTokenException(e.getUnknownToken(), prefix + e.getPrefix());
        }
        catch (NamePrefixException e) {
            String prefix = this.alreadyLexed();
            throw new NamePrefixException(prefix + e.getParsed(), e.token);
        }
    }

    private String parseText(String text, ArrayList<Token> res) throws NameFormatException {
        try {
            this.parseFullText(text, res);
            return text;
        }
        catch (UnknownTokenException e) {
            int space = text.lastIndexOf(32);
            if (space == -1) {
                throw e;
            }
            try {
                return this.parseBeforeSpace(text, space, res);
            }
            catch (NameFormatException e4) {
                throw e;
            }
        }
    }

    private void parseFullText(String text, ArrayList<Token> res) throws NameFormatException {
        StructureLexer.addStructures(text, res);
    }

    private String parseBeforeSpace(String text, int space, ArrayList<Token> res) throws NameFormatException {
        String textPrefix = text.substring(0, space);
        return this.parseText(textPrefix, res);
    }

    private String parseSplitAtSpace(String text, int space, ArrayList<Token> res) throws NameFormatException {
        ArrayList<Token> newTokens = new ArrayList<Token>();
        String text1 = text.substring(0, space);
        String text2 = text.substring(space + 1);
        this.parseFullText(text1, newTokens);
        newTokens.add(new Separator(' '));
        this.parseText(text2, newTokens);
        res.addAll(newTokens);
        return text;
    }

    private String parseRemovingSpace(String text, int space, ArrayList<Token> res) throws NameFormatException {
        String fixedText = text.substring(0, space) + text.substring(space + 1);
        String parsed = this.parseText(fixedText, res);
        if (parsed == fixedText) {
            return text;
        }
        return parsed;
    }

    private char closingBracket(char open) {
        switch (open) {
            case '(': {
                return ')';
            }
            case '{': {
                return '}';
            }
            case '[': {
                return ']';
            }
            case '~': {
                return '~';
            }
        }
        return '\u0000';
    }

    private boolean isOpenBracket(char c) {
        return c == '[' || c == '(' || c == '{';
    }
}

