/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.lex;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.util.StringRewriter;

public class PreLexer {
    private static StringRewriter rewriter = PreLexer.getRewriter();

    static String preParseName(String IUPACName, boolean dataMining) {
        IUPACName = PreLexer.addCommasToCASName(IUPACName);
        IUPACName = PreLexer.removeWhiteSpaces(IUPACName);
        IUPACName = IUPACName.replace("epoxy", "epioxy");
        IUPACName = PreLexer.changeNormalFlagToOne(IUPACName);
        IUPACName = PreLexer.replaceCommonMisspellings(IUPACName);
        IUPACName = PreLexer.replaceTraditionalForms(IUPACName);
        boolean CAS = false;
        if (IUPACName.endsWith("CI)")) {
            int index = IUPACName.lastIndexOf(40);
            IUPACName = IUPACName.substring(0, index).trim();
            CAS = true;
        }
        if ((IUPACName = PreLexer.separateNameFragmentsInCAS(IUPACName)).indexOf(", ") > 0) {
            CAS = true;
            IUPACName = PreLexer.CASToIUPAC(IUPACName, dataMining);
        }
        if (CAS) {
            IUPACName = PreLexer.checkBrackets(IUPACName, '(', ')');
            IUPACName = PreLexer.checkBrackets(IUPACName, '[', ']');
            IUPACName = PreLexer.checkBrackets(IUPACName, '{', '}');
        }
        return IUPACName;
    }

    private static String replaceCommonMisspellings(String name) {
        name = name.replaceAll("tertbut", "tert-but");
        name = name.replaceAll("(([^a-z])t\\-but)|(^t\\-but)", "$2tert-but");
        name = name.replaceAll("iso-", "iso");
        name = name.replaceAll("O-acetyl", "acetyl");
        name = PreLexer.sulphaneToSulfane(name);
        return name;
    }

    private static String addCommasToCASName(String name) {
        boolean endsWithSalt = name.matches(".*- [a-z]*ide");
        if (!endsWithSalt || !name.matches(".*- [a-z]*ide[^a-z]*.*")) {
            return name;
        }
        int dashIndex = -1;
        int ideIndex = 0;
        while (dashIndex == -1) {
            if ((ideIndex = name.indexOf("ide", ideIndex + 1)) < 0) {
                dashIndex = -2;
            }
            dashIndex = name.substring(0, ideIndex).lastIndexOf("- ");
        }
        if (dashIndex > 0) {
            name = name.substring(0, dashIndex + 1) + "," + name.substring(dashIndex + 1);
        }
        return name;
    }

    private static String CASToIUPAC(String CASName, boolean dataMining) {
        String[] fragments = CASName.split(", ");
        String name = "";
        int valid = 1;
        for (int i = 0; i < fragments.length; ++i) {
            String fragment = fragments[i];
            if (fragment.length() == 0) continue;
            if (i > 0 && (valid = Math.min(PreLexer.isFragmentValidCASLigand(fragment), valid)) < 0) {
                throw new NameImportException("Invalid CAS name.");
            }
            if (fragment.matches(".*[^A-Z]\\)\\-")) {
                fragment = fragment.substring(0, fragment.length() - 1);
            }
            if (name != "" && Character.isLetter(name.charAt(name.length() - 1))) {
                name = fragment.endsWith(" ester") ? " " + name : '\u200b' + name;
            }
            name = i == fragments.length - 1 && PreLexer.isSaltFragment(fragment) ? name + " " + fragment : (name.length() > 0 && (fragment.endsWith("ide") || fragment.endsWith("ate")) ? fragment + " " + name : fragment + name);
        }
        if (dataMining && valid < 1) {
            throw new NameImportException("Invalid CAS name.");
        }
        return name;
    }

    private static boolean isSaltFragment(String nameFragment) {
        return nameFragment.endsWith("ide") && !nameFragment.matches(".*[a-z\\)\\]\\}]-.*") && nameFragment.indexOf("yl") < 0 && nameFragment.indexOf(" ") < 0;
    }

    private static String changeNormalFlagToOne(String IUPACName) {
        IUPACName = PreLexer.replaceWord(IUPACName, "n-meth", "meth");
        IUPACName = PreLexer.replaceWord(IUPACName, "n-eth", "eth");
        IUPACName = PreLexer.replaceWord(IUPACName, "n-prop", "prop");
        IUPACName = PreLexer.replaceWord(IUPACName, "n-but", "but");
        IUPACName = PreLexer.replaceWord(IUPACName, "n-pent", "pent");
        IUPACName = PreLexer.replaceWord(IUPACName, "n-hex", "hex");
        IUPACName = PreLexer.replaceWord(IUPACName, "n-hept", "hept");
        IUPACName = PreLexer.replaceWord(IUPACName, "n-oct", "oct");
        IUPACName = PreLexer.replaceWord(IUPACName, "n-non", "non");
        IUPACName = PreLexer.replaceWord(IUPACName, "n-dec", "dec");
        IUPACName = PreLexer.replaceWord(IUPACName, "n-undec", "undec");
        IUPACName = PreLexer.replaceWord(IUPACName, "n-dodec", "dodec");
        IUPACName = PreLexer.replaceWord(IUPACName, "n-tridec", "tridec");
        IUPACName = PreLexer.replaceWord(IUPACName, "n-tetradec", "tetradec");
        IUPACName = PreLexer.replaceWord(IUPACName, "n-amyl", "amyl");
        return IUPACName;
    }

    private static String replaceWord(String str, String pattern, String replacement) {
        int index;
        int from = 0;
        while ((index = str.indexOf(pattern, from)) > -1) {
            if (index == 0 || !Character.isLetter(str.charAt(index - 1))) {
                str = str.substring(0, index) + replacement + str.substring(index + pattern.length());
            }
            from = index + 1;
        }
        return str;
    }

    private static StringRewriter getRewriter() {
        StringRewriter res = new StringRewriter();
        res.replaceAll("[ \\t\\n\\x0B\\f\\r]+", " ");
        res.replaceAll("[ ]*-[ ]*", "-");
        res.replaceAll("\\( ", "(");
        res.replaceAll("\\[ ", "[");
        res.replaceAll("\\{ ", "{");
        res.replaceAll(" \\)", ")");
        res.replaceAll(" \\]", "]");
        res.replaceAll(" \\}", "}");
        res.replaceAll("([A-Z]|[1-9]), ", "$1,");
        return res;
    }

    private static String removeWhiteSpaces(String IUPACName) {
        IUPACName = IUPACName.trim();
        IUPACName = rewriter.rewrite(IUPACName);
        return IUPACName;
    }

    private static int isFragmentValidCASLigand(String str) {
        if (str.endsWith("ane") || str.endsWith("ene") || str.endsWith("yne")) {
            return -1;
        }
        if (!(str.endsWith("-") || str.endsWith("ester") || str.endsWith("acid") || str.endsWith("alcohol") || str.endsWith("acetate") || str.endsWith("ether") || str.endsWith("o"))) {
            return 0;
        }
        return 1;
    }

    private static String checkBrackets(String name, char ob, char cb) {
        int close;
        int open = name.lastIndexOf(ob);
        if (open > (close = name.lastIndexOf(cb))) {
            return name + cb;
        }
        return name;
    }

    private static String separateNameFragmentsInCAS(String IUPACName) {
        IUPACName = IUPACName.replace(",[", ", [");
        IUPACName = IUPACName.replace(",(", ", (");
        IUPACName = IUPACName.replace(",{", ", {");
        return IUPACName;
    }

    private static String sulphaneToSulfane(String IUPACName) {
        IUPACName = IUPACName.replace("sulph", "sulf");
        return IUPACName;
    }

    private static String replaceTraditionalForms(String name) {
        name = name.replace("as-triazin", "1,2,4-triazin");
        name = name.replace("s-triazin", "1,3,5-triazin");
        name = name.replace("s-triazol", "1,2,4-triazol");
        return name;
    }

    public static void main(String[] args) {
        String input = args[0];
        System.out.println();
        System.out.println("Original name : " + input);
        System.out.println();
        System.out.println("Preparsed name: " + PreLexer.preParseName(input, false));
        System.out.println();
    }
}

