/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.lex.data;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StereoNumber;
import chemaxon.struc.MolAtom;

public class AtomLocant
extends Locant {
    private int locantIndex = 0;
    private boolean possibleStereo = false;

    public AtomLocant(String atomLocant) {
        this.parseLocant(atomLocant);
        this.possibleStereo = "S".equals(atomLocant);
    }

    protected AtomLocant() {
    }

    public int getLocantIndex() {
        return this.locantIndex;
    }

    public void setLocantIndex(int locantIndex) {
        this.locantIndex = locantIndex;
    }

    private void parseLocant(String locant) {
        char ch;
        this.value = 0;
        this.locantIndex = 0;
        int index = -1;
        index = locant.indexOf(45);
        if (index > -1) {
            String loc = locant.substring(0, index);
            this.locantIndex = AtomLocant.stringToInt(loc);
            locant = locant.substring(index + 1);
        }
        String atomSymbol = "";
        index = 0;
        while (index < locant.length() && Character.isLetter(ch = locant.charAt(index++))) {
            atomSymbol = atomSymbol + ch;
        }
        this.value = MolAtom.numOf(atomSymbol);
        if (index >= locant.length()) {
            return;
        }
        locant = locant.substring(index + 1);
        for (int i = 0; i < locant.length(); ++i) {
            if (locant.charAt(i) == '\'') {
                ++this.parent;
                continue;
            }
            if (locant.charAt(i) != '\"') continue;
            this.parent += 2;
        }
    }

    public String toString() {
        String atomSymbol = MolAtom.symbolOf(this.value);
        if (this.locantIndex > 0) {
            atomSymbol = atomSymbol + Integer.toString(this.locantIndex);
        }
        for (int i = 0; i < this.parent; ++i) {
            atomSymbol = atomSymbol + "'";
        }
        return atomSymbol;
    }

    public String getAtomSymbol() {
        return MolAtom.symbolOf(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AtomLocant)) {
            return false;
        }
        AtomLocant oo = (AtomLocant)o;
        return super.equals(o) && this.locantIndex == oo.locantIndex;
    }

    boolean isPossibleStereo() {
        return this.possibleStereo;
    }

    public StereoNumber toStereoNumber() {
        if (this.possibleStereo) {
            return new StereoNumber(16);
        }
        return null;
    }
}

