/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.lex.data;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;

public class AzaLocant
extends AtomLocant {
    private int azaIndex = 0;

    public AzaLocant(String locant) {
        this.parseLocant(locant);
    }

    @Override
    public void setParent(int parent) {
        this.value = parent;
    }

    @Override
    public int getParent() {
        return this.azaIndex;
    }

    public int getAzaIndex() {
        return this.value;
    }

    private void parseLocant(String locant) {
        this.value = 0;
        this.azaIndex = 0;
        if (!locant.startsWith("N")) {
            String loc = locant.substring(0, locant.indexOf("-"));
            this.azaIndex = AzaLocant.stringToInt(loc);
            locant = locant.substring(locant.indexOf("-") + 1);
        }
        locant = locant.substring(1);
        for (int i = 0; i < locant.length(); ++i) {
            if (locant.charAt(i) == '\'') {
                ++this.value;
                continue;
            }
            if (locant.charAt(i) != '\"') continue;
            this.value += 2;
        }
        if (this.azaIndex <= 0) {
            this.azaIndex = AzaLocant.stringToInt(locant);
        }
    }

    @Override
    public String toString() {
        String N = "N";
        if (this.azaIndex > 0) {
            N = N + Integer.toString(this.azaIndex);
        }
        for (int i = 0; i < this.value; ++i) {
            N = N + "'";
        }
        return N;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AzaLocant)) {
            return false;
        }
        AzaLocant oo = (AzaLocant)o;
        return super.equals(o) && this.azaIndex == oo.azaIndex;
    }

    @Override
    public String getAtomSymbol() {
        return "N";
    }

    @Override
    public int getMaxParent() {
        return this.value;
    }
}

