/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.lex.data;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.EndingToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import java.util.ArrayList;

public class BracketToken
extends Token {
    public final char open;
    public final char close;
    public final ArrayList<Token> inside;

    public BracketToken(char open, char close, ArrayList<Token> inside) {
        this.open = open;
        this.close = close;
        this.inside = inside;
        this.name = open + ".." + close;
    }

    @Override
    public String getValue() {
        String content = this.inside.toString();
        content = content.substring(1, content.length() - 1);
        return this.open + content + this.close;
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    public ArrayList<Token> getInside() {
        if (this.isDoubleBracket()) {
            return ((BracketToken)this.inside.get(0)).getInside();
        }
        return this.inside;
    }

    public int getInsideLength() {
        if (this.getInside() == null) {
            return 0;
        }
        return this.getInside().size();
    }

    public LocantList toNumbering() {
        if (this.getInside() == null || this.getInside().size() != 1) {
            return null;
        }
        if (this.getInside().get(0) instanceof LocantList) {
            return (LocantList)this.getInside().get(0);
        }
        return null;
    }

    public EndingToken toEnding() {
        if (this.getInside() == null || this.getInside().size() != 1) {
            return null;
        }
        if (this.getInside().get(0) instanceof EndingToken) {
            return (EndingToken)this.getInside().get(0);
        }
        return null;
    }

    private boolean isDoubleBracket() {
        return this.inside != null && this.inside.size() == 1 && this.inside.get(0) instanceof BracketToken;
    }
}

