/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.lex.data;

import chemaxon.marvin.io.formats.name.nameimport.lex.LocantLexer;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;

public class Hydro
extends Token {
    public static final int HYDRO = 0;
    public static final int DEHYDRO = 1;
    private int type;
    private SimpleLocant locant;

    public Hydro(SimpleLocant locant) {
        this.locant = locant;
        this.name = "H";
    }

    public Hydro(int locant) {
        this(locant, 0);
    }

    public Hydro(int locant, int parent) {
        this.locant = new SimpleLocant(locant, parent);
        this.name = "H";
    }

    public Hydro(String name, String hydroString) {
        if (name.equalsIgnoreCase("hydro")) {
            this.name = name;
            this.type = 0;
            this.locant = null;
        } else if (name.equalsIgnoreCase("dehydro")) {
            this.name = name;
            this.type = 1;
            this.locant = null;
        } else if (hydroString.endsWith("h") || hydroString.endsWith("H")) {
            this.name = "H";
            this.type = 0;
            String locant = hydroString.substring(0, hydroString.length() - 1);
            this.locant = LocantLexer.parseSimpleLocant(locant);
        }
    }

    public SimpleLocant getLocant() {
        return this.locant;
    }

    public void setLocant(SimpleLocant locant) {
        this.locant = locant;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(boolean isHydro) {
        this.type = isHydro ? 0 : 1;
    }

    @Override
    public String toString() {
        if (this.locant == null) {
            return this.name;
        }
        String loc = this.locant.toString();
        return loc.equals("0") ? this.name : this.locant.toString() + this.name;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public String getTypeInString() {
        switch (this.type) {
            case 0: {
                return "HYDRO";
            }
            case 1: {
                return "DEHYDRO";
            }
        }
        return "ERROR " + this.type;
    }

    public Hydro cloneToken() {
        Hydro h = new Hydro(this.name, "H");
        h.locant = this.locant;
        h.type = this.type;
        return h;
    }
}

