/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.lex.data;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AzaLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.BondNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.ComplexLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.FusedLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.IonNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.RingNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StereoNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import java.util.ArrayList;

public class LocantList
extends Token {
    public static final int NOT_SET = -1;
    public static final int RING_NUMBERING = 0;
    public static final int BOND_NUMBERING = 1;
    public static final int SIMPLE_LOCANTS = 2;
    public static final int COMPLEX_LOCANTS = 3;
    public static final int ION_NUMBERING = 4;
    public static final int FUSED_LOCANTS = 5;
    public static final int ATOM_LOCANT = 6;
    private int type = -1;
    private ArrayList<Locant> locantList;
    boolean isOrthoMetaPara = false;

    public boolean isStereo() {
        return this.getLocant(0) instanceof StereoNumber;
    }

    public boolean isOrthoMetaPara() {
        return this.isOrthoMetaPara;
    }

    public LocantList expandOMP(int expectedSize) {
        if (expectedSize != 2) {
            return this;
        }
        if (this.isOrthoMetaPara() && this.size() == 1) {
            LocantList res = this.clone();
            res.locantList.add(0, new SimpleLocant(1));
            return res;
        }
        return this;
    }

    public LocantList() {
        this.name = "";
        this.type = -1;
        this.locantList = new ArrayList();
    }

    public LocantList clone() {
        LocantList res = new LocantList();
        res.tryAddLocant(this);
        return res;
    }

    public boolean hasLocant() {
        return this.locantList.size() > 0;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public ArrayList<Locant> getLocantsList() {
        return this.locantList;
    }

    public Locant getLocant(int index) {
        if (this.locantList.size() > index) {
            return this.locantList.get(index);
        }
        return null;
    }

    public Locant removeLocant(int index) {
        if (this.locantList.size() > index) {
            if (this.locantList.size() == 1) {
                this.type = -1;
            }
            return this.locantList.remove(index);
        }
        return null;
    }

    public void addLocant(Locant locant) {
        this.setOrthoMetaPara(locant);
        if (this.getType() == 1 && locant instanceof SimpleLocant) {
            locant = new BondNumber((SimpleLocant)locant);
        }
        if (this.getType() == 2 && locant instanceof BondNumber) {
            this.type = 1;
            ArrayList<Locant> oldList = this.locantList;
            this.locantList = new ArrayList();
            for (Locant old : oldList) {
                this.locantList.add(new BondNumber((SimpleLocant)old));
            }
        }
        if (this.locantList.size() == 1 && locant instanceof StereoNumber && this.locantList.get(0) instanceof SimpleLocant) {
            StereoNumber stereo = (StereoNumber)locant;
            SimpleLocant prev = (SimpleLocant)this.locantList.get(0);
            ComplexLocant complex = new ComplexLocant(prev, (SimpleLocant)stereo.getLocant());
            this.locantList.clear();
            locant = new StereoNumber(complex, stereo.getStereoData());
        }
        if (!this.tryAddLocant(locant)) {
            throw new NameImportException("Invalid locant: " + locant);
        }
    }

    public boolean tryAddLocant(Locant locant) {
        int type = LocantList.getLocantType(locant);
        this.setOrthoMetaPara(locant);
        if (this.type == -1) {
            this.type = type;
        }
        if (this.type == -1 || this.type != type) {
            return false;
        }
        this.locantList.add(locant);
        return true;
    }

    public boolean tryAddLocant(LocantList list) {
        if (list == null) {
            return true;
        }
        if (this.locantList.isEmpty()) {
            this.isOrthoMetaPara = list.isOrthoMetaPara;
        }
        if (this.type == -1) {
            this.type = list.type;
        }
        if (this.type != list.type) {
            return false;
        }
        this.locantList.addAll(list.locantList);
        return true;
    }

    public void addFirstLocant(Locant locant) {
        this.locantList.add(0, locant);
    }

    private void setOrthoMetaPara(Locant locant) {
        if (this.locantList.isEmpty() && locant instanceof SimpleLocant) {
            this.isOrthoMetaPara = ((SimpleLocant)locant).isOrthoMetaPara();
        }
    }

    public int getMaxParentIndex() {
        int max = 0;
        for (int i = 0; i < this.locantList.size(); ++i) {
            max = Math.max(max, this.locantList.get(i).getMaxParent());
        }
        return max;
    }

    public void setParentIndex(int parentIndex) {
        for (int i = 0; i < this.locantList.size(); ++i) {
            this.locantList.get(i).setParent(parentIndex);
        }
    }

    private static int getLocantType(Locant locant) {
        if (locant.getClass() == FusedLocant.class) {
            return 5;
        }
        if (locant.getClass() == RingNumber.class) {
            return 0;
        }
        if (locant.getClass() == BondNumber.class) {
            return 1;
        }
        if (locant instanceof SimpleLocant || locant instanceof AzaLocant || locant instanceof StereoNumber) {
            return 2;
        }
        if (locant.getClass() == ComplexLocant.class) {
            return 3;
        }
        if (locant.getClass() == IonNumber.class) {
            return 4;
        }
        if (locant instanceof AtomLocant) {
            return 6;
        }
        return -1;
    }

    public int size() {
        return this.locantList == null ? 0 : this.locantList.size();
    }

    @Override
    public String toString() {
        String stringValue = "";
        char separator = ',';
        switch (this.type) {
            case -1: {
                return "";
            }
            case 0: {
                separator = '.';
                break;
            }
            case 1: 
            case 2: {
                separator = ',';
                break;
            }
            case 3: {
                separator = ':';
            }
        }
        for (int i = 0; i < this.locantList.size(); ++i) {
            if (i > 0) {
                stringValue = stringValue + separator;
            }
            stringValue = stringValue + this.locantList.get(i).toString();
        }
        if (separator == '.') {
            stringValue = "[" + stringValue + "]";
        }
        if (this.size() > 0 && this.getLocant(0) instanceof StereoNumber) {
            stringValue = "(" + stringValue + ")";
        }
        return stringValue;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public String getTypeInString() {
        switch (this.type) {
            case -1: {
                return "NOT_SET";
            }
            case 0: {
                return "RING_NUMBERING";
            }
            case 1: {
                return "BOND_NUMBERING";
            }
            case 2: {
                return "SIMPLE_LOCANTS";
            }
            case 3: {
                return "COMPLEX_LOCANTS";
            }
            case 4: {
                return "ION_NUMBERING";
            }
            case 5: {
                return "FUSED_LOCANTS";
            }
            case 6: {
                return "ATOM_LOCANT";
            }
        }
        return "ERROR " + this.type;
    }

    public boolean contains(Locant locant) {
        return this.locantList.contains(locant);
    }

    public boolean containsAll(LocantList locantList) {
        return this.locantList.containsAll(locantList.locantList);
    }

    public boolean isCis() {
        if (this.type != 2 || this.size() != 1) {
            return false;
        }
        return this.getLocant(0).isCis();
    }

    public boolean isTrans() {
        if (this.type != 2 || this.size() != 1) {
            return false;
        }
        return this.getLocant(0).isTrans();
    }

    public boolean isSingleLocant() {
        return this.locantList.size() == 1 && !this.isOrthoMetaPara;
    }

    public SimpleLocant getSimpleLocant() {
        if (this.locantList.size() != 1) {
            return null;
        }
        Locant l = this.locantList.get(0);
        if (l instanceof SimpleLocant) {
            return (SimpleLocant)l;
        }
        return null;
    }

    public static LocantList simpleList(int ... locants) {
        LocantList res = new LocantList();
        for (int locant : locants) {
            res.tryAddLocant(new SimpleLocant(locant));
        }
        return res;
    }

    public static LocantList simpleList(Locant l) {
        LocantList res = new LocantList();
        res.tryAddLocant(l);
        return res;
    }

    public boolean isAllNumGreek() {
        for (Locant l : this.locantList) {
            if (l.isNumGreekLocant()) continue;
            return false;
        }
        return true;
    }
}

