/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.lex.data;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;

public class SimpleLocant
extends Locant {
    public char greekLetter = '\u0000';
    private boolean isOrthoMetaPara = false;

    public SimpleLocant(int value) {
        this.value = value;
    }

    public SimpleLocant(int value, char greekLetter) {
        this.value = value;
        this.greekLetter = greekLetter;
    }

    public SimpleLocant(int value, int parent) {
        this.value = value;
        this.parent = parent;
    }

    public SimpleLocant(int value, boolean isOrthoMetaPara) {
        this.value = value;
        this.isOrthoMetaPara = isOrthoMetaPara;
    }

    @Override
    public boolean isOrthoMetaPara() {
        return this.isOrthoMetaPara;
    }

    @Override
    public boolean isGreekLetter() {
        return this.value == Integer.MAX_VALUE || this.value == 0x7FFFFFFE || this.value == 0x7FFFFFFD;
    }

    @Override
    public boolean isNumGreekLocant() {
        return this.greekLetter != '\u0000';
    }

    public String toString() {
        int value = this.value;
        if (value == Integer.MAX_VALUE) {
            return "alpha";
        }
        if (value == 0x7FFFFFFE) {
            return "beta";
        }
        if (value == 0x7FFFFFFD) {
            return "omega";
        }
        char asc = '.';
        if (value > 100) {
            asc = (char)(value % 100 + 96);
            value /= 100;
        }
        String val = Integer.toString(value);
        if (asc != '.') {
            val = val + asc;
        }
        for (int i = 0; i < this.parent; ++i) {
            val = val + "'";
        }
        if (this.greekLetter != '\u0000') {
            val = val + " greek(" + this.greekLetter + ")";
        }
        return val;
    }
}

