/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.AcetateGroup;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;

public class AlcoholAcetateChecker
implements Refactoring<Structure> {
    static final Suffix acetate = SuffixFactory.createSuffix("[O-]C(=O)C |$1;4;;2$|{SpaceAttach: 1}", "acetate", new LocantList(), 1, 4);

    @Override
    public boolean checkTree(Structure root) {
        if (!"alcohol".equals(root.getName())) {
            return false;
        }
        if (root.substituentCount() < 2 || !root.getSubstituent(0).isSpaceSeparated()) {
            return false;
        }
        Structure acetGroup = root.getSubstituent(root.substituentCount() - 1);
        if (acetGroup instanceof AcetateGroup && acetGroup.substituentCount() == 0) {
            ((SimpleStructure)root).setName(acetGroup.getName());
            ((SimpleStructure)root).setValue(((AcetateGroup)acetGroup).getValue());
            root.removeSubstituent(acetGroup);
            return true;
        }
        return false;
    }
}

