/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;

public class CarbonicAcidChecker
implements Refactoring<Structure> {
    @Override
    public boolean checkTree(Structure root) {
        Structure nextLignad;
        if (root == null || root.substituentCount() < 2 || !this.isCarbonAcid(root)) {
            return false;
        }
        Structure possibleBasic = root.getSubstituent(0);
        Structure structure = nextLignad = root.substituentCount() > 1 ? root.getSubstituent(1) : null;
        if (!Util.canBeBasic(possibleBasic, nextLignad)) {
            return false;
        }
        this.replaceLigands(root);
        return true;
    }

    private boolean isCarbonAcid(Structure struc) {
        if (!(struc instanceof SimpleStructure) || struc.suffixCount() == 0) {
            return false;
        }
        String smi = ((SimpleStructure)struc).getValue();
        if (smi == null || !smi.replace("C", "").equals("")) {
            return false;
        }
        String suffix = struc.getSuffix(0).getName();
        for (int i = 1; i < struc.suffixCount() && ((suffix = struc.getSuffix(i).getName()) == null || suffix.length() <= 0); ++i) {
        }
        return suffix != null && suffix.trim().equals("oic acid");
    }

    private void replaceLigands(Structure root) {
        Structure newBasic = root.getSubstituent(0);
        for (int i = 1; i < root.substituentCount(); ++i) {
            Structure ligand = root.getSubstituent(i);
            if (ligand.hasLocant() && ligand.getLocantInParent().getLocant(0).isGreekLetter()) continue;
            newBasic.addSubstituent(ligand);
            root.removeSubstituent(ligand);
            --i;
        }
    }
}

