/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StereoNumber;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.AminoAcid;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;

public class DLConfigChecker
implements Refactoring<Structure> {
    @Override
    public boolean checkTree(Structure root) {
        int i;
        if (root == null) {
            return false;
        }
        boolean changed = false;
        for (i = 0; i < root.substituentCount(); ++i) {
            changed |= this.checkTree(root.getSubstituent(i));
        }
        for (i = 0; i < root.getStereoLocants().size(); ++i) {
            StereoNumber num = (StereoNumber)root.getStereoLocants().getLocant(i);
            if (!num.isDLconfiguration()) continue;
            if (root instanceof AminoAcid) {
                ((AminoAcid)root).setConfiguration(num.getStereoData());
                root.getStereoLocants().removeLocant(i--);
                changed = true;
                continue;
            }
            throw new NameImportException("Invalid stereo descriptor: " + num);
        }
        return changed;
    }
}

