/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Ester;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;

public class FunctionalGroupChecker
implements Refactoring<Structure> {
    @Override
    public boolean checkTree(Structure root) {
        if (root == null || root.getParent() == null || !this.isAmide(root) || root.substituentCount() != 1 || root.hasLocant()) {
            boolean changed = false;
            if (root == null || this.isEster(root)) {
                return false;
            }
            for (int i = 0; i < root.substituentCount(); ++i) {
                changed |= this.checkTree(root.getSubstituent(i));
            }
            return changed;
        }
        if (!this.areLigandsValid(root)) {
            return false;
        }
        Structure ligand = root.getSubstituent(0);
        Structure parent = root.getParent();
        root.removeSubstituent(0);
        int index = parent.indexOf(root);
        parent.removeSubstituent(root);
        parent.addSubstituent(index, ligand);
        ligand.addSubstituent(root);
        if (root.hasConnectionPoint()) {
            root.dropConnectionPoint();
        }
        return true;
    }

    private boolean areLigandsValid(Structure struc) {
        Structure ligand = struc.getSubstituent(0);
        Structure parent = struc.getParent();
        boolean hasMultiNumbering = parent.hasLocant() && parent.getLocantInParent().size() > 1;
        return hasMultiNumbering && !ligand.hasLocant() && (!parent.hasLocant() || parent.getLocantInParent().getLocant(0) instanceof SimpleLocant);
    }

    private boolean isAmide(Structure struc) {
        String name = struc.getName();
        return struc instanceof SimpleStructure && name != null && name.contains("amid") && !name.contains("amido");
    }

    private boolean isEster(Structure struc) {
        return struc instanceof Ester || struc.getName() != null && struc.getName().contains("ester");
    }
}

