/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;

public class HydrazideChecker
implements Refactoring<Structure> {
    @Override
    public boolean checkTree(Structure root) {
        boolean changed = false;
        for (int i = 0; i < root.substituentCount(); ++i) {
            changed |= this.checkTree(root.getSubstituent(i));
        }
        Suffix oicAcid = null;
        for (int i = 0; i < root.suffixCount(); ++i) {
            Suffix s = root.getSuffix(i);
            if (s.getName() == null) continue;
            if (s.getName().equals("oic acid")) {
                oicAcid = s;
                continue;
            }
            if (!s.getName().startsWith("hydrazid") || oicAcid == null || s.getMultiplicity() != oicAcid.getMultiplicity()) continue;
            oicAcid.setValue(s.getValue());
            oicAcid.setName(s.getName());
            root.removeSuffix(i);
            changed = true;
            break;
        }
        return changed;
    }
}

