/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;

public class HydrogenChecker
implements Refactoring<Structure> {
    checkType type = checkType.IMPLICIT;

    public HydrogenChecker(boolean checkExplicitHydrogens) {
        this.type = checkExplicitHydrogens ? checkType.EXPLICIT : checkType.IMPLICIT;
    }

    @Override
    public boolean checkTree(Structure root) {
        if (this.type == checkType.IMPLICIT) {
            return this.checkImplicitHydrogens(root);
        }
        return this.checkExplicitHydrogens(root);
    }

    private boolean checkImplicitHydrogens(Structure root) {
        if (!this.needCheck(root)) {
            return false;
        }
        boolean changed = false;
        Structure ligand = root.getSubstituent(0);
        for (int i = 0; i < root.getHydroList().size(); ++i) {
            SimpleLocant HLocant = root.getHydro(i).getLocant();
            if (HLocant == null || root.hasLocant(HLocant)) continue;
            while (!root.getHydroList().isEmpty()) {
                ligand.addHydro(root.getHydro(0));
                root.removeHydro(0);
                changed = true;
            }
        }
        return changed;
    }

    private boolean needCheck(Structure root) {
        return root != null && !root.getHydroList().isEmpty() && root.substituentCount() > 0;
    }

    private boolean checkExplicitHydrogens(Structure root) {
        if (root instanceof SimpleStructure && ((SimpleStructure)root).getValue().indexOf("-") > 0) {
            return false;
        }
        boolean changed = false;
        for (int i = 0; i < root.substituentCount(); ++i) {
            SimpleStructure sbefore;
            changed |= this.checkExplicitHydrogens(root.getSubstituent(i));
            SimpleStructure s = root.getSubstituent(i) instanceof SimpleStructure ? (SimpleStructure)root.getSubstituent(i) : null;
            SimpleStructure simpleStructure = sbefore = i > 0 && root.getSubstituent(i - 1) instanceof SimpleStructure ? (SimpleStructure)root.getSubstituent(i - 1) : null;
            if (s == null || !s.getValue().equals("[H+]") || sbefore == null || sbefore.getValue().indexOf("-") <= 0) continue;
            sbefore.addSubstituent(s);
            root.removeSubstituent(i);
            --i;
            changed = true;
        }
        return changed;
    }

    static enum checkType {
        EXPLICIT,
        IMPLICIT;

    }
}

