/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Atom;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AzaLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.BracketToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.EndingToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Hydro;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.NonStdValenceLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Number;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Separator;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SpecialGroup;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StereoNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StructureToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.AlcoholAcetateChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.AmineChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.CarbanilideChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.CarbonicAcidChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.DLConfigChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.DisulfideChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.FunctionalGroupChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.HantzschWidmanChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.HydrazideChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.HydrogenChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.IUPACParser;
import chemaxon.marvin.io.formats.name.nameimport.parse.InvalidLocantChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.KetoneChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.MultiAmineChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.MultiParentChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.NLocantChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.NumberingChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.ParserUtil;
import chemaxon.marvin.io.formats.name.nameimport.parse.PeroxyChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.PhenoxyChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.RevolutionParser;
import chemaxon.marvin.io.formats.name.nameimport.parse.SaltChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.SpaceSeparatedLigandChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.StereoDataChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.SulfonamidoChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.AcidGenerator;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Amine;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.BenzoFusedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Compound;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.EsterGenerator;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.FusedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HantzschWidmanSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroAtom;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroChain;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.MultipliedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyCyclicSpiroSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SaltEnding;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.VonBaeyerSystem;
import java.util.ArrayList;
import java.util.List;

public class IUPACParserCore {
    private IUPACParser parser = new IUPACParser();
    private Structure struc = null;
    private boolean dashConnected = false;
    private ArrayList<StereoInfo> stereoData = new ArrayList();
    private ArrayList<Structure> rePositionedLocants;
    private ArrayList<Token> tokenList;
    private ArrayList<Token> controlList;
    private int actIndex;
    private int[] indexes;
    private final boolean validateLocants;
    public static boolean revolution = true;
    public static boolean debug = false;
    ArrayList<Refactoring<Structure>> steps = new ArrayList();

    private IUPACParserCore(ArrayList<Token> tokenList) {
        this.tokenList = tokenList;
        this.validateLocants = true;
    }

    public IUPACParserCore(ArrayList<Token> tokenList, boolean validateLocants) {
        this.tokenList = tokenList;
        this.validateLocants = validateLocants;
    }

    public static Structure parseTokens(ArrayList<Token> tokenList) {
        Structure res = Compound.parseRatio(tokenList);
        if (res != null) {
            return res;
        }
        if (revolution) {
            return new RevolutionParser().parse(tokenList);
        }
        return IUPACParserCore.oldParseTokens(tokenList);
    }

    public static Structure oldParseTokens(ArrayList<Token> tokenList) {
        int[] index = new int[]{tokenList.size() - 1};
        return new IUPACParserCore(tokenList).parseTokens(index, 0);
    }

    public static Structure parseTokens(ArrayList<Token> tokenList, int inBracket) {
        int[] index = new int[]{tokenList.size() - 1};
        return new IUPACParserCore(tokenList).parseTokens(index, inBracket);
    }

    static Structure parseTokens(ArrayList<Token> tokenList, boolean validatelocants) {
        int[] index = new int[]{tokenList.size() - 1};
        return new IUPACParserCore(tokenList, validatelocants).parseTokens(index, 0);
    }

    private Structure parseTokens(int[] lastIndex, int close) {
        if (this.controlList == null) {
            this.controlList = new ArrayList();
            this.controlList.addAll(this.tokenList);
        }
        this.actIndex = lastIndex[0];
        boolean isDoubleParent = false;
        NodeSet nodes = new NodeSet();
        boolean spaceSeparated = false;
        int multiroot = 0;
        boolean isMultiroot = false;
        ArrayList<Suffix> multiParentSuffixes = new ArrayList<Suffix>();
        while (this.actIndex > -1) {
            this.indexes = this.getMainStructure(close, nodes, spaceSeparated);
            if (debug && this.indexes[0] >= 0) {
                System.out.print("Parsing: ");
                for (int i = this.indexes[0]; i <= this.indexes[1] && i < this.tokenList.size(); ++i) {
                    System.out.print(this.tokenList.get(i));
                }
                System.out.println();
            }
            isMultiroot = this.multiParentToSuffix(nodes, multiroot, spaceSeparated, multiParentSuffixes);
            isDoubleParent = this.setDoubleParent(isDoubleParent, nodes, true);
            isDoubleParent = this.addSuffixes(isDoubleParent, nodes);
            this.struc.setSpaceSeparated(spaceSeparated);
            this.struc.setDashConnected(this.dashConnected);
            spaceSeparated = false;
            this.actIndex = this.indexes[0] - 1;
            int tokenIndex = this.indexes[1];
            int[] m = new int[]{1};
            Token token = this.cloneMultipliedSubstitients(m, nodes);
            int mul = m[0];
            multiroot = nodes.getRoot().equals(this.struc) && close == 0 ? mul : 0;
            this.addHydrogens(this.struc);
            this.addStereoData(this.struc, nodes.getActual().isSpaceSeparated() ? nodes.getActual() : nodes.getRoot(), this.struc);
            boolean canBeParent = true;
            while (this.NextTokenIsASeparator()) {
                canBeParent = false;
                this.checkCarboxyGroup(nodes, tokenIndex);
                Token t = this.tokenList.get(this.actIndex);
                if (t instanceof BracketToken) {
                    mul = this.parseBracket(lastIndex, nodes, spaceSeparated, mul);
                    isMultiroot = this.multiParentToSuffix(nodes, multiroot, spaceSeparated, multiParentSuffixes);
                    continue;
                }
                if (t.getType() == 2) {
                    this.handleDash(isDoubleParent, nodes);
                    continue;
                }
                if (t.getType() == 3) {
                    spaceSeparated = this.handleSpace(nodes);
                    continue;
                }
                --this.actIndex;
            }
            if ((!canBeParent || mul != 1 || !this.isActualParentNodeChange(token)) && !this.canBeParent(this.struc)) continue;
            nodes.setActual(this.struc);
        }
        this.checkControlList();
        if (isMultiroot) {
            ParserUtil.addLocantsToMultiRoot(nodes.getRoot(), multiParentSuffixes);
        }
        this.refactorTree(nodes);
        lastIndex[0] = this.actIndex;
        return nodes.getSecondRoot();
    }

    private boolean NextTokenIsASeparator() {
        return this.actIndex > -1 && (this.tokenList.get(this.actIndex) instanceof Separator || this.tokenList.get(this.actIndex) instanceof BracketToken && !Util.isEnding(this.tokenList.get(this.actIndex)));
    }

    private boolean isActualParentNodeChange(Token token) {
        if (this.actIndex < 0) {
            return false;
        }
        if (Util.isHetero(this.struc) && (this.struc.hasLocant() || !(token instanceof Separator))) {
            return false;
        }
        if (this.struc instanceof HeteroAtom) {
            return false;
        }
        if (token instanceof EndingToken) {
            return true;
        }
        return true;
    }

    private boolean canBeParent(Structure struc) {
        if (struc.getParent() instanceof SimpleStructure && ((SimpleStructure)struc.getParent()).getName().equals("oxy")) {
            return struc.getParent().getParent() == null;
        }
        return false;
    }

    private void checkControlList() {
        this.checkControlList(this.controlList);
    }

    private void checkControlList(ArrayList<Token> controlList) {
        if (!this.controlListCleared(controlList)) {
            String unknown = "";
            for (int t = 0; t < controlList.size(); ++t) {
                unknown = unknown + controlList.get(t).toString() + " ";
            }
            throw new NameImportException("There is an unknown part of the name: " + unknown);
        }
    }

    private boolean multiParentToSuffix(NodeSet nodes, int multiroot, boolean spaceSeparated, ArrayList<Suffix> newSuffixes) {
        if (multiroot < 2 || spaceSeparated) {
            return false;
        }
        int nodecount = nodes.getRoot().substituentCount(true);
        LocantList locant = nodes.getRoot().getSubstituent(0).getLocantInParent();
        Structure newParent = this.getNodeToAddMultiParentsuffix(this.struc, nodecount, 0);
        this.multiSaltsToSingle(nodes.getRoot(), nodecount);
        for (int i = 0; i < nodecount; ++i) {
            Suffix suff = SuffixFactory.createSuffix("fromstructure", "fromstructure", locant, 1, 8);
            suff.setStructure(nodes.getRoot().cloneStructure());
            suff.getStructure().clearSubstituentList(true);
            suff.getStructure().setLocantInParent(locant);
            newParent.addSuffix(suff);
            newSuffixes.add(suff);
            suff.getStructure().setParent(newParent);
            if (i < nodecount - 2) {
                nodes.getRoot().removeSubstituent(0);
                locant = nodes.getRoot().getSubstituent(0).getLocantInParent();
            } else {
                locant = nodes.getRoot().getLocantInParent();
            }
            if (newParent.equals(this.struc)) continue;
            newParent = this.getNodeToAddMultiParentsuffix(this.struc, nodecount, i + 1);
        }
        nodes.setRoot(this.struc);
        nodes.setActual(this.struc);
        this.struc.setParent(null);
        return true;
    }

    private void multiSaltsToSingle(Structure struc, int mul) {
        for (int i = 0; i < struc.suffixCount(); ++i) {
            Suffix suff = struc.getSuffix(i);
            if (suff.getType() != 3 || suff.getMultiplicity() != mul) continue;
            suff.setMultiplicity(1);
        }
    }

    private Structure getNodeToAddMultiParentsuffix(Structure basicStruc, int parentMul, int index) {
        if (basicStruc.substituentCount(true) != parentMul) {
            return basicStruc;
        }
        Structure clone = null;
        int heterocount = 0;
        for (int i = 0; i < basicStruc.substituentCount(); ++i) {
            Structure ligand = basicStruc.getSubstituent(i);
            if (!(ligand instanceof HeteroAtom)) {
                if (i > heterocount && clone == null) {
                    return basicStruc;
                }
                if (clone != null && !clone.equals(ligand.getCloneOf())) {
                    return basicStruc;
                }
                clone = ligand.getCloneOf();
                continue;
            }
            ++heterocount;
        }
        return basicStruc.getSubstituent(index + heterocount);
    }

    private void checkCarboxyGroup(NodeSet nodes, int tokenIndex) {
        Token t2;
        if (!(nodes.getActual() instanceof SimpleStructure)) {
            return;
        }
        Token t1 = this.tokenList.get(tokenIndex);
        Token token = t2 = tokenIndex < this.tokenList.size() - 1 ? this.tokenList.get(tokenIndex + 1) : null;
        if (Util.isCharbonChain(t1.getValue()) && t2 != null && t2.getName().equalsIgnoreCase("oxy")) {
            nodes.setActual(this.struc);
        }
    }

    private void setRefactoringSteps() {
        if (this.steps.isEmpty()) {
            this.steps.add(new HantzschWidmanChecker());
            this.steps.add(new MultiAmineChecker());
            this.steps.add(new SaltChecker());
            this.steps.add(new CarbanilideChecker());
            this.steps.add(new PhenoxyChecker());
            this.steps.add(new AlcoholAcetateChecker());
            this.steps.add(new HydrogenChecker(false));
            this.steps.add(new PeroxyChecker());
            this.steps.add(new HydrazideChecker());
            this.steps.add(new NumberingChecker());
            this.steps.add(new CarbonicAcidChecker());
            this.steps.add(new SpaceSeparatedLigandChecker());
            this.steps.add(new StereoDataChecker(this));
            this.steps.add(new NLocantChecker());
            this.steps.add(new KetoneChecker());
            this.steps.add(new FunctionalGroupChecker());
            this.steps.add(new InvalidLocantChecker(this.validateLocants));
            this.steps.add(new DisulfideChecker());
            this.steps.add(new AmineChecker());
            this.steps.add(new HydrogenChecker(true));
            this.steps.add(new DLConfigChecker());
            this.steps.add(new MultiParentChecker());
        }
    }

    private void refactorTree(NodeSet nodes) {
        if (nodes.getSecondRoot() == null) {
            nodes.setSecondRoot(nodes.getRoot());
        }
        Structure root = nodes.getSecondRoot();
        if (debug) {
            this.debugPrint("Before tree refactoring", root);
        }
        if (new SulfonamidoChecker().checkTree(nodes) && debug) {
            this.debugPrint("Change by SulfonAmidoChecker", root);
        }
        this.refactorTree(root);
        if (EsterGenerator.isEster(root)) {
            nodes.setSecondRoot(EsterGenerator.createEster(root));
            if (debug) {
                this.debugPrint("Change by EsterGenerator", nodes.secondRoot);
            }
        }
    }

    public void refactorTree(Structure root) {
        this.setRefactoringSteps();
        for (Refactoring<Structure> step : this.steps) {
            if (!step.checkTree(root) || !debug) continue;
            this.debugPrint("Change by " + step.getClass().getSimpleName(), root);
        }
    }

    private void debugPrint(String stepName, Structure root) {
        System.out.println();
        System.out.println(stepName + ":");
        root.print();
        System.out.println();
    }

    private int parseBracket(int[] lastIndex, NodeSet nodes, boolean spaceSeparated, int mul) {
        boolean hasDash = this.actIndex < this.tokenList.size() - 1 && this.tokenList.get(this.actIndex + 1).getType() == 2;
        BracketToken bracket = (BracketToken)this.tokenList.get(this.actIndex);
        LocantList numbering = bracket.toNumbering();
        if (numbering != null && numbering.getType() == 4) {
            this.tokenList.add(this.actIndex + 1, new EndingToken("ion", "[ION]"));
            this.tokenList.add(this.actIndex + 1, new Separator(' '));
            this.actIndex += 2;
            return mul;
        }
        this.removeFromControlList(this.actIndex);
        lastIndex[0] = this.actIndex;
        Structure s = this.struc;
        this.dashConnected = false;
        this.struc = IUPACParserCore.parseTokens(bracket.getInside(), 1);
        this.struc.setSpaceSeparated(spaceSeparated);
        this.struc.setRoot(true);
        if (!hasDash && this.changeActualNeeded(nodes.getActual(), s, this.struc, mul)) {
            nodes.setActual(s);
        } else if (s.isSpaceSeparated() && !this.struc.isSpaceSeparated()) {
            nodes.setActual(s);
        } else if (this.canBeParent(s)) {
            nodes.setActual(s);
        }
        if (hasDash && !nodes.getActual().isSpaceSeparated() && !this.canBeParent(nodes.getActual())) {
            nodes.setActual(nodes.getRoot());
        }
        this.addStereoDataToParents();
        nodes.getActual().addSubstituent(this.struc);
        this.actIndex = lastIndex[0] - 1;
        LocantList l = null;
        if (this.actIndex > -1 && this.isDash(this.tokenList.get(this.actIndex))) {
            --this.actIndex;
        }
        if (this.actIndex > -1 && this.tokenList.get(this.actIndex) instanceof Number) {
            mul = ((Number)this.tokenList.get(this.actIndex)).getData();
            this.removeFromControlList(this.actIndex--);
            if (this.actIndex > -1 && this.isDash(this.tokenList.get(this.actIndex))) {
                --this.actIndex;
            }
        } else {
            mul = 1;
        }
        if (mul == 1 && this.struc.hasLocant()) {
            if (this.actIndex < this.tokenList.size() - 1 && this.tokenList.get(this.actIndex + 1) instanceof Separator) {
                ++this.actIndex;
            }
            return mul;
        }
        if (this.actIndex > -1 && Util.isNumbering(this.tokenList.get(this.actIndex))) {
            l = Util.getNumbering(this.tokenList.get(this.actIndex));
            if (l.getLocant(0) instanceof StereoNumber) {
                l = null;
                ++this.actIndex;
            } else {
                this.removeFromControlList(this.actIndex--);
            }
        }
        if (l != null) {
            if (mul == 1) {
                this.struc.addLocant(l);
            } else {
                this.struc.addLocant(l.getLocant(0));
            }
        }
        for (int i = 0; i < mul - 1; ++i) {
            Structure clone = this.struc.cloneStructure();
            if (l != null) {
                clone.setLocantInParent(l.getLocant(i + 1));
            }
            nodes.getActual().addSubstituent(clone);
        }
        return mul;
    }

    private boolean handleSpace(NodeSet nodes) {
        this.removeFromControlList(this.actIndex--);
        nodes.setActual(nodes.getRoot());
        this.dashConnected = false;
        return true;
    }

    private void handleDash(boolean isDoubleParent, NodeSet nodes) {
        LocantList locantList;
        LocantList locantList2 = locantList = this.tokenList.get(this.actIndex - 1) instanceof LocantList ? (LocantList)this.tokenList.get(this.actIndex - 1) : null;
        if (locantList != null && !(locantList.getLocant(0) instanceof StereoNumber)) {
            this.addLocant(locantList);
        } else if (this.tokenList.get(this.actIndex - 1) instanceof Atom) {
            this.addAtom((Atom)this.tokenList.get(this.actIndex - 1));
        }
        this.removeFromControlList(this.actIndex--);
        this.addHydrogens(this.struc);
        Structure n = nodes.getActual().isSpaceSeparated() ? nodes.getActual() : nodes.getRoot();
        this.addStereoData(this.struc.isRoot() && (n.substituentCount() == 0 || !n.getSubstituent(0).isSpaceSeparated()) ? n : this.struc, n, this.struc);
        if (nodes.getRoot().equals(nodes.getActual())) {
            this.dashConnected = true;
        }
        if (!nodes.getActual().equals(nodes.getRoot()) && !isDoubleParent && this.dashConnected && !nodes.getActual().isSpaceSeparated()) {
            nodes.setActual(nodes.getRoot());
        }
    }

    private void addLocant(LocantList locantList) {
        Structure parentNode;
        Suffix canGetLigand;
        if (this.struc.hasLocant() && locantList.getType() != 6 && (canGetLigand = ParserUtil.getFirstSuffixForLigandAddition(this.struc, locantList.size())) != null) {
            canGetLigand.setLocant(this.struc.getLocantInParent());
            this.struc.setLocantInParent((LocantList)null);
        }
        if ((parentNode = this.addLocantToParentNode(this.struc)) != null) {
            parentNode.setLocantInParent(locantList);
        } else if (locantList.size() > 1 && this.struc.getFirstRadicalSuffixIndex() > -1 && (parentNode = this.getNodeToAddMultiParentsuffix(this.struc, locantList.size(), 0)) != this.struc) {
            if (parentNode.hasLocant(locantList.getLocant(0))) {
                this.struc.setLocantInParent(locantList);
            } else {
                locantList.setParentIndex(0);
                parentNode.addLocant(locantList.getLocant(0));
                for (int i = 1; i < locantList.size(); ++i) {
                    parentNode = this.getNodeToAddMultiParentsuffix(this.struc, locantList.size(), i);
                    parentNode.addLocant(locantList.getLocant(i));
                }
            }
        } else {
            this.struc.setLocantInParent(locantList);
        }
        this.removeFromControlList(this.actIndex--);
    }

    private Structure addLocantToParentNode(Structure struc) {
        if (!struc.hasLocant()) {
            return null;
        }
        Locant firstLocant = struc.getLocantInParent().getLocant(0);
        if (!(firstLocant instanceof SimpleLocant) || firstLocant instanceof NonStdValenceLocant || firstLocant.getValue() > 100) {
            return null;
        }
        Structure parentNode = this.getSpaceSeparatedParentNode(struc);
        return parentNode.hasLocant() ? null : parentNode;
    }

    private void addAtom(Atom atom) {
        AtomLocant loc = new AtomLocant(((Atom)this.tokenList.get(this.actIndex - 1)).getName());
        this.struc.setLocantInParent(loc);
        this.removeFromControlList(this.actIndex--);
    }

    private Structure getSpaceSeparatedParentNode(Structure struc) {
        while (struc.getParent() != null && !struc.getParent().isSpaceSeparated()) {
            struc = struc.getParent();
        }
        if (struc.getParent() != null) {
            struc = struc.getParent();
        }
        return struc;
    }

    private boolean controlListCleared(ArrayList<Token> controlList) {
        for (int i = 0; i < controlList.size(); ++i) {
            if (controlList.get(i) instanceof Separator) continue;
            return false;
        }
        return true;
    }

    private void removeFromControlList(int[] indexes) {
        for (int i = indexes[0]; i < indexes[1] + 1; ++i) {
            if (i <= -1 || i >= this.tokenList.size()) continue;
            this.controlList.remove(this.tokenList.get(i));
        }
    }

    private void removeFromControlList(int index) {
        this.controlList.remove(this.tokenList.get(index));
    }

    private Token cloneMultipliedSubstitients(int[] mul, NodeSet nodes) {
        Token token;
        Token token2 = token = this.actIndex > -1 ? this.tokenList.get(this.actIndex) : null;
        if (this.actIndex > 0 && token instanceof Separator && token.getType() == 2 && this.tokenList.get(this.actIndex - 1) instanceof Number) {
            Token token3 = token = --this.actIndex > -1 ? this.tokenList.get(this.actIndex) : null;
        }
        if (this.actIndex > -1 && token instanceof Number) {
            boolean isSingleAtom;
            int acidSuff = ParserUtil.getBaseSuffixIndex(this.struc);
            if (this.struc == nodes.getRoot() && acidSuff > -1) {
                Suffix suffAcid = this.struc.getSuffix(acidSuff);
                String acid = suffAcid instanceof SaltEnding ? ((SaltEnding)suffAcid).getAtom() : this.struc.getSuffix(acidSuff).getValue();
                SimpleStructure s = new SimpleStructure(acid, "acid");
                this.struc.removeSuffix(acidSuff);
                nodes.setRoot(s);
                nodes.setActual(s);
                s.addSubstituent(this.struc);
            }
            mul[0] = ((Number)token).getData();
            Token token4 = token = this.actIndex > 1 ? this.tokenList.get(this.actIndex - 2) : null;
            if (!(token instanceof LocantList)) {
                Token befToken;
                Token token5 = befToken = this.actIndex > 0 ? this.tokenList.get(this.actIndex - 1) : null;
                if (befToken instanceof LocantList) {
                    token = befToken;
                } else if (Util.isNumbering(befToken)) {
                    token = ((BracketToken)befToken).getInside().get(0);
                }
            }
            boolean isMultipliedSystem = nodes.getRoot() == this.struc && token instanceof LocantList && ((LocantList)token).getMaxParentIndex() > 0;
            boolean bl = isSingleAtom = this.struc instanceof SimpleStructure && Util.atomCount(((SimpleStructure)this.struc).getValue()) == 1;
            if (isMultipliedSystem && isSingleAtom) {
                SimpleStructure ss = (SimpleStructure)this.struc;
                String atom = ss.getValue();
                for (int i = 1; i < mul[0]; ++i) {
                    ss.setValue(ss.getValue() + atom);
                    this.removeFromControlList(this.actIndex--);
                }
            } else if (isMultipliedSystem) {
                MultipliedSystem ms = new MultipliedSystem(2, nodes.getActual(), (LocantList)token);
                ms.addSuffix(nodes.getRoot().getSuffixList());
                nodes.getRoot().clearSuffixList();
                nodes.setRoot(ms);
                nodes.setActual(ms);
                this.struc = ms;
                this.actIndex -= 3;
                this.removeFromControlList(new int[]{this.actIndex + 1, this.actIndex + 3});
                mul[0] = 1;
            } else {
                this.addClones(nodes.getActual(), mul, token);
            }
        }
        return token;
    }

    private void addClones(Structure actual, int[] mul, Token token) {
        Structure newStruc = this.struc.cloneStructure();
        if (mul[0] == 1) {
            this.struc.setExplicitSingle(true);
        }
        for (int i = 0; i < mul[0] - 1; ++i) {
            actual.addSubstituent(newStruc);
            newStruc = newStruc.cloneStructure();
        }
        this.removeFromControlList(this.actIndex--);
        if (token != null && token instanceof LocantList && !(((LocantList)token).getLocant(0) instanceof StereoNumber)) {
            if (((LocantList)token).isSingleLocant() && actual.getLocantInParent() == null && actual.getParent() != null) {
                actual.setLocantInParent((LocantList)token);
            } else {
                for (int index = 0; mul[0] > index && index < ((LocantList)token).size(); ++index) {
                    Structure s = actual.getSubstituent(actual.substituentCount() - index - 1);
                    if (s == null) {
                        s = actual;
                    }
                    s.setLocantInParent(((LocantList)token).getLocant(index));
                }
            }
            this.removeFromControlList(new int[]{this.actIndex - 1, this.actIndex});
            this.actIndex -= 2;
        }
    }

    private int[] getMainStructure(int close, NodeSet nodes, boolean spaceSeparated) {
        int size = this.tokenList.size();
        int[] indexes = this.findMainGroup(this.actIndex, nodes.getRoot());
        this.actIndex += this.tokenList.size() - size;
        if (indexes[2] == 22) {
            Structure actual;
            int mul = ((Number)this.tokenList.get(this.actIndex)).getData();
            LocantList loc = indexes[0] == indexes[1] ? null : (LocantList)this.tokenList.get(this.actIndex - 2);
            Structure structure = actual = nodes.getRoot().substituentCount() > 0 ? nodes.getRoot().getSubstituent(0) : null;
            if (actual != null && actual.getParent() != null && actual.isSpaceSeparated()) {
                for (int i = 0; i < mul - 1; ++i) {
                    actual.getParent().addSubstituent(actual.cloneStructure());
                }
                this.refactorTree(nodes);
            } else {
                this.refactorTree(nodes);
                nodes.setRoot(new MultipliedSystem(mul, nodes.getSecondRoot(), loc));
            }
            this.struc = nodes.getRoot();
            nodes.setRoot(null);
            nodes.setSecondRoot(null);
        } else if (indexes[2] == 25) {
            if (nodes.getSecondRoot() != null) {
                this.refactorTree(nodes);
            }
            List<Token> list = this.tokenList.subList(Math.max(indexes[0], 0), Math.min(indexes[1] + 1, this.tokenList.size()));
            nodes.setRoot(IUPACParser.createFusedSystem(list, nodes.getRoot()));
            this.struc = nodes.getRoot();
            nodes.setRoot(null);
            nodes.setSecondRoot(null);
        } else if (indexes[2] == 27) {
            ArrayList<Token> innerList = ((BracketToken)this.tokenList.get(indexes[0])).getInside();
            this.struc = IUPACParserCore.parseTokens(innerList);
        } else {
            List<Token> list = this.tokenList.subList(Math.max(indexes[0], 0), Math.min(indexes[1] + 1, this.tokenList.size()));
            this.struc = this.parser.getStructure(list, indexes[2]);
            this.struc.setSpaceSeparated(spaceSeparated);
        }
        if (this.struc != null) {
            if (nodes.getRoot() == null) {
                nodes.setRoot(this.struc);
                nodes.setActual(this.struc);
                this.struc.setRoot(true);
            } else if (spaceSeparated && nodes.getSecondRoot() != null) {
                nodes.getSecondRoot().addSubstituent(this.struc);
            } else {
                if (indexes[2] != 27) {
                    nodes.setActual(this.changeActual(close, nodes.getActual(), this.struc));
                }
                nodes.getActual().addSubstituent(this.struc);
            }
        } else {
            throw new NameImportException("Name is not supported yet.");
        }
        this.removeFromControlList(indexes);
        return indexes;
    }

    protected int[] findMainGroup(int lastindex, Structure root) {
        int thiolGroup = -1;
        ArrayList<Token> closeBrackets = new ArrayList<Token>();
        ArrayList<Token> possibleParent = new ArrayList<Token>();
        boolean canBeMultipliedSystem = true;
        Object closebr = null;
        int bracketIndex = -1;
        for (int index = lastindex; index > -1; --index) {
            Token token = this.tokenList.get(index);
            if (token instanceof BracketToken) {
                BracketToken bt = (BracketToken)token;
                if (!canBeMultipliedSystem && bt.toNumbering() == null && bt.toEnding() == null) {
                    bracketIndex = index;
                }
                canBeMultipliedSystem = true;
                continue;
            }
            if (token instanceof Separator) continue;
            if (token instanceof EndingToken && bracketIndex > -1) {
                return new int[]{bracketIndex, bracketIndex, 27};
            }
            if (token instanceof LocantList && token.getType() == 5) {
                return new int[]{ParserUtil.getDashOrBracerIndex(this.tokenList, index) + 1, index, 25};
            }
            if (token.getName().equals("thiol") || token.getName().equals("thiole")) {
                thiolGroup = index;
            }
            if (this.isParentHydride(token, index, possibleParent)) {
                if (token instanceof Number) {
                    this.changeNumberToCarbonChain(index);
                }
                return this.findMainStructure(index, root);
            }
            if (token.getClass() == SpecialGroup.class) {
                if (closeBrackets.isEmpty() && closebr != null) {
                    closeBrackets.add((Token)closebr);
                }
                return IUPACParserCore.findSpecialGroups(this.tokenList, index, closeBrackets);
            }
            if (token.getName().endsWith("carbonic acid") && AcidGenerator.structureLength(this.tokenList, index) > 1) {
                return this.findAcidAsMainGroup(index);
            }
            if (token.getName().endsWith("acid")) {
                index -= AcidGenerator.structureLength(this.tokenList, index) - 1;
                continue;
            }
            if (token.getName().endsWith("peroxol")) {
                index -= this.peroxolLength(index);
                continue;
            }
            if (this.isAmidoParent(index)) {
                return new int[]{index, index, 0};
            }
            if (canBeMultipliedSystem && this.tokenList.get(index) instanceof Number) {
                int multitype = this.isMultipliedStruc(index);
                if (multitype <= -1) continue;
                this.removeFromControlList(0);
                int bracket = index + 1;
                if (index > 1 && this.tokenList.get(index - 2) instanceof LocantList) {
                    index -= 2;
                }
                if (multitype == 0) {
                    return new int[]{index, bracket, 17};
                }
                if (multitype > 1) {
                    return new int[]{index, multitype, 17};
                }
                if (this.tokenList.get(index) instanceof LocantList) {
                    return new int[]{index, index + 2, 22};
                }
                return new int[]{index, index, 22};
            }
            canBeMultipliedSystem = false;
        }
        if (this.tokenList.get(lastindex).getName().endsWith("acid")) {
            return this.findAcidAsMainGroup(lastindex);
        }
        if (this.tokenList.size() == 1 && this.tokenList.get(0) instanceof EndingToken) {
            return new int[]{-1, -1, 21};
        }
        if (thiolGroup > -1) {
            StructureToken S = new StructureToken("thi", "S");
            EndingToken ol = new EndingToken("ol", "O.");
            int i = this.controlList.indexOf(this.tokenList.get(thiolGroup));
            this.controlList.add(i, S);
            this.controlList.add(i + 1, ol);
            this.controlList.remove(i + 2);
            this.tokenList.add(thiolGroup, S);
            this.tokenList.add(thiolGroup + 1, ol);
            this.tokenList.remove(thiolGroup + 2);
            return this.findMainStructure(thiolGroup, root);
        }
        if (!possibleParent.isEmpty()) {
            return this.findMainStructure(this.tokenList.indexOf(possibleParent.get(0)), root);
        }
        if (bracketIndex > -1) {
            return new int[]{bracketIndex, bracketIndex, 27};
        }
        throw new NameImportException("Could not find main parent");
    }

    private boolean setDoubleParent(boolean isDoubleParent, NodeSet nodes, boolean checkNodes) {
        boolean parentHasLocant;
        if (checkNodes && (nodes.getRoot().equals(this.struc) || !nodes.getActual().equals(nodes.getRoot()) || nodes.getRoot().substituentCount() != 1)) {
            return isDoubleParent;
        }
        Structure actual = nodes.getActual();
        Locant locantOfParent = actual.hasLocant() ? actual.getLocantInParent().getLocant(0) : null;
        boolean bl = parentHasLocant = locantOfParent instanceof SimpleLocant && !(locantOfParent instanceof NonStdValenceLocant);
        if (parentHasLocant && (isDoubleParent = this.rePositionLocant(this.tokenList, this.actIndex, this.struc, actual))) {
            actual = this.struc;
        }
        nodes.setActual(actual);
        if (checkNodes && isDoubleParent && nodes.getSecondRoot() == null) {
            nodes.setSecondRoot(nodes.getRoot());
            nodes.setRoot(nodes.getActual());
        }
        return isDoubleParent;
    }

    private boolean addSuffixes(boolean isDoubleParent, NodeSet nodes) {
        boolean first = true;
        int bracketIndex = -1;
        Suffix s = null;
        while (this.actIndex > this.indexes[1]) {
            Token actToken = this.tokenList.get(this.actIndex);
            if (actToken instanceof BracketToken) {
                --this.actIndex;
                continue;
            }
            if (s != null && actToken instanceof Hydro && this.actIndex < this.tokenList.size() - 1) {
                this.struc.addHydro((Hydro)actToken);
                this.removeFromControlList(this.actIndex);
                --this.actIndex;
                continue;
            }
            boolean[] flags = new boolean[]{isDoubleParent, first};
            s = this.addSuffix(actToken, flags, nodes);
            isDoubleParent = flags[0];
            first = flags[1];
            if (bracketIndex <= -1) continue;
            this.addBracketedSuffix(bracketIndex, nodes);
            bracketIndex = -1;
        }
        return isDoubleParent;
    }

    private void addBracketedSuffix(int bracketIndex, NodeSet nodes) {
        Token tokenBefore = bracketIndex > 0 ? this.tokenList.get(bracketIndex - 1) : null;
        BracketToken bracket = (BracketToken)this.tokenList.get(bracketIndex);
        if (tokenBefore instanceof Number) {
            int mul = ((Number)tokenBefore).getData();
            this.addSubstituent(mul, bracketIndex - 1, bracket.getInside(), nodes);
            this.removeFromControlList(new int[]{bracketIndex - 1, bracketIndex});
        } else {
            this.addSubstituent(1, bracketIndex, bracket.getInside(), nodes);
            this.removeFromControlList(bracketIndex);
        }
    }

    private void addSubstituent(int mul, int startIndex, ArrayList<Token> bracketedList, NodeSet nodes) {
        LocantList locant;
        boolean spaceSep = startIndex > 0 && this.tokenList.get(startIndex - 1) instanceof Separator && this.tokenList.get(startIndex - 1).getType() == 3;
        LocantList locantList = locant = startIndex > 2 && this.tokenList.get(startIndex - 2) instanceof LocantList ? (LocantList)this.tokenList.get(startIndex - 2) : null;
        if (locant != null) {
            this.removeFromControlList(startIndex - 2);
        }
        Structure s = IUPACParserCore.parseTokens(bracketedList);
        s.setSpaceSeparated(spaceSep);
        if (mul == 1 && locant == null && this.isBracketedParent(this.struc, s)) {
            nodes.setRoot(s);
            s.addSubstituent(this.struc);
        } else {
            for (int i = 0; i < mul; ++i) {
                Structure si = s.cloneStructure();
                this.struc.addSubstituent(si);
                if (locant == null || locant.size() <= 0) continue;
                si.setLocantInParent(locant.removeLocant(0));
            }
        }
    }

    private boolean isBracketedParent(Structure node, Structure suffix) {
        if (node.getParent() != null) {
            return false;
        }
        return !(suffix instanceof SimpleStructure) || ((SimpleStructure)suffix).getName().length() != 0;
    }

    private Suffix addSuffix(Token actToken, boolean[] flags, NodeSet nodes) {
        Suffix suffix = null;
        if (actToken instanceof EndingToken) {
            suffix = SuffixFactory.createSuffix(this.tokenList, this.actIndex, this.indexes[1]);
            this.removeFromControlList(new int[]{this.actIndex - suffix.tokenCount() + 1, this.actIndex});
            this.actIndex -= suffix.tokenCount();
            this.checkSuffix(suffix, this.actIndex, this.struc);
            this.struc.addSuffix(suffix);
            if (flags[1] && suffix.getValue().equals("") && !nodes.getRoot().equals(this.struc) && nodes.getRoot().substituentCount() == 1) {
                flags[0] = this.setDoubleParent(flags[0], nodes, false);
            }
            flags[1] = false;
        } else {
            --this.actIndex;
        }
        if (this.actIndex < this.indexes[1]) {
            this.indexes = this.findMainGroup(this.actIndex, nodes.getRoot());
            List<Token> list = this.tokenList.subList(this.indexes[0], this.indexes[1] + 1);
            Structure struc2 = this.parser.getStructure(list, this.indexes[2]);
            struc2.addSuffix(this.struc.getSuffixList());
            if (nodes.getRoot().equals(this.struc)) {
                nodes.setRoot(struc2);
                nodes.setActual(struc2);
            } else {
                nodes.getActual().removeSubstituent(nodes.getActual().substituentCount() - 1);
                nodes.getActual().addSubstituent(struc2);
            }
            this.struc = struc2;
        }
        return suffix;
    }

    private void checkSuffix(Suffix suffix, int actIndex, Structure parentStruc) {
        if (actIndex > -1 && this.tokenList.get(actIndex) instanceof Separator && ((Separator)this.tokenList.get(actIndex)).getType() == 3 && Util.atomCount(suffix.getValue()) == 0 && suffix.getType() == -1) {
            String sname = this.tokenList.get(actIndex + suffix.tokenCount()).toString();
            throw new NameImportException("Space can't stand before ending: " + sname);
        }
        if (suffix.getValue().equals("[HWE]")) {
            if (!(parentStruc instanceof HantzschWidmanSystem)) {
                String name = suffix.getName() + (suffix.getName().endsWith("e") ? "" : "e");
                if (name.equals("ine") && this.canHasIneEnding(parentStruc)) {
                    suffix.setValue("");
                    return;
                }
                throw new NameImportException("Invalid ending found: " + name);
            }
            suffix.setValue("");
        }
    }

    private boolean canHasIneEnding(Structure struc) {
        if (!(struc instanceof SimpleStructure)) {
            return true;
        }
        SimpleStructure ss = (SimpleStructure)struc;
        return !Util.isCharbonChain(ss.getName()) && Util.atomCount(ss.getValue()) > 1;
    }

    private Structure changeActual(int close, Structure actual, Structure struc) {
        actual = this.changeParentOfCarbonChains(close, actual, struc);
        return actual;
    }

    private Structure changeParentOfCarbonChains(int close, Structure actual, Structure struc) {
        if (close == 0 && actual instanceof SimpleStructure && struc instanceof SimpleStructure && actual.getParent() != null && actual.getParent() instanceof SimpleStructure) {
            String pname = ((SimpleStructure)actual.getParent()).getName();
            String aname = ((SimpleStructure)actual).getValue();
            String sname = ((SimpleStructure)struc).getValue();
            if (pname.indexOf("azan") > -1 && Util.isCharbonChain(aname) && Util.isCharbonChain(sname)) {
                actual = actual.getParent();
            }
        }
        return actual;
    }

    private boolean changeActualNeeded(Structure actual, Structure toBeActual, Structure newStruc, int mul) {
        Token t;
        boolean treeCheck;
        if (toBeActual.isRoot() && toBeActual.getParent() != null) {
            return false;
        }
        boolean bl = treeCheck = !actual.equals(toBeActual) && actual.substituentCount() > 0 && actual.getSubstituent(actual.substituentCount() - 1).getLocantInParent() == null && mul == 1 && !toBeActual.isSpaceSeparated() && !newStruc.isSpaceSeparated();
        if (!treeCheck) {
            return false;
        }
        boolean newNodeCheck = newStruc.getLocantInParent() != null || this.getSuffixLocantCount(newStruc) != 0 || newStruc.substituentCount() != 0;
        String actName = actual.getName();
        boolean actualcheck1 = actName != null && actName.endsWith("yl") || ParserUtil.getRadical(actual) > -1 || actual.isSpaceSeparated();
        boolean newStrucHaveToBeParent = toBeActual.getName() != null && ("oxy".equals(toBeActual.getName()) || toBeActual.getName().startsWith("carbo") && toBeActual.getName().endsWith("yl"));
        int index = this.getLastBracket(this.actIndex + 1);
        boolean actualCheck2 = actual instanceof Amine && index == 0 || index > 0 && (t = this.tokenList.get(index - 1)) instanceof Separator && t.getType() == 2 || actual instanceof SimpleStructure && ((SimpleStructure)actual).getName().equals("oxy");
        return newNodeCheck & (actualcheck1 | newStrucHaveToBeParent) | actualCheck2;
    }

    private int getLastBracket(int index) {
        for (int i = index; i > -1; --i) {
            if (!(this.tokenList.get(i) instanceof BracketToken)) continue;
            return i;
        }
        return 0;
    }

    private int getSuffixLocantCount(Structure struc) {
        int count = 0;
        int suffCount = struc.hasConnectionPoint() ? struc.suffixCount() - 1 : struc.suffixCount();
        for (int i = 0; i < suffCount; ++i) {
            if (struc.getSuffix(i).getLocant() == null || struc.getSuffix(i).getLocant().size() <= 0) continue;
            ++count;
        }
        return count;
    }

    private void addStereoDataToParents() {
        this.addStereoDataToParents(false);
    }

    boolean addStereoDataToParents(boolean isRoot) {
        boolean changed = false;
        for (int i = 0; i < this.stereoData.size(); ++i) {
            Structure st;
            StereoInfo info = this.stereoData.get(i);
            Structure struc = info.getParentStruc();
            LocantList data = info.getStereoData();
            boolean added = false;
            ArrayList<Structure> l = new ArrayList<Structure>();
            for (st = struc; st != null; st = st.getParent()) {
                l.add(0, st);
                if (st.isSpaceSeparated()) break;
            }
            while (!added && !l.isEmpty()) {
                st = (Structure)l.remove(0);
                if (!this.canHasStereoData(st, data)) continue;
                added = true;
                st.addStereoLocant(data);
                changed = true;
            }
            if (added) continue;
            Structure s = struc.getParent() == null ? struc : struc.getParent();
            for (int j = 0; j < s.substituentCount(); ++j) {
                if (!this.canHasStereoData(s.getSubstituent(j), data)) continue;
                s.getSubstituent(j).addStereoLocant(data);
                added = true;
                changed = true;
                break;
            }
            if (added || struc.getParent() == null) continue;
            struc.getParent().addStereoLocant(data);
            changed = true;
        }
        this.stereoData.clear();
        if (!isRoot) {
            return changed;
        }
        while (this.rePositionedLocants != null && !this.rePositionedLocants.isEmpty()) {
            Structure parent = this.rePositionedLocants.remove(0);
            LocantList data = parent.getStereoLocants();
            parent.clearStereoLocants();
            Structure child = this.rePositionedLocants.remove(0);
            child.addStereoLocant(data);
            changed = true;
        }
        return changed;
    }

    private boolean canHasStereoData(Structure struc, LocantList locantList) {
        SimpleStructure ss;
        if (struc == null) {
            return false;
        }
        if (struc instanceof HeteroAtom || struc instanceof HeteroChain) {
            return false;
        }
        if (struc instanceof SimpleStructure && (ss = (SimpleStructure)struc).getName().indexOf("oxy") > -1 && Util.atomCount(ss.getValue()) < 3) {
            return false;
        }
        if (struc instanceof VonBaeyerSystem || struc instanceof PolyCyclicSpiroSystem || struc instanceof BenzoFusedSystem) {
            return true;
        }
        if (struc instanceof FusedSystem) {
            return true;
        }
        for (int i = 0; i < locantList.size(); ++i) {
            Locant locant = locantList.getLocant(i);
            if (locant.getValue() < 100 && struc.getAtomCount() < locant.getValue()) {
                return false;
            }
            if (struc.getAtomCount() >= locant.getValue() / 100) continue;
            return false;
        }
        return true;
    }

    private boolean rePositionLocant(ArrayList<Token> tokenList, int lastIndex, Structure actual, Structure root) {
        if (this.repositionNeeded(tokenList, lastIndex, actual, root)) {
            LocantList l = new LocantList();
            l.tryAddLocant(root.getLocantInParent());
            int mul = root.getLocantInParent().size();
            LocantList l2 = null;
            root.setLocantInParent(l2);
            if (root instanceof Amine) {
                ((Amine)root).setNumbering(l);
            } else {
                if (this.rePositionedLocants == null) {
                    this.rePositionedLocants = new ArrayList();
                }
                this.rePositionedLocants.add(root);
                this.rePositionedLocants.add(actual);
            }
            Suffix s = SuffixFactory.createSuffix("|", "yl", l, mul, 2);
            actual.addSuffix(s);
            return true;
        }
        return false;
    }

    private boolean repositionNeeded(ArrayList<Token> tokenList, int lastIndex, Structure actual, Structure root) {
        boolean rootCheck;
        Suffix radical;
        boolean tokenCheck;
        boolean bl = tokenCheck = lastIndex < tokenList.size() - 4 && !tokenList.get(lastIndex).getName().startsWith("yl") && this.isDash(tokenList.get(lastIndex + 1)) && tokenList.get(lastIndex + 2) instanceof LocantList && this.isDash(tokenList.get(lastIndex + 3));
        if (!tokenCheck) {
            return false;
        }
        boolean canBeSuffixNumbering = root.hasLocant() && root.hasLocant(root.getLocantInParent().getLocant(0));
        int suffixIndex = canBeSuffixNumbering ? root.getFirstSuffixWithoutLocant() : -1;
        Suffix suffix = radical = suffixIndex > -1 ? root.getSuffix(suffixIndex) : null;
        if (!this.canBeNumberedSuffixOf(root, radical)) {
            radical = null;
        }
        boolean bl2 = rootCheck = !(root.hasLocant() && (actual.hasConnectionPoint() && !actual.hasDefaultSuffixNumbering() || !actual.hasLocant(root.getLocantInParent().getLocant(0))) || radical != null && !radical.hasLocant());
        if (!rootCheck) {
            return false;
        }
        return !(actual instanceof SimpleStructure) || Util.atomCount(((SimpleStructure)actual).getValue()) > 1 || ((SimpleStructure)actual).getValue().equals("C");
    }

    private boolean canBeNumberedSuffixOf(Structure parentStruc, Suffix suffix) {
        if (suffix == null) {
            return false;
        }
        int suffixType = suffix.getType();
        if (suffixType == 0) {
            return true;
        }
        if (suffixType == 4 || suffix.isSpaceSeparated()) {
            return false;
        }
        return !suffix.getName().equals("ol") || !(parentStruc instanceof SimpleStructure) || !((SimpleStructure)parentStruc).getValue().equals("CC");
    }

    private boolean isDash(Token token) {
        return token instanceof Separator && ((Separator)token).getType() == 2;
    }

    private void addHydrogens(Structure struc) {
        if (this.actIndex < 0) {
            return;
        }
        if (Util.isHetero(struc) || Util.hasClone(struc)) {
            struc = struc.getParent();
        }
        int index = this.actIndex;
        this.decSeparators();
        Hydro h = null;
        int mul = 1;
        ArrayList<Hydro> list = new ArrayList<Hydro>();
        while (this.actIndex > -1 && this.tokenList.get(this.actIndex) instanceof Hydro) {
            h = (Hydro)this.tokenList.get(this.actIndex);
            struc.addHydro(h);
            list.add(0, h);
            this.removeFromControlList(this.actIndex--);
            this.decSeparators();
        }
        if (h != null && this.actIndex > -1 && this.tokenList.get(this.actIndex) instanceof Number) {
            mul = ((Number)this.tokenList.get(this.actIndex)).getData();
            for (int i = 0; i < mul - 1; ++i) {
                Hydro h1 = h.cloneToken();
                struc.addHydro(h1);
                list.add(0, h1);
            }
            this.removeFromControlList(this.actIndex--);
        }
        this.decSeparators();
        if (h != null && this.actIndex > -1 && this.tokenList.get(this.actIndex) instanceof LocantList && ((LocantList)this.tokenList.get(this.actIndex)).getLocant(0) instanceof SimpleLocant) {
            LocantList loc = (LocantList)this.tokenList.get(this.actIndex);
            for (int i = 0; i < mul; ++i) {
                ((Hydro)list.get(i)).setLocant((SimpleLocant)loc.getLocant(i));
            }
            this.removeFromControlList(this.actIndex--);
        }
        if (h == null) {
            this.actIndex = index;
        }
    }

    private void addStereoData(Structure struc, Structure root, Structure basic) {
        if (this.actIndex < 0) {
            return;
        }
        int index = this.actIndex;
        boolean isAmine = root.getParent() instanceof Amine;
        this.decSeparators();
        LocantList bondstereo = new LocantList();
        LocantList atomstereo = new LocantList();
        while (this.actIndex > -1 && this.tokenList.get(this.actIndex) instanceof LocantList && ((LocantList)this.tokenList.get(this.actIndex)).getLocant(0) instanceof StereoNumber) {
            StereoNumber num = (StereoNumber)((LocantList)this.tokenList.get(this.actIndex)).getLocant(0);
            if (isAmine && num.getLocant() instanceof AzaLocant) {
                root = root.getParent();
                isAmine = false;
            }
            if (num.isBondStereo()) {
                bondstereo.tryAddLocant((LocantList)this.tokenList.get(this.actIndex));
            } else {
                atomstereo.tryAddLocant((LocantList)this.tokenList.get(this.actIndex));
            }
            this.removeFromControlList(this.actIndex--);
            if (this.actIndex > 0 && this.tokenList.get(this.actIndex - 1) instanceof LocantList) continue;
            this.decSeparators();
        }
        if (bondstereo.size() == 0 && atomstereo.size() == 0) {
            this.actIndex = index;
        } else {
            if (bondstereo.size() != 0) {
                if (ParserUtil.canBeStereo(root, bondstereo) && !struc.isSpaceSeparated()) {
                    root.addStereoLocant(bondstereo);
                } else {
                    struc.addStereoLocant(bondstereo);
                }
            }
            if (atomstereo.size() != 0) {
                this.stereoData.add(new StereoInfo(struc, atomstereo));
            }
        }
    }

    private void decSeparators() {
        while (this.actIndex > -1 && this.tokenList.get(this.actIndex) instanceof Separator && this.tokenList.get(this.actIndex).getType() == 2) {
            this.removeFromControlList(this.actIndex--);
        }
    }

    private int peroxolLength(int index) {
        int len = 0;
        if (index < this.tokenList.size() && this.tokenList.get(index).getName().equals("peroxol")) {
            Token t3;
            Token t;
            Token token = t = index - ++len > 0 ? this.tokenList.get(index - len) : null;
            if (index > 0 && t != null && (t.getName().equals("thio") || t.getName().equals("seleno") || t.getName().equals("telluro"))) {
                ++len;
            }
            Token t1 = index - 2 > 0 ? this.tokenList.get(index - 2) : null;
            Token t2 = index - 3 > 0 ? this.tokenList.get(index - 3) : null;
            Token token2 = t3 = index - 4 > 0 ? this.tokenList.get(index - 4) : null;
            if (len == 2 && index > 3 && t1 instanceof Separator && t2 instanceof Atom && t3 instanceof Atom) {
                len += 3;
            }
        }
        return len;
    }

    private boolean isAmidoParent(int index) {
        if (index < 2) {
            return false;
        }
        if (!(this.tokenList.get(index - 1) instanceof Separator) || !(this.tokenList.get(index - 2) instanceof LocantList)) {
            return false;
        }
        Token token0 = this.tokenList.get(index);
        Token token1 = this.tokenList.get(index - 1);
        return token0.getName().equals("amido") && token1.getType() == 2;
    }

    private int isMultipliedStruc(int actindex) {
        boolean structureCheck;
        Token tokenBefore = actindex > 0 ? this.tokenList.get(actindex - 1) : null;
        Token tokenAfter = actindex < this.tokenList.size() - 1 ? this.tokenList.get(actindex + 1) : null;
        boolean isMultipliedStructure = this.tokenList.get(actindex) instanceof Number && !(tokenBefore instanceof SpecialGroup);
        boolean isBracketedEnding = tokenAfter instanceof BracketToken && ((BracketToken)tokenAfter).getInside().get(0) instanceof EndingToken;
        boolean isSeparated = tokenBefore == null || tokenBefore instanceof Separator && tokenBefore.getType() != 3 || tokenBefore instanceof BracketToken;
        boolean hasNonReflexiveLocant = actindex > 1 && this.tokenList.get(actindex - 2) instanceof LocantList && ((LocantList)this.tokenList.get(actindex - 2)).getMaxParentIndex() == 0;
        boolean bl = structureCheck = !isBracketedEnding && isSeparated && !hasNonReflexiveLocant;
        if (!isMultipliedStructure || !structureCheck) {
            return -1;
        }
        boolean hasBracketedPart = this.tokenList.get(actindex + 1) instanceof BracketToken;
        if (isMultipliedStructure && hasBracketedPart) {
            return 0;
        }
        if (isMultipliedStructure && actindex < this.tokenList.size() + 1 && this.tokenList.get(actindex + 1) instanceof Separator) {
            return 1;
        }
        return -1;
    }

    private int[] findAcidAsMainGroup(int index) {
        Token token = this.tokenList.get(index);
        int type = -1;
        int lenght = AcidGenerator.structureLength(this.tokenList, index);
        type = token.getName().equals("carbonic acid") ? 12 : 13;
        return new int[]{index - lenght + 1, index, type};
    }

    void changeNumberToCarbonChain(int index) {
        if (this.tokenList.size() <= index || !(this.tokenList.get(index) instanceof Number)) {
            return;
        }
        if (this.tokenList.size() > index + 1 && SuffixFactory.isPolyRingSystemEnding(this.tokenList.get(index + 1))) {
            return;
        }
        Number token = (Number)this.tokenList.get(index);
        String chain = "";
        for (int i = 0; i < token.getData(); ++i) {
            chain = chain + "C";
        }
        StructureToken newtoken = new StructureToken(token.getName(), chain);
        this.tokenList.remove(index);
        this.tokenList.add(index, newtoken);
        this.controlList.add(this.controlList.indexOf(token), newtoken);
        this.controlList.remove(token);
    }

    private boolean isParentHydride(Token token, int index, ArrayList<Token> possibleParent) {
        if (token.getName().equals("tert") || this.isSaltEnding(token, index)) {
            return false;
        }
        if (token instanceof StructureToken) {
            return true;
        }
        if (token instanceof Number) {
            Token tk;
            if (this.isParentHydrideNumber((Number)token, index)) {
                return true;
            }
            Token token2 = tk = index < this.tokenList.size() - 1 ? this.tokenList.get(index + 1) : null;
            if (SuffixFactory.isPolyRingSystemEnding(tk)) {
                return true;
            }
            Token token3 = tk = index > 1 ? this.tokenList.get(index - 2) : null;
            if (tk != null && (tk.getName().equals("sec") || tk.getName().equals("tert"))) {
                return true;
            }
        }
        return this.canBeParentHydride(index, possibleParent);
    }

    private boolean isSaltEnding(Token token, int index) {
        boolean beforeCheck;
        boolean isSalt;
        Token tokenAfter = index < this.tokenList.size() - 1 ? this.tokenList.get(index + 1) : null;
        boolean bl = isSalt = tokenAfter != null && tokenAfter instanceof EndingToken && tokenAfter.getValue().equals("[SALT]");
        if (!isSalt) {
            return false;
        }
        Token tokenBefore = index > 0 ? this.tokenList.get(index - 1) : null;
        boolean bl2 = beforeCheck = tokenBefore == null || !(tokenBefore instanceof EndingToken) && (!tokenBefore.getName().endsWith("o") || tokenBefore.getName().equals("hydro"));
        if (!beforeCheck) {
            return false;
        }
        Token beforeBefore = index > 1 ? this.tokenList.get(index - 2) : null;
        boolean beforeBeforeCheck = beforeBefore == null || !(tokenBefore instanceof Separator) || !beforeBefore.getName().equals("hydrogen");
        return beforeBeforeCheck;
    }

    private boolean isParentHydrideNumber(Number multiplier, int index) {
        Token after1;
        Token token = after1 = index < this.tokenList.size() - 1 ? this.tokenList.get(index + 1) : null;
        if (multiplier.getType() == 2) {
            return true;
        }
        if (multiplier.getType() == 0) {
            Token after2 = index < this.tokenList.size() - 2 ? this.tokenList.get(index + 2) : null;
            return after1 instanceof Separator && after2 instanceof LocantList || after1 instanceof Number && after2 instanceof EndingToken;
        }
        if (multiplier.getData() < 5) {
            return false;
        }
        Token before = index > 0 ? this.tokenList.get(index - 1) : null;
        boolean beforeCheck = before == null || before instanceof EndingToken && before.getType() == 5 || before instanceof Separator && before.getType() == 3;
        boolean afterCheck = !(after1 instanceof Separator) && !(after1 instanceof BracketToken) && !(after1 instanceof StructureToken);
        return beforeCheck && afterCheck;
    }

    private boolean canBeParentHydride(int index, ArrayList<Token> possibleParent) {
        boolean possible;
        Token token = this.tokenList.get(index);
        boolean bl = possible = token instanceof EndingToken && ParserUtil.suffixCanBeParent(token.getName());
        if (possible && (index == 0 || this.tokenList.get(index - 1) instanceof BracketToken) && Util.atomCount(this.tokenList.get(index).getValue()) > 0) {
            return true;
        }
        if (token instanceof EndingToken && token.getValue().equals("[SALT]") && (this.tokenList.size() == 2 || index > 1 && this.tokenList.get(index - 2) instanceof BracketToken)) {
            return true;
        }
        if (token instanceof EndingToken && token.getName().endsWith("ide") && (index == 0 || this.tokenList.get(index - 1) instanceof BracketToken) && !(this.tokenList.get(index - 2) instanceof Number) && !(this.tokenList.get(index - 2) instanceof LocantList)) {
            return true;
        }
        if (possible) {
            possibleParent.add(0, token);
        }
        return false;
    }

    private int[] findMainStructure(int index, Structure root) {
        Token t3;
        int[] indexes = this.findHeteroChains(this.tokenList, index);
        index = indexes[0];
        Token t = this.tokenList.get(index);
        Token t1 = index < this.tokenList.size() - 1 ? this.tokenList.get(index + 1) : null;
        Token t2 = index > 0 ? this.tokenList.get(index - 1) : null;
        Token token = t3 = index > 1 ? this.tokenList.get(index - 2) : null;
        if (t2 instanceof Separator && ((Separator)t2).getType() == 3 && t3 != null && t3.getValue().equals("[MOLECULAR]")) {
            indexes[0] = index - 2;
            indexes[1] = index;
            indexes[2] = 20;
        } else if (t.getValue().equals("[ANNULENE]")) {
            indexes[0] = index - 2;
            indexes[1] = index;
            indexes[2] = 19;
            if (this.tokenList.get(indexes[0] - 1).getName().equals("benzo")) {
                indexes[0] = indexes[0] - 1;
            }
        } else if (t2 instanceof StructureToken && t2.getValue().equals("[EPI]")) {
            indexes[0] = index - 1;
            indexes[1] = index;
            indexes[2] = 26;
        } else {
            int len = this.isBridge(index);
            if (len > 0) {
                indexes[0] = index;
                indexes[1] = len;
                indexes[2] = 26;
            } else if (t instanceof Number && t1 != null && SuffixFactory.isPolyRingSystemEnding(t1)) {
                indexes[0] = index;
                indexes[1] = index + 1;
                indexes[2] = 16;
            } else if (t instanceof EndingToken && t.getValue().equalsIgnoreCase("[SALT]")) {
                indexes[0] = index - 1;
                indexes[1] = index - 1;
                indexes[2] = 0;
            } else if (index > 1 && this.tokenList.get(index - 1) instanceof LocantList && this.tokenList.get(index - 1).getType() == 0 && this.tokenList.get(index - 2) instanceof SpecialGroup) {
                indexes[0] = indexes[0] - 2;
                SpecialGroup spec = (SpecialGroup)this.tokenList.get(index - 2);
                if (spec.getType() == 1) {
                    indexes[2] = 1;
                    indexes[0] = indexes[0] - 1;
                } else if (spec.getType() == 0) {
                    indexes[2] = 2;
                    if (index > 2 && this.tokenList.get(index - 3) instanceof Number && this.tokenList.get(index - 3).getType() != 2) {
                        indexes[0] = indexes[0] - 1;
                    }
                }
                if (index > 2 && this.tokenList.get(index - 1).getClass() == Number.class) {
                    indexes[0] = indexes[0] - 1;
                }
            } else if (index > 0 && this.tokenList.get(index - 1).getClass() == SpecialGroup.class) {
                Token token2;
                indexes[2] = 1;
                indexes[0] = indexes[0] - 1;
                Token token3 = token2 = this.tokenList.size() > index + 1 ? this.tokenList.get(index + 1) : null;
                if (token2 != null && token2.getName().equals("ine")) {
                    indexes[1] = indexes[1] + 1;
                }
            } else if (index > 0 && this.tokenList.get(index).getName().equals("carbonate") && this.tokenList.get(index - 1) instanceof Number) {
                indexes[0] = index - 1;
                indexes[2] = 18;
            } else if (index > 0 && t.getName().equals("oxy") && Util.isCharbonChain(t2.getValue()) && !(t3 instanceof SpecialGroup)) {
                indexes[0] = indexes[0] - 1;
                indexes[2] = 6;
            } else if (this.tokenList.get(index).getName().endsWith("ate")) {
                indexes[2] = 10;
            } else if (index > 0 && this.tokenList.get(index).getName().equalsIgnoreCase("sulfinyl")) {
                indexes = this.findSulfinylGroup(index);
            } else if (this.isMultipliedStructure(index)) {
                indexes = new int[]{index - 3, index, 17};
            } else if (this.isMultiMethylene(index)) {
                indexes = new int[]{index - 1, index + 1, 28};
            } else if (index > -1 && this.tokenList.get(index) instanceof StructureToken && indexes[2] != 5) {
                indexes = this.findFusedStructures(index);
            }
        }
        if (indexes[0] > 1 && this.tokenList.get(indexes[0] - 1) instanceof Separator && this.tokenList.get(indexes[0] - 2).getName().equals("tert")) {
            indexes[0] = indexes[0] - 2;
        } else if (indexes[0] > 1 && this.tokenList.get(indexes[0] - 1) instanceof Separator && this.tokenList.get(indexes[0] - 2).getName().equals("sec")) {
            indexes[0] = indexes[0] - 2;
            if (indexes[1] < this.tokenList.size() && this.tokenList.get(indexes[1] + 1).getName().equals("yl")) {
                indexes[1] = indexes[1] + 1;
            }
        }
        this.checkBiphenylGroup(indexes);
        return indexes;
    }

    private boolean isMultiMethylene(int rootIndex) {
        if (!this.tokenList.get(rootIndex).getName().equals("meth")) {
            return false;
        }
        if (rootIndex >= this.tokenList.size() || !this.tokenList.get(rootIndex + 1).getName().startsWith("ylen")) {
            return false;
        }
        return rootIndex > 0 && this.tokenList.get(rootIndex - 1) instanceof Number;
    }

    private void checkBiphenylGroup(int[] indexes) {
        if (this.isPolyPheneGroup(indexes)) {
            EndingToken phene = new EndingToken("phene", "[POLY_PHENE]");
            this.removeFromControlList(indexes[0]);
            this.tokenList.remove(indexes[0]);
            this.tokenList.add(indexes[0], phene);
            indexes[0] = indexes[0] - 1;
            indexes[2] = 16;
            return;
        }
        if (!this.isBiphenylGroup(indexes)) {
            return;
        }
        StructureToken biphenyl = new StructureToken("biphenyl", "c1ccc(cc1)c1ccccc1 |$4;3;2;1;6;5;1';2';3';4';5';6'$|");
        this.removeFromControlList(new int[]{indexes[0] - 1, indexes[0] + 1});
        this.tokenList.remove(indexes[0] - 1);
        this.tokenList.remove(indexes[0] - 1);
        this.tokenList.remove(indexes[0] - 1);
        this.tokenList.add(indexes[0] - 1, biphenyl);
        indexes[0] = indexes[0] - 1;
        indexes[1] = indexes[1] - 1;
    }

    private boolean isPolyPheneGroup(int[] indexes) {
        if (!this.isPhenyl(indexes)) {
            return false;
        }
        if (!(this.tokenList.get(indexes[0] - 1) instanceof Number) || ((Number)this.tokenList.get(indexes[0] - 1)).getData() < 3) {
            return false;
        }
        return indexes[0] < this.tokenList.size() - 2 && this.tokenList.get(indexes[0] + 1) instanceof Separator && this.tokenList.get(indexes[0] + 2) instanceof LocantList;
    }

    private boolean isBiphenylGroup(int[] indexes) {
        boolean separatorBefore;
        LocantList list;
        if (!this.isPhenyl(indexes)) {
            return false;
        }
        if (!(this.tokenList.get(indexes[0] - 1) instanceof Number) || !this.tokenList.get(indexes[0] - 1).getValue().equals("2")) {
            return false;
        }
        if (!this.tokenList.get(indexes[0] + 1).getName().equals("yl")) {
            return false;
        }
        int index = indexes[0] + 2;
        if (index < this.tokenList.size() && this.tokenList.get(index) instanceof Separator) {
            ++index;
        }
        boolean locantsBefore = indexes[0] > 2 && this.tokenList.get(indexes[0] - 2) instanceof Separator && this.tokenList.get(indexes[0] - 3) instanceof LocantList;
        LocantList locantList = list = locantsBefore ? (LocantList)this.tokenList.get(indexes[0] - 3) : null;
        if (!(this.struc != null && this.struc.getParent() != null || list == null || list.size() != 1 || list.getLocant(0) instanceof StereoNumber)) {
            return true;
        }
        boolean acidBehind = index < this.tokenList.size() && this.tokenList.get(index) instanceof EndingToken && this.tokenList.get(index).getType() == 2 && !this.tokenList.get(index).getValue().startsWith("&");
        boolean bl = separatorBefore = indexes[0] > 1 && this.tokenList.get(indexes[0] - 2) instanceof Separator;
        if (acidBehind && (indexes[0] == 1 || separatorBefore)) {
            return false;
        }
        boolean case1 = indexes[0] < this.tokenList.size() - 2 && this.tokenList.get(indexes[0] + 2) instanceof EndingToken && (this.tokenList.get(indexes[0] + 2).getType() == 5 || this.tokenList.get(indexes[0] + 2).getName().startsWith("ylen"));
        boolean case2 = this.struc == null && (!locantsBefore || list.getMaxParentIndex() == 0);
        return case1 || case2;
    }

    private boolean isPhenyl(int[] indexes) {
        return indexes[0] > 0 && indexes[0] < this.tokenList.size() && indexes[2] == 0 && indexes[0] == indexes[1] && (this.tokenList.get(indexes[0]).getName().equals("phen") || this.tokenList.get(indexes[0]).getName().equals("benz"));
    }

    private int isBridge(int mainindex) {
        for (int idx = mainindex + 1; idx < this.tokenList.size(); ++idx) {
            Token token = this.tokenList.get(idx);
            if (token instanceof EndingToken && token.getValue().endsWith("[EPI]")) {
                return idx;
            }
            if (!(token instanceof StructureToken) && !(token instanceof EndingToken)) continue;
            return -1;
        }
        return -1;
    }

    private boolean isMultipliedStructure(int index) {
        if (this.tokenList.get(index) instanceof StructureToken && index > 2 && this.tokenList.get(index - 1) instanceof Number && this.tokenList.get(index - 2) instanceof Separator && this.tokenList.get(index - 3) instanceof LocantList) {
            Number num = (Number)this.tokenList.get(index - 1);
            Separator sep = (Separator)this.tokenList.get(index - 2);
            LocantList loc = (LocantList)this.tokenList.get(index - 3);
            if (sep.getType() != 2) {
                return false;
            }
            if (num.getData() == 2) {
                if (this.tokenList.size() - index > 1) {
                    return false;
                }
                if (loc.getType() != 2 || loc.size() != 2) {
                    return false;
                }
                for (int i = 0; i < loc.size(); ++i) {
                    if (loc.getLocant(i).getParent() == i) continue;
                    return false;
                }
            } else if (loc.getType() != 3 || loc.size() != num.getData() - 1) {
                return false;
            }
            return true;
        }
        return false;
    }

    private int[] findSulfinylGroup(int index) {
        int[] indexes = new int[]{index, index, 0};
        if (index > 0 && this.tokenList.get(index - 1) instanceof StructureToken) {
            StructureToken t = (StructureToken)this.tokenList.get(index - 1);
            if (Util.isCharbonChain(t.getValue())) {
                indexes[0] = indexes[0] - 1;
                indexes[2] = 14;
            }
        } else if (index > 1 && this.tokenList.get(index - 1) instanceof EndingToken && this.tokenList.get(index - 2) instanceof StructureToken) {
            EndingToken t1 = (EndingToken)this.tokenList.get(index - 1);
            StructureToken t = (StructureToken)this.tokenList.get(index - 2);
            if (t1.getValue().equals("") && Util.isCharbonChain(t.getValue())) {
                indexes[0] = indexes[0] - 2;
                indexes[2] = 14;
            }
        }
        return indexes;
    }

    private int[] findFusedStructures(int index) {
        int numberingindex;
        int[] indexes = new int[]{index, index, 0};
        StructureToken main = (StructureToken)this.tokenList.get(index);
        int len = 0;
        if ((ParserUtil.isStructureNamedAs(this.tokenList, index, "amin") || ParserUtil.isStructureNamedAs(this.tokenList, index, "oxim")) && index > 0 && !main.getName().endsWith("o") && this.tokenList.get(index - 1) instanceof Number) {
            indexes[0] = indexes[0] - 1;
        }
        if ((numberingindex = this.isAtomNumberedStructure(this.tokenList, indexes)) > -1) {
            indexes[0] = numberingindex;
            indexes[2] = 0;
        } else if (IUPACParser.isAnthrene(main.getName()) && index > 0) {
            Token hetatom = this.tokenList.get(index - 1);
            if (hetatom instanceof StructureToken && Util.heteroAtom(hetatom.getValue())) {
                indexes[2] = 7;
                indexes[0] = index - 1;
            }
        } else {
            len = ParserUtil.isPhenoIneComponent(this.tokenList, index);
            if (len > 0) {
                indexes[2] = 8;
                indexes[0] = index - len;
                indexes[1] = Math.min(index + 1, this.tokenList.size() - 1);
            } else {
                len = ParserUtil.isBenzoFusedComponent(this.tokenList, index);
                if (len > 0) {
                    indexes[2] = 9;
                    indexes[0] = index - len;
                    if (index < this.tokenList.size() - 1 && !(this.tokenList.get(index + 1) instanceof Separator)) {
                        indexes[1] = index + 1;
                    }
                } else {
                    len = ParserUtil.isHantzschWidmanSystem(this.tokenList, index);
                    if (len > -1) {
                        indexes[2] = 11;
                        indexes[0] = index - len;
                        indexes[1] = index + 1;
                    }
                }
            }
        }
        len = ParserUtil.getFusedLocantIndex(this.tokenList, index);
        if (!(len <= -1 || this.tokenList.get(indexes[1]) instanceof StructureToken && Util.heteroAtom(this.tokenList.get(indexes[1]).getValue()))) {
            indexes[0] = ParserUtil.getDashOrBracerIndex(this.tokenList, len) + 1;
            indexes[2] = 23;
        }
        return indexes;
    }

    private int isAtomNumberedStructure(ArrayList<Token> tokenList, int[] indexes) {
        Token t = null;
        int numberingindex = indexes[0] > 1 && (t = tokenList.get(indexes[0] - 1)) instanceof Separator ? indexes[0] - 2 : indexes[0] - 1;
        boolean numbered = numberingindex > -1 && Util.isNumbering(t = tokenList.get(numberingindex));
        boolean bl = numbered = numbered && Util.getNumbering(t).getLocant(0) instanceof SimpleLocant;
        if (!numbered) {
            return -1;
        }
        LocantList locants = numbered ? Util.getNumbering(t) : new LocantList();
        boolean isTolyl = tokenList.get(indexes[0]).getName().equals("tol");
        if (!isTolyl && locants.size() == 1 && indexes[1] < tokenList.size() - 1 && tokenList.get(indexes[1] + 1).getName().equals("yl")) {
            return -1;
        }
        return ParserUtil.isRingSystemWithHeteroAtom(tokenList, indexes[0]) || ParserUtil.isRingSystemWithdoubleBond(tokenList, indexes[0]) || ParserUtil.isRingSystemWithSubstituent(tokenList, indexes[0]) || this.isSystemWithRgroup(tokenList, indexes[0], locants.getLocant(0)) ? numberingindex : -1;
    }

    private boolean isSystemWithRgroup(ArrayList<Token> tokenlist, int index, Locant l) {
        if (this.struc != null && !(this.struc instanceof Amine) || index < 0 || !(tokenlist.get(index) instanceof StructureToken) || !(l instanceof SimpleLocant)) {
            return false;
        }
        StructureToken token = (StructureToken)tokenlist.get(index);
        if (((Token)token).getValue().indexOf("RGroup") < 0) {
            return false;
        }
        SimpleStructure tmp = new SimpleStructure(((Token)token).getValue(), token.getName());
        return tmp.hasLocant(l);
    }

    private int[] findHeteroChains(ArrayList<Token> tokenList, int index) {
        Token multiplier;
        int[] indexes = new int[]{index, index, 0};
        Token atom1 = index > 0 ? tokenList.get(index - 1) : null;
        Token atom2 = tokenList.get(index);
        Token ending = index < tokenList.size() - 1 ? tokenList.get(index + 1) : null;
        int i = index + 1;
        while (i < tokenList.size() && (ending.getValue().equals("-") || ending instanceof LocantList)) {
            ending = tokenList.get(i++);
        }
        if (!ParserUtil.isHeteroChainAtom(atom2) || !ParserUtil.isHeteroEnding(ending) && !ParserUtil.endingFits("ane", atom2.getName()) && !ParserUtil.endingFits("ene", atom2.getName()) && index < tokenList.size() - 1) {
            return indexes;
        }
        if (ParserUtil.isHeteroChainAtom(atom1)) {
            atom2 = tokenList.get(--index);
        }
        Token token = multiplier = index > 0 ? tokenList.get(index - 1) : null;
        if (multiplier instanceof Number && ParserUtil.isHeteroChainAtom(atom2) && (!ParserUtil.isVIAAtom(atom2.getValue()) || ParserUtil.endingFits("ane", atom2.getName()) || ParserUtil.endingFits("ene", atom2.getName()))) {
            Token t2;
            Token t1 = --index > 1 ? tokenList.get(index - 1) : null;
            Token token2 = t2 = index > 1 ? tokenList.get(index - 2) : null;
            if (this.struc == null || !(t1 instanceof Separator) || t1.getType() != 2 || !(t2 instanceof LocantList) || ((LocantList)t2).size() <= 1) {
                indexes[2] = 5;
                indexes[0] = index;
            }
        }
        return indexes;
    }

    private static int[] findSpecialGroups(ArrayList<Token> tokenList, int index, ArrayList<Token> closeBrackets) {
        int[] indexes = new int[3];
        indexes[0] = index;
        SpecialGroup token = (SpecialGroup)tokenList.get(index);
        if (token.getType() == 0) {
            if (index > 0 && tokenList.get(index - 1).getType() != 2 && tokenList.get(index - 1) instanceof Number && tokenList.get(index + 1) instanceof Separator) {
                indexes[0] = indexes[0] - 1;
                indexes[2] = 3;
            } else if (index > 1 && tokenList.get(index - 1) instanceof Separator && tokenList.get(index - 2) instanceof LocantList && tokenList.get(index + 1) instanceof Number && tokenList.get(index + 1).getType() != 2) {
                indexes[0] = indexes[0] - 2;
                indexes[2] = 4;
                ++index;
            } else if (index > 2 && tokenList.get(index - 2) instanceof Separator && tokenList.get(index - 3) instanceof LocantList && tokenList.get(index + 1) instanceof Number && tokenList.get(index + 1).getType() != 2) {
                indexes[0] = indexes[0] - 3;
                indexes[2] = 4;
                ++index;
            } else {
                indexes[2] = 3;
            }
            if (tokenList.get(index + 1) instanceof Separator && tokenList.get(index + 1).getType() == 2) {
                ++index;
            }
            if (!(tokenList.get(index + 1) instanceof BracketToken)) {
                indexes[2] = -1;
            } else {
                indexes[1] = index + 1;
            }
        } else {
            indexes[2] = -1;
        }
        return indexes;
    }

    public String toString() {
        return this.tokenList.toString();
    }

    class StereoInfo {
        Structure parentStruc;
        LocantList stereoData;

        StereoInfo(Structure parentStruc, LocantList stereoData) {
            this.parentStruc = parentStruc;
            this.stereoData = stereoData;
        }

        Structure getParentStruc() {
            return this.parentStruc;
        }

        LocantList getStereoData() {
            return this.stereoData;
        }
    }

    class NodeSet {
        Structure root;
        Structure secondRoot;
        Structure actual;

        NodeSet() {
        }

        Structure getRoot() {
            return this.root;
        }

        void setRoot(Structure root) {
            this.root = root;
        }

        Structure getSecondRoot() {
            return this.secondRoot;
        }

        void setSecondRoot(Structure secondRoot) {
            this.secondRoot = secondRoot;
        }

        Structure getActual() {
            return this.actual;
        }

        void setActual(Structure actual) {
            this.actual = actual;
        }

        public String toString() {
            return "" + this.actual + " " + this.root + " " + this.secondRoot;
        }
    }
}

