/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AzaLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.parse.ParserUtil;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroAtom;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;

public class InvalidLocantChecker
implements Refactoring<Structure> {
    private boolean validateLocants;
    private boolean changed = false;
    private IdentityHashMap<Structure, Boolean> singleAtoms;

    public InvalidLocantChecker(boolean validateLocants) {
        this.validateLocants = validateLocants;
    }

    @Override
    public boolean checkTree(Structure root) {
        if (!this.validateLocants) {
            return false;
        }
        this.changed = false;
        this.replaceLocantsWithGreekLetters(root);
        this.singleAtoms = new IdentityHashMap();
        this.replaceInvalidLocants(root);
        return this.changed;
    }

    private void replaceLocantsWithGreekLetters(Structure struc) {
        boolean hasFunctionalGroup;
        int subCount = struc.substituentCount();
        for (int i = 0; i < subCount; ++i) {
            this.replaceLocantsWithGreekLetters(struc.getSubstituent(i));
        }
        boolean hasImplicitGreekLetter = this.hasImplicitGreekLetter(struc.getParent());
        boolean bl = hasFunctionalGroup = this.hasFunctionalGroup(struc.getParent()) && !this.hasFunctionalGroup(struc);
        if (struc.isRoot() || !hasImplicitGreekLetter && !hasFunctionalGroup) {
            return;
        }
        ArrayList<Structure> greekLocants = new ArrayList<Structure>();
        for (Structure s : struc.getSubstituentList()) {
            if (!this.hasGreekLocant(s)) continue;
            greekLocants.add(s);
        }
        for (Structure s : greekLocants) {
            if ((!hasFunctionalGroup || hasImplicitGreekLetter) && !this.hasImplicitGreekLetter(struc.getParent(), s.getLocantInParent().getLocant(0).toString())) continue;
            struc.removeSubstituent(s);
            struc.getParent().addSubstituent(s);
            this.changed = true;
        }
    }

    private boolean hasFunctionalGroup(Structure struc) {
        if (struc == null) {
            return false;
        }
        String name = struc.getName();
        if (name != null && name.contains("sulf")) {
            return false;
        }
        for (Suffix suffix : struc.getSuffixList()) {
            int type = suffix.getType();
            if (type != 0 && type != 5 && type != 1) continue;
            return true;
        }
        return name != null && name.contains("acid");
    }

    private boolean hasGreekLocant(Structure struc) {
        if (!struc.hasLocant()) {
            return false;
        }
        return struc.getLocantInParent().getLocant(0).isGreekLetter();
    }

    private boolean hasImplicitGreekLetter(Structure struc, String locant) {
        return struc instanceof SimpleStructure && ((SimpleStructure)struc).getValue().matches(".*" + locant + ".*");
    }

    private boolean hasImplicitGreekLetter(Structure struc) {
        return struc instanceof SimpleStructure && ((SimpleStructure)struc).getValue().matches(".*(alpha|beta).*");
    }

    private int replaceInvalidLocants(Structure struc) {
        for (int i = 0; i < struc.substituentCount() && i >= 0; ++i) {
            Structure s = struc.getSubstituent(i);
            i += this.replaceInvalidLocants(s);
        }
        return this.replaceInvalidLocants(struc, false);
    }

    private int replaceInvalidLocants(Structure struc, boolean rec) {
        int i;
        Locant locant;
        if (rec && struc.getParent() == null) {
            throw new NameImportException("Invalid numbering.");
        }
        if (struc.getParent() instanceof HeteroAtom) {
            throw new NameImportException("Name cannot be recognized.");
        }
        if (struc == null || struc instanceof HeteroAtom || !struc.hasLocant() || struc instanceof SimpleStructure && ((SimpleStructure)struc).getValue().length() == 0) {
            return 0;
        }
        if (struc.getParent() == null) {
            this.multiRadicalCheck(struc, rec);
            return 0;
        }
        if (struc.getLocantInParent().size() > 1) {
            return 0;
        }
        HashSet<String> exceptions = new HashSet<String>();
        exceptions.add("carbonyl");
        exceptions.add("sulfinyl");
        exceptions.add("sulfonyl");
        Structure parentStruc = struc.getParent();
        String name = parentStruc instanceof SimpleStructure ? ((SimpleStructure)parentStruc).getName() : "";
        Locant locant2 = locant = struc.hasLocant() ? struc.getLocantInParent().getLocant(0) : null;
        if (struc instanceof SimpleStructure && parentStruc instanceof SimpleStructure && Util.atomCount(((SimpleStructure)struc).getValue()) == 1) {
            int count = struc.hydroCount();
            for (i = 0; i < count; ++i) {
                parentStruc.addHydro(struc.getHydro(0));
                struc.removeHydro(0);
                this.changed = true;
            }
        }
        if ((!this.hasLocant(parentStruc, locant) || exceptions.contains(name)) && this.spaceCheck(struc, parentStruc)) {
            ArrayList<Structure> cloneStructures = new ArrayList<Structure>();
            cloneStructures.add(struc);
            for (i = parentStruc.indexOf(struc) + 1; i < parentStruc.substituentCount() && parentStruc.getSubstituent(i).getCloneOf() != null && parentStruc.getSubstituent(i).isCloneOf(struc); ++i) {
                cloneStructures.add(parentStruc.getSubstituent(i));
            }
            return this.replaceLocantOrSubstituent(cloneStructures, parentStruc, exceptions);
        }
        if (InvalidLocantChecker.isRadicalNumbering(parentStruc, struc, locant, name)) {
            Suffix s = SuffixFactory.createSuffix("|", "yl", struc.getLocantInParent(), 1, 2);
            struc.addSuffix(s);
            struc.setLocantInParent((LocantList)null);
            this.changed = true;
        }
        return 0;
    }

    private boolean spaceCheck(Structure child, Structure parent) {
        if (!child.isSpaceSeparated()) {
            return true;
        }
        int index = parent.indexOf(child);
        if (index < 1) {
            return true;
        }
        Structure childBefore = parent.getSubstituent(index);
        return !childBefore.isSpaceSeparated();
    }

    private boolean hasLocant(Structure struc, Locant locant) {
        if (!struc.isRoot() && "oxy".equals(struc.getName())) {
            return false;
        }
        if (struc.hasLocant(locant)) {
            return true;
        }
        if (locant.isGreekLetter()) {
            int numbering = Util.greekLetterToNumbering(locant.getValue());
            return struc.hasLocant(new SimpleLocant(numbering, locant.getParent()));
        }
        return false;
    }

    private static boolean isRadicalNumbering(Structure parent, Structure child, Locant locant, String parentName) {
        if (child.isSpaceSeparated()) {
            return !parent.hasLocant(locant) && child.getFirstRadicalSuffixIndex() > -1;
        }
        if (parent.substituentCount() != 1) {
            return false;
        }
        if (!(locant instanceof SimpleLocant)) {
            return false;
        }
        if (parentName.indexOf("acet") < 0) {
            return false;
        }
        if (child instanceof SimpleStructure && child.getName().endsWith("oxy")) {
            return false;
        }
        if (child.isRoot || !(child instanceof SimpleStructure) || !child.hasLocant(locant) || child.getLocantInParent().size() != 1) {
            return false;
        }
        return parent.getFirstRadicalSuffixIndex() < 0;
    }

    private void multiRadicalCheck(Structure struc, boolean rec) {
        int i;
        if (rec || struc.getParent() != null) {
            return;
        }
        LocantList locant = struc.getLocantInParent();
        if (locant == null || locant.size() != struc.substituentCount()) {
            return;
        }
        if (struc instanceof SimpleStructure && ((SimpleStructure)struc).getType() == 1) {
            return;
        }
        for (i = 0; i < struc.substituentCount(); ++i) {
            Locant l = locant.getLocant(i);
            int parent = l.getParent();
            l.setParent(0);
            if (struc.getSubstituent(i).hasLocant() || !struc.getSubstituent(i).hasLocant(l)) {
                return;
            }
            l.setParent(parent);
        }
        struc.setLocantInParent((LocantList)null);
        for (i = 0; i < struc.substituentCount(); ++i) {
            LocantList list = new LocantList();
            list.tryAddLocant(locant.getLocant(i));
            Suffix s = SuffixFactory.createSuffix("|", "yl", list, 1, 2);
            struc.getSubstituent(i).addSuffix(s);
            this.changed = true;
        }
    }

    private int replaceLocantOrSubstituent(ArrayList<Structure> cloneStructures, Structure parentStruc, HashSet<String> exceptions) {
        boolean isFirstLigand;
        boolean monoAtomicChain;
        Structure struc = cloneStructures.get(0);
        Structure grandparent = parentStruc.getParent();
        Locant loc = struc.getLocantInParent().getLocant(0);
        boolean canBeSingle = ParserUtil.isMonoAtomicChain(parentStruc, exceptions) || this.singleAtoms.containsKey(parentStruc);
        boolean bl = monoAtomicChain = canBeSingle && cloneStructures.size() == 1;
        if (canBeSingle) {
            this.singleAtoms.put(parentStruc, true);
        }
        boolean monoAtomicParent = canBeSingle && (!(loc instanceof AzaLocant) || !ParserUtil.isAmide(grandparent, true));
        boolean bl2 = isFirstLigand = cloneStructures.get(0) == parentStruc.getSubstituent(0);
        if (!monoAtomicChain && grandparent != null && this.isOxy(parentStruc) && isFirstLigand) {
            for (int i = 0; i < cloneStructures.size() - 1; ++i) {
                Structure ligand = cloneStructures.get(i);
                parentStruc.removeSubstituent(ligand);
                Structure clone = parentStruc.cloneStructure();
                clone.clearSubstituentList();
                clone.addSubstituent(ligand);
                parentStruc.removeSubstituent(ligand);
                clone.setLocantInParent(ligand.getLocantInParent());
                ligand.setLocantInParent(new LocantList());
                grandparent.addSubstituent(clone);
                this.changed = true;
            }
            Structure ligand = cloneStructures.get(cloneStructures.size() - 1);
            parentStruc.setLocantInParent(ligand.getLocantInParent());
            ligand.setLocantInParent(new LocantList());
            return 0;
        }
        if (!monoAtomicParent && cloneStructures.size() > 1 && grandparent != null) {
            for (int i = 0; i < cloneStructures.size(); ++i) {
                parentStruc.removeSubstituent(cloneStructures.get(i));
                grandparent.addSubstituent(cloneStructures.get(i));
                this.changed = true;
            }
            return -cloneStructures.size();
        }
        if (this.isOrthoMetaParaLigands(struc, parentStruc, monoAtomicParent, exceptions)) {
            parentStruc.removeSubstituent(struc);
            grandparent.addSubstituent(struc);
            this.changed = true;
            return -1;
        }
        if (parentStruc.getLocantInParent() != null) {
            int val = this.checkOxyGroupWithMultipliedLigands(struc, parentStruc, grandparent);
            if (val != 0) {
                this.changed = true;
                return val;
            }
            if (grandparent != null) {
                grandparent.addSubstituent(struc);
                parentStruc.removeSubstituent(struc);
                this.changed = true;
                return -1;
            }
        } else {
            if (monoAtomicParent && parentStruc.substituentCount() > 1 && !parentStruc.getSubstituent(0).equals(struc) && !ParserUtil.isSameStructure(parentStruc.getSubstituent(0), struc)) {
                Structure newparent = parentStruc.getSubstituent(0);
                newparent.addSubstituent(struc);
                parentStruc.removeSubstituent(struc);
                this.changed = true;
                return -1;
            }
            if (grandparent == null && ParserUtil.canHasRadical(struc, loc)) {
                struc.addSuffix(SuffixFactory.createSuffix("|", "yl", struc.getLocantInParent(), 1, 2));
                LocantList l = null;
                struc.setLocantInParent(l);
                this.changed = true;
            } else {
                int index;
                if (struc.hasLocant(loc) && !struc.isRoot() && (index = struc.indexOfUnLocantedSuffix()) > -1) {
                    struc.getSuffix(index).addLocant(loc);
                    LocantList l = null;
                    struc.setLocantInParent(l);
                    this.changed = true;
                    return 0;
                }
                parentStruc.setLocantInParent(struc.getLocantInParent());
                LocantList l = null;
                struc.setLocantInParent(l);
                return this.replaceInvalidLocants(parentStruc, true);
            }
        }
        return 0;
    }

    private boolean isOxy(Structure struc) {
        return "oxy".equals(struc.getName());
    }

    private boolean isOrthoMetaParaLigands(Structure struc, Structure parentStruc, boolean isMonoAtomicParent, HashSet<String> exceptions) {
        if (!(struc instanceof SimpleStructure) || !(parentStruc instanceof SimpleStructure)) {
            return false;
        }
        return (isMonoAtomicParent &= !exceptions.contains(parentStruc.getName())) && struc.getLocantInParent().isOrthoMetaPara() && ParserUtil.isMonoAtomicChain(struc, exceptions) && !parentStruc.getName().startsWith("ox") && !this.hasSignificantSuffix(parentStruc.getParent());
    }

    private boolean hasSignificantSuffix(Structure struc) {
        if (struc == null) {
            return false;
        }
        if (struc.getParent() != null) {
            return true;
        }
        if (struc.getName() != null && (struc.getName().endsWith("yl") || struc.getName().endsWith("acid"))) {
            return true;
        }
        for (int i = 0; i < struc.suffixCount(); ++i) {
            Suffix s = struc.getSuffix(i);
            if (s.getType() == 2) {
                return true;
            }
            if (s.getValue().length() <= 0 || s.getValue().equals("=") || s.getValue().equals("#")) continue;
            return true;
        }
        return false;
    }

    private int checkOxyGroupWithMultipliedLigands(Structure struc, Structure parentStruc, Structure grandParent) {
        Structure ss;
        if (parentStruc instanceof SimpleStructure && ((SimpleStructure)parentStruc).getName().equals("oxy") && grandParent != null && struc.isCloneOf(ss = parentStruc.getSubstituent(0))) {
            SimpleStructure oxy = new SimpleStructure("O", "oxy");
            ((Structure)oxy).addSubstituent(struc);
            parentStruc.removeSubstituent(struc);
            oxy.setLocantInParent(struc.getLocantInParent());
            struc.setLocantInParent(new LocantList());
            grandParent.addSubstituent(oxy);
            return -1;
        }
        return 0;
    }
}

