/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.AzaLocant;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;

public class MultiAmineChecker
implements Refactoring<Structure> {
    @Override
    public boolean checkTree(Structure root) {
        boolean changed = false;
        Suffix amineEnding = this.getAmineEnding(root);
        if (amineEnding == null) {
            return false;
        }
        int mul = this.getMaxPrimeCountOfAmineLocant(root);
        if (mul > amineEnding.getMultiplicity()) {
            if (amineEnding.getType() == 1) {
                amineEnding.setMultiplicity(mul);
            } else {
                amineEnding.setValue(this.incAmine(amineEnding.getValue(), mul - 1));
            }
            changed = true;
        }
        for (Structure node : root.getSubstituentList()) {
            changed |= this.checkTree(node);
        }
        return changed;
    }

    private Suffix getAmineEnding(Structure struc) {
        for (Suffix suffix : struc.getSuffixList()) {
            if (suffix.getType() != 1 && suffix.getType() != 5) continue;
            return suffix;
        }
        return null;
    }

    private int getMaxPrimeCountOfAmineLocant(Structure struc) {
        int max = -1;
        for (Structure node : struc.getSubstituentList()) {
            if (!node.hasLocant() || !(node.getLocantInParent().getLocant(0) instanceof AzaLocant)) continue;
            max = Math.max(max, node.getLocantInParent().getMaxParentIndex());
        }
        return max + 1;
    }

    private String incAmine(String value, int mul) {
        String[] arr = value.split(" ");
        StringBuffer val = new StringBuffer(arr[0].substring(0, 1));
        StringBuffer num = new StringBuffer(arr[1].substring(0, arr[1].indexOf(59)));
        String numend = arr[1].substring(arr[1].indexOf(59));
        mul -= this.matchCount(arr[0], 'N') - 1;
        int loc = 99;
        for (int i = 0; i < mul; ++i) {
            val.append("(N)");
            num.append(";" + loc++);
        }
        return val + arr[0].substring(1) + " " + num + numend;
    }

    private int matchCount(String str, char sample) {
        int count = 0;
        char[] arr = str.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != sample || i != arr.length - 1 && Character.isLowerCase(arr[i + 1])) continue;
            ++count;
        }
        return count;
    }
}

