/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AzaLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StereoNumber;
import chemaxon.marvin.io.formats.name.nameimport.parse.ParserUtil;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import java.util.HashMap;

public class NLocantChecker
implements Refactoring<Structure> {
    @Override
    public boolean checkTree(Structure root) {
        if (root == null) {
            return false;
        }
        boolean changed = false;
        changed |= NLocantChecker.addLigandToAmineChild(root);
        changed |= NLocantChecker.addLigandToAmineParent(root);
        changed |= NLocantChecker.removeLigandFromAmin(root);
        changed |= NLocantChecker.replaceAtomLocants(root);
        return changed |= NLocantChecker.replaceStereoLocant(root);
    }

    private static boolean addLigandToAmineChild(Structure struc) {
        boolean changed = false;
        if (!ParserUtil.isAmide(struc) && !ParserUtil.isBenzAmide(struc)) {
            HashMap<Integer, Structure> amines = new HashMap<Integer, Structure>();
            int firstIndex = -1;
            for (int i = 0; i < struc.substituentCount(); ++i) {
                Locant loc;
                Structure s = struc.getSubstituent(i);
                Locant locant = loc = s.getLocantInParent() != null ? s.getLocantInParent().getLocant(0) : null;
                if (ParserUtil.isAmide(s) || ParserUtil.isBenzAmide(s)) {
                    Integer index = s.getLocantInParent() == null ? new Integer(amines.size()) : new Integer(s.getLocantInParent().getLocant(0).getValue());
                    amines.put(index, s);
                    if (firstIndex >= 0) continue;
                    firstIndex = index;
                    continue;
                }
                if (!(loc instanceof AzaLocant) || amines.isEmpty()) continue;
                Integer azaIndex = new Integer(((AzaLocant)loc).getParent());
                Structure amine = (Structure)amines.get(azaIndex);
                if (amine == null) {
                    amine = (Structure)amines.get(new Integer(firstIndex));
                }
                if (amine == null) continue;
                struc.removeSubstituent(i);
                amine.addSubstituent(s);
                --i;
                changed = true;
            }
        }
        return changed;
    }

    private static boolean addLigandToAmineParent(Structure struc) {
        boolean changed = false;
        if (!struc.isRoot && ParserUtil.isAmide(struc.getParent()) && !ParserUtil.isAmide(struc)) {
            int i = 0;
            while (i < struc.substituentCount()) {
                Structure s = struc.getSubstituent(i);
                if (s.getLocantInParent() != null && s.getLocantInParent().getLocant(0) instanceof AzaLocant) {
                    struc.removeSubstituent(i);
                    struc.getParent().addSubstituent(s);
                    changed = true;
                } else {
                    ++i;
                }
                changed |= NLocantChecker.addLigandToAmineParent(s);
            }
        } else {
            for (int i = 0; i < struc.substituentCount(); ++i) {
                Structure s = struc.getSubstituent(i);
                changed |= NLocantChecker.addLigandToAmineParent(s);
            }
        }
        return changed;
    }

    private static boolean removeLigandFromAmin(Structure struc) {
        String name = struc instanceof SimpleStructure ? ((SimpleStructure)struc).getName() : null;
        boolean changed = false;
        if (ParserUtil.isAmide(struc, false) && struc.substituentCount() > 0 && (name == null || name.indexOf("acet") < 0 && name.indexOf("acryl") < 0)) {
            Structure parent = struc.getSubstituent(0);
            for (int i = 1; i < struc.substituentCount(); ++i) {
                Structure s = struc.getSubstituent(i);
                if (s.hasLocant() && struc.hasLocant(s.getLocantInParent().getLocant(0))) continue;
                if (ParserUtil.isSameStructure(parent, s) && !NLocantChecker.isPhenyl(s)) break;
                if (!s.hasLocant() || s.getLocantInParent().getLocant(0) instanceof AzaLocant) continue;
                struc.removeSubstituent(i--);
                parent.addSubstituent(s);
                if (parent.substituentCount() == 0) {
                    ++i;
                }
                changed = true;
            }
        }
        return changed;
    }

    private static boolean isPhenyl(Structure struc) {
        if (!(struc instanceof SimpleStructure)) {
            return false;
        }
        return ((SimpleStructure)struc).getName().equals("phen");
    }

    private static boolean replaceAtomLocants(Structure struc) {
        Structure parent;
        boolean changed = false;
        boolean hasAtomLocant = true;
        if (struc == null || struc.getParent() == null || struc.getLocantInParent() == null || !(struc.getLocantInParent().getLocant(0) instanceof AtomLocant) || struc.getLocantInParent().getLocant(0) instanceof AzaLocant) {
            hasAtomLocant = false;
        }
        AtomLocant loc = hasAtomLocant ? (AtomLocant)struc.getLocantInParent().getLocant(0) : null;
        Structure parentStruc = hasAtomLocant ? struc.getParent() : null;
        Structure structure = parent = hasAtomLocant ? struc.getParent().getParent() : null;
        if (hasAtomLocant && parent != null && !parentStruc.hasAtom(loc.toString())) {
            parentStruc.removeSubstituent(struc);
            parent.addSubstituent(struc);
            changed = true;
        } else {
            if (hasAtomLocant && parent == null && !parentStruc.hasAtom(loc.getAtomSymbol(), true)) {
                throw new NameImportException("Invalid numbering: " + loc.toString());
            }
            for (int i = 0; i < struc.substituentCount(); ++i) {
                changed |= NLocantChecker.replaceAtomLocants(struc.getSubstituent(i));
            }
        }
        return changed;
    }

    private static boolean replaceStereoLocant(Structure struc) {
        int i;
        boolean changed = false;
        for (i = 0; i < struc.getStereoLocants().size(); ++i) {
            StereoNumber sn = (StereoNumber)struc.getStereoLocants().getLocant(i);
            if (!(sn.getLocant() instanceof AzaLocant) || ParserUtil.isAmide(struc) || !ParserUtil.isAmide(struc.getParent())) continue;
            struc.getParent().addStereoLocant(sn);
            struc.getStereoLocants().removeLocant(i--);
            changed = true;
        }
        for (i = 0; i < struc.substituentCount(); ++i) {
            changed |= NLocantChecker.replaceStereoLocant(struc.getSubstituent(i));
        }
        return changed;
    }
}

