/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SaltEnding;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;

public class NumberingChecker
implements Refactoring<Structure> {
    @Override
    public boolean checkTree(Structure root) {
        if (root == null) {
            return false;
        }
        boolean changed = false;
        if (root.suffixCount() > 0 && root.getSuffix(0).getValue().equals("")) {
            root.removeSuffix(0);
            changed = true;
        }
        if (root.getLocantInParent() != null && NumberingChecker.canReplaceLocant(root)) {
            LocantList dummy;
            LocantList locant;
            if (root.getParent() == null) {
                locant = root.getLocantInParent();
                root.getSuffix(0).setLocant(locant);
                dummy = null;
                root.setLocantInParent(dummy);
                changed = true;
            } else if (root.isSpaceSeparated() && root.getSuffix(0).getType() != 2) {
                locant = root.getLocantInParent();
                root.getSuffix(0).setLocant(locant);
                dummy = null;
                root.setLocantInParent(dummy);
                changed = true;
            }
        }
        changed |= NumberingChecker.searchLocantsForStructureDerivatedSuffixes(root);
        for (int i = 0; i < root.substituentCount(); ++i) {
            if (!root.getSubstituent(i).isSpaceSeparated()) continue;
            changed |= this.checkTree(root.getSubstituent(i));
        }
        return changed;
    }

    private static boolean canReplaceLocant(Structure root) {
        while (root.suffixCount() > 0 && root.getSuffix(0).getValue().length() == 0) {
            root.removeSuffix(0);
        }
        Suffix suff = !root.getSuffixList().isEmpty() ? root.getSuffix(0) : null;
        Suffix suff2 = root.getSuffixList().size() > 1 ? root.getSuffix(1) : null;
        return !root.getSuffixList().isEmpty() && !suff.hasLocant() && suff.getMultiplicity() == root.getLocantInParent().size() && !suff.getValue().equals("[O-]") && suff.getValue().indexOf("+") < 0 && suff.getType() != 3 && (suff.getType() != 2 || !(suff2 instanceof SaltEnding));
    }

    static boolean searchLocantsForStructureDerivatedSuffixes(Structure struc) {
        int i;
        int index = struc.getFirstRadicalSuffixIndex();
        if (index < 0) {
            return false;
        }
        Suffix radical = struc.getSuffix(index);
        if (!radical.hasLocant()) {
            return false;
        }
        IntVector strucDerivedSuffixes = new IntVector();
        for (i = 0; i < struc.suffixCount(); ++i) {
            if (struc.getSuffix(i).getStructure() == null) continue;
            strucDerivedSuffixes.add(i);
        }
        if (radical.getLocant().size() == strucDerivedSuffixes.size()) {
            for (i = 0; i < strucDerivedSuffixes.size(); ++i) {
                struc.getSuffix(strucDerivedSuffixes.get(i)).addLocant(radical.getLocant().getLocant(i));
            }
            struc.removeSuffix(radical);
            return true;
        }
        return false;
    }
}

