/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.BracketToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.EndingToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Hydro;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Number;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Separator;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SpecialGroup;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StereoNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StructureToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.IUPACParser;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Amine;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HantzschWidmanSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroAtom;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SaltEnding;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;
import chemaxon.struc.MolAtom;
import java.util.ArrayList;
import java.util.HashSet;

public class ParserUtil {
    public static final String HantschWidmanEnding = "[HWE]";
    private static final IntVector SixCAtoms = new IntVector(new int[]{9, 17, 35, 53, 7, 15, 33, 51, 13, 31, 49, 81});

    static boolean isMonoAtomicChain(Structure struc, HashSet<String> exceptions) {
        if (struc == null) {
            return false;
        }
        if (!(struc instanceof SimpleStructure)) {
            return false;
        }
        SimpleStructure ss = (SimpleStructure)struc;
        boolean oneAtom = Util.atomCount(ss.getValue()) == 1;
        boolean isEx = exceptions.contains(ss.getName());
        boolean checkParent = ss.getParent() == null || ss.getParent().substituentCount() == 1;
        return (oneAtom || isEx) && checkParent;
    }

    static void replaceHydrogen(Structure root) {
        if (root instanceof SimpleStructure && ((SimpleStructure)root).getValue().indexOf("-") > 0) {
            return;
        }
        for (int i = 0; i < root.substituentCount(); ++i) {
            SimpleStructure sbefore;
            ParserUtil.replaceHydrogen(root.getSubstituent(i));
            SimpleStructure s = root.getSubstituent(i) instanceof SimpleStructure ? (SimpleStructure)root.getSubstituent(i) : null;
            SimpleStructure simpleStructure = sbefore = i > 0 && root.getSubstituent(i - 1) instanceof SimpleStructure ? (SimpleStructure)root.getSubstituent(i - 1) : null;
            if (s == null || !s.getValue().equals("[H+]") || sbefore == null || sbefore.getValue().indexOf("-") <= 0) continue;
            sbefore.addSubstituent(s);
            root.removeSubstituent(i);
            --i;
        }
    }

    static int getBaseSuffixIndex(Structure struc) {
        ArrayList<Suffix> list = struc.getSuffixList();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getType() == 0 && list.get(i).getRadical() > 0) {
                return i;
            }
            if (!(list.get(i) instanceof SaltEnding) || !((SaltEnding)list.get(i)).getAtom().equals("S")) continue;
            return i;
        }
        return -1;
    }

    static boolean isAmide(Structure struc) {
        return ParserUtil.isAmide(struc, true);
    }

    public static boolean isAmide(Structure struc, boolean withSuffixes) {
        if (struc instanceof Amine) {
            return true;
        }
        boolean amide = false;
        if (struc instanceof SimpleStructure) {
            String name = ((SimpleStructure)struc).getName();
            amide = name.indexOf("amid") > -1 || name.startsWith("imid") || name.indexOf("amin") > -1 || name.indexOf("imin") > -1 || name.indexOf("hydrazid") > -1;
            amide &= !ParserUtil.containsRing((SimpleStructure)struc);
        } else if (!withSuffixes || struc == null) {
            return false;
        }
        return withSuffixes ? amide || ParserUtil.hasAmideSuffix(struc) : amide;
    }

    private static boolean hasAmideSuffix(Structure struc) {
        for (int i = 0; i < struc.suffixCount(); ++i) {
            Suffix suf = struc.getSuffix(i);
            if (suf.getType() != 1 && suf.getType() != 5) continue;
            return true;
        }
        return false;
    }

    static boolean isBenzAmide(Structure struc) {
        if (struc instanceof SimpleStructure) {
            return ((SimpleStructure)struc).getName().indexOf("benzamid") > -1;
        }
        return false;
    }

    private static boolean containsRing(SimpleStructure struc) {
        String smi = struc.getValue();
        int index = smi.indexOf(49, 0);
        while (index > -1 && index < smi.length()) {
            if (index > -1 && smi.indexOf(":1") != index - 1 && (smi.indexOf("|$") <= 0 || smi.indexOf("|$") >= index)) {
                return true;
            }
            index = smi.indexOf(49, index + 1);
        }
        return false;
    }

    static boolean canHasRadical(Structure s, Locant l) {
        if (!s.hasLocant(l)) {
            return false;
        }
        if (s.hasConnectionPoint()) {
            return true;
        }
        int index = ParserUtil.getRadical(s);
        if (index < 0) {
            return s.suffixCount() == 0;
        }
        return index > -1 && index < 99 && !s.getSuffix(index).hasLocant();
    }

    static int getRadical(Structure s) {
        if (s == null) {
            return -1;
        }
        if (s instanceof SimpleStructure && ((SimpleStructure)s).getName().endsWith("o")) {
            return 99;
        }
        for (int i = 0; i < s.suffixCount(); ++i) {
            if (s.getSuffix(i).getValue().indexOf("|") <= -1) continue;
            return i;
        }
        return -1;
    }

    static boolean canBeStereo(Structure struc, LocantList locants) {
        if (struc instanceof SimpleStructure) {
            SimpleStructure ss = (SimpleStructure)struc;
            int atomcount = ss.getAtomCount();
            for (int i = 0; i < locants.size(); ++i) {
                if (locants.getLocant(i).getValue() <= atomcount) continue;
                return false;
            }
            return !ss.getName().equals("oxy");
        }
        return !(struc instanceof HeteroAtom);
    }

    static boolean suffixCanBeParent(String name) {
        return name.endsWith("acid") || name.indexOf("amin") > -1 || name.indexOf("imin") > -1 || name.indexOf("imid") > -1 || name.indexOf("amid") > -1 || name.endsWith("nitrile") || name.endsWith("ate") || name.endsWith("aldehyde") || name.endsWith("peroxol");
    }

    static int getFusedLocantIndex(ArrayList<Token> tokenList, int index) {
        for (int i = index - 1; i > 0; --i) {
            Token token = tokenList.get(i);
            if (token instanceof LocantList && token.getType() == 5) {
                return i;
            }
            if (!(token instanceof Separator) || token.getType() != 2) continue;
            return -1;
        }
        return -1;
    }

    static int getDashOrBracerIndex(ArrayList<Token> tokenList, int index) {
        for (int i = index - 1; i > -1; --i) {
            Token pretoken;
            Token token = tokenList.get(i);
            Token token2 = pretoken = i > 0 ? tokenList.get(i - 1) : null;
            if (token instanceof BracketToken) {
                if (Util.isNumbering(token)) {
                    return i - 1;
                }
                return i;
            }
            if (token instanceof Separator && !(pretoken instanceof LocantList)) {
                return i;
            }
            if (token.getName().indexOf("yl") <= -1 && !(token instanceof Hydro)) continue;
            return i;
        }
        return -1;
    }

    static boolean isRingSystemWithdoubleBond(ArrayList<Token> tokenlist, int index) {
        if (index < 0 || !(tokenlist.get(index) instanceof StructureToken)) {
            return false;
        }
        StructureToken token = (StructureToken)tokenlist.get(index);
        return ((Token)token).getValue().indexOf("DoubleBond") > 0;
    }

    static boolean isStructureNamedAs(ArrayList<Token> tokenlist, int index, String name) {
        Token token;
        Token token2 = token = index > -1 && index < tokenlist.size() ? tokenlist.get(index) : null;
        if (!(token instanceof StructureToken)) {
            return false;
        }
        return token.getName().indexOf(name) > -1;
    }

    static boolean isRingSystemWithHeteroAtom(ArrayList<Token> tokenlist, int index) {
        if (index < 0 || !(tokenlist.get(index) instanceof StructureToken)) {
            return false;
        }
        StructureToken token = (StructureToken)tokenlist.get(index);
        return ((Token)token).getValue().indexOf("AtomsToReplace") > 0;
    }

    static boolean isRingSystemWithSubstituent(ArrayList<Token> tokenlist, int index) {
        if (index < 0 || !(tokenlist.get(index) instanceof StructureToken)) {
            return false;
        }
        StructureToken token = (StructureToken)tokenlist.get(index);
        return ((Token)token).getValue().indexOf("Substituent") > 0;
    }

    static int isHantzschWidmanSystem(ArrayList<Token> tokenList, int index) {
        boolean suffix;
        if (index < 0) {
            return -1;
        }
        boolean base = tokenList.get(index) instanceof StructureToken && Util.heteroAtom(tokenList.get(index).getValue()) && !tokenList.get(index).getName().endsWith("an");
        boolean bl = suffix = index < tokenList.size() - 1 && tokenList.get(index + 1) instanceof EndingToken && HantzschWidmanSystem.isHantzschWidmanSuffix((EndingToken)tokenList.get(index + 1));
        if (base && suffix) {
            boolean bl2 = suffix = !((EndingToken)tokenList.get(index + 1)).equalsName("ane") || ParserUtil.isVIAAtom(tokenList.get(index).getValue());
        }
        if (base && suffix) {
            int len = 0;
            Token t = tokenList.get(index);
            while (index - len > -1 && (ParserUtil.heteroAtom(t) || t instanceof Number && t.getType() != 2)) {
                if (index - ++len <= -1) continue;
                t = tokenList.get(index - len);
            }
            if (index - len > -1 && t instanceof BracketToken) {
                if ((t = ((BracketToken)t).toNumbering()) != null && !(((LocantList)t).getLocant(0) instanceof StereoNumber)) {
                    ++len;
                }
            } else if (index - len > 0 && t instanceof Separator && (t = tokenList.get(index - len - 1)) instanceof LocantList && !(((LocantList)t).getLocant(0) instanceof StereoNumber)) {
                len += 2;
            }
            return len - 1;
        }
        return -1;
    }

    static boolean heteroAtom(Token t) {
        if (!(t instanceof StructureToken)) {
            return false;
        }
        HashSet<String> exceptions = new HashSet<String>();
        exceptions.add("amino");
        exceptions.add("iodo");
        exceptions.add("bromo");
        exceptions.add("oxy");
        exceptions.add("hydroxy");
        exceptions.add("mercapto");
        exceptions.add("chloro");
        if (exceptions.contains(t.getName())) {
            return false;
        }
        String value = t.getValue();
        if (value.endsWith("|")) {
            value = value.substring(0, value.length() - 1);
        }
        return Util.heteroAtom(value);
    }

    static int isBenzoFusedComponent(ArrayList<Token> tokenList, int index) {
        if (index <= 0 || !ParserUtil.canBeBenzoFusedRing(tokenList, index)) {
            return -1;
        }
        int len = -1;
        int heteroAtomCount = 1;
        boolean bo = false;
        int i = index - 1;
        Token token = tokenList.get(i);
        while (i > -1 && (bo || i == index - 1) && !IUPACParser.isBenzo(token.getName())) {
            boolean bl = bo = token instanceof StructureToken && Util.heteroAtom(token.getValue()) || token instanceof Number && token.getType() != 2;
            if (--i < 0) break;
            token = tokenList.get(i);
            ++heteroAtomCount;
        }
        boolean bl = bo = bo && i > -1 || i == index - 1 && i > -1 && IUPACParser.isBenzo(token.getName()) && (index == tokenList.size() - 1 || !(tokenList.get(index + 1) instanceof SpecialGroup));
        if (bo && i > 1 && tokenList.get(i - 2) instanceof LocantList && ((LocantList)tokenList.get(i - 2)).size() >= heteroAtomCount) {
            i -= 2;
        } else if (bo && i > 0 && (token = tokenList.get(i - 1)) instanceof BracketToken && ((BracketToken)token).toNumbering() != null) {
            --i;
        }
        if (bo) {
            len = index - i;
        }
        return len;
    }

    static boolean canBeBenzoFusedRing(ArrayList<Token> tokenList, int index) {
        Token ending;
        Token basic = index > 0 && index < tokenList.size() ? tokenList.get(index) : null;
        Token token = ending = index > 0 && index < tokenList.size() - 1 ? tokenList.get(index + 1) : null;
        if (!(basic instanceof StructureToken) || !(ending instanceof EndingToken)) {
            return false;
        }
        String name = ending.getName();
        boolean hasEnding = IUPACParser.isIne(name) || IUPACParser.isOle(name) || IUPACParser.isEpine(name) || IUPACParser.isYl(name);
        Token t = tokenList.get(index + 1);
        boolean hasIncludedEnding = index < tokenList.size() - 1 && (t.getName().endsWith("ol") || t.getName().endsWith("ole")) && Util.heteroAtom(t.getValue());
        return Util.heteroAtom(basic.getValue()) && !basic.getName().equals("oxy") && (hasEnding || hasIncludedEnding);
    }

    static int isPhenoIneComponent(ArrayList<Token> tokenList, int index) {
        if (index <= 0) {
            return -1;
        }
        boolean b = Util.heteroAtom(tokenList.get(index).getValue()) && index < tokenList.size() - 1 && IUPACParser.isIne(tokenList.get(index + 1).getName()) || tokenList.get(index).getName().endsWith("ine") || tokenList.get(index).getName().endsWith("in");
        boolean b1 = index > 0 && b && (IUPACParser.isPhenox(tokenList.get(index - 1).getName()) || IUPACParser.isPhenArs(tokenList.get(index - 1).getName()));
        boolean b2 = index > 1 && b && !b1 && tokenList.get(index - 1) instanceof Number && tokenList.get(index - 1).getType() != 2 && tokenList.get(index - 2).getName().equalsIgnoreCase("pheno");
        boolean b3 = index > 1 && b && !b1 && !b2 && Util.heteroAtom(tokenList.get(index - 1).getValue()) && tokenList.get(index - 2).getName().equalsIgnoreCase("pheno");
        int len = -1;
        if (b1) {
            len = 1;
        }
        if (b2 || b3) {
            len = 2;
        }
        return len;
    }

    static boolean endingFits(String ending, String name) {
        return name.endsWith(ending) || name.endsWith(ending.substring(0, ending.length() - 1));
    }

    static boolean isHeteroEnding(Token token) {
        if (!(token instanceof EndingToken)) {
            return false;
        }
        EndingToken ending = (EndingToken)token;
        return ending.equalsName("ane") || !HantzschWidmanSystem.isHantzschWidmanSuffix(ending);
    }

    static boolean isHeteroChainAtom(Token token) {
        return token instanceof StructureToken && token.getValue() != null && Util.heteroAtom(token.getValue()) && ParserUtil.canBeHeteroChainAtom(token.getName());
    }

    static boolean canBeHeteroChainAtom(String name) {
        return !name.endsWith("oxy") && !name.endsWith("a") && name.indexOf("amin") < 0 && !name.startsWith("oxidan") && !name.startsWith("plumb") && !name.startsWith("oxido") && !name.startsWith("chlor") && !name.startsWith("astat") && !name.startsWith("fluor") && !name.startsWith("bromo") && !name.startsWith("mangan") && !name.startsWith("nickel");
    }

    static boolean isVIAAtom(String smiles) {
        return Util.atomCount(smiles) == 1 && smiles.matches("^.*(O|S|Se|Te|Po).*$") && !smiles.matches("^.*(Si|Sm|Sb|Sc|Sr|Sn|Sg).*$");
    }

    static void addLocantsToMultiRoot(Structure root, ArrayList<Suffix> multiParentSuffixes) {
        int i;
        Suffix s;
        int locantcount;
        int n = locantcount = root.hasLocant() ? root.getLocantInParent().size() : 0;
        if (locantcount == 0 || multiParentSuffixes.isEmpty()) {
            return;
        }
        if (locantcount > 1 && multiParentSuffixes.size() >= locantcount) {
            for (int i2 = 0; i2 < multiParentSuffixes.size(); ++i2) {
                Locant l = root.getLocantInParent().getLocant(i2);
                l.setParent(0);
                Suffix radical = SuffixFactory.createSuffix("|", "yl", l, 1, 2);
                multiParentSuffixes.get(i2).getStructure().addSuffix(radical);
            }
            root.setLocantInParent((LocantList)null);
        }
        if ((s = root.getSuffix(0)) == null) {
            return;
        }
        ArrayList<Structure> multiParents = new ArrayList<Structure>();
        boolean directParent = multiParentSuffixes.get(0).getStructure().getParent() == root;
        for (i = 0; i < multiParentSuffixes.size(); ++i) {
            Structure suffix = multiParentSuffixes.get(i).getStructure();
            multiParents.add(directParent ? suffix : suffix.getParent());
        }
        if (s.getType() == 2 || s.getName().equals("ylen")) {
            if (s.hasLocant()) {
                for (i = 0; i < multiParents.size(); ++i) {
                    int index = i % s.getLocant().size();
                    Locant l = s.getLocant().getLocant(index);
                    if (!root.hasLocant(l)) {
                        l.setParent(0);
                    }
                    ((Structure)multiParents.get(i)).setLocantInParent(l);
                    if (!directParent) continue;
                    multiParentSuffixes.get(i).setLocant(l);
                }
            }
            root.removeSuffix(s);
        }
    }

    static Suffix getFirstSuffixForLigandAddition(Structure struc, int multiplicity) {
        for (int i = 0; i < struc.suffixCount(); ++i) {
            Suffix s = struc.getSuffix(i);
            if (s.getValue().length() <= 0 && s.getType() == -1) continue;
            if (!s.hasLocant() && s.getMultiplicity() == multiplicity) {
                return s;
            }
            if (!s.hasLocant() && (s.getType() == 2 || s.getName().startsWith("ylen"))) {
                return s;
            }
            return null;
        }
        return null;
    }

    static boolean isSameStructure(Structure struc1, Structure struc2) {
        if (struc1 == null && struc2 == null) {
            return true;
        }
        if (struc1 == null || struc2 == null) {
            return false;
        }
        if (struc1.equals(struc2)) {
            return true;
        }
        if (struc1.isCloneOf(struc2) || struc2.isCloneOf(struc1)) {
            return true;
        }
        return struc1.getCloneOf() == struc2.getCloneOf() && struc1.getCloneOf() != null;
    }

    public static boolean is6CAtom(MolAtom atom) {
        return SixCAtoms.contains(atom.getAtno());
    }
}

