/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AzaLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.BracketToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.EndingToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Hydro;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.NonStdValenceLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Number;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.RingNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Separator;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StereoNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StructureToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.CarbanilideChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.CarbonicAcidChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.DLConfigChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.DisulfideChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.HantzschWidmanChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.HydrazideChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.IUPACParserCore;
import chemaxon.marvin.io.formats.name.nameimport.parse.NLocantChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.NumberingChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.ParserUtil;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.SaltChecker;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.AcetateGroup;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.AggregateStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.AminoAcid;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Anhydride;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Annulene;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.BenzoFusedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Bridge;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Ester;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Ether;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.FusedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HantzschWidmanSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroAtom;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroChain;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Hydrazone;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.MonoCyclicSpiroSytem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.MultipliedSpiroSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.MultipliedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.NucleoBase;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Oxime;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PhenoIneSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyCane;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyCyclicSpiroSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyHelicene;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyNaphthylene;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyRingSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyaLene;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyaPhene;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SaltEnding;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SecChain;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.TertChain;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.VonBaeyerSystem;
import chemaxon.naming.n2s.N2S;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RevolutionParser {
    final Rewriter[] rewriters = new Rewriter[]{new SpiroLocantsBeforeLocants(), new ComplexSpiro(), new BracketRewriter(), new Epi(), new AcidModifier(), new Tolyl(), new AcidAmide(), new Carbox(), new Methylene(), new EthyleneGlycol(), new Phosphoro(), new CasMultiplierAtEnd(), new MultiplierDash(), new OxyRewriter(), new AtomModifierRewriter(), new Disulfide(), new Hydrogen(), new DoubleLocantBeforeRewriter(), new HeteroChainRewriter(), new PhenoIne(), new HeterAnthrene(), new SpecialPolyFused(), new FusedLocantsBeforeLocants(), new BenzoFused(), new HantzschWidman(), new AnnuleneRewriter(), new Ano(), new SecTert(), new Cyclo(), new Fused(), new SimpleSpiro(), new ComplexSpiro(), new SpiroMulStruct(), new MultiplierDashRemover(), new Biphenyl(), new LocantsBeforeRewriter().pass(0), new StereoRewriter().pass(1), new HydroRewriter(), new EndingWithoutLocant(), new EndingWithLocant(), new SubstituentWithLocant(), new SubstituentWithoutLocant().pass(0), new StereoRewriter().pass(2), new ExplicitSalt(), new SaltRewriter(), new MultipliedSystemRewriter(), new ExplicitEster(), new ImplicitEsterRewriter(), new SpaceClass(), new AlcoholRewriter(), new StructureSuffixRewriter(), new SuffixWithHydro(), new Ion(), new Lambda(), new MultipliedAcid(), new NumberAsChain(), new EndingAsStructure(), new DashRemover(), new NbSpRemover(), new MonoRemover(), new MultipliedStructureAfter().pass(0), new Poly(), new ThiolBreaker(), new Benzo(), new LocantsBeforeRewriter().pass(1), new MultipliedStructure(), new DetachedSubstituent(), new DetachedSuffix(), new SpaceSubstituent(), new BracketRewriter().pass(2), new BracketedLocants(), new LocantsBeforeRewriter().pass(2), new MultipliedStructureAfter().pass(1), new SubstituentWithoutLocant().pass(1), new BracketRemover(), new SpaceClass().pass(2)};
    private Rewriter lastRewriter;
    List<Structure> components = new ArrayList<Structure>();
    static final String nbsp = "\u200b";

    public Structure parse(List<Token> tokens) {
        String initialList = tokens.toString();
        do {
            if (!IUPACParserCore.debug) continue;
            System.out.println(tokens + (this.lastRewriter == null ? "" : " <- " + this.lastRewriter.getName()));
        } while (this.rewriteOnce(tokens, false));
        Structure res = null;
        if (tokens.size() == 1 && (res = RevolutionParser.structure(tokens.get(0))) != null) {
            this.components.add(res);
        }
        if (tokens.size() >= 2 || tokens.size() == 1 && res == null) {
            throw new NameImportException.ParseException("Could not parse: " + tokens + " in " + initialList);
        }
        for (Structure s : this.components) {
            s.isRoot = true;
            if (IUPACParserCore.debug) {
                s.print();
            }
            RevolutionParser.refactor(s);
        }
        if (this.components.size() == 1) {
            return this.components.get(0);
        }
        return new AggregateStructure(this.components);
    }

    boolean rewriteOnce(List<Token> tokens, boolean insideBrackets) {
        if (tokens.isEmpty()) {
            return false;
        }
        if (tokens.get(tokens.size() - 1) instanceof StructureToken) {
            ((StructureToken)tokens.get((int)(tokens.size() - 1))).isRoot = true;
        }
        for (Rewriter w : this.rewriters) {
            if (!w.rewriteSomewhere(tokens, insideBrackets)) continue;
            ++Rewriter.applications;
            if (w.outsideComponent != null) {
                this.components.add(w.outsideComponent);
            }
            if (!(w instanceof BracketRewriter)) {
                this.lastRewriter = w;
            }
            return true;
        }
        return false;
    }

    static int parseHeteros(List<Token> tokens, int cur, ArrayList<HeteroAtom> heteros) {
        while (true) {
            if (RevolutionParser.name(tokens, cur, "imid")) {
                heteros.add(new HeteroAtom("N"));
            } else {
                int mul = RevolutionParser.multiplier(RevolutionParser.get(tokens, cur));
                if (mul == -1) {
                    mul = 1;
                } else {
                    String name = tokens.get(cur).getName();
                    if (name.endsWith("s") || name.equals("bi")) {
                        return -1;
                    }
                    ++cur;
                }
                if (RevolutionParser.get(tokens, cur) instanceof StructureToken) {
                    StructureToken atom = (StructureToken)tokens.get(cur);
                    if (!atom.isMonoAtomic() && !atom.is("azo") || atom.is("oxy") || atom.is("hydroxy") || atom.getValue().equals("C") || atom.getValue().indexOf("Radical:") != -1) {
                        return -1;
                    }
                    String name = atom.getName();
                    if (!atom.is("thio") && !atom.is("azo") && name.endsWith("o")) {
                        return -1;
                    }
                    for (int i = 0; i < mul; ++i) {
                        HeteroAtom a = new HeteroAtom(atom.is("azo") ? "N" : atom.getValue());
                        heteros.add(a);
                    }
                } else {
                    if (mul > 1) {
                        return -1;
                    }
                    return cur;
                }
            }
            ++cur;
        }
    }

    static boolean setLocants(ArrayList<HeteroAtom> heteros, LocantList locants, int ringSize) {
        if (locants != null) {
            locants = locants.expandOMP(heteros.size());
            if (heteros.size() != locants.size()) {
                return false;
            }
        } else if (heteros.size() == 2 && ringSize > 3) {
            locants = LocantList.simpleList(1, 3);
        } else if (heteros.size() == 3 && ringSize == 6) {
            locants = LocantList.simpleList(1, 3, 5);
        }
        int locant = 0;
        for (HeteroAtom a : heteros) {
            Locant locant2;
            if (locants != null) {
                locant2 = locants.getLocant(locant++);
            } else {
                ++locant;
                locant2 = new SimpleLocant(locant);
            }
            Locant l = locant2;
            a.addLocant(l);
        }
        return true;
    }

    static boolean stereo(Token t) {
        if (!(t instanceof LocantList)) {
            return false;
        }
        LocantList locants = (LocantList)t;
        if (locants.getType() != 2) {
            return false;
        }
        for (Locant l : locants.getLocantsList()) {
            if (l instanceof StereoNumber) continue;
            return false;
        }
        return true;
    }

    public void printStats() {
        for (Rewriter w : this.rewriters) {
            System.out.println(w.getName() + "\t" + Rewriter.applications + " apps");
        }
    }

    static boolean cannotBeParent(Token t) {
        String name = t.getName();
        return name.equals("epi") || name.equals("hydroxy") || name.equals("oxo") || name.equals("oxa") || name.equals("chloro") || name.equals("iodo") || name.equals("bromo") || name.equals("fluoro") || name.equals("imido") || name.equals("nitro") || name.equals("nitroso") || name.equals("cyano");
    }

    static boolean cannotHaveSuffix(Token t) {
        if (RevolutionParser.cannotBeParent(t)) {
            return true;
        }
        return t.is("oxo") || t.is("oxy");
    }

    static Token get(List<Token> tokens, int i) {
        if (i < tokens.size()) {
            return tokens.get(i);
        }
        return null;
    }

    static Structure getStructure(StructureToken st) {
        SimpleStructure res;
        if (st.wrap) {
            return st.structure;
        }
        String value = st.getValue();
        String name = st.getName();
        if (name.equals("ester") && st.substituents != null) {
            Structure acid = RevolutionParser.structure(st.substituents.remove(st.substituents.size() - 1));
            ArrayList<Structure> bases = new ArrayList<Structure>(st.substituents.size());
            for (StructureToken s : st.substituents) {
                bases.add(RevolutionParser.structure(s));
            }
            st.substituents.clear();
            return new Ester(acid, bases);
        }
        if (name.endsWith("ether")) {
            return new Ether(st.getValue(), st.getName());
        }
        if (name.equals("epi")) {
            Bridge b = new Bridge(RevolutionParser.structure(st.substituents.remove(0)), new LocantList());
            b.setLocantInParent(st.locantsBefore);
            return b;
        }
        if (value.indexOf(124) == value.length() - 1) {
            return new HeteroAtom(value.substring(0, value.length() - 1));
        }
        if (name.endsWith("ate") || st.hasSuffix("ionat")) {
            res = AcetateGroup.create(value, name);
        } else if (value.indexOf("AminoAcid") > 0) {
            res = new AminoAcid(value, name);
        } else if (value.contains("NucleoBase")) {
            res = new NucleoBase(value, name, st.locantsBefore);
        } else if (name.indexOf("oxim") > -1 && !name.endsWith("yl")) {
            res = new Oxime(value, st.multiplicity, name);
        } else if (st.is("hydrazone")) {
            res = new Hydrazone(value, name, null);
        } else if (name.indexOf("anhydrid") > -1) {
            res = new Anhydride(value, name);
        } else {
            if (st.multiplicity != 1) {
                throw new NameImportException.ParseException("Unexpected multiplicity");
            }
            if (st.is("oxy") && st.substituents == null) {
                throw new NameImportException.ParseException("Unsubstituted oxy");
            }
            res = st.locantsBefore.hasLocant() ? new SimpleStructure(value, name, st.locantsBefore) : new SimpleStructure(value, name);
        }
        return res;
    }

    static Structure structure(Token t) {
        if (!(t instanceof StructureToken)) {
            return null;
        }
        StructureToken st = (StructureToken)t;
        Structure res = RevolutionParser.getStructure(st);
        if (st.cloneOf == null || st.cloneOf == st) {
            st.structure = res;
        } else {
            if (st.cloneOf.structure == null) {
                // empty if block
            }
            res.cloneOf = st.cloneOf.structure;
        }
        res.setSpaceSeparated(st.getSpaceSeparated());
        res.setExplicitSingle(st.explicitSingle);
        res.setRoot(st.isRoot);
        if (st.locantInParent != null) {
            res.setLocantInParent(st.locantInParent);
        }
        if (st.suffixes != null) {
            block0: for (Suffix s : st.suffixes) {
                if (!s.hasLocant()) continue;
                for (Suffix defaultS : res.getSuffixList()) {
                    if (!RevolutionParser.shouldReplaceSuffix(s.getName(), defaultS.getName())) continue;
                    res.removeSuffix(defaultS);
                    continue block0;
                }
            }
            res.addSuffix(st.suffixes);
            for (Suffix s : res.getSuffixList()) {
                if (s != res.getConnectionPoint() && !s.getName().equals("rad")) continue;
                res.getSuffixList().remove(s);
                res.getSuffixList().add(s);
                break;
            }
        }
        if (st.substituents != null) {
            for (StructureToken sub : st.substituents) {
                Structure s = RevolutionParser.structure(sub);
                res.addSubstituent(s);
            }
        }
        if (st.stereos != null) {
            res.addStereoLocant(st.stereos);
        }
        if (st.hydros != null) {
            for (Hydro h : st.hydros) {
                res.addHydro(h);
            }
        }
        return res;
    }

    static boolean shouldReplaceSuffix(String suffix, String defaultSuffix) {
        if (suffix.equals(defaultSuffix)) {
            return true;
        }
        return suffix.startsWith("yl") && defaultSuffix.startsWith("yl");
    }

    static Suffix suffix(EndingToken ending, LocantList locants, int multiplier) {
        String value = ending.getValue();
        int radical = SuffixFactory.getRadical(value);
        if (radical != 1) {
            value = SuffixFactory.remRadicalFlag(value);
        }
        if (ending.getName().equals("salt")) {
            value = "";
        }
        int type = SuffixFactory.getSuffixType(ending, null, 1);
        Suffix res = new Suffix(value, locants, multiplier, type, 1, radical);
        String name = ending.getName();
        if (name.endsWith("ate") || name.equals("one")) {
            name = name.substring(0, name.length() - 1);
        }
        res.setName(name);
        return res;
    }

    static boolean sep(Token t, String separator) {
        if (!(t instanceof Separator)) {
            return false;
        }
        String name = ((Separator)t).getName();
        if (name.equals(nbsp) && separator.equals(" ")) {
            return true;
        }
        return name.equals(separator);
    }

    static boolean name(List<Token> l, int rank, String name) {
        return RevolutionParser.name(l, rank, name, false);
    }

    static boolean name(List<Token> l, int rank, String name, boolean strict) {
        return RevolutionParser.name(RevolutionParser.get(l, rank), name, strict);
    }

    static boolean name(Token t, String name, boolean strict) {
        if (t == null) {
            return false;
        }
        if (strict) {
            return t.getName().equals(name);
        }
        return Util.isName(t.getName(), name);
    }

    static boolean hetero(List<Token> l, int rank) {
        return RevolutionParser.hetero(RevolutionParser.get(l, rank));
    }

    static boolean hetero(Token t) {
        if (!(t instanceof StructureToken)) {
            return false;
        }
        if ("C".equals(t.getValue())) {
            return false;
        }
        return ((StructureToken)t).isMonoAtomic();
    }

    static Locant simpleLocant(Token t) {
        if (!(t instanceof LocantList)) {
            return null;
        }
        LocantList ll = (LocantList)t;
        if (ll.size() != 1) {
            return null;
        }
        Locant l = ll.getLocant(0);
        if (l instanceof SimpleLocant || l instanceof AtomLocant) {
            return l;
        }
        return null;
    }

    static boolean simpleLocants(Token t) {
        if (!(t instanceof LocantList)) {
            return false;
        }
        LocantList l = (LocantList)t;
        return l.getType() == 2 || l.getType() == 6;
    }

    static boolean isNLocantList(Token t) {
        if (!(t instanceof LocantList)) {
            return false;
        }
        LocantList locants = (LocantList)t;
        for (Locant l : locants.getLocantsList()) {
            if (l instanceof AzaLocant) continue;
            return false;
        }
        return true;
    }

    static boolean hasPrime(LocantList locants) {
        for (Locant l : locants.getLocantsList()) {
            if (l.getParent() == 0) continue;
            return true;
        }
        return false;
    }

    static int multiplier(Token t) {
        if (!(t instanceof Number)) {
            return -1;
        }
        Number n = (Number)t;
        int type = n.getType();
        if (type == 1 || type == 0) {
            return n.getData();
        }
        return -1;
    }

    static int chainLength(Token t) {
        if (!(t instanceof Number)) {
            return -1;
        }
        Number n = (Number)t;
        int type = n.getType();
        if (type == 2 || type == 0) {
            return n.getData();
        }
        return -1;
    }

    static StructureToken structureMaybeInBrackets(Token t) {
        if (t == null) {
            return null;
        }
        if (t.getName().equals("ester")) {
            return null;
        }
        if (t instanceof StructureToken) {
            return (StructureToken)t;
        }
        if (t instanceof BracketToken) {
            BracketToken b = (BracketToken)t;
            if (b.inside.size() == 1 && b.inside.get(0) instanceof StructureToken) {
                StructureToken res = (StructureToken)b.inside.get(0);
                res.isRoot = true;
                return res;
            }
        }
        return null;
    }

    static boolean beforeDash(Token t) {
        return t instanceof StructureToken || t instanceof BracketToken || t instanceof EndingToken;
    }

    static boolean isEnding(Token t) {
        if (t instanceof EndingToken) {
            return true;
        }
        if (t == null) {
            return false;
        }
        if (t instanceof StructureToken) {
            StructureToken st = (StructureToken)t;
            if (st.suffixes != null || st.substituents != null) {
                return false;
            }
        }
        if (t.is("amine")) {
            return true;
        }
        String name = t.getName();
        return name.equals("sulfinamide") || name.equals("sulfonamide") || name.equals("carboxamide") || name.equals("carbohydrazide");
    }

    static EndingToken asEnding(Token t) {
        if (t instanceof EndingToken) {
            return (EndingToken)t;
        }
        if (t instanceof StructureToken) {
            StructureToken st = (StructureToken)t;
            return new EndingToken(st.getName(), st.getValue());
        }
        return null;
    }

    static String removeAndGetName(List<Token> tokens, int from, int to) {
        String name = "";
        for (int i = to; i >= 0; --i) {
            name = tokens.remove(i).getName() + name;
        }
        return name;
    }

    static boolean anyStructureHas(LocantList locants, List<Token> tokens) {
        block0: for (Token t : tokens) {
            for (Locant l : locants.getLocantsList()) {
                if (t.hasLocant(l)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    static boolean anyStructureHas(Locant locant, List<Token> tokens) {
        for (Token t : tokens) {
            if (RevolutionParser.name(t, " ", true)) break;
            if (!(t instanceof StructureToken) || !((StructureToken)t).hasLocant(locant)) continue;
            return true;
        }
        return false;
    }

    static void refactor(Structure s) {
        if (IUPACParserCore.debug) {
            System.out.println();
        }
        for (Refactoring r : new Refactoring[]{new HantzschWidmanChecker(), new SaltChecker(), new CarbanilideChecker(), new HydrazideChecker(), new NumberingChecker(), new CarbonicAcidChecker(), new NLocantChecker(), new DisulfideChecker(), new DLConfigChecker()}) {
            if (!r.checkTree(s) || !IUPACParserCore.debug) continue;
            System.out.println("Change by " + r.getClass().getSimpleName() + ":");
            s.print();
        }
    }

    static class EndingWithLocant
    extends Rewriter {
        EndingWithLocant() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            Token tok1 = RevolutionParser.get(tokens, 1);
            if (!(tokens.get(0) instanceof StructureToken) || !RevolutionParser.sep(tok1, "-")) {
                return false;
            }
            StructureToken base = (StructureToken)tokens.get(0);
            if (RevolutionParser.cannotHaveSuffix(base)) {
                return false;
            }
            if (RevolutionParser.get(tokens, 2) instanceof LocantList && RevolutionParser.sep(tokens.get(3), "-") && RevolutionParser.isEnding(tokens.get(4))) {
                if (((LocantList)RevolutionParser.get(tokens, 2)).isStereo()) {
                    return false;
                }
                EndingToken ending = RevolutionParser.asEnding(tokens.remove(4));
                tokens.remove(3);
                LocantList locants = (LocantList)tokens.remove(2);
                tokens.remove(1);
                base.addSuffix(RevolutionParser.suffix(ending, locants, 1));
                return true;
            }
            if (RevolutionParser.get(tokens, 2) instanceof LocantList && RevolutionParser.sep(tokens.get(3), "-") && RevolutionParser.multiplier(tokens.get(4)) != -1 && RevolutionParser.isEnding(tokens.get(5))) {
                if (RevolutionParser.name(tokens, 5, "yl") && RevolutionParser.multiplier(RevolutionParser.get(tokens, 6)) != -1) {
                    return false;
                }
                EndingToken ending = RevolutionParser.asEnding(tokens.remove(5));
                int multiplier = RevolutionParser.multiplier(tokens.remove(4));
                tokens.remove(3);
                LocantList locants = (LocantList)tokens.remove(2);
                locants = locants.expandOMP(multiplier);
                tokens.remove(1);
                if (multiplier != locants.size()) {
                    throw new NameImportException.ParseException("Number of locants (" + locants.size() + ") does not match multiplier (" + multiplier + ") in " + tokens);
                }
                base.addSuffix(RevolutionParser.suffix(ending, locants, multiplier));
                return true;
            }
            return false;
        }
    }

    static class SubstituentWithoutLocant
    extends PrettyRewriter {
        SubstituentWithoutLocant() {
        }

        @Override
        boolean rewrite() {
            int start = 0;
            int multiplier = this.multiplier();
            if (multiplier == -1) {
                multiplier = 1;
            } else {
                LocantList locantsBefore;
                if (RevolutionParser.sep(this.get(-1), "-") && this.get(-2) instanceof LocantList && (locantsBefore = (LocantList)this.get(-2)).size() == multiplier && !locantsBefore.isStereo()) {
                    return false;
                }
                start = 1;
            }
            StructureToken sub = RevolutionParser.structureMaybeInBrackets(this.get(start));
            if (sub == null && multiplier == 1 && this.get(start) instanceof BracketToken) {
                BracketToken bracket = (BracketToken)this.get(start);
                if (bracket.inside.size() != 2) {
                    return false;
                }
                multiplier = RevolutionParser.multiplier(bracket.inside.get(0));
                if (multiplier == -1) {
                    return false;
                }
                sub = RevolutionParser.structureMaybeInBrackets(bracket.inside.get(1));
            }
            if (sub != null && this.get(start + 1) instanceof StructureToken) {
                int i;
                boolean hasMoreTokens;
                StructureToken parent = (StructureToken)this.get(start + 1);
                boolean bl = hasMoreTokens = start + 1 < this.length() - 1;
                if (RevolutionParser.cannotBeParent(parent) && hasMoreTokens) {
                    return false;
                }
                if (this.pass == 0 && sub.isChain() && parent.isChain() && hasMoreTokens) {
                    return false;
                }
                if (this.get(start) instanceof BracketToken && this.get(start - 1) instanceof StructureToken && RevolutionParser.structureMaybeInBrackets(this.get(start + 2)) != null) {
                    return false;
                }
                if (this.pass == 0 && parent.needsLocant()) {
                    return false;
                }
                if (multiplier > 1 && (parent.is("oxy") || parent.is("oxo")) && parent.substituents == null) {
                    return false;
                }
                if (sub.is("amino") && parent.is("imino") && hasMoreTokens) {
                    return false;
                }
                if (this.name(start + 2, "amine")) {
                    int offset = 0;
                    if (multiplier == 1 && RevolutionParser.multiplier(this.get(-1)) != -1) {
                        offset = -1;
                    }
                    if (offset == 0 && multiplier == 1 ? this.name(-2, "N") && this.name(-1, "-") : RevolutionParser.isNLocantList(this.get(offset - 2)) && this.name(offset - 1, "-")) {
                        return false;
                    }
                }
                if (sub.is("sulfone") || sub.getName().endsWith("ano!")) {
                    return false;
                }
                if (sub.is("hydrazone") && multiplier == 1) {
                    parent.setSpaceSeparated(true);
                    sub.addSubstituent(null, parent);
                    this.remove(start + 1);
                    --start;
                } else {
                    for (i = 0; i < multiplier; ++i) {
                        if (multiplier > 1) {
                            sub = sub.cloneMe();
                        }
                        parent.addSubstituent(null, sub);
                    }
                }
                for (i = start; i >= 0; --i) {
                    this.remove(i);
                }
                return true;
            }
            return false;
        }
    }

    static class SubstituentWithLocant
    extends PrettyRewriter {
        SubstituentWithLocant() {
            this.removeDashBefore = true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean rewrite() {
            int i;
            int multiplier;
            LocantList locants = this.simpleLocants();
            if (locants == null || locants.isStereo()) {
                return false;
            }
            LocantList stereo = null;
            if (RevolutionParser.stereo(this.get(this.current)) && RevolutionParser.sep(this.get(this.current + 1), "-")) {
                stereo = (LocantList)this.get(this.current);
                this.current += 2;
            }
            if ((multiplier = this.multiplier()) == -1) {
                multiplier = 1;
            }
            StructureToken sub = this.structure();
            boolean subInBrackets = this.get(this.current - 1) instanceof BracketToken;
            if (RevolutionParser.sep(this.get(this.current), "-") && RevolutionParser.sep(this.get(this.current + 1), RevolutionParser.nbsp)) {
                this.current += 2;
            } else if (this.name(RevolutionParser.nbsp)) {
                // empty if block
            }
            StructureToken parent = this.structureNoBracket();
            if (parent == null || parent.is("oxy") || parent.is("oxo") || RevolutionParser.cannotBeParent(parent)) {
                return false;
            }
            int removeBottom = 0;
            if (multiplier != (locants = locants.expandOMP(multiplier)).size()) {
                if (!this.eol()) return false;
                if (multiplier == 2 && locants.size() == 1 && this.name(-1, "-") && this.get(-2) instanceof LocantList && ((LocantList)this.get(-2)).size() == 1) {
                    removeBottom = -2;
                    locants.addFirstLocant(((LocantList)this.get(-2)).getLocant(0));
                } else if (locants.size() == 1 && parent.hasLocant(locants.getLocant(0))) {
                    for (i = 1; i < multiplier; ++i) {
                        locants.addLocant(locants.getLocant(0));
                    }
                } else {
                    if (!sub.tryAddLocantsBefore(locants, true)) throw new NameImportException.ParseException("Number of locants (" + locants.size() + ") does not match multiplier (" + multiplier + ") in " + this.tokens());
                    locants = null;
                }
            }
            if (locants != null) {
                for (Locant locant : locants.getLocantsList()) {
                    if (parent.hasLocant(locant)) continue;
                    if (subInBrackets || !sub.hasLocant(locant)) return false;
                    if (sub.is("acet") || sub.is("benzyl") || sub.is("benzoyl") || sub.is("phen") || sub.is("meth")) {
                        return false;
                    }
                    if (!sub.tryAddLocantsBefore(LocantList.simpleList(locant), true)) {
                        if (RevolutionParser.anyStructureHas(locant, this.remainingTokens())) {
                            return false;
                        }
                        if (!sub.tryAddLocantsBefore(LocantList.simpleList(locant), false)) {
                            sub.setLocantBefore(locant);
                        }
                    }
                    this.remove(1);
                    this.remove(0);
                    return true;
                }
            }
            if (stereo != null) {
                parent.addStereo(stereo);
            }
            i = this.current - 1;
            while (--i >= removeBottom) {
                this.remove(i);
            }
            if (locants == null) {
                for (i = 0; i < multiplier; ++i) {
                    parent.addSubstituent(null, sub.cloneMe());
                }
                return true;
            } else {
                for (Locant l : locants.getLocantsList()) {
                    parent.addSubstituent(l, sub.cloneMe());
                }
            }
            return true;
        }
    }

    static class EndingWithoutLocant
    extends Rewriter {
        EndingWithoutLocant() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int endingPos = 1;
            int multiplier = RevolutionParser.multiplier(RevolutionParser.get(tokens, 1));
            if (multiplier != -1) {
                endingPos = 2;
            } else {
                multiplier = 1;
            }
            if (tokens.get(0) instanceof StructureToken && RevolutionParser.isEnding(RevolutionParser.get(tokens, endingPos))) {
                Token ending;
                if (multiplier > 1 && RevolutionParser.name(tokens, endingPos, "yl") && RevolutionParser.multiplier(RevolutionParser.get(tokens, endingPos + 1)) != -1) {
                    return false;
                }
                StructureToken parent = (StructureToken)tokens.get(0);
                if (RevolutionParser.cannotHaveSuffix(parent)) {
                    return false;
                }
                if (parent.hasSuffix("yl") && !(RevolutionParser.get(tokens, endingPos) instanceof EndingToken) && !RevolutionParser.name(tokens, endingPos, "amine")) {
                    return false;
                }
                if (RevolutionParser.get(tokens, endingPos) instanceof StructureToken) {
                    ending = (StructureToken)RevolutionParser.get(tokens, endingPos);
                    if (((StructureToken)ending).substituents != null) {
                        return false;
                    }
                }
                if (RevolutionParser.name(tokens, endingPos, "amine") && multiplier == 1 && (RevolutionParser.multiplier(this.before) != -1 || parent.is("meth") && parent.hasSuffix("yl") || parent.isCyclic())) {
                    return false;
                }
                if (RevolutionParser.name(tokens, endingPos, "ane")) {
                    if (multiplier > 1) {
                        return false;
                    }
                    if (!parent.acceptsAne()) {
                        return false;
                    }
                }
                if (!RevolutionParser.name(tokens, endingPos, "amine") || !parent.hasSuffix("yl") || multiplier == 1) {
                    // empty if block
                }
                ending = RevolutionParser.asEnding(tokens.remove(endingPos));
                if (endingPos != 1) {
                    tokens.remove(1);
                }
                if (parent.suffixes != null && ending.getName().startsWith("yl")) {
                    for (Suffix s : parent.suffixes) {
                        if (!s.getName().equals("an") && !s.getName().equals("ane")) continue;
                        parent.suffixes.remove(s);
                        break;
                    }
                }
                parent.addSuffix(RevolutionParser.suffix((EndingToken)ending, null, multiplier));
                return true;
            }
            return false;
        }
    }

    static class HydroRewriter
    extends Rewriter {
        HydroRewriter() {
            this.removeDashBefore = true;
        }

        static boolean hydro(List<Token> tokens) {
            int struc;
            int start = 0;
            if (RevolutionParser.multiplier(RevolutionParser.get(tokens, 0)) != -1) {
                start = 1;
            }
            Token sep = RevolutionParser.sep(RevolutionParser.get(tokens, start + 1), "-") ? tokens.get(start + 1) : null;
            int n = struc = sep == null ? start + 1 : start + 2;
            if (RevolutionParser.get(tokens, start) instanceof Hydro && tokens.get(struc) instanceof StructureToken) {
                StructureToken parent = (StructureToken)tokens.get(struc);
                if (!parent.isCyclic()) {
                    return false;
                }
                if (sep != null) {
                    tokens.remove(start + 1);
                }
                Hydro hydro = (Hydro)tokens.remove(start);
                int multiplier = start == 0 ? 1 : RevolutionParser.multiplier(tokens.remove(0));
                for (int i = 0; i < multiplier; ++i) {
                    parent.addHydro(hydro);
                }
                return true;
            }
            if (RevolutionParser.get(tokens, 0) instanceof LocantList && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-") && RevolutionParser.multiplier(RevolutionParser.get(tokens, 2)) != -1 && RevolutionParser.get(tokens, 3) instanceof Hydro) {
                Hydro hydro = (Hydro)RevolutionParser.get(tokens, 3);
                struc = 4;
                if (RevolutionParser.sep(RevolutionParser.get(tokens, 4), "-")) {
                    struc = 5;
                }
                if (RevolutionParser.get(tokens, struc) instanceof StructureToken) {
                    LocantList locants;
                    StructureToken parent = (StructureToken)tokens.get(struc);
                    int multiplier = RevolutionParser.multiplier(tokens.get(2));
                    if (multiplier != (locants = (LocantList)tokens.get(0)).size()) {
                        return false;
                    }
                    int i = struc;
                    while (--i >= 0) {
                        tokens.remove(i);
                    }
                    parent.addHydros(locants, hydro);
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (HydroRewriter.hydro(tokens)) {
                return true;
            }
            if (RevolutionParser.beforeDash(tokens.get(0)) && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-") && HydroRewriter.hydro(tokens.subList(2, tokens.size()))) {
                tokens.remove(1);
                return true;
            }
            return false;
        }
    }

    static class ComplexSpiro
    extends Rewriter {
        ComplexSpiro() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!RevolutionParser.name(tokens, 0, "spiro")) {
                return false;
            }
            if (!(RevolutionParser.get(tokens, 1) instanceof BracketToken)) {
                return false;
            }
            ArrayList<Token> inside = ((BracketToken)RevolutionParser.get(tokens, (int)1)).inside;
            if (inside.size() != 5) {
                return false;
            }
            if (!(RevolutionParser.get(inside, 0) instanceof StructureToken && RevolutionParser.sep(RevolutionParser.get(inside, 1), "-") && RevolutionParser.get(inside, 2) instanceof LocantList && RevolutionParser.sep(RevolutionParser.get(inside, 3), "-") && RevolutionParser.get(inside, 4) instanceof StructureToken)) {
                return false;
            }
            StructureToken first = (StructureToken)RevolutionParser.get(inside, 0);
            StructureToken second = (StructureToken)RevolutionParser.get(inside, 4);
            LocantList locants = (LocantList)RevolutionParser.get(inside, 2);
            if (!RevolutionParser.hasPrime(locants)) {
                return false;
            }
            ArrayList<Structure> structures = new ArrayList<Structure>();
            structures.add(RevolutionParser.structure(first));
            structures.add(RevolutionParser.structure(second));
            PolyCyclicSpiroSystem spiro = new PolyCyclicSpiroSystem(structures, locants);
            tokens.remove(1);
            tokens.remove(0);
            tokens.add(0, new StructureToken(spiro));
            return true;
        }
    }

    static class SpiroMulStruct
    extends PrettyRewriter {
        SpiroMulStruct() {
        }

        @Override
        boolean rewrite() {
            LocantList locants = this.locants();
            if (!this.name("spiro")) {
                return false;
            }
            int mul = this.multiplier();
            StructureToken component = this.structure();
            if (locants == null || mul == -1 || component == null) {
                return false;
            }
            MultipliedSpiroSystem s = new MultipliedSpiroSystem(RevolutionParser.structure(component), locants);
            int i = this.current;
            while (--i >= 0) {
                this.remove(i);
            }
            this.add(0, new StructureToken(s));
            return true;
        }
    }

    static class SimpleSpiro
    extends Rewriter {
        SimpleSpiro() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            HeteroChain h;
            StructureToken second;
            int cur = -1;
            int mul = RevolutionParser.multiplier(tokens.get(0));
            if (mul == -1) {
                mul = 1;
            } else {
                ++cur;
            }
            if (!RevolutionParser.name(tokens, ++cur, "spiro")) {
                return false;
            }
            if (!(RevolutionParser.get(tokens, ++cur) instanceof LocantList)) {
                return false;
            }
            LocantList numbering = (LocantList)RevolutionParser.get(tokens, cur);
            if (numbering.getType() != 0) {
                return false;
            }
            if ((second = RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, ++cur))) == null) {
                return false;
            }
            if (mul > 1) {
                // empty if block
            }
            for (int i = cur; i >= 0; --i) {
                tokens.remove(i);
            }
            MonoCyclicSpiroSytem s = second.structure instanceof HeteroChain ? ((h = (HeteroChain)second.structure).getAtom2() != null ? new MonoCyclicSpiroSytem(numbering, h.getAtom(), h.getAtom2()) : new MonoCyclicSpiroSytem(numbering, h.getAtom())) : new MonoCyclicSpiroSytem(numbering, "C");
            tokens.add(0, new StructureToken(s));
            return true;
        }
    }

    static class Fused
    extends PrettyRewriter {
        Fused() {
        }

        @Override
        boolean rewrite() {
            StructureToken first = this.structure();
            if (first == null) {
                return false;
            }
            this.optional(this.name("o"));
            this.optional(this.name(" ") || this.name("-"));
            LocantList fusion = this.fusion();
            if (fusion == null) {
                return false;
            }
            this.optional(this.name(" ") || this.name("-"));
            StructureToken second = this.structure();
            if (second == null) {
                return false;
            }
            while (this.get(0) != second) {
                this.remove(0);
            }
            this.remove(0);
            FusedSystem s = new FusedSystem(RevolutionParser.structure(first), RevolutionParser.structure(second), fusion);
            this.add(0, new StructureToken(s));
            return true;
        }
    }

    static class FusedLocantsBeforeLocants
    extends Rewriter {
        FusedLocantsBeforeLocants() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!(RevolutionParser.get(tokens, 0) instanceof LocantList)) {
                return false;
            }
            LocantList fusion = (LocantList)RevolutionParser.get(tokens, 0);
            if (fusion.getType() != 5) {
                return false;
            }
            if (!(RevolutionParser.get(tokens, 1) instanceof BracketToken)) {
                return false;
            }
            BracketToken bracket = (BracketToken)RevolutionParser.get(tokens, 1);
            if (bracket.inside.size() != 1) {
                return false;
            }
            Token inside = bracket.inside.get(0);
            if (!(inside instanceof LocantList)) {
                return false;
            }
            LocantList locants = (LocantList)bracket.inside.get(0);
            tokens.remove(1);
            tokens.add(1, locants);
            tokens.add(2, new Separator('-'));
            return true;
        }
    }

    static class SpiroLocantsBeforeLocants
    extends Rewriter {
        SpiroLocantsBeforeLocants() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!(RevolutionParser.get(tokens, 0) instanceof LocantList)) {
                return false;
            }
            LocantList spiroLocants = (LocantList)RevolutionParser.get(tokens, 0);
            if (!RevolutionParser.hasPrime(spiroLocants)) {
                return false;
            }
            if (!RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-")) {
                return false;
            }
            if (!(RevolutionParser.get(tokens, 2) instanceof BracketToken)) {
                return false;
            }
            BracketToken bracket = (BracketToken)RevolutionParser.get(tokens, 2);
            if (bracket.inside.size() != 1) {
                return false;
            }
            Token inside = bracket.inside.get(0);
            if (!(inside instanceof LocantList)) {
                return false;
            }
            LocantList locants = (LocantList)bracket.inside.get(0);
            tokens.remove(2);
            tokens.add(2, locants);
            tokens.add(3, new Separator('-'));
            return true;
        }
    }

    static class Cyclo
    extends Rewriter {
        Cyclo() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int cur = 0;
            int multiplier = RevolutionParser.multiplier(tokens.get(cur));
            if (multiplier != -1) {
                cur = 1;
            }
            if (!RevolutionParser.name(tokens, cur++, "cyclo")) {
                return false;
            }
            LocantList ringNumbering = null;
            if (RevolutionParser.get(tokens, cur) instanceof LocantList && (ringNumbering = (LocantList)RevolutionParser.get(tokens, cur++)).getType() != 0) {
                return false;
            }
            if (multiplier != -1 && ringNumbering == null) {
                return false;
            }
            HeteroChain heteroChain = null;
            if (RevolutionParser.get(tokens, cur) instanceof StructureToken && ((StructureToken)RevolutionParser.get(tokens, (int)cur)).structure instanceof HeteroChain) {
                heteroChain = (HeteroChain)((StructureToken)RevolutionParser.get(tokens, (int)cur)).structure;
            }
            if (ringNumbering == null) {
                int length;
                if (heteroChain != null) {
                    length = heteroChain.getMultiplicity();
                } else if (RevolutionParser.get(tokens, cur) instanceof StructureToken) {
                    StructureToken s = (StructureToken)tokens.get(cur);
                    if (multiplier == -1 && s.getName().endsWith("ylene")) {
                        tokens.remove(0);
                        return true;
                    }
                    length = s.getValue().length();
                } else {
                    length = RevolutionParser.chainLength(RevolutionParser.get(tokens, cur));
                    if (length == -1) {
                        return false;
                    }
                }
                ringNumbering = new LocantList();
                ringNumbering.tryAddLocant(new RingNumber(length));
            }
            String atom = "C";
            String atom2 = null;
            if (RevolutionParser.hetero(tokens, cur + 1) && !RevolutionParser.get(tokens, cur).endsWith("an")) {
                atom = tokens.get(++cur).getValue();
            } else if (heteroChain != null) {
                atom = heteroChain.getAtom();
                atom2 = heteroChain.getAtom2();
            }
            VonBaeyerSystem cycle = new VonBaeyerSystem(ringNumbering, atom, atom2);
            int i = cur + 1;
            while (--i >= 0) {
                tokens.remove(i);
            }
            tokens.add(0, new StructureToken(cycle));
            return true;
        }
    }

    static class StereoRewriter
    extends PrettyRewriter {
        StereoRewriter() {
        }

        @Override
        boolean rewrite() {
            if (!RevolutionParser.stereo(this.get(0))) {
                return false;
            }
            ++this.current;
            this.optional(this.name("-"));
            StructureToken parent = this.structure();
            if (parent == null) {
                return false;
            }
            LocantList stereos = (LocantList)this.get(0);
            if (this.pass == 1 && RevolutionParser.anyStructureHas(stereos, this.remainingTokens())) {
                return false;
            }
            parent.addStereo(stereos);
            int i = this.current - 1;
            while (--i >= 0) {
                this.remove(i);
            }
            return true;
        }
    }

    class BracketRewriter
    extends PrettyRewriter {
        BracketRewriter() {
        }

        @Override
        boolean rewrite() {
            if (this.get(0) instanceof BracketToken) {
                ArrayList<Token> inside = ((BracketToken)this.get((int)0)).inside;
                if (inside.size() > 1) {
                    boolean res = RevolutionParser.this.rewriteOnce(inside, true);
                    return res;
                }
                Token t = (Token)inside.get(0);
                if (this.canRemoveSingle(t)) {
                    this.remove(0);
                    this.add(0, t);
                    RevolutionParser.this.lastRewriter = this;
                    return true;
                }
            }
            return false;
        }

        private boolean canRemoveSingle(Token t) {
            if (t instanceof BracketToken) {
                return true;
            }
            return t instanceof StructureToken && (this.pass >= 2 || ((StructureToken)t).structure instanceof MultipliedSystem);
        }
    }

    static class SaltRewriter
    extends Rewriter {
        SaltRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (RevolutionParser.multiplier(this.before) != -1) {
                return false;
            }
            if (tokens.size() < 3) {
                return false;
            }
            if (!(tokens.get(0) instanceof StructureToken)) {
                return false;
            }
            StructureToken s = (StructureToken)tokens.get(0);
            if (s.is("hydrogen")) {
                return false;
            }
            int atomPos = 1;
            if (RevolutionParser.sep(RevolutionParser.get(tokens, 1), " ")) {
                ++atomPos;
            }
            if (RevolutionParser.name(tokens, atomPos, "hydrate")) {
                s.addSuffix(RevolutionParser.suffix((EndingToken)tokens.get(atomPos), null, 1));
                for (int i = atomPos; i > 0; --i) {
                    tokens.remove(i);
                }
                return true;
            }
            boolean hydro = false;
            int mul = RevolutionParser.multiplier(RevolutionParser.get(tokens, atomPos));
            if (mul == -1) {
                mul = 1;
            } else {
                ++atomPos;
            }
            if (RevolutionParser.get(tokens, atomPos) instanceof Hydro) {
                hydro = true;
                ++atomPos;
            }
            if (RevolutionParser.get(tokens, atomPos) instanceof StructureToken) {
                StructureToken atom = (StructureToken)RevolutionParser.get(tokens, atomPos);
                if (!atom.isMonoAtomic()) {
                    return false;
                }
                if (atom.suffixes == null || atom.suffixes.size() != 1 || atom.substituents != null) {
                    return false;
                }
                Suffix suffix = atom.suffixes.get(0);
                if (suffix.getType() != 3) {
                    return false;
                }
                if (atom.is("sulf") && suffix.is("ide") && this.before != null) {
                    return false;
                }
                for (int i = 2; i < atomPos; ++i) {
                    tokens.remove(2);
                }
                tokens.remove(2);
                tokens.remove(1);
                SaltEnding salt = new SaltEnding(suffix.getValue(), mul, atom.getValue(), 1, hydro);
                salt.setName(suffix.getName());
                s.addSuffix(salt);
                return true;
            }
            return false;
        }
    }

    static class ExplicitSalt
    extends PrettyRewriter {
        ExplicitSalt() {
            this.removeSpaceBefore = true;
        }

        @Override
        boolean rewrite() {
            StructureToken s;
            if (!(this.get(-1) == null || this.name(-1, " ") || this.name(-1, ",") || this.name(-1, RevolutionParser.nbsp))) {
                return false;
            }
            int multiplier = this.multiplier();
            if (multiplier == -1) {
                multiplier = 1;
            }
            if ((s = this.structure()) != null && this.name(" ") && this.name("salt")) {
                --this.current;
                EndingToken salt = this.ending();
                s.addSuffix(RevolutionParser.suffix(salt, null, 1));
                this.outsideComponent = RevolutionParser.structure(s);
                this.outsideComponent.multiplicity = multiplier;
                int i = this.current;
                while (--i >= 0) {
                    this.remove(i);
                }
                return true;
            }
            return false;
        }
    }

    static class Disulfide
    extends GlobalRewriter {
        Disulfide() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int i;
            StructureToken disulfide;
            int mul;
            int cur = 0;
            if (RevolutionParser.get(tokens, 0) instanceof LocantList && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-")) {
                LocantList locants = (LocantList)RevolutionParser.get(tokens, 0);
                if (locants.size() != 2) {
                    return false;
                }
                if (!locants.getLocant(0).equals(Locant.One) || !locants.getLocant(1).equals(Locant.OnePrime)) {
                    return false;
                }
                cur = 2;
            }
            if ((mul = RevolutionParser.multiplier(RevolutionParser.get(tokens, cur))) == -1) {
                mul = 1;
            } else {
                ++cur;
            }
            if (RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, cur)) == null || !RevolutionParser.sep(RevolutionParser.get(tokens, cur + 1), " ")) {
                return false;
            }
            StructureToken sub = RevolutionParser.structureMaybeInBrackets(tokens.get(cur));
            if (RevolutionParser.name(tokens, cur + 2, "disulfide")) {
                disulfide = (StructureToken)RevolutionParser.get(tokens, cur + 2);
            } else if (RevolutionParser.name(tokens, cur + 2, "di") && (RevolutionParser.name(tokens, cur + 3, "selen") || RevolutionParser.name(tokens, cur + 3, "tellur")) && RevolutionParser.name(tokens, cur + 4, "ide")) {
                disulfide = (StructureToken)tokens.get(cur + 3);
                disulfide.setValue("[*]" + disulfide.getValue() + disulfide.getValue() + "[*] |$_R0;;;_R0$|");
                disulfide.setName("di" + disulfide.getName() + "ide");
                tokens.remove(cur + 4);
                tokens.remove(cur + 2);
            } else {
                return false;
            }
            for (i = cur + 1; i >= 0; --i) {
                tokens.remove(i);
            }
            for (i = 0; i < mul; ++i) {
                if (mul > 1) {
                    sub = sub.cloneMe();
                }
                sub.setSpaceSeparated(true);
                disulfide.addSubstituent(null, sub);
            }
            return true;
        }
    }

    static class LocantsBeforeRewriter
    extends BackwardsRewriter {
        LocantsBeforeRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (this.pass == 0 && !(this.before instanceof LocantList)) {
                return false;
            }
            if (!(tokens.get(0) instanceof LocantList)) {
                return false;
            }
            if (!RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-") && !RevolutionParser.sep(RevolutionParser.get(tokens, 1), RevolutionParser.nbsp)) {
                return false;
            }
            if (RevolutionParser.get(tokens, 2) instanceof StructureToken) {
                StructureToken s = (StructureToken)RevolutionParser.get(tokens, 2);
                if (s.isMonoAtomic() && !s.is("oxy")) {
                    return false;
                }
                LocantList ll = (LocantList)tokens.get(0);
                if (ll.getType() == 5) {
                    return false;
                }
                if (!s.tryAddLocantsBefore(ll, true)) {
                    if (this.pass < 2) {
                        return false;
                    }
                    if (!s.addLocantsBefore(ll)) {
                        return false;
                    }
                }
                tokens.remove(1);
                tokens.remove(0);
                return true;
            }
            return false;
        }
    }

    static class BracketedLocants
    extends PrettyRewriter {
        BracketedLocants() {
        }

        @Override
        boolean rewrite() {
            LocantList locants = this.bracketedLocants();
            StructureToken s = this.structure();
            if (locants == null || s == null || !this.eol()) {
                return false;
            }
            if (!s.addLocantsBefore(locants)) {
                return false;
            }
            this.remove(0);
            return true;
        }
    }

    static class StructureSuffixRewriter
    extends GlobalRewriter {
        StructureSuffixRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() != 5) {
                return false;
            }
            if (RevolutionParser.get(tokens, 0) instanceof StructureToken && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-") && RevolutionParser.simpleLocant(RevolutionParser.get(tokens, 2)) != null && RevolutionParser.sep(RevolutionParser.get(tokens, 3), "-") && RevolutionParser.get(tokens, 4) instanceof StructureToken) {
                StructureToken first = (StructureToken)RevolutionParser.get(tokens, 0);
                StructureToken second = (StructureToken)RevolutionParser.get(tokens, 4);
                if (!first.isCyclic()) {
                    return false;
                }
                tokens.add(4, new EndingToken("yl", "|"));
                return true;
            }
            return false;
        }
    }

    static class DoubleLocantBeforeRewriter
    extends BackwardsRewriter {
        DoubleLocantBeforeRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() < 5) {
                return false;
            }
            if (RevolutionParser.simpleLocant(tokens.get(0)) != null && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-") && RevolutionParser.simpleLocant(tokens.get(2)) != null && RevolutionParser.sep(RevolutionParser.get(tokens, 3), "-") && RevolutionParser.get(tokens, 4) instanceof StructureToken && (RevolutionParser.get(tokens, 5) instanceof EndingToken || RevolutionParser.get(tokens, 5) instanceof Separator)) {
                StructureToken s = (StructureToken)RevolutionParser.get(tokens, 4);
                Token sep = tokens.remove(3);
                LocantList ll = (LocantList)tokens.remove(2);
                if (RevolutionParser.get(tokens, 3) instanceof EndingToken && !s.hasDefaultLocants()) {
                    tokens.add(3, sep);
                    tokens.add(4, ll);
                    tokens.add(5, sep);
                } else {
                    s.addLocantsBefore(ll);
                }
                return true;
            }
            return false;
        }
    }

    static class SecTert
    extends PrettyRewriter {
        SecTert() {
        }

        @Override
        boolean rewrite() {
            boolean sec;
            if (this.name("sec")) {
                sec = true;
            } else if (this.name("tert")) {
                sec = false;
            } else {
                return false;
            }
            if (!this.name("-")) {
                return false;
            }
            StructureToken chain = this.structure();
            if (chain == null || sec && !this.name("yl")) {
                return false;
            }
            int i = this.current;
            while (--i >= 0) {
                this.remove(i);
            }
            SimpleStructure s = sec ? new SecChain(chain.getValue(), chain.getName()) : new TertChain(chain.getValue(), chain.getName());
            this.add(0, new StructureToken(s));
            return true;
        }
    }

    static class Epi
    extends Rewriter {
        Epi() {
            this.removeDashBefore = true;
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int start = 0;
            if (RevolutionParser.get(tokens, 0) instanceof LocantList && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-")) {
                start = 2;
            }
            if (!RevolutionParser.name(tokens, start, "epi")) {
                return false;
            }
            if (RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, start + 1)) == null) {
                return false;
            }
            StructureToken epi = (StructureToken)tokens.get(start);
            if (epi.substituents != null) {
                return false;
            }
            StructureToken bridge = RevolutionParser.structureMaybeInBrackets(tokens.remove(start + 1));
            if (start == 2) {
                LocantList locants;
                tokens.remove(1);
                epi.locantsBefore = locants = (LocantList)tokens.remove(0);
            }
            bridge.setName("epi" + bridge.getName());
            epi.addSubstituent(null, bridge);
            return true;
        }
    }

    static class Ano
    extends Rewriter {
        Ano() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            Structure s;
            if (!RevolutionParser.name(tokens, 1, "ano")) {
                return false;
            }
            int mul = RevolutionParser.multiplier(tokens.get(0));
            if (mul != -1) {
                String structure = "";
                for (int i = 0; i < mul; ++i) {
                    structure = structure + "C";
                }
                s = new SimpleStructure(structure, mul + "ano");
            } else if (tokens.get(0) instanceof StructureToken) {
                s = RevolutionParser.structure(tokens.get(0));
            } else {
                return false;
            }
            String name = RevolutionParser.removeAndGetName(tokens, 0, 1) + "!";
            Bridge b = new Bridge(s, new LocantList());
            StructureToken st = new StructureToken(b);
            st.setName(name);
            tokens.add(0, st);
            return true;
        }
    }

    static class SpecialPolyFused
    extends Rewriter {
        SpecialPolyFused() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            PolyRingSystem s;
            int multiplier = RevolutionParser.multiplier(tokens.get(0));
            if (multiplier == -1) {
                return false;
            }
            if (RevolutionParser.name(tokens, 1, "cene")) {
                s = new PolyCane(multiplier, true);
            } else if (RevolutionParser.name(tokens, 1, "cane")) {
                s = new PolyCane(multiplier, false);
            } else if (RevolutionParser.name(tokens, 1, "phene", true)) {
                s = new PolyaPhene(multiplier, true);
            } else if (RevolutionParser.name(tokens, 1, "phane")) {
                s = new PolyaPhene(multiplier, false);
            } else if (RevolutionParser.name(tokens, 1, "lene")) {
                s = new PolyaLene(multiplier);
            } else if (RevolutionParser.name(tokens, 1, "naphthylene")) {
                s = new PolyNaphthylene(multiplier);
            } else if (RevolutionParser.name(tokens, 1, "helicene")) {
                s = new PolyHelicene(multiplier);
            } else {
                return false;
            }
            tokens.remove(1);
            tokens.remove(0);
            tokens.add(0, new StructureToken(s));
            return true;
        }
    }

    static class HeterAnthrene
    extends Rewriter {
        HeterAnthrene() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!RevolutionParser.hetero(tokens, 0) || !RevolutionParser.name(tokens, 1, "anthrene")) {
                return false;
            }
            tokens.remove(1);
            HeteroAtom hetero = new HeteroAtom(tokens.remove(0).getValue());
            tokens.add(0, new StructureToken(new PhenoIneSystem(hetero)));
            return true;
        }
    }

    static class PhenoIne
    extends Rewriter {
        PhenoIne() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            HeteroAtom hetero2;
            int second;
            HeteroAtom hetero1;
            if (RevolutionParser.name(tokens, 0, "pheno")) {
                if (!RevolutionParser.hetero(tokens, 1)) {
                    return false;
                }
                hetero1 = new HeteroAtom(tokens.get(1).getValue());
                second = 2;
            } else if (RevolutionParser.name(tokens, 0, "phenox") || RevolutionParser.name(tokens, 0, "phenoxa")) {
                hetero1 = new HeteroAtom("O");
                second = 1;
            } else {
                return false;
            }
            if (RevolutionParser.name(tokens, second, "phosphine")) {
                hetero2 = new HeteroAtom("P");
                --second;
            } else if (RevolutionParser.name(tokens, second, "arsine")) {
                hetero2 = new HeteroAtom("[As]");
                --second;
            } else {
                if (!RevolutionParser.hetero(tokens, second)) {
                    return false;
                }
                if (!RevolutionParser.name(tokens, second + 1, "ine")) {
                    return false;
                }
                hetero2 = new HeteroAtom(tokens.get(second).getValue());
            }
            for (int i = second + 1; i >= 0; --i) {
                tokens.remove(i);
            }
            tokens.add(0, new StructureToken(new PhenoIneSystem(hetero1, hetero2)));
            return true;
        }
    }

    static class AnnuleneRewriter
    extends PrettyRewriter {
        AnnuleneRewriter() {
        }

        @Override
        boolean rewrite() {
            LocantList locants;
            boolean benzo = false;
            if (this.name("benz")) {
                if (this.name("o")) {
                    benzo = true;
                } else {
                    return false;
                }
            }
            if ((locants = this.bracketedLocants()) == null) {
                return false;
            }
            SimpleLocant l = locants.getSimpleLocant();
            if (l == null) {
                return false;
            }
            if (!this.name("annulene")) {
                return false;
            }
            Annulene annulene = new Annulene(l.getValue(), benzo);
            int i = this.current;
            while (--i >= 0) {
                this.remove(i);
            }
            this.add(0, new StructureToken(annulene));
            return true;
        }
    }

    static class HantzschWidman
    extends PrettyRewriter {
        HantzschWidman() {
        }

        @Override
        boolean rewrite() {
            Boolean aromatic;
            int ringSize;
            if (this.name(0, "ox") && this.name(1, "ine")) {
                this.remove(1);
                this.remove(0);
                this.add(0, new StructureToken("oxine", "OC1=CC=CC2=C1N=CC=C2 |$;;7;;5;;;;;;$|"));
                return true;
            }
            LocantList locants = this.locants();
            if (locants != null && (locants.isStereo() || RevolutionParser.hasPrime(locants))) {
                return false;
            }
            ArrayList<HeteroAtom> heteros = new ArrayList<HeteroAtom>();
            this.current = RevolutionParser.parseHeteros(this.tokens(), this.current, heteros);
            if (this.current == -1 || heteros.isEmpty()) {
                return false;
            }
            if (heteros.size() == 2 && this.name(this.current - 2, "imid") && this.name(this.current - 1, "azo") && this.peek(this.fusion())) {
                ringSize = 5;
                aromatic = true;
            } else {
                EndingToken ending = this.ending();
                if (ending == null) {
                    return false;
                }
                if (ending.equalsName("ane")) {
                    for (HeteroAtom h : heteros) {
                        if (ParserUtil.isVIAAtom(h.getValue())) continue;
                        return false;
                    }
                }
                if ((ringSize = HantzschWidmanSystem.getRingSize(ending)) == -1) {
                    return false;
                }
                aromatic = HantzschWidmanSystem.isAromatic(ending);
                if (aromatic == null) {
                    return false;
                }
                if (ending.equalsName("ol") && !this.name("ine") && this.name("id")) {
                    aromatic = false;
                }
            }
            if (!RevolutionParser.setLocants(heteros, locants, ringSize)) {
                return false;
            }
            int i = this.current;
            while (--i >= 0) {
                this.remove(i);
            }
            this.add(0, new StructureToken(new HantzschWidmanSystem(ringSize, new ArrayList<Structure>(heteros), aromatic)));
            return true;
        }
    }

    static class BenzoFused
    extends PrettyRewriter {
        BenzoFused() {
        }

        @Override
        boolean rewrite() {
            int type;
            boolean imidaz;
            LocantList locants = this.locants();
            if (!(this.name("benz") && this.optional(this.name("o")) || this.name("benzo") || this.name("benzoyl"))) {
                return false;
            }
            ArrayList<HeteroAtom> heteros = new ArrayList<HeteroAtom>();
            if (this.name("thiole")) {
                --this.current;
                this.add(this.current, new StructureToken("thi", "S"));
                this.get(this.current + 1).setName("ol");
            }
            this.current = RevolutionParser.parseHeteros(this.tokens(), this.current, heteros);
            if (this.current == -1 || heteros.isEmpty()) {
                return false;
            }
            boolean bl = imidaz = this.name(this.current - 2, "imid") && (this.name(this.current - 1, "az") || this.name(this.current - 1, "azo"));
            if (this.name("ole")) {
                type = 5;
                this.name("ine");
            } else if (this.name("yl")) {
                type = 5;
                --this.current;
            } else if (this.name("ine")) {
                type = 6;
            } else if (this.name("epine")) {
                type = 7;
            } else {
                return false;
            }
            if (locants == null) {
                switch (heteros.size()) {
                    case 1: {
                        locants = LocantList.simpleList(1);
                        break;
                    }
                    case 2: {
                        if (type == 7) {
                            locants = LocantList.simpleList(1, 4);
                            break;
                        }
                        locants = LocantList.simpleList(1, 3);
                        break;
                    }
                    case 3: {
                        locants = LocantList.simpleList(1, 2, 3);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (!RevolutionParser.setLocants(heteros, locants, type)) {
                return false;
            }
            int i = this.current;
            while (--i >= 0) {
                this.remove(i);
            }
            BenzoFusedSystem s = new BenzoFusedSystem(type, heteros, locants);
            this.add(0, new StructureToken(s));
            if (imidaz) {
                s.defaultHydro = new ArrayList();
                s.defaultHydro.add(new Hydro("1H", "1H"));
            }
            return true;
        }
    }

    static class AlcoholRewriter
    extends GlobalRewriter {
        AlcoholRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() < 3) {
                return false;
            }
            if (tokens.get(0) instanceof StructureToken && RevolutionParser.sep(RevolutionParser.get(tokens, 1), " ") && RevolutionParser.name(tokens, 2, "alcohol")) {
                StructureToken parent = (StructureToken)RevolutionParser.get(tokens, 2);
                tokens.remove(1);
                StructureToken sub = (StructureToken)tokens.remove(0);
                sub.setSpaceSeparated(true);
                parent.addSubstituent(null, sub);
                return true;
            }
            return false;
        }
    }

    static class SpaceClass
    extends PrettyRewriter {
        SpaceClass() {
        }

        static boolean isSpaceClass(Token t, boolean justTest) {
            if (!(t instanceof StructureToken)) {
                return false;
            }
            String name = t.getName();
            if (name.equals("oxime") || name.endsWith("oxide") || name.endsWith("one") || name.equals("ketoxime") || name.equals("ketone oxime") || name.endsWith("ether") || name.equals("anhydride")) {
                return true;
            }
            StructureToken st = (StructureToken)t;
            if (st.suffixes != null && st.suffixes.size() == 1) {
                String suff = st.suffixes.get(0).getName();
                if (suff.equals("salt")) {
                    return true;
                }
                if (name.equals("sulf") && suff.equals("ide")) {
                    if (!justTest) {
                        st.suffixes.remove(0);
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean rewrite() {
            StructureToken parent;
            StructureToken sub;
            int subMul;
            LocantList locants;
            if (this.get(-1) != null && !RevolutionParser.sep(this.get(-1), " ")) {
                return false;
            }
            Locant locant = null;
            if (this.pass >= 2 && (locants = this.locants()) != null) {
                if (locants.size() == 1) {
                    locant = locants.getLocant(0);
                } else {
                    return false;
                }
            }
            if ((subMul = this.multiplier()) == -1) {
                subMul = 1;
            }
            if ((sub = this.structure()) == null || !this.name(" ")) {
                return false;
            }
            if (sub.is("hydrogen")) {
                return false;
            }
            int multiplicity = 1;
            if (!this.name("mon") && !this.name("mono") && this.name("di")) {
                multiplicity = 2;
            }
            if ((parent = this.structure()) == null) {
                return false;
            }
            if (!(SpaceClass.isSpaceClass(parent, false) || sub.is("sodium") && multiplicity == 1)) {
                return false;
            }
            if (locant != null && !parent.hasLocant(locant)) {
                return false;
            }
            parent.multiplicity = multiplicity;
            String name = parent.getName();
            if (subMul == 1 && this.get(-1) == null && (parent.is("ether") || parent.is("ketone") || parent.is("sulfone") || name.endsWith("oxide") && !name.equals("hydroxide")) && parent.substituents == null) {
                subMul = 2;
            }
            int i = this.current;
            while (--i >= 0) {
                this.remove(i);
            }
            this.add(0, parent);
            if (parent.is("ether") && sub.getName().endsWith("ethylene glycol")) {
                String glycolSmiles = sub.getValue();
                parent.setValue(glycolSmiles + "{RGroups: R2:" + glycolSmiles.length() + " R1:1}");
                return true;
            }
            for (i = 0; i < subMul; ++i) {
                if (subMul > 1) {
                    sub = sub.cloneMe();
                }
                sub.setSpaceSeparated(true);
                parent.addSubstituent(locant, sub);
            }
            return true;
        }
    }

    static class SpaceSubstituent
    extends GlobalRewriter {
        SpaceSubstituent() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int start;
            for (start = tokens.size() - 3; start >= 0 && !RevolutionParser.sep(tokens.get(start + 1), " "); --start) {
            }
            if (start < 0) {
                return false;
            }
            if (RevolutionParser.structureMaybeInBrackets(tokens.get(start)) == null) {
                return false;
            }
            StructureToken sub = RevolutionParser.structureMaybeInBrackets(tokens.get(start));
            if (!(RevolutionParser.get(tokens, start + 2) instanceof StructureToken)) {
                return false;
            }
            StructureToken parent = (StructureToken)RevolutionParser.get(tokens, start + 2);
            if (!sub.is("hydrogen") && (SpaceClass.isSpaceClass(parent, true) || parent.is("disulfide") || parent.is("ester") || parent.isEsterParent() || parent.is("acetal"))) {
                return false;
            }
            sub.setSpaceSeparated(true);
            tokens.remove(start + 1);
            return true;
        }
    }

    static class ImplicitEsterRewriter
    extends Rewriter {
        ImplicitEsterRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int multiplier;
            boolean explicitSingle;
            if (this.before != null && !RevolutionParser.sep(this.before, " ")) {
                return false;
            }
            LocantList locants = null;
            int start = 0;
            if (RevolutionParser.simpleLocants(tokens.get(0)) && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-")) {
                locants = (LocantList)tokens.get(0);
                if (locants.isOrthoMetaPara()) {
                    return false;
                }
                start = 2;
            }
            boolean bl = explicitSingle = (multiplier = RevolutionParser.multiplier(tokens.get(start))) == 1;
            if (multiplier != -1) {
                ++start;
            } else {
                multiplier = 1;
            }
            if (RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, start)) != null && RevolutionParser.sep(RevolutionParser.get(tokens, start + 1), " ") && RevolutionParser.get(tokens, start + 2) instanceof StructureToken) {
                StructureToken sub = RevolutionParser.structureMaybeInBrackets(tokens.get(start));
                StructureToken parent = (StructureToken)RevolutionParser.get(tokens, start + 2);
                if (!parent.hasLocants(locants)) {
                    return false;
                }
                if (!parent.isEsterParent()) {
                    if (!SpaceClass.isSpaceClass(parent, true) && sub.isEsterParent() && multiplier == 1 && locants == null) {
                        StructureToken tmp = parent;
                        parent = sub;
                        sub = tmp;
                    } else {
                        return false;
                    }
                }
                if (locants != null && multiplier != locants.size()) {
                    throw new NameImportException.ParseException("Number of locants (" + locants.size() + ") does not match multiplier (" + multiplier + ") in " + tokens);
                }
                tokens.remove(start + 1);
                tokens.remove(start);
                while (start >= 0) {
                    tokens.remove(start--);
                }
                tokens.add(0, parent);
                for (int i = 0; i < multiplier; ++i) {
                    if (multiplier > 1) {
                        sub = sub.cloneMe();
                    }
                    sub.setSpaceSeparated(true);
                    sub.explicitSingle = explicitSingle;
                    Locant locant = locants == null ? null : locants.getLocant(i);
                    parent.addSubstituent(locant, sub);
                }
                return true;
            }
            return false;
        }
    }

    static class ExplicitEster
    extends GlobalRewriter {
        ExplicitEster() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            StructureToken acid;
            if (tokens.size() < 5) {
                return false;
            }
            int start = 0;
            ArrayList<StructureToken> subs = new ArrayList<StructureToken>();
            while (!RevolutionParser.name(tokens, start, "ester")) {
                boolean explicitSingle;
                int multiplier = RevolutionParser.multiplier(RevolutionParser.get(tokens, start));
                boolean bl = explicitSingle = multiplier == 1;
                if (multiplier == -1) {
                    multiplier = 1;
                } else {
                    ++start;
                }
                if (RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, start)) == null || !RevolutionParser.sep(RevolutionParser.get(tokens, start + 1), " ")) break;
                StructureToken sub = RevolutionParser.structureMaybeInBrackets(tokens.get(start));
                if (sub.isSalt()) {
                    return false;
                }
                for (int i = 0; i < multiplier; ++i) {
                    if (multiplier > 1) {
                        sub = sub.cloneMe();
                    }
                    sub.explicitSingle = explicitSingle;
                    subs.add(sub);
                }
                start += 2;
            }
            if (subs.isEmpty()) {
                return false;
            }
            if (!RevolutionParser.get(tokens, start).getName().equals("ester")) {
                return false;
            }
            StructureToken ester = (StructureToken)tokens.get(start);
            if (RevolutionParser.sep(RevolutionParser.get(tokens, start + 1), " ")) {
                if (RevolutionParser.get(tokens, start + 2) instanceof StructureToken) {
                    acid = (StructureToken)RevolutionParser.get(tokens, start + 2);
                    if (!acid.isEsterParent()) {
                        return false;
                    }
                } else {
                    return false;
                }
                tokens.remove(start + 2);
                tokens.remove(start + 1);
            } else if (((StructureToken)subs.get(0)).isEsterParent()) {
                acid = (StructureToken)subs.remove(0);
            } else {
                return false;
            }
            int i = start + 1;
            while (--i >= 0) {
                tokens.remove(i);
            }
            tokens.add(0, ester);
            for (StructureToken sub : subs) {
                sub.setSpaceSeparated(true);
                ester.addSubstituent(null, sub);
            }
            ester.addSubstituent(null, acid);
            return true;
        }
    }

    static class Oxide
    extends PrettyRewriter {
        Oxide() {
        }

        @Override
        boolean rewrite() {
            StructureToken s1 = this.structure();
            if (!(s1 != null && this.name(" ") && this.name("peroxide") && this.name(" "))) {
                return false;
            }
            StructureToken s2 = this.structure();
            if (s2 == null) {
                return false;
            }
            StructureToken oxide = (StructureToken)this.get(2);
            oxide.addSubstituent(null, s1);
            oxide.addSubstituent(null, s2);
            s1.setSpaceSeparated(true);
            s2.setSpaceSeparated(true);
            int i = this.current;
            while (--i >= 0) {
                if (i == 2) continue;
                this.remove(i);
            }
            return true;
        }
    }

    static class MultipliedStructure
    extends PrettyRewriter {
        MultipliedStructure() {
        }

        @Override
        boolean rewrite() {
            if (this.insideBrackets) {
                return false;
            }
            if (!this.atBeginningOrAfterSpace()) {
                return false;
            }
            int mul = this.multiplier();
            if (mul == -1) {
                return false;
            }
            StructureToken st = this.structure();
            if (st == null) {
                return false;
            }
            if (st.substituents != null) {
                return false;
            }
            if (!this.atEndOrBeforeSpace()) {
                return false;
            }
            this.remove(0);
            this.remove(0);
            Structure s = RevolutionParser.structure(st);
            s.multiplicity = mul;
            AggregateStructure a = new AggregateStructure(Arrays.asList(s));
            this.add(0, new StructureToken(a));
            return true;
        }
    }

    static class MultipliedSystemRewriter
    extends Rewriter {
        MultipliedSystemRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() != 4) {
                return false;
            }
            if (!(tokens.get(0) instanceof LocantList)) {
                return false;
            }
            LocantList locants = (LocantList)tokens.get(0);
            if (!RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-")) {
                return false;
            }
            int multiplier = RevolutionParser.multiplier(RevolutionParser.get(tokens, 2));
            if (multiplier == -1) {
                return false;
            }
            if (locants.size() != multiplier) {
                return false;
            }
            StructureToken parent = RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, 3));
            if (parent == null || parent.substituents != null) {
                return false;
            }
            MultipliedSystem s = new MultipliedSystem(multiplier, RevolutionParser.structure(parent), locants);
            for (int i = 3; i >= 0; --i) {
                tokens.remove(i);
            }
            tokens.add(0, new StructureToken(s));
            return true;
        }
    }

    static class Benzo
    extends PrettyRewriter {
        Benzo() {
        }

        @Override
        boolean rewrite() {
            StructureToken s = this.structure();
            if (s == null || !s.is("benz")) {
                return false;
            }
            if (!this.name("o")) {
                return false;
            }
            this.remove(1);
            s.setValue("Cc1ccccc1 |$1;;2;3;4;5;6;$|");
            return true;
        }
    }

    static class ThiolBreaker
    extends Rewriter {
        ThiolBreaker() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (RevolutionParser.name(tokens, 0, "thiole")) {
                tokens.remove(0);
                tokens.add(0, new StructureToken("thi", "S"));
                tokens.add(1, new EndingToken("ol", "O"));
                return true;
            }
            return false;
        }
    }

    static class Poly
    extends PrettyRewriter {
        Poly() {
        }

        @Override
        boolean rewrite() {
            if (!this.name("poly")) {
                return false;
            }
            BracketToken b = this.bracket();
            if (b == null || b.inside.size() != 1) {
                return false;
            }
            this.remove(1);
            this.remove(0);
            this.add(0, b.inside.get(0));
            N2S.getState().warnApproximation("Polymer not represented");
            return true;
        }
    }

    static class BracketRemover
    extends PrettyRewriter {
        BracketRemover() {
        }

        @Override
        boolean rewrite() {
            BracketToken b = this.bracket();
            if (b == null) {
                return false;
            }
            if (b.inside.size() != 1) {
                return false;
            }
            Token t = b.inside.get(0);
            if (!(t instanceof EndingToken)) {
                return false;
            }
            this.remove(0);
            this.add(0, t);
            return true;
        }
    }

    static class MonoRemover
    extends PrettyRewriter {
        MonoRemover() {
        }

        @Override
        boolean rewrite() {
            if (this.name("mono")) {
                if (this.name("anhydride")) {
                    throw new NameImportException.ParseException("monoanhydride not supported yet");
                }
                this.remove(0);
                return true;
            }
            return false;
        }
    }

    static class NbSpRemover
    extends Rewriter {
        NbSpRemover() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (RevolutionParser.sep(RevolutionParser.get(tokens, 0), RevolutionParser.nbsp)) {
                if (this.before instanceof LocantList && ((LocantList)this.before).isAllNumGreek()) {
                    return false;
                }
                tokens.remove(0);
                return true;
            }
            return false;
        }
    }

    static class MultiplierDashRemover
    extends Rewriter {
        MultiplierDashRemover() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() < 3) {
                return false;
            }
            if (!RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-") || !(RevolutionParser.get(tokens, 2) instanceof StructureToken)) {
                return false;
            }
            if (RevolutionParser.multiplier(RevolutionParser.get(tokens, 0)) != -1) {
                tokens.remove(1);
                return true;
            }
            return false;
        }
    }

    static class DashRemover
    extends BackwardsRewriter {
        DashRemover() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() < 3) {
                return false;
            }
            if (!RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-")) {
                return false;
            }
            Token after = RevolutionParser.get(tokens, 2);
            if (!(after instanceof StructureToken) && !(after instanceof EndingToken)) {
                return false;
            }
            if (RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, 0)) != null) {
                tokens.remove(1);
                return true;
            }
            return false;
        }
    }

    static class EndingAsStructure
    extends Rewriter {
        EndingAsStructure() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!(RevolutionParser.get(tokens, 0) instanceof EndingToken)) {
                return false;
            }
            EndingToken ending = (EndingToken)RevolutionParser.get(tokens, 0);
            if (ending.getType() == 2) {
                tokens.remove(0);
                StructureToken s = new StructureToken(ending.getName(), ending.getValue());
                tokens.add(0, s);
                return true;
            }
            return false;
        }
    }

    static class EthyleneGlycol
    extends PrettyRewriter {
        EthyleneGlycol() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean rewrite() {
            String atom;
            int num = this.multiplier();
            if (num == -1) {
                num = 1;
            }
            if (!this.name("eth") || !this.name("ylene")) {
                return false;
            }
            if (this.name(" ")) {
                if (!this.name("glycol")) return false;
                atom = "O";
            } else {
                int mulAmine = this.multiplier();
                if (mulAmine == -1 || !this.name("amine")) return false;
                if (mulAmine != num + 1) {
                    throw new NameImportException.ParseException("Invalid ethylene");
                }
                atom = "N";
            }
            String name = this.removeAllAndGetName();
            String struc = atom;
            while (num-- > 0) {
                struc = struc + "CC" + atom;
            }
            StructureToken s = new StructureToken(name, struc);
            this.add(0, s);
            return true;
        }
    }

    static class MethyleneSuffix
    extends PrettyRewriter {
        MethyleneSuffix() {
        }

        @Override
        boolean rewrite() {
            StructureToken methylene = this.structure();
            if (methylene == null || !methylene.nameEndsWith("methylene")) {
                return false;
            }
            this.optional(this.name(" "));
            StructureToken suffix = this.structure();
            if (suffix == null) {
                return false;
            }
            String value = RevolutionParser.structure(suffix).getMolecule().toFormat("smiles");
            Suffix s = SuffixFactory.createSuffix(value, suffix.getName(), (LocantList)null, 1, -1);
            methylene.addSuffix(s);
            int i = this.current;
            while (--i > 0) {
                this.remove(i);
            }
            return true;
        }
    }

    static class Methylene
    extends PrettyRewriter {
        Methylene() {
        }

        @Override
        boolean rewrite() {
            int num = this.multiplier();
            if (num == -1) {
                return false;
            }
            if (!this.name("meth")) {
                return false;
            }
            if (!this.name("ylene")) {
                return false;
            }
            String name = this.removeAllAndGetName();
            String struc = "";
            while (num-- > 0) {
                struc = struc + "C";
            }
            StructureToken methylene = new StructureToken(name, struc);
            this.add(0, methylene);
            this.current = 1;
            if (this.name(" ") && this.name("glycol")) {
                this.remove(2);
                this.remove(1);
                methylene.addSuffix(SuffixFactory.createSuffix("O", "glycol", (LocantList)null, 2, -1));
            }
            return true;
        }
    }

    static class HeteroChainRewriter
    extends PrettyRewriter {
        HeteroChainRewriter() {
        }

        @Override
        boolean rewrite() {
            int mul = this.multiplier();
            if (mul == -1) {
                return false;
            }
            StructureToken atom1 = this.structureNoBracket();
            if (!ParserUtil.isHeteroChainAtom(atom1)) {
                return false;
            }
            StructureToken atom2 = this.structureNoBracket();
            if (atom2 != null && !ParserUtil.isHeteroChainAtom(atom2)) {
                atom2 = null;
                --this.current;
            }
            String name1 = atom1.getName();
            if (atom2 == null && (name1.endsWith("ane") || name1.endsWith("an"))) {
                LocantList locants;
                if (this.get(-2) instanceof LocantList && (locants = (LocantList)this.get(-2)).size() == 2 && !(locants.getLocant(0) instanceof NonStdValenceLocant)) {
                    return false;
                }
            } else {
                if (ParserUtil.isVIAAtom(atom1.getValue())) {
                    return false;
                }
                if (!(atom2 != null && atom2.getName().endsWith("ane") || this.peek(this.name("ane")) || this.peek(this.name("ene")) || atom1.hasSuffix("ane") || atom1.hasSuffix("ene"))) {
                    return false;
                }
            }
            for (int i = this.current - 1; i >= 0; --i) {
                this.remove(i);
            }
            HeteroChain h = atom2 == null ? new HeteroChain(atom1.getValue(), mul) : new HeteroChain(atom2.getValue(), atom1.getValue(), mul);
            h.addSuffix((atom2 != null ? atom2 : atom1).suffixes);
            this.add(0, new StructureToken(h));
            return true;
        }
    }

    static class NumberAsChain
    extends Rewriter {
        NumberAsChain() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            Token t = tokens.get(0);
            int num = RevolutionParser.multiplier(t);
            if (num == -1 || num < 5) {
                return false;
            }
            if (!this.canFollowParent(num, tokens, 1)) {
                return false;
            }
            tokens.remove(0);
            String struc = "";
            while (num-- > 0) {
                struc = struc + "C";
            }
            tokens.add(0, new StructureToken(t.getName(), struc));
            return true;
        }

        private boolean canFollowParent(int num, List<Token> tokens, int cur) {
            LocantList locants;
            Token next = RevolutionParser.get(tokens, cur);
            String name = next.getName();
            if (name.equals("oic acid") || name.equals("amide") || name.equals("oate") || next instanceof Number) {
                return true;
            }
            return RevolutionParser.sep(next, "-") && RevolutionParser.get(tokens, cur + 1) instanceof LocantList && (locants = (LocantList)RevolutionParser.get(tokens, cur + 1)).size() != num;
        }
    }

    static class MultipliedAcid
    extends PrettyRewriter {
        MultipliedAcid() {
        }

        @Override
        boolean rewrite() {
            int i;
            int mul = this.multiplier();
            StructureToken acid = this.structure();
            if (mul == -1 || acid == null || !acid.isAcid()) {
                return false;
            }
            if (!acid.is("phosphate")) {
                return false;
            }
            String acidSmi = "P(=O)([O-])O";
            StringBuilder smiles = new StringBuilder("[O-]");
            int i2 = mul;
            while (--i2 >= 0) {
                smiles.append(acidSmi);
            }
            smiles.deleteCharAt(smiles.length() - 1);
            smiles.append("[O-]");
            String spaceAttach = "{SpaceAttach:99 ";
            smiles.append(" |$99;");
            int sp = mul + 2;
            for (i = 0; i < 2 * mul; i += 2) {
                String s = ";;" + sp + ";";
                if (i == 0) {
                    s = "1" + s;
                }
                smiles.append(s);
                if (i + 2 < 2 * mul) {
                    smiles.append(";");
                }
                spaceAttach = spaceAttach + sp-- + " ";
            }
            smiles.append(sp);
            spaceAttach = spaceAttach + sp + "}";
            smiles.append("$|").append(spaceAttach);
            acid.setValue(smiles.toString());
            i = this.current - 1;
            while (--i >= 0) {
                this.remove(i);
            }
            return true;
        }
    }

    static class Hydrogen
    extends PrettyRewriter {
        Hydrogen() {
        }

        @Override
        boolean rewrite() {
            int mulH = this.multiplier();
            if (mulH == -1 || !this.name("hydrogen") || !this.name(" ")) {
                return false;
            }
            int removeStart = this.current;
            this.optional(this.multiplier());
            StructureToken acid = this.structure();
            if (acid == null) {
                return false;
            }
            StructureToken h = new StructureToken("hydro", "[H+]").cloneMe();
            h.setSpaceSeparated(true);
            int i = mulH;
            while (--i >= 0) {
                acid.addSubstituent(null, h.cloneMe());
            }
            i = removeStart;
            while (--i >= 0) {
                this.remove(i);
            }
            return true;
        }
    }

    static class Lambda
    extends PrettyRewriter {
        Lambda() {
        }

        @Override
        boolean rewrite() {
            LocantList locants = this.locants();
            if (locants == null || locants.size() != 1) {
                return false;
            }
            if (!(locants.getLocant(0) instanceof NonStdValenceLocant)) {
                return false;
            }
            StructureToken s = this.structure();
            if (s == null) {
                return false;
            }
            if (!s.hasLocants(locants)) {
                return false;
            }
            if (!s.addLocantsBefore(locants)) {
                return false;
            }
            int i = this.current - 1;
            while (--i >= 0) {
                this.remove(i);
            }
            return true;
        }
    }

    static class Ion
    extends PrettyRewriter {
        Ion() {
        }

        @Override
        boolean rewrite() {
            String value;
            if (!(this.get(0) instanceof StructureToken)) {
                return false;
            }
            StructureToken parent = (StructureToken)this.get(0);
            if (!(this.get(1) instanceof BracketToken)) {
                return false;
            }
            BracketToken b = (BracketToken)this.get(1);
            if (b.inside.size() != 1 || !(b.inside.get(0) instanceof LocantList)) {
                return false;
            }
            LocantList l = (LocantList)b.inside.get(0);
            if (l.getType() != 4) {
                return false;
            }
            int charge = l.getLocant(0).getValue();
            if (charge < 0) {
                value = "-";
                charge = -charge;
            } else {
                value = "+";
            }
            Suffix ion = new Suffix(value, null, charge, 7, 1);
            ion.setName("ion");
            parent.addSuffix(ion);
            this.remove(1);
            if (RevolutionParser.sep(this.get(1), " ") && this.name(2, "ion")) {
                this.remove(2);
                this.remove(1);
            }
            return true;
        }
    }

    static class SuffixWithHydro
    extends Rewriter {
        SuffixWithHydro() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!(RevolutionParser.get(tokens, 0) instanceof StructureToken && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-") && RevolutionParser.get(tokens, 2) instanceof Hydro)) {
                return false;
            }
            StructureToken parent = (StructureToken)RevolutionParser.get(tokens, 0);
            if (parent.suffixes != null || !parent.isCyclic()) {
                return false;
            }
            int lastHydro = 2;
            while (RevolutionParser.get(tokens, lastHydro + 1) instanceof Hydro) {
                ++lastHydro;
            }
            if (!(RevolutionParser.get(tokens, lastHydro + 1) instanceof LocantList || RevolutionParser.sep(RevolutionParser.get(tokens, lastHydro + 1), "-") && RevolutionParser.get(tokens, lastHydro + 2) instanceof LocantList)) {
                return false;
            }
            if (RevolutionParser.sep(RevolutionParser.get(tokens, lastHydro + 1), "-")) {
                tokens.remove(lastHydro + 1);
            }
            for (int i = 2; i <= lastHydro; ++i) {
                Hydro hydro = (Hydro)tokens.remove(2);
                parent.addHydro(hydro);
            }
            return true;
        }
    }

    static class MultipliedStructureAfter
    extends Rewriter {
        MultipliedStructureAfter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            boolean toParentSubstituents;
            int multiplier;
            StructureToken parent;
            int start = 0;
            LocantList locants = null;
            LocantList secondLocants = null;
            if (RevolutionParser.get(tokens, 0) instanceof LocantList && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-")) {
                locants = (LocantList)RevolutionParser.get(tokens, 0);
                if (locants.isStereo()) {
                    return false;
                }
                start = 2;
            }
            if (RevolutionParser.get(tokens, start) instanceof LocantList && RevolutionParser.sep(RevolutionParser.get(tokens, start + 1), "-")) {
                secondLocants = (LocantList)RevolutionParser.get(tokens, start);
                start += 2;
            }
            if ((parent = RevolutionParser.structureMaybeInBrackets(tokens.get(start))) == null) {
                if (RevolutionParser.name(tokens, start, "di") && RevolutionParser.name(tokens, start + 1, "thio")) {
                    if (secondLocants == null) {
                        secondLocants = LocantList.simpleList(1, 2);
                    }
                    parent = (StructureToken)tokens.get(start + 1);
                    parent.setValue("SS");
                    ++start;
                } else {
                    return false;
                }
            }
            if (secondLocants == null && RevolutionParser.sep(RevolutionParser.get(tokens, start + 1), "-") && RevolutionParser.get(tokens, start + 2) instanceof LocantList && RevolutionParser.sep(RevolutionParser.get(tokens, start + 3), "-")) {
                secondLocants = (LocantList)RevolutionParser.get(tokens, start + 2);
                start += 3;
            }
            if ((multiplier = RevolutionParser.multiplier(RevolutionParser.get(tokens, start + 1))) == -1) {
                return false;
            }
            int multiplierYl = -1;
            if (RevolutionParser.name(tokens, start + 2, "yl")) {
                multiplierYl = multiplier;
                multiplier = RevolutionParser.multiplier(RevolutionParser.get(tokens, (start += 2) + 1));
                if (multiplier == -1) {
                    return false;
                }
            }
            if (this.pass == 0 && multiplierYl == -1 && locants == null) {
                return false;
            }
            String multiplierString = RevolutionParser.get(tokens, start + 1).toString();
            StructureToken after = RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, start + 2));
            if (after == null) {
                return false;
            }
            if (secondLocants != null && (secondLocants = secondLocants.expandOMP(multiplier)).size() != multiplier) {
                return false;
            }
            if (locants != null && multiplier != (locants = locants.expandOMP(multiplier)).size()) {
                return false;
            }
            for (int i = start + 2; i >= 0; --i) {
                tokens.remove(i);
            }
            tokens.add(0, parent);
            if (parent.getName().equals("ethylene")) {
                parent.setValue("CC");
            }
            parent.removeSuffix("ylene");
            parent.setName(parent.getName() + multiplierString);
            Suffix yl = null;
            if ((multiplierYl != -1 || after.is("oxy") || after.is("acetonitrile")) && secondLocants == null) {
                secondLocants = locants;
                locants = null;
            }
            if (secondLocants == null && locants != null && locants.isOrthoMetaPara()) {
                secondLocants = locants;
                locants = null;
            }
            boolean bl = toParentSubstituents = parent.substituents != null && parent.substituents.size() == multiplier;
            if (secondLocants == null) {
                Suffix parentYl = parent.getSuffix("yl");
                if (parentYl != null && parentYl.hasLocant() && parentYl.getLocant().size() == multiplier) {
                    secondLocants = parentYl.getLocant();
                    parent.suffixes.remove(parentYl);
                    toParentSubstituents = false;
                } else {
                    int i;
                    parentYl = parent.getSuffix("ylidene");
                    if (parentYl != null) {
                        if (!parentYl.hasLocant() || parentYl.getLocant().size() * 2 == multiplier) {
                            if (!parentYl.hasLocant()) {
                                secondLocants = LocantList.simpleList(1, 1);
                            } else {
                                secondLocants = new LocantList();
                                for (Locant l : parentYl.getLocant().getLocantsList()) {
                                    for (i = 0; i < 2; ++i) {
                                        secondLocants.addLocant(l);
                                    }
                                }
                            }
                            parent.suffixes.remove(parentYl);
                            toParentSubstituents = false;
                        }
                    } else {
                        parentYl = parent.getSuffix("ylidyne");
                        if (!(parentYl == null || parentYl.hasLocant() && parentYl.getLocant().size() * 3 != multiplier)) {
                            if (!parentYl.hasLocant()) {
                                secondLocants = LocantList.simpleList(1, 1);
                                secondLocants.tryAddLocant(new SimpleLocant(1));
                            } else {
                                secondLocants = new LocantList();
                                for (Locant l : parentYl.getLocant().getLocantsList()) {
                                    for (i = 0; i < 3; ++i) {
                                        secondLocants.addLocant(l);
                                    }
                                }
                            }
                            parent.suffixes.remove(parentYl);
                            toParentSubstituents = false;
                        }
                    }
                }
            }
            for (int i = 0; i < multiplier; ++i) {
                after = after.cloneMe();
                Locant l = null;
                if (locants != null) {
                    if (yl != null) {
                        after.suffixes.remove(yl);
                    }
                    yl = SuffixFactory.createSuffix("|", "yl", locants.getLocant(i), 1, 2);
                    after.addSuffix(yl);
                }
                if (secondLocants != null) {
                    l = secondLocants.getLocant(i);
                }
                if (toParentSubstituents) {
                    StructureToken sub = parent.substituents.get(i);
                    sub.removeSuffix("ylene");
                    sub.addSubstituent(l, after);
                    continue;
                }
                parent.addSubstituent(l, after);
            }
            return true;
        }
    }

    static class AcidStructureEndingRewriter
    extends Rewriter {
        AcidStructureEndingRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() < 2) {
                return false;
            }
            if (!(RevolutionParser.get(tokens, 0) instanceof StructureToken) || !(RevolutionParser.get(tokens, 1) instanceof StructureToken)) {
                return false;
            }
            StructureToken parent = (StructureToken)tokens.get(0);
            StructureToken ending = (StructureToken)tokens.get(1);
            if (!parent.isCyclic()) {
                return false;
            }
            if (!ending.getName().endsWith(" acid")) {
                return false;
            }
            Suffix acid = new Suffix(ending.getValue(), null, 1, 0, 1);
            acid.setName(ending.getName());
            parent.addSuffix(acid);
            tokens.remove(1);
            return true;
        }
    }

    static class AtomModifierRewriter
    extends PrettyRewriter {
        AtomModifierRewriter() {
        }

        @Override
        boolean rewrite() {
            StructureToken atom = this.structure();
            if (this.name("-") && !this.name(RevolutionParser.nbsp)) {
                return false;
            }
            StructureToken parent = this.structure();
            if (atom == null || parent == null) {
                return false;
            }
            if (this.name(-1, "-") || this.get(-1) instanceof Number) {
                return false;
            }
            if (!(atom.is("thio") || atom.is("seleno") || atom.is("telluro"))) {
                return false;
            }
            parent.addSubstituent(null, atom);
            int i = this.current - 1;
            while (--i >= 0) {
                this.remove(i);
            }
            return true;
        }
    }

    static class OxyRewriter
    extends Rewriter {
        OxyRewriter() {
        }

        boolean isOxyUnit(List<Token> tokens) {
            if (RevolutionParser.name(tokens, 0, "meth") && RevolutionParser.name(tokens, 1, "oxy")) {
                return true;
            }
            return RevolutionParser.name(tokens, 0, "thi") && RevolutionParser.name(tokens, 1, "oxo");
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() < 2) {
                return false;
            }
            if (RevolutionParser.name(tokens, 0, "carbo") && RevolutionParser.name(tokens, 1, "meth") && RevolutionParser.name(tokens, 2, "oxy")) {
                StructureToken oxy = (StructureToken)tokens.get(2);
                oxy.setValue("COC=O |$;;1;;$|");
                oxy.setName("carbomethoxy");
                tokens.remove(1);
                tokens.remove(0);
                return true;
            }
            if (this.isOxyUnit(tokens)) {
                StructureToken sub = (StructureToken)tokens.remove(0);
                ((StructureToken)tokens.get(0)).addSubstituent(null, sub);
                return true;
            }
            return false;
        }
    }

    static class Carbox
    extends Rewriter {
        Carbox() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (RevolutionParser.name(tokens, 0, "carbox") && RevolutionParser.get(tokens, 1) instanceof EndingToken) {
                EndingToken acid = (EndingToken)tokens.get(1);
                if (acid.getType() != 2) {
                    return false;
                }
                if (acid.getValue().indexOf("Radical:") != -1) {
                    acid.setValue(acid.getValue().replaceAll("Radical:[ ]*0", "Radical:1"));
                }
                tokens.remove(0);
                return true;
            }
            return false;
        }
    }

    static class AcidAmide
    extends Rewriter {
        AcidAmide() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int i;
            Token acid = tokens.get(0);
            if (!acid.getName().endsWith("ic acid")) {
                return false;
            }
            if (!RevolutionParser.sep(RevolutionParser.get(tokens, 1), " ")) {
                return false;
            }
            int cur = 2;
            int mul = RevolutionParser.multiplier(RevolutionParser.get(tokens, cur));
            if (mul == -1) {
                mul = 1;
            } else {
                ++cur;
            }
            if (!RevolutionParser.name(tokens, cur, "amide")) {
                return false;
            }
            String value = acid.getValue();
            for (i = 0; i < mul; ++i) {
                if (value.startsWith("O") && !value.startsWith("O=")) {
                    value = "N" + value.substring(1);
                    continue;
                }
                if (value.matches(".*([^=])O.*")) {
                    value = value.replaceFirst("([^=])O", "$1N");
                    continue;
                }
                return false;
            }
            acid.setValue(value);
            acid.setName(acid.getName() + " amide");
            for (i = cur; i > 0; --i) {
                tokens.remove(i);
            }
            return true;
        }
    }

    static class Tolyl
    extends Rewriter {
        Tolyl() {
            this.removeDashBefore = true;
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!(tokens.get(0) instanceof LocantList)) {
                return false;
            }
            LocantList locant = (LocantList)tokens.get(0);
            if (!locant.isOrthoMetaPara()) {
                return false;
            }
            if (!RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-") || !RevolutionParser.name(tokens, 2, "tol")) {
                return false;
            }
            StructureToken tolyl = (StructureToken)tokens.get(2);
            if (!tolyl.addLocantsBefore(locant)) {
                return false;
            }
            tokens.remove(1);
            tokens.remove(0);
            return true;
        }
    }

    static class AcidModifier
    extends PrettyRewriter {
        AcidModifier() {
        }

        @Override
        boolean rewrite() {
            int mul = RevolutionParser.multiplier(this.get(-1));
            if (mul != -1) {
                return false;
            }
            StructureToken modifier = this.hetero();
            StructureToken acid = this.structureNoBracket();
            if (modifier == null || acid == null) {
                return false;
            }
            if (modifier.substituents != null) {
                return false;
            }
            if (!acid.isAcid()) {
                return false;
            }
            if (acid.firstAtomSubstituable()) {
                return false;
            }
            if (!acid.replaceLastO(modifier.getValue())) {
                return false;
            }
            this.remove(0);
            return true;
        }
    }

    static class DetachedSubstituent
    extends PrettyRewriter {
        DetachedSubstituent() {
        }

        @Override
        boolean rewrite() {
            StructureToken parent = this.structure();
            if (!this.name(" ")) {
                return false;
            }
            LocantList locants = this.locants();
            StructureToken sub = this.structure();
            if (parent == null || sub == null || locants == null) {
                return false;
            }
            if (parent.hasSuffix("yl")) {
                return false;
            }
            SimpleLocant locant = locants.getSimpleLocant();
            if (locant == null) {
                return false;
            }
            if (!this.eol() && !this.peek(this.name(" "))) {
                return false;
            }
            parent.addSubstituent(locant, sub);
            int i = this.current;
            while (--i > 0) {
                this.remove(i);
            }
            return true;
        }
    }

    static class DetachedSuffix
    extends Rewriter {
        DetachedSuffix() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int mul;
            if (RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, 0)) == null || !RevolutionParser.sep(RevolutionParser.get(tokens, 1), " ")) {
                return false;
            }
            LocantList locants = null;
            int cur = 2;
            if (RevolutionParser.get(tokens, 2) instanceof LocantList && RevolutionParser.sep(RevolutionParser.get(tokens, 3), "-")) {
                locants = (LocantList)tokens.get(2);
                cur = 4;
            }
            if ((mul = RevolutionParser.multiplier(RevolutionParser.get(tokens, cur))) == -1) {
                mul = 1;
            } else {
                ++cur;
            }
            if (RevolutionParser.get(tokens, cur) instanceof EndingToken) {
                EndingToken ending = (EndingToken)tokens.get(cur);
                for (int i = cur; i > 0; --i) {
                    tokens.remove(i);
                }
                StructureToken parent = RevolutionParser.structureMaybeInBrackets(tokens.get(0));
                Suffix suffix = RevolutionParser.suffix(ending, locants, mul);
                suffix.setSpaceSeparated(true);
                parent.addSuffix(suffix);
                return true;
            }
            return false;
        }
    }

    static class Phosphoro
    extends Rewriter {
        Phosphoro() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int i;
            String ending;
            if (!RevolutionParser.name(tokens, 0, "phosphoro")) {
                return false;
            }
            int mul = RevolutionParser.multiplier(RevolutionParser.get(tokens, 1));
            if (mul == -1) {
                return false;
            }
            if (!(RevolutionParser.get(tokens, 2) instanceof StructureToken)) {
                return false;
            }
            StructureToken atom = (StructureToken)RevolutionParser.get(tokens, 2);
            if (!atom.isMonoAtomic()) {
                return false;
            }
            int max = 3;
            if (RevolutionParser.name(tokens, 3, "ite")) {
                ending = " |$0;0;0;0;$|";
            } else if (RevolutionParser.name(tokens, 3, "id") && RevolutionParser.name(tokens, 4, "ite")) {
                ending = "  |$0;0;0;0;$|";
                max = 4;
            } else if (RevolutionParser.name(tokens, 3, "ate")) {
                ending = "=O  |$0;0;0;0;$|";
            } else if (RevolutionParser.name(tokens, 3, "id") && RevolutionParser.name(tokens, 4, "ate")) {
                ending = "=O  |$0;0;0;0;$|";
                max = 4;
            } else {
                return false;
            }
            String name = tokens.get(0).toString() + tokens.get(1) + tokens.get(2) + tokens.get(max);
            for (int i2 = max; i2 >= 0; --i2) {
                tokens.remove(i2);
            }
            String s = "P";
            for (i = 0; i < mul; ++i) {
                s = s + "([" + atom.getValue() + "])";
            }
            for (i = mul; i < 3; ++i) {
                s = s + "(O)";
            }
            s = s + ending;
            tokens.add(0, new StructureToken(name, s));
            return true;
        }
    }

    static class Biphenyl
    extends Rewriter {
        Biphenyl() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!RevolutionParser.name(tokens, 0, "bi")) {
                return false;
            }
            if (RevolutionParser.name(tokens, 1, "phen") && RevolutionParser.name(tokens, 2, "yl")) {
                StructureToken biphenyl = (StructureToken)tokens.get(1);
                tokens.remove(2);
                tokens.remove(0);
                biphenyl.setName("biphenyl");
                biphenyl.setValue("c1ccc(cc1)c1ccccc1 |$4;3;2;1;6;5;1';2';3';4';5';6'$|");
                return true;
            }
            return false;
        }
    }

    static class CasMultiplierAtEnd
    extends Rewriter {
        CasMultiplierAtEnd() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-") || !RevolutionParser.sep(RevolutionParser.get(tokens, 2), RevolutionParser.nbsp)) {
                return false;
            }
            if (tokens.get(0) instanceof LocantList) {
                tokens.remove(2);
                return true;
            }
            if (RevolutionParser.multiplier(tokens.get(0)) != -1) {
                tokens.remove(2);
                tokens.remove(1);
                return true;
            }
            return false;
        }
    }

    static class MultiplierDash
    extends Rewriter {
        MultiplierDash() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (RevolutionParser.multiplier(RevolutionParser.get(tokens, 0)) != -1 && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-")) {
                if (RevolutionParser.get(tokens, 2) instanceof LocantList) {
                    return false;
                }
                tokens.remove(1);
                return true;
            }
            return false;
        }
    }

    static abstract class GlobalRewriter
    extends Rewriter {
        GlobalRewriter() {
        }

        @Override
        boolean rewriteSomewhere(List<Token> tokens) {
            this.before = null;
            return this.rewrite(tokens);
        }
    }

    static abstract class BackwardsRewriter
    extends Rewriter {
        BackwardsRewriter() {
        }

        @Override
        boolean rewriteSomewhere(List<Token> tokens) {
            int i = tokens.size() - 1;
            while (--i >= 1) {
                this.before = tokens.get(i - 1);
                if (!this.rewrite(tokens.subList(i, tokens.size()))) continue;
                return true;
            }
            this.before = null;
            return this.rewrite(tokens);
        }
    }

    static abstract class PrettyRewriter
    extends Rewriter {
        private List<Token> tokens;
        private int currentStart;
        int current;

        PrettyRewriter() {
        }

        abstract boolean rewrite();

        @Override
        public String toString() {
            return this.tokens.toString() + " [start=" + this.currentStart + "]";
        }

        int length() {
            return this.tokens.size() - this.currentStart;
        }

        Token get(int offset) {
            if ((offset += this.currentStart) < 0 || offset >= this.tokens.size()) {
                return null;
            }
            return this.tokens.get(offset);
        }

        Token remove(int offset) {
            return this.tokens.remove(this.currentStart + offset);
        }

        List<Token> tokens() {
            return this.tokens.subList(this.currentStart, this.tokens.size());
        }

        List<Token> remainingTokens() {
            return this.tokens.subList(this.currentStart + this.current, this.tokens.size());
        }

        String removeAllAndGetName() {
            return RevolutionParser.removeAndGetName(this.tokens(), 0, this.current - 1);
        }

        boolean name(String name) {
            if (this.name(this.current, name)) {
                ++this.current;
                return true;
            }
            return false;
        }

        boolean name(int offset, String name) {
            return RevolutionParser.name(this.get(offset), name, false);
        }

        int multiplier() {
            int res = RevolutionParser.multiplier(this.get(this.current));
            if (res != -1) {
                ++this.current;
            }
            return res;
        }

        boolean peek(boolean res) {
            if (res) {
                --this.current;
            }
            return res;
        }

        boolean peek(Token t) {
            return this.peek(t != null);
        }

        boolean optional(Object o) {
            return true;
        }

        boolean eol() {
            return this.current + this.currentStart == this.tokens.size();
        }

        boolean atBeginningOrAfterSpace() {
            return this.get(-1) == null || this.name(-1, " ");
        }

        boolean atEndOrBeforeSpace() {
            return this.get(this.current) == null || this.name(this.current, " ");
        }

        void add(int offset, Token t) {
            this.tokens.add(this.currentStart + offset, t);
        }

        void set(int offset, Token t) {
            this.tokens.set(this.currentStart + offset, t);
        }

        LocantList fusion() {
            if (!(this.get(this.current) instanceof LocantList)) {
                return null;
            }
            LocantList res = (LocantList)this.get(this.current);
            if (res.getType() != 5) {
                return null;
            }
            ++this.current;
            return res;
        }

        LocantList simpleLocants() {
            int oldCurrent = this.current;
            LocantList res = this.locants(false, false);
            if (RevolutionParser.simpleLocants(res)) {
                return res;
            }
            this.current = oldCurrent;
            return null;
        }

        LocantList locants() {
            return this.locants(true, false);
        }

        LocantList locants(boolean allowBrackets, boolean allowNbSp) {
            if (this.get(this.current) instanceof LocantList) {
                Token next = this.get(this.current + 1);
                if (RevolutionParser.sep(next, "-") || RevolutionParser.sep(next, RevolutionParser.nbsp)) {
                    this.current += 2;
                    return (LocantList)this.get(this.current - 2);
                }
                return null;
            }
            if (allowBrackets) {
                return this.bracketedLocants();
            }
            return null;
        }

        LocantList bracketedLocants() {
            if (this.get(this.current) instanceof BracketToken) {
                BracketToken b = (BracketToken)this.get(this.current);
                if (b.inside.size() == 1 && b.inside.get(0) instanceof LocantList) {
                    ++this.current;
                    return (LocantList)b.inside.get(0);
                }
            }
            return null;
        }

        StructureToken structure() {
            StructureToken res = RevolutionParser.structureMaybeInBrackets(this.get(this.current));
            if (res != null) {
                ++this.current;
            }
            return res;
        }

        StructureToken structureNoBracket() {
            Token t = this.get(this.current);
            if (t instanceof StructureToken) {
                ++this.current;
                return (StructureToken)t;
            }
            return null;
        }

        StructureToken hetero() {
            Token t = this.get(this.current);
            if (!RevolutionParser.hetero(t)) {
                return null;
            }
            ++this.current;
            return (StructureToken)t;
        }

        EndingToken ending() {
            Token t = this.get(this.current);
            if (t instanceof EndingToken) {
                ++this.current;
                return (EndingToken)t;
            }
            return null;
        }

        BracketToken bracket() {
            Token t = this.get(this.current);
            if (t instanceof BracketToken) {
                return (BracketToken)t;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean rewriteSomewhere(List<Token> tokens) {
            List<Token> previousTokens = this.tokens;
            int previousCurrentStart = this.currentStart;
            int previousCurrent = this.current;
            try {
                this.tokens = tokens;
                int i = 0;
                while (i < tokens.size()) {
                    this.currentStart = i++;
                    this.current = 0;
                    if (!this.rewrite()) continue;
                    if (this.removeSpaceBefore && this.name(-1, " ")) {
                        this.remove(-1);
                    }
                    if (this.removeDashBefore && this.name(-1, "-") && RevolutionParser.beforeDash(this.get(-2))) {
                        this.remove(-1);
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.tokens = previousTokens;
                this.currentStart = previousCurrentStart;
                this.current = previousCurrent;
            }
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            throw new NameImportException.Failure("Not used in PrettyRewriter");
        }
    }

    static abstract class Rewriter {
        int pass = -1;
        static int applications = 0;
        Token before;
        boolean insideBrackets;
        boolean removeDashBefore = false;
        boolean removeSpaceBefore = false;
        Structure outsideComponent;

        Rewriter() {
        }

        Rewriter pass(int pass) {
            this.pass = pass;
            return this;
        }

        abstract boolean rewrite(List<Token> var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean rewriteSomewhere(List<Token> tokens, boolean insideBrackets) {
            boolean previousInsideBrackets = this.insideBrackets;
            this.insideBrackets = insideBrackets;
            try {
                boolean bl = this.rewriteSomewhere(tokens);
                return bl;
            }
            finally {
                this.insideBrackets = previousInsideBrackets;
            }
        }

        boolean rewriteSomewhere(List<Token> tokens) {
            this.before = null;
            if (this.rewrite(tokens)) {
                return true;
            }
            for (int i = 1; i < tokens.size(); ++i) {
                this.before = tokens.get(i - 1);
                if (!this.rewrite(tokens.subList(i, tokens.size()))) continue;
                if (this.removeDashBefore && RevolutionParser.sep(this.before, "-") && (i == 1 || RevolutionParser.beforeDash(tokens.get(i - 2)))) {
                    tokens.remove(i - 1);
                }
                if (this.removeSpaceBefore && RevolutionParser.sep(this.before, " ")) {
                    tokens.remove(i - 1);
                }
                return true;
            }
            return false;
        }

        public String getName() {
            return this.getClass().getSimpleName() + (this.pass == -1 ? "" : "(pass " + this.pass + ")");
        }

        public String toString() {
            return this.getName();
        }
    }
}

