/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.calculations.TopologyAnalyser;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StereoNumber;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.naming.n2s.N2S;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class StereoCalculator {
    public static final int STEREO_R = 8;
    public static final int STEREO_S = 16;
    public static final int STEREO_r = 32;
    public static final int STEREO_s = 64;
    public static final int STEREO_E = 64;
    public static final int STEREO_Z = 128;

    public static void setBondStereo(Molecule mol, MolBond bond, int bondStereo) {
        StereoCalculator.addExplicitHydrogen(mol, bond.getAtom1());
        StereoCalculator.addExplicitHydrogen(mol, bond.getAtom2());
        ArrayList<MolAtom> atoms1 = StereoCalculator.getAtomsForBondStereo(mol, bond.getAtom1());
        ArrayList<MolAtom> atoms2 = StereoCalculator.getAtomsForBondStereo(mol, bond.getAtom2());
        mol.dearomatize();
        if (atoms1 == null || atoms2 == null) {
            return;
        }
        for (int i = 0; i < atoms1.size(); ++i) {
            for (int j = 0; j < atoms2.size(); ++j) {
                bond.setStereo2Flags(atoms1.get(i), atoms2.get(j), bondStereo);
                if (mol.getStereo2(bond) != bondStereo) continue;
                return;
            }
        }
    }

    private static ArrayList<MolAtom> getAtomsForBondStereo(Molecule mol, MolAtom atom) {
        if (atom.getBondCount() < 2) {
            return null;
        }
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        for (int i = 0; i < atom.getBondCount(); ++i) {
            if (atom.getBond(i).getType() != 1) continue;
            atoms.add(atom.getBond(i).getOtherAtom(atom));
        }
        return atoms;
    }

    public static MolAtom[][] getAtomsForStereoBond(Molecule mol, MolBond bond) {
        MolAtom atom1 = bond.getAtom1();
        MolAtom atom2 = bond.getAtom2();
        StereoCalculator.addExplicitHydrogen(mol, atom1);
        StereoCalculator.addExplicitHydrogen(mol, atom2);
        if (!mol.canBeCT(mol.indexOf(atom1), mol.indexOf(atom2))) {
            return null;
        }
        MolAtom[] neighours1 = new MolAtom[atom1.getBondCount()];
        int[] indexes1 = new int[atom1.getBondCount()];
        StereoCalculator.getNeigbourAtomsAndIndexes(mol, atom1, neighours1, indexes1);
        MolAtom[] neighours2 = new MolAtom[atom1.getBondCount()];
        int[] indexes2 = new int[atom2.getBondCount()];
        StereoCalculator.getNeigbourAtomsAndIndexes(mol, atom2, neighours2, indexes2);
        MolAtom[][] atoms = new MolAtom[][]{neighours1, neighours2};
        return atoms;
    }

    private static MolAtom addExplicitHydrogen(Molecule mol, MolAtom atom) {
        if (atom.getBondCount() == 1 && atom.getImplicitHcount() > 0) {
            MolAtom a = new MolAtom(1);
            mol.add(a);
            mol.add(new MolBond(a, atom));
            return a;
        }
        return null;
    }

    private static void getNeigbourAtomsAndIndexes(Molecule mol, MolAtom atom, MolAtom[] neighbours, int[] indexes) {
        if (atom.getBondCount() < 1) {
            return;
        }
        for (int i = 0; i < atom.getBondCount(); ++i) {
            neighbours[i] = atom.getBond(i).getOtherAtom(atom);
            indexes[i] = mol.indexOf(neighbours[i]);
        }
    }

    public static boolean setAtomStereo(Molecule mol, int atomindex, StereoNumber stereo) {
        int chirality = stereo.getStereoData();
        boolean success = mol.setChirality(atomindex, chirality);
        if (mol.getChirality(atomindex) != chirality) {
            if (chirality == 32) {
                success = mol.setChirality(atomindex, 8);
            } else if (chirality == 64) {
                success = mol.setChirality(atomindex, 16);
            }
        }
        if (N2S.getState().rel || stereo.relative) {
            mol.getAtom(atomindex).setStereoGroupType(2);
            mol.getAtom(atomindex).setStereoGroupNumber(1);
        }
        return success;
    }

    public static boolean isChiralDataFit(Molecule molecule, ArrayList<Structure.StereoInfo> chiralData) {
        if (chiralData.isEmpty() || !StereoCalculator.isHomogenChiralData(chiralData) || StereoCalculator.isNumbered(chiralData)) {
            return false;
        }
        TopologyAnalyser analyser = new TopologyAnalyser();
        analyser.setMolecule(molecule);
        return analyser.chiralCenterCount() == chiralData.size();
    }

    private static boolean isHomogenChiralData(ArrayList<Structure.StereoInfo> stereoData) {
        int sdata = -1;
        for (Structure.StereoInfo info : stereoData) {
            if (!info.getStereoData().isChiral()) {
                return false;
            }
            if (sdata > 0 && sdata != info.getStereoData().getStereoData()) {
                return false;
            }
            sdata = info.getStereoData().getStereoData();
        }
        return true;
    }

    private static boolean isNumbered(ArrayList<Structure.StereoInfo> stereoData) {
        for (Structure.StereoInfo info : stereoData) {
            if (info.getStereoData().getLocant().getValue() <= 1) continue;
            return true;
        }
        return false;
    }
}

