/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.parse.IUPACParserCore;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Amine;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.ImplicitPolyAcid;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import java.util.ArrayList;

public class AcetateGroup
extends SimpleStructure {
    int chargedAtom = 1;
    boolean needEqualizeCharge = false;
    ArrayList<Structure> possibleIon = new ArrayList();

    public static AcetateGroup create(String value, String name) {
        if (Util.isImplicitPolyAcid(name)) {
            return new ImplicitPolyAcid(value, name);
        }
        return new AcetateGroup(value, name);
    }

    public AcetateGroup(String value, String name) {
        super(value, name);
        if (name.equals("sulfate")) {
            this.needEqualizeCharge = true;
        }
    }

    @Override
    protected void connectSuffixes(ArrayList<Suffix> suffixList) {
        super.connectSuffixes(suffixList);
        for (int i = 0; i < suffixList.size(); ++i) {
            Suffix s = suffixList.get(i);
            LocantList l = s.getLocant();
            this.setAtomCharge(l);
        }
    }

    @Override
    protected void connectLigands(ArrayList<Structure> ligands) {
        super.connectLigands(ligands);
        for (int i = 0; i < this.substituentCount(); ++i) {
            Structure s = (Structure)this.substituentList.get(i);
            LocantList l = s.getLocantInParent();
            this.setAtomCharge(l);
        }
    }

    private void setAtomCharge(LocantList l) {
        if (l == null) {
            return;
        }
        for (int j = 0; j < l.size(); ++j) {
            Locant loc = l.getLocant(j);
            if (!(loc instanceof SimpleLocant) || ((SimpleLocant)loc).getParent() != 0) continue;
            MolAtom atom = this.buildMolecule().getAtom(this.getAtomIndex(((SimpleLocant)loc).getValue()));
            if (atom.getBondCount() > 1) {
                atom.setCharge(0);
            }
            return;
        }
    }

    @Override
    public Structure cloneStructure() {
        AcetateGroup s = new AcetateGroup(this.value, this.name);
        this.cloneProperties(s);
        s.chargedAtom = this.chargedAtom;
        return s;
    }

    @Override
    protected boolean bondNeeded(Structure child, int index1, Molecule parent, int index2) {
        if (this.possibleIon(child)) {
            this.possibleIon.add(child);
            this.needEqualizeCharge = !this.getName().equals("nitrate");
            return false;
        }
        MolAtom atomToConnect = child.getMolecule().getAtom(index1);
        if (this.isSulfate() && Util.isNitrogen(atomToConnect) && atomToConnect.getImplicitHcount() == 0) {
            return false;
        }
        return !(child instanceof AcetateGroup) && !this.isAcid(child) && !this.isCatIon(child) && !this.isAmineParentHydride(child, IUPACParserCore.revolution && this.isSulfate()) && super.bondNeeded(child, index1, parent, index2);
    }

    private boolean isAmineParentHydride(Structure s, boolean hasAmine) {
        if (IUPACParserCore.revolution && hasAmine) {
            if (s.getName().endsWith("ine")) {
                return true;
            }
            for (Suffix suf : s.suffixList) {
                if (!suf.getName().equals("amine")) continue;
                return true;
            }
        }
        if (!(s instanceof Amine)) {
            return false;
        }
        Amine a = (Amine)s;
        return !a.getName().endsWith("o");
    }

    private boolean possibleIon(Structure s) {
        if (!(s instanceof SimpleStructure) || s.getName() == null) {
            return false;
        }
        if (s.getName().endsWith("ium") || s.getName().equals("manganese")) {
            return true;
        }
        SimpleStructure ss = (SimpleStructure)s;
        if (Util.atomCount(ss.getValue()) != 1) {
            return false;
        }
        Molecule mol = s.getMolecule();
        return mol.getAtomCount() == 1 && PeriodicSystem.isMetal(mol.getAtom(0).getAtno());
    }

    private boolean isAcid(Structure struc) {
        for (int i = 0; i < struc.suffixCount(); ++i) {
            if (struc.getSuffix(i).getType() != 0) continue;
            return true;
        }
        return false;
    }

    private boolean isCatIon(Structure struc) {
        if (struc.spaceSeparated) {
            for (int i = 0; i < struc.suffixCount(); ++i) {
                Suffix suff = struc.suffixList.get(i);
                if (suff.getValue().indexOf("+") <= -1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Molecule buildMolecule() {
        if (this.molecule == null) {
            this.removalHydroxyGroups = new ArrayList();
            for (int i = 0; i < this.substituentCount(); ++i) {
                if (!this.getSubstituent(i).isSpaceSeparated()) continue;
                this.removeExtraHydroxyGroup(this.getSubstituent(i), "O", this.removalHydroxyGroups);
            }
            this.molecule = super.buildMolecule();
            if (this.substituentList.isEmpty()) {
                this.needEqualizeCharge = false;
            }
            this.equalizeCharge();
        }
        return this.molecule;
    }

    protected void equalizeCharge() {
        if (!this.needEqualizeCharge) {
            return;
        }
        this.setBasicGroupCharge(this.getMolCharge());
    }

    private int getMolCharge() {
        if (this.molecule == null) {
            return -1;
        }
        int charge = 0;
        for (int i = 0; i < this.molecule.getAtomCount(); ++i) {
            charge += this.molecule.getAtom(i).getCharge();
        }
        return charge;
    }

    private void setBasicGroupCharge(int charge) {
        if (charge >= 0) {
            return;
        }
        if (this.possibleIon.isEmpty()) {
            MolAtom atom = this.molecule.getAtom(this.getAtomIndex(2));
            int atch = atom.getCharge();
            atom.setCharge(0);
            if (charge == -1 && atch != 0) {
                return;
            }
            atom = this.molecule.getAtom(this.getAtomIndex(3));
            atom.setCharge(0);
        } else {
            for (int i = 0; i < -charge; ++i) {
                MolAtom atom = this.possibleIon.get(i % this.possibleIon.size()).getMolecule().getAtom(0);
                boolean isIonAlready = atom.getCharge() != 0;
                atom.setCharge(atom.getCharge() + 1);
                this.molecule.valenceCheck();
                if (!isIonAlready || !atom.hasValenceError()) continue;
                atom.setCharge(atom.getCharge() - 1);
                this.molecule.add((MolAtom)atom.clone());
            }
        }
    }

    @Override
    protected int ImplicitHCount(int parent, int index) {
        Molecule mol = this.getStructure(parent).buildMolecule();
        int atomIndex = this.getAtomIndex(index);
        if (atomIndex >= mol.getAtomCount()) {
            return -1;
        }
        MolAtom atom = mol.getAtom(atomIndex);
        if (Util.isOxygen(atom) && atom.getCharge() == -1) {
            return 1;
        }
        return super.ImplicitHCount(parent, index);
    }

    private boolean isSulfate() {
        return this.value.indexOf("S") > -1;
    }
}

