/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Atom;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.EndingToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Number;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Separator;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StructureToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class AcidGenerator {
    public static String createAcid(ArrayList<Token> tokens, int index, ArrayList<Token> t) {
        HashSet<String> replacements = new HashSet<String>();
        replacements.add("NN");
        replacements.add("OO");
        Token token = index > -1 ? tokens.get(index) : null;
        String value = token.getValue() == "[ACID]" ? "[C:1](O)=O" : token.getValue();
        t.add(0, token);
        String atom = null;
        String atom2 = null;
        String atom3 = null;
        Token token2 = token = --index > -1 ? tokens.get(index) : null;
        if (token != null && token instanceof Separator && ((Separator)token).getType() == 2 && index > 0 && AcidGenerator.canBeAtom(tokens.get(index - 1))) {
            t.add(0, token);
            token = --index > -1 ? tokens.get(index) : null;
            atom = AcidGenerator.getAtomValue(token);
            t.add(0, token);
            Token token3 = token = --index > -1 ? tokens.get(index) : null;
            if (token instanceof Atom) {
                t.add(0, token);
                --index;
            }
            Token token4 = token = index > -1 ? tokens.get(index) : null;
            if (token != null) {
                value = token.getValue();
                t.add(0, token);
                --index;
            }
        }
        Token token5 = token = index > -1 ? tokens.get(index) : null;
        if (AcidGenerator.isAtomToReplace(token, replacements)) {
            atom2 = token.getValue();
            t.add(0, token);
            --index;
        }
        Token token6 = token = index > -1 ? tokens.get(index) : null;
        if (AcidGenerator.isAtomToReplace(token, replacements)) {
            atom3 = token.getValue();
            t.add(0, token);
            --index;
        }
        Token token7 = token = index > -1 ? tokens.get(index) : null;
        if (atom3 == null && atom2 != null && token instanceof Number && token.getType() != 2) {
            atom3 = atom2;
            t.add(0, token);
            --index;
        }
        Token token8 = token = index > -1 ? tokens.get(index) : null;
        if (token != null && AcidGenerator.getSulfAcidType(token.getName()) > -1) {
            value = token.getValue();
            t.add(0, token);
            --index;
        }
        Token token9 = token = index > -1 ? tokens.get(index) : null;
        if (atom3 != null) {
            value = AcidGenerator.replaceAtom(value, atom2, Util.matchCount(value, "=O") > 1);
            value = AcidGenerator.replaceAtom(value, atom3, true);
        } else if (atom2 != null) {
            if (atom == null) {
                atom = "O";
            }
            value = AcidGenerator.replaceAtom(value, atom2, atom.equals("O"));
        }
        Token token10 = token = index > -1 ? tokens.get(index) : null;
        if (token != null && (token.getName().equalsIgnoreCase("carbox") || token.getName().equalsIgnoreCase("carbo"))) {
            if (value.indexOf("Radical:") > 0) {
                value = value.replaceAll("Radical:[ ]*0", "Radical:1");
            }
            t.add(0, token);
            --index;
        }
        return value;
    }

    public static String createPolyCarbonicAcid(ArrayList<Token> tokens, int index, ArrayList<Token> t) {
        Token token = index > -1 ? tokens.get(index) : null;
        String value = token.getValue();
        t.add(0, token);
        Token token2 = token = --index > -1 ? tokens.get(index) : null;
        if (token != null && token instanceof Number && token.getType() != 2) {
            value = AcidGenerator.createPolyCarbonicAcid(((Number)token).getData());
            t.add(0, token);
        }
        return value;
    }

    public static int structureLength(ArrayList<Token> tokens, int index) {
        Token token = tokens.get(index);
        int len = 0;
        if (token.getName().equalsIgnoreCase("carbonic acid")) {
            ++len;
            if (index > 0 && tokens.get(index - 1) instanceof Number) {
                ++len;
            }
        } else if (token.getName().endsWith("acid")) {
            ++len;
            ArrayList<Token> t = new ArrayList<Token>();
            AcidGenerator.createAcid(tokens, index, t);
            len = t.size();
        }
        return len;
    }

    private static boolean isAtomToReplace(Token token, Set<String> replacements) {
        if (token == null) {
            return false;
        }
        if (token.getName().equals("imid")) {
            ((EndingToken)token).setData("N");
            return true;
        }
        return token != null && token instanceof StructureToken && (Util.atomCount(token.getValue()) == 1 && !token.getValue().equals("C") && !token.getName().equals("oxy") && !token.getName().equals("hydroxy") && !token.getName().endsWith("ane") || replacements.contains(token.getValue()));
    }

    private static String replaceAtom(String basic, String atom, boolean def) {
        if (atom.equals("OO")) {
            def = false;
        }
        if (atom.indexOf("{") > 0) {
            atom = atom.substring(0, atom.indexOf("{"));
        }
        if (!def) {
            int index2;
            int index = basic.indexOf("=O");
            if (index == (index2 = basic.indexOf("O")) - 1) {
                index2 = basic.indexOf(79, index + 1);
            }
            basic = basic.substring(0, index2) + atom + basic.substring(index2 + 1);
        } else {
            basic = basic.replaceFirst("=O", "=" + atom);
        }
        return basic;
    }

    private static boolean canBeAtom(Token token) {
        String s;
        if (token instanceof Atom) {
            return true;
        }
        return token instanceof LocantList && (s = ((LocantList)token).getLocant(0).toString()).equals("S");
    }

    private static String getAtomValue(Token token) {
        if (token instanceof Atom) {
            return ((Atom)token).getValue();
        }
        if (token instanceof LocantList) {
            return "S";
        }
        return null;
    }

    private static int getSulfAcidType(String name) {
        if (name.startsWith("sulf") || name.startsWith("tellur") || name.startsWith("selen") || name.startsWith("phosph")) {
            if (name.endsWith("on") || name.endsWith("ono")) {
                return 1;
            }
            if (name.endsWith("ino")) {
                return 0;
            }
        }
        return -1;
    }

    private static String createPolyCarbonicAcid(int poly) {
        String carbonicAcid = "[O:1][C:2](=[O:])[O:3]";
        String noAttach = "{NoAttach:";
        int index = 4;
        for (int i = 0; i < poly - 1; ++i) {
            carbonicAcid = carbonicAcid + "[C:" + index++ + "](=[O:])" + "[O:" + index++ + "]";
        }
        boolean changed = true;
        while (changed) {
            carbonicAcid = carbonicAcid.replaceFirst("=\\[O:\\]", "=\\[O:" + index + "\\]");
            noAttach = noAttach + " " + index++;
            if (carbonicAcid.indexOf("=[O:]") >= 0) continue;
            changed = false;
        }
        noAttach = noAttach + "}";
        return carbonicAcid + noAttach;
    }
}

