/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

public class AggregateStructure
extends Structure {
    private List<Structure> components;

    public AggregateStructure(List<Structure> components) {
        this.components = components;
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenlist) {
        return true;
    }

    @Override
    public Structure cloneStructure() {
        return this;
    }

    @Override
    protected Molecule getMol() {
        Molecule res = null;
        for (Structure s : this.components) {
            Molecule m = s.getMolecule();
            for (int i = 0; i < s.multiplicity; ++i) {
                if (i > 0) {
                    m = m.cloneMolecule();
                }
                if (res == null) {
                    res = m;
                    continue;
                }
                res.fuse(m, false);
            }
        }
        return res;
    }

    @Override
    protected Structure getStructure(int index) {
        if (index == 0) {
            return this;
        }
        throw new NameImportException.Failure("index=" + index);
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return false;
    }

    @Override
    public boolean hasLocant(Locant loc) {
        return false;
    }

    @Override
    protected String printValue() {
        return this.components.toString();
    }

    @Override
    protected String toSmiles() {
        return null;
    }
}

