/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class Anhydride
extends SimpleStructure {
    public Anhydride(String value, String name) {
        super(value, name);
    }

    @Override
    protected void preProcess() {
        if (this.substituentCount() == 1) {
            int acidCount = this.getAcidMultiplicity(this.getSubstituent(0));
            if (acidCount == 2) {
                super.preProcess();
                this.molecule = this.getSubstituent(0).getMolecule();
                this.mergeHydroxyGroups();
                this.postProcess();
            } else if (acidCount <= 1) {
                super.preProcess();
                this.molecule = this.getSubstituent(0).getMolecule();
                int hydroxyCount = this.markHydroxy(this.molecule);
                if (hydroxyCount == 1) {
                    Molecule clone = this.molecule.cloneMolecule();
                    this.molecule.fuse(clone);
                }
                this.mergeHydroxyGroups();
                this.postProcess();
            } else {
                super.preProcess();
            }
        } else if (this.substituentCount() > 2 && this.getName().contains("acetic")) {
            int subCount = this.substituentCount();
            for (int i = 0; i < subCount; ++i) {
                this.addSubstituent(this.getSubstituent(i).cloneStructure());
            }
            super.preProcess();
        } else {
            super.preProcess();
        }
    }

    private int getAcidMultiplicity(Structure struc) {
        for (int i = 0; i < struc.suffixCount(); ++i) {
            Suffix suffix = struc.getSuffix(i);
            if (suffix.getType() != 0) continue;
            return suffix.getMultiplicity();
        }
        return -1;
    }

    private void mergeHydroxyGroups() {
        ArrayList<MolAtom> hydroxy = new ArrayList<MolAtom>();
        for (int i = 0; i < this.molecule.getAtomCount(); ++i) {
            String alias = this.molecule.getAtom(i).getAliasstr();
            if (alias == null || !alias.equals("HYDROXY")) continue;
            hydroxy.add(this.molecule.getAtom(i));
        }
        if (hydroxy.size() < 2) {
            return;
        }
        MolAtom oxy = (MolAtom)hydroxy.get(0);
        MolAtom toRemove = (MolAtom)hydroxy.get(1);
        MolAtom neighbour = toRemove.getBond(0).getOtherAtom(toRemove);
        this.molecule.add(new MolBond(oxy, neighbour));
        this.molecule.removeAtom(toRemove);
    }

    private int removeAcidAndGetMul(Structure struc) {
        for (int i = 0; i < struc.suffixCount(); ++i) {
            Suffix suffix = struc.getSuffix(i);
            if (suffix.getType() != 0) continue;
            int multiplicity = suffix.getMultiplicity();
            struc.removeSuffix(i);
            return multiplicity;
        }
        return -1;
    }
}

