/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;

public class Annulene
extends SimpleStructure {
    private int size;

    public Annulene(String value, String name, int size) {
        super(value, name);
        this.size = size;
    }

    public Annulene(int size) {
        this(size, true);
    }

    public Annulene(int size, boolean isBenzo) {
        String value;
        if (isBenzo) {
            this.name = "benzo[" + size + "]annulene";
            this.size = size;
            value = "c12ccccc1";
            IntVector numbering = new IntVector(new int[]{1, 2, 3, 4, 401});
            for (int i = 0; i < size - 2; ++i) {
                value = value + "c";
                numbering.add(5 + i);
            }
            value = value + "2";
            numbering.add(0, (size - 2) * 100 + 1);
            this.setAtomMap(numbering);
        } else {
            this.name = "[" + size + "]annulene";
            this.size = size;
            value = "c1";
            for (int i = 1; i < size; ++i) {
                value = value + "c";
            }
            value = value + "1";
        }
        if (size % 2 > 0) {
            value = value + "{Hydrogens: 1}";
        }
        this.handleValue(value, 0);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

