/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class Bridge
extends Structure {
    public Structure structure;
    private LocantList attachPoints;

    public Bridge(Structure structure, LocantList attachPoints) {
        this.structure = structure;
        this.attachPoints = attachPoints;
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenlist) {
        return true;
    }

    @Override
    public Structure cloneStructure() {
        Structure newStruc = this.structure.cloneStructure();
        LocantList newLocL = new LocantList();
        newLocL.tryAddLocant(this.attachPoints);
        Bridge newStructure = new Bridge(newStruc, newLocL);
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected Molecule getMol() {
        return this.structure.getMolecule();
    }

    @Override
    public Molecule getMolecule() {
        if (!this.attachPoints.hasLocant() && this.suffixList.isEmpty()) {
            throw new NameImportException("Bridge cannot be a parent");
        }
        return super.getMolecule();
    }

    @Override
    public Molecule buildMolecule() {
        if (this.molecule == null && this.getParent() == null) {
            if (this.locantInParent != null) {
                this.attachPoints.tryAddLocant(this.locantInParent);
            }
            for (int i = 0; i < this.attachPoints.size(); ++i) {
                Suffix radical = SuffixFactory.createSuffix("|", "yl", (LocantList)null, 1, 0);
                this.radicals.add(radical);
            }
        }
        return super.buildMolecule();
    }

    @Override
    protected Structure getStructure(int index) {
        return this;
    }

    @Override
    protected String printValue() {
        return "[" + this.attachPoints.toString() + "]  " + this.structure.printValue();
    }

    @Override
    protected String toSmiles() {
        return this.structure.toSmiles();
    }

    @Override
    protected void addLigand(Structure s) {
        if (s instanceof Bridge) {
            if (s.locantInParent != null && (this.locantInParent == null || this.locantInParent.size() == 0) || this.isLocantCalculated()) {
                this.setLocantInParent(s.locantInParent);
                s.locantInParent = null;
            }
            this.atomMap.clear();
            String bridge = ((Bridge)s).structure.toSmiles();
            bridge = bridge + this.structure.toSmiles();
            this.structure = new SimpleStructure(bridge, "bridge");
            this.removeSubstituent(s);
            this.molecule = this.getMol();
        } else {
            super.addLigand(s);
        }
    }

    @Override
    public boolean hasLocant(Locant loc) {
        return this.structure.hasLocant(loc);
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return this.structure.hasAtom(atomSymbol) || this.getHeteroAtomCountOf(atomSymbol) > 0;
    }
}

