/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.RatioToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Separator;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.IUPACParserCore;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class Compound
extends Structure {
    Structure s1;
    Structure s2;
    int ratio1;
    int ratio2;

    public static Structure parseRatio(ArrayList<Token> tokens) {
        for (int i = 0; i < tokens.size(); ++i) {
            int endS1;
            int startS2;
            int endS2;
            if (!(tokens.get(i) instanceof RatioToken)) continue;
            RatioToken r = (RatioToken)tokens.get(i);
            if (i == tokens.size() - 1) {
                while (tokens.get(--i) instanceof Separator) {
                }
                endS2 = i + 1;
                while (!(tokens.get(--i) instanceof Separator)) {
                }
                startS2 = i + 1;
                endS1 = i;
            } else {
                endS1 = i;
                startS2 = i + 1;
                endS2 = tokens.size();
            }
            int startS1 = 0;
            while (tokens.get(startS1).getName().equals(" ")) {
                ++startS1;
            }
            while (tokens.get(endS1 - 1).getName().equals(" ")) {
                --endS1;
            }
            while (tokens.get(startS2).getName().equals(" ")) {
                ++startS2;
            }
            Structure s1 = IUPACParserCore.parseTokens(new ArrayList<Token>(tokens.subList(startS1, endS1)));
            Structure s2 = IUPACParserCore.parseTokens(new ArrayList<Token>(tokens.subList(startS2, endS2)));
            return new Compound(s1, s2, r.ratio2, r.ratio1);
        }
        return null;
    }

    Compound(Structure s1, Structure s2, int ratio1, int ratio2) {
        this.s1 = s1;
        this.s2 = s2;
        this.ratio1 = ratio1;
        this.ratio2 = ratio2;
        this.substituentList.add(s1);
        this.substituentList.add(s2);
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenlist) {
        return false;
    }

    @Override
    public Structure cloneStructure() {
        return null;
    }

    @Override
    protected Molecule getMol() {
        Molecule res = new Molecule();
        Molecule m1 = this.s1.buildMolecule();
        Molecule m2 = this.s2.buildMolecule();
        int r1 = this.ratio1 == -1 ? 1 : this.ratio1;
        for (int i = 0; i < r1; ++i) {
            res.fuse(m1.cloneMolecule());
        }
        int r2 = this.ratio2 == -1 ? 1 : this.ratio2;
        for (int i = 0; i < r2; ++i) {
            res.fuse(m2.cloneMolecule());
        }
        return res;
    }

    @Override
    protected Molecule buildMolecule() {
        return this.getMol();
    }

    @Override
    protected Structure getStructure(int index) {
        return null;
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return false;
    }

    @Override
    public boolean hasLocant(Locant loc) {
        return false;
    }

    @Override
    protected String printValue() {
        return null;
    }

    @Override
    protected String toSmiles() {
        return null;
    }
}

